/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;

public class BasicExtendedMetaData
implements ExtendedMetaData {
    protected String annotationURI;
    protected EPackage.Registry registry;
    protected EPackage.Registry demandRegistry;

    public BasicExtendedMetaData() {
        this("http:///org/eclipse/emf/ecore/util/ExtendedMetaData", EPackage.Registry.INSTANCE);
    }

    public BasicExtendedMetaData(EPackage.Registry registry) {
        this("http:///org/eclipse/emf/ecore/util/ExtendedMetaData", registry);
    }

    public BasicExtendedMetaData(String annotationURI, EPackage.Registry registry) {
        this.annotationURI = annotationURI;
        this.registry = registry;
        this.demandRegistry = new EPackageRegistryImpl();
    }

    protected EAnnotation getAnnotation(EModelElement eModelElement, boolean demandCreate) {
        EAnnotation result = eModelElement.getEAnnotation(this.annotationURI);
        if (result == null && demandCreate) {
            result = EcoreFactory.eINSTANCE.createEAnnotation();
            result.setSource(this.annotationURI);
            eModelElement.getEAnnotations().add((Object)result);
        }
        return result;
    }

    public EClassifier getType(EPackage ePackage, String name) {
        Iterator i = ePackage.getEClassifiers().iterator();
        while (i.hasNext()) {
            EClassifier eClassifier = (EClassifier)i.next();
            if (!name.equals(this.getName(eClassifier))) continue;
            return eClassifier;
        }
        return null;
    }

    public EPackage getPackage(String namespace) {
        EPackage ePackage = this.registry.getEPackage(namespace);
        if (ePackage == null) {
            ePackage = this.demandRegistry.getEPackage(namespace);
        }
        return ePackage;
    }

    public void putPackage(String namespace, EPackage ePackage) {
        this.registry.put(namespace, ePackage);
    }

    public EClass getDocumentRoot(EPackage ePackage) {
        return (EClass)this.getType(ePackage, "");
    }

    public void setDocumentRoot(EClass eClass) {
        this.setName(eClass, "");
        this.setContentKind(eClass, 3);
    }

    public EReference getXMLNSPrefixMapFeature(EClass eClass) {
        if (this.getContentKind(eClass) == 3) {
            Iterator i = eClass.getEAllReferences().iterator();
            while (i.hasNext()) {
                EReference eReference = (EReference)i.next();
                if (!"xmlns:prefix".equals(this.getName(eReference))) continue;
                return eReference;
            }
        }
        return null;
    }

    public EReference getXSISchemaLocationMapFeature(EClass eClass) {
        if (this.getContentKind(eClass) == 3) {
            Iterator i = eClass.getEAllReferences().iterator();
            while (i.hasNext()) {
                EReference eReference = (EReference)i.next();
                if (!"xsi:schemaLocation".equals(this.getName(eReference))) continue;
                return eReference;
            }
        }
        return null;
    }

    public boolean isQualified(EPackage ePackage) {
        EAnnotation eAnnotation = this.getAnnotation(ePackage, false);
        return eAnnotation == null || !"false".equals(eAnnotation.getDetails().get((Object)"qualified"));
    }

    public void setQualified(EPackage ePackage, boolean isQualified) {
        if (!isQualified) {
            EAnnotation eAnnotation = this.getAnnotation(ePackage, true);
            eAnnotation.getDetails().put((Object)"qualified", (Object)"false");
        } else {
            EAnnotation eAnnotation = this.getAnnotation(ePackage, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove((Object)"qualified");
            }
        }
    }

    public String getNamespace(EPackage ePackage) {
        if (this.isQualified(ePackage)) {
            return ePackage.getNsURI();
        }
        return null;
    }

    public String getNamespace(EClassifier eClassifier) {
        return this.getNamespace(eClassifier.getEPackage());
    }

    public String getNamespace(EStructuralFeature eStructuralFeature) {
        EAnnotation eAnnotation = this.getAnnotation(eStructuralFeature, false);
        if (eAnnotation == null) {
            return null;
        }
        String result = (String)eAnnotation.getDetails().get((Object)"namespace");
        if ("##targetNamespace".equals(result)) {
            return this.getNamespace(eStructuralFeature.getEContainingClass().getEPackage());
        }
        return result;
    }

    public void setNamespace(EStructuralFeature eStructuralFeature, String namespace) {
        String packageNamespace = this.getNamespace(eStructuralFeature.getEContainingClass().getEPackage());
        if (namespace == null ? packageNamespace == null : namespace.equals(packageNamespace)) {
            namespace = "##targetNamespace";
        }
        if (namespace != null) {
            EAnnotation eAnnotation = this.getAnnotation(eStructuralFeature, true);
            eAnnotation.getDetails().put((Object)"namespace", (Object)namespace);
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eStructuralFeature, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove((Object)"namespace");
            }
        }
    }

    public String getName(ENamedElement eNamedElement) {
        String result;
        EAnnotation eAnnotation = this.getAnnotation(eNamedElement, false);
        if (eAnnotation != null && (result = (String)eAnnotation.getDetails().get((Object)"name")) != null) {
            return result;
        }
        return eNamedElement.getName();
    }

    public void setName(ENamedElement eNamedElement, String name) {
        EAnnotation eAnnotation = this.getAnnotation(eNamedElement, true);
        eAnnotation.getDetails().put((Object)"name", (Object)name);
    }

    protected String getQualifiedName(String defaultNamespace, EClassifier eClassifier) {
        String namespace = this.getNamespace(eClassifier);
        String name = this.getName(eClassifier);
        if (namespace == null) {
            return namespace == defaultNamespace ? name : "#" + name;
        }
        return namespace.equals(defaultNamespace) ? name : String.valueOf(namespace) + "#" + name;
    }

    protected String getQualifiedName(String defaultNamespace, EStructuralFeature eStructuralFeature) {
        String namespace = this.getNamespace(eStructuralFeature);
        String name = this.getName(eStructuralFeature);
        if (namespace == null) {
            return namespace == defaultNamespace ? name : "#" + name;
        }
        return namespace.equals(defaultNamespace) ? name : String.valueOf(namespace) + "#" + name;
    }

    public EClassifier getType(String namespace, String name) {
        EPackage ePackage = this.getPackage(namespace);
        return ePackage == null ? null : this.getType(ePackage, name);
    }

    public EStructuralFeature getAttribute(String namespace, String name) {
        EClass documentRoot;
        EPackage ePackage = this.getPackage(namespace);
        if (ePackage != null && (documentRoot = this.getDocumentRoot(ePackage)) != null) {
            return this.getLocalAttribute(documentRoot, namespace, name);
        }
        return null;
    }

    public EStructuralFeature getElement(String namespace, String name) {
        EClass documentRoot;
        EPackage ePackage = this.getPackage(namespace);
        if (ePackage != null && (documentRoot = this.getDocumentRoot(ePackage)) != null) {
            return this.getLocalElement(documentRoot, namespace, name);
        }
        return null;
    }

    public int getFeatureKind(EStructuralFeature eStructuralFeature) {
        Object kind;
        EAnnotation eAnnotation = this.getAnnotation(eStructuralFeature, false);
        if (eAnnotation != null && (kind = eAnnotation.getDetails().get((Object)"kind")) != null) {
            int i = 1;
            while (i < ExtendedMetaData.FEATURE_KINDS.length) {
                if (ExtendedMetaData.FEATURE_KINDS[i].equals(kind)) {
                    return i;
                }
                ++i;
            }
        }
        return 0;
    }

    public void setFeatureKind(EStructuralFeature eStructuralFeature, int kind) {
        if (kind > 0 && kind < ExtendedMetaData.FEATURE_KINDS.length) {
            EAnnotation eAnnotation = this.getAnnotation(eStructuralFeature, true);
            eAnnotation.getDetails().put((Object)"kind", (Object)ExtendedMetaData.FEATURE_KINDS[kind]);
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eStructuralFeature, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove((Object)"kind");
            }
        }
    }

    public int getContentKind(EClass eClass) {
        Object kind;
        EAnnotation eAnnotation = this.getAnnotation(eClass, false);
        if (eAnnotation != null && (kind = eAnnotation.getDetails().get((Object)"kind")) != null) {
            int i = 1;
            while (i < ExtendedMetaData.CONTENT_KINDS.length) {
                if (ExtendedMetaData.CONTENT_KINDS[i].equals(kind)) {
                    return i;
                }
                ++i;
            }
        }
        return 0;
    }

    public void setContentKind(EClass eClass, int kind) {
        if (kind > 0 && kind < ExtendedMetaData.CONTENT_KINDS.length) {
            EAnnotation eAnnotation = this.getAnnotation(eClass, true);
            eAnnotation.getDetails().put((Object)"kind", (Object)ExtendedMetaData.CONTENT_KINDS[kind]);
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eClass, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove((Object)"kind");
            }
        }
    }

    public int getDerivationKind(EDataType eDataType) {
        EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
        if (eAnnotation != null) {
            EMap details = eAnnotation.getDetails();
            Object kind = details.get((Object)"restriction");
            if (kind != null) {
                return 0;
            }
            kind = details.get((Object)"list");
            if (kind != null) {
                return 0;
            }
            kind = details.get((Object)"union");
            if (kind != null) {
                return 0;
            }
        }
        return 0;
    }

    public EDataType getBaseType(EDataType eDataType) {
        EMap details;
        String baseType;
        EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
        if (eAnnotation != null && (baseType = (String)(details = eAnnotation.getDetails()).get((Object)"baseType")) != null) {
            EClassifier type;
            int index = baseType.lastIndexOf("#");
            EClassifier eClassifier = index == -1 ? this.getType(eDataType.getEPackage(), baseType) : (type = index == 0 ? this.getType((String)null, baseType.substring(1)) : this.getType(baseType.substring(0, index), baseType.substring(index + 1)));
            if (type instanceof EDataType) {
                return (EDataType)type;
            }
        }
        return null;
    }

    public void setBaseType(EDataType eDataType, EDataType baseType) {
        if (baseType == null) {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove((Object)"baseType");
            }
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, true);
            eAnnotation.getDetails().put((Object)"baseType", (Object)this.getQualifiedName(this.getNamespace(eDataType), baseType));
        }
    }

    public EDataType getItemType(EDataType eDataType) {
        EMap details;
        String itemType;
        EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
        if (eAnnotation != null && (itemType = (String)(details = eAnnotation.getDetails()).get((Object)"itemType")) != null) {
            EClassifier type;
            int index = itemType.lastIndexOf("#");
            EClassifier eClassifier = index == -1 ? this.getType(eDataType.getEPackage(), itemType) : (type = index == 0 ? this.getType((String)null, itemType.substring(1)) : this.getType(itemType.substring(0, index), itemType.substring(index + 1)));
            if (type instanceof EDataType) {
                return (EDataType)type;
            }
        }
        return null;
    }

    public void setItemType(EDataType eDataType, EDataType itemType) {
        if (itemType == null) {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove((Object)"itemType");
            }
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, true);
            eAnnotation.getDetails().put((Object)"itemType", (Object)this.getQualifiedName(this.getNamespace(eDataType), itemType));
        }
    }

    public List getMemberTypes(EDataType eDataType) {
        String memberTypes;
        EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
        if (eAnnotation != null && (memberTypes = (String)eAnnotation.getDetails().get((Object)"memberTypes")) != null) {
            ArrayList<EClassifier> result = new ArrayList<EClassifier>();
            StringTokenizer stringTokenizer = new StringTokenizer(memberTypes);
            while (stringTokenizer.hasMoreTokens()) {
                EClassifier type;
                String member = stringTokenizer.nextToken();
                int index = member.lastIndexOf("#");
                EClassifier eClassifier = index == -1 ? this.getType(eDataType.getEPackage(), member) : (type = index == 0 ? this.getType((String)null, member.substring(1)) : this.getType(member.substring(0, index), member.substring(index + 1)));
                if (!(type instanceof EDataType)) continue;
                result.add(type);
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    public void setMemberTypes(EDataType eDataType, List memberTypes) {
        if (memberTypes.isEmpty()) {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove((Object)"memberTypes");
            }
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, true);
            String namespace = this.getNamespace(eDataType);
            StringBuffer result = new StringBuffer();
            Iterator i = memberTypes.iterator();
            while (i.hasNext()) {
                result.append(this.getQualifiedName(namespace, (EDataType)i.next()));
                result.append(' ');
            }
            eAnnotation.getDetails().put((Object)"memberTypes", (Object)result.substring(0, result.length() - 1));
        }
    }

    public EStructuralFeature getLocalAttribute(EClass eClass, String namespace, String name) {
        Iterator i = this.getAllAttributes(eClass).iterator();
        while (i.hasNext()) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)i.next();
            if (!name.equals(this.getName(eStructuralFeature)) || !(namespace == null ? this.getNamespace(eStructuralFeature) == null : namespace.equals(this.getNamespace(eStructuralFeature)))) continue;
            return eStructuralFeature;
        }
        return null;
    }

    public EStructuralFeature getAttribute(EClass eClass, String namespace, String name) {
        EStructuralFeature result = this.getLocalAttribute(eClass, namespace, name);
        if (result == null && (result = this.getAttribute(namespace, name)) != null && this.getAffiliation(eClass, result) == null) {
            return null;
        }
        return result;
    }

    protected EStructuralFeature getLocalElement(EClass eClass, String namespace, String name) {
        Iterator i = this.getAllElements(eClass).iterator();
        while (i.hasNext()) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)i.next();
            if (!name.equals(this.getName(eStructuralFeature)) || !(namespace == null ? this.getNamespace(eStructuralFeature) == null : namespace.equals(this.getNamespace(eStructuralFeature)))) continue;
            return eStructuralFeature;
        }
        return null;
    }

    public EStructuralFeature getElement(EClass eClass, String namespace, String name) {
        EStructuralFeature result = this.getLocalElement(eClass, namespace, name);
        if (result == null && (result = this.getElement(namespace, name)) != null && this.getAffiliation(eClass, result) == null) {
            return null;
        }
        return result;
    }

    public List getAllAttributes(EClass eClass) {
        ArrayList result = new ArrayList();
        Iterator i = eClass.getESuperTypes().iterator();
        while (i.hasNext()) {
            EClass eSuperType = (EClass)i.next();
            result.addAll(this.getAllAttributes(eSuperType));
        }
        result.addAll(this.getAttributes(eClass));
        return result;
    }

    public EStructuralFeature getSimpleFeature(EClass eClass) {
        if (this.getContentKind(eClass) == 2) {
            Iterator i = eClass.getEAllStructuralFeatures().iterator();
            while (i.hasNext()) {
                EStructuralFeature eStructuralFeature = (EStructuralFeature)i.next();
                if (this.getFeatureKind(eStructuralFeature) != 1) continue;
                return eStructuralFeature;
            }
        }
        return null;
    }

    public EAttribute getMixedFeature(EClass eClass) {
        switch (this.getContentKind(eClass)) {
            case 2: 
            case 3: {
                Iterator i = eClass.getEAllAttributes().iterator();
                while (i.hasNext()) {
                    EAttribute eAttribute = (EAttribute)i.next();
                    if (this.getFeatureKind(eAttribute) != 5) continue;
                    return eAttribute;
                }
                break;
            }
        }
        return null;
    }

    public List getAllElements(EClass eClass) {
        UniqueEList result = new UniqueEList();
        Iterator i = eClass.getESuperTypes().iterator();
        while (i.hasNext()) {
            EClass eSuperType = (EClass)i.next();
            result.addAll(this.getAllElements(eSuperType));
        }
        result.addAll(this.getElements(eClass));
        return result;
    }

    public List getAttributes(EClass eClass) {
        ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>();
        Iterator i = eClass.getEStructuralFeatures().iterator();
        while (i.hasNext()) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)i.next();
            switch (this.getFeatureKind(eStructuralFeature)) {
                case 2: 
                case 3: {
                    result.add(eStructuralFeature);
                }
            }
        }
        return result;
    }

    public List getElements(EClass eClass) {
        ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>();
        Iterator i = eClass.getEStructuralFeatures().iterator();
        while (i.hasNext()) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)i.next();
            switch (this.getFeatureKind(eStructuralFeature)) {
                case 4: 
                case 5: 
                case 6: {
                    result.add(eStructuralFeature);
                }
            }
        }
        return result;
    }

    public List getWildcards(EStructuralFeature eStructuralFeature) {
        String wildcards;
        EAnnotation eAnnotation = this.getAnnotation(eStructuralFeature, false);
        if (eAnnotation != null && (wildcards = (String)eAnnotation.getDetails().get((Object)"wildcards")) != null) {
            ArrayList<String> result = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(wildcards);
            while (stringTokenizer.hasMoreTokens()) {
                String wildcard = stringTokenizer.nextToken();
                if (wildcard.equals("##other")) {
                    result.add("!##" + this.getNamespace(eStructuralFeature.getEContainingClass().getEPackage()));
                    continue;
                }
                if (wildcard.equals("##local")) {
                    result.add(null);
                    continue;
                }
                if (wildcard.equals("##targetNamespace")) {
                    result.add(this.getNamespace(eStructuralFeature.getEContainingClass().getEPackage()));
                    continue;
                }
                result.add(wildcard);
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    public void setWildcards(EStructuralFeature eStructuralFeature, List wildcards) {
        if (wildcards.isEmpty()) {
            EAnnotation eAnnotation = this.getAnnotation(eStructuralFeature, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove((Object)"wildcards");
                eAnnotation.getDetails().remove((Object)"name");
            }
        } else {
            String namespace = this.getNamespace(eStructuralFeature.getEContainingClass().getEPackage());
            EAnnotation eAnnotation = this.getAnnotation(eStructuralFeature, true);
            StringBuffer value = new StringBuffer();
            Iterator i = wildcards.iterator();
            while (i.hasNext()) {
                String wildcard = (String)i.next();
                if (wildcard == null) {
                    if (namespace == null) {
                        value.append("##targetNamespace");
                        continue;
                    }
                    value.append("##local");
                    continue;
                }
                if (wildcard.startsWith("!##")) {
                    if (namespace == null ? wildcard.length() == 3 : wildcard.endsWith(namespace) && wildcard.length() == namespace.length() + 3) {
                        value.append("##other");
                        continue;
                    }
                    value.append(wildcard);
                    continue;
                }
                if (wildcard.equals(namespace)) {
                    value.append("##targetNamespace");
                    continue;
                }
                value.append(wildcard);
            }
            eAnnotation.getDetails().put((Object)"wildcards", (Object)value.toString());
            eAnnotation.getDetails().put((Object)"name", (Object)"");
        }
    }

    public int getProcessingKind(EStructuralFeature eStructuralFeature) {
        Object kind;
        EAnnotation eAnnotation = this.getAnnotation(eStructuralFeature, false);
        if (eAnnotation != null && (kind = eAnnotation.getDetails().get((Object)"processing")) != null) {
            int i = 1;
            while (i < ExtendedMetaData.PROCESSING_KINDS.length) {
                if (ExtendedMetaData.PROCESSING_KINDS[i].equals(kind)) {
                    return i;
                }
                ++i;
            }
        }
        return 0;
    }

    public void setProcessingKind(EStructuralFeature eStructuralFeature, int kind) {
        if (kind > 0 && kind < ExtendedMetaData.PROCESSING_KINDS.length) {
            EAnnotation eAnnotation = this.getAnnotation(eStructuralFeature, true);
            eAnnotation.getDetails().put((Object)"processing", (Object)ExtendedMetaData.PROCESSING_KINDS[kind]);
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eStructuralFeature, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove((Object)"processing");
            }
        }
    }

    public EStructuralFeature getGroup(EStructuralFeature eStructuralFeature) {
        String qualifiedName;
        EAnnotation eAnnotation = this.getAnnotation(eStructuralFeature, false);
        if (eAnnotation != null && (qualifiedName = (String)eAnnotation.getDetails().get((Object)"group")) != null) {
            int fragmentIndex = qualifiedName.lastIndexOf(35);
            if (fragmentIndex == -1) {
                return this.getElement(eStructuralFeature.getEContainingClass(), this.getNamespace(eStructuralFeature.getEContainingClass().getEPackage()), qualifiedName);
            }
            if (fragmentIndex == 0) {
                return this.getElement(eStructuralFeature.getEContainingClass(), null, qualifiedName.substring(1));
            }
            return this.getElement(eStructuralFeature.getEContainingClass(), qualifiedName.substring(0, fragmentIndex), qualifiedName.substring(fragmentIndex + 1));
        }
        return null;
    }

    public void setGroup(EStructuralFeature eStructuralFeature, EStructuralFeature group) {
        if (group == null) {
            EAnnotation eAnnotation = this.getAnnotation(eStructuralFeature, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove((Object)"group");
            }
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eStructuralFeature, true);
            eAnnotation.getDetails().put((Object)"group", (Object)this.getQualifiedName(this.getNamespace(eStructuralFeature.getEContainingClass().getEPackage()), group));
        }
    }

    public EStructuralFeature getAffiliation(EStructuralFeature eStructuralFeature) {
        String qualifiedName;
        EAnnotation eAnnotation = this.getAnnotation(eStructuralFeature, false);
        if (eAnnotation != null && (qualifiedName = (String)eAnnotation.getDetails().get((Object)"affiliation")) != null) {
            int fragmentIndex = qualifiedName.lastIndexOf(35);
            if (fragmentIndex == -1) {
                return this.getElement(this.getNamespace(eStructuralFeature.getEContainingClass().getEPackage()), qualifiedName);
            }
            if (fragmentIndex == 0) {
                return this.getElement(null, qualifiedName.substring(1));
            }
            return this.getElement(qualifiedName.substring(0, fragmentIndex), qualifiedName.substring(fragmentIndex + 1));
        }
        return null;
    }

    public void setAffiliation(EStructuralFeature eStructuralFeature, EStructuralFeature affiliation) {
        if (affiliation == null) {
            EAnnotation eAnnotation = this.getAnnotation(eStructuralFeature, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove((Object)"affiliation");
            }
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eStructuralFeature, true);
            eAnnotation.getDetails().put((Object)"affiliation", (Object)this.getQualifiedName(this.getNamespace(eStructuralFeature.getEContainingClass().getEPackage()), affiliation));
        }
    }

    public EStructuralFeature getAffiliation(EClass eClass, EStructuralFeature eStructuralFeature) {
        EList eAllStructuralFeatures = eClass.getEAllStructuralFeatures();
        if (eAllStructuralFeatures.contains(eStructuralFeature)) {
            return eStructuralFeature;
        }
        switch (this.getFeatureKind(eStructuralFeature)) {
            case 2: {
                String namespace = this.getNamespace(eStructuralFeature);
                String name = this.getName(eStructuralFeature);
                EStructuralFeature result = this.getLocalAttribute(eClass, namespace, name);
                if (result != null) {
                    return result;
                }
                Iterator i = this.getAllAttributes(eClass).iterator();
                while (i.hasNext()) {
                    result = (EStructuralFeature)i.next();
                    if (!this.matches(this.getWildcards(result), namespace)) continue;
                    return result;
                }
                return null;
            }
            case 4: {
                EStructuralFeature affiliation = eStructuralFeature;
                while (affiliation != null) {
                    String name;
                    String namespace = this.getNamespace(affiliation);
                    EStructuralFeature result = this.getLocalElement(eClass, namespace, name = this.getName(affiliation));
                    if (result != null) {
                        return result;
                    }
                    affiliation = this.getAffiliation(affiliation);
                }
                String namespace = this.getNamespace(eStructuralFeature);
                if ("http://www.eclipse.org/emf/2003/XMLType".equals(namespace)) {
                    return this.getMixedFeature(eClass);
                }
                Iterator i = this.getAllElements(eClass).iterator();
                while (i.hasNext()) {
                    EStructuralFeature result = (EStructuralFeature)i.next();
                    if (!this.matches(this.getWildcards(result), namespace)) continue;
                    return result;
                }
                return null;
            }
        }
        return null;
    }

    public EStructuralFeature getAttributeWildcardAffiliation(EClass eClass, String namespace, String name) {
        Iterator i = this.getAllAttributes(eClass).iterator();
        while (i.hasNext()) {
            EStructuralFeature result = (EStructuralFeature)i.next();
            if (!this.matches(this.getWildcards(result), namespace)) continue;
            return result;
        }
        return null;
    }

    public EStructuralFeature getElementWildcardAffiliation(EClass eClass, String namespace, String name) {
        Iterator i = this.getAllElements(eClass).iterator();
        while (i.hasNext()) {
            EStructuralFeature result = (EStructuralFeature)i.next();
            if (!this.matches(this.getWildcards(result), namespace)) continue;
            return result;
        }
        return null;
    }

    public boolean matches(List wildcards, String namespace) {
        if (!wildcards.isEmpty()) {
            Iterator j = wildcards.iterator();
            while (j.hasNext()) {
                String wildcard = (String)j.next();
                if (!this.matches(wildcard, namespace)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean matches(String wildcard, String namespace) {
        return wildcard == null ? namespace == null : (wildcard.startsWith("!##") ? (namespace == null ? wildcard.length() != 3 : !(wildcard.endsWith(namespace) && wildcard.length() == namespace.length() + 3 || "http://www.eclipse.org/emf/2003/XMLType".equals(namespace))) : wildcard.equals("##any") && !"http://www.eclipse.org/emf/2003/XMLType".equals(namespace) || wildcard.equals(namespace));
    }

    public int getWhiteSpaceFacet(EDataType eDataType) {
        EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
        if (eAnnotation != null) {
            String whiteSpaceLiteral = (String)eAnnotation.getDetails().get((Object)"whiteSpace");
            int i = 1;
            while (i < ExtendedMetaData.WHITE_SPACE_KINDS.length) {
                if (ExtendedMetaData.WHITE_SPACE_KINDS[i].equals(whiteSpaceLiteral)) {
                    return i;
                }
                ++i;
            }
        }
        return 0;
    }

    public void setWhiteSpaceFacet(EDataType eDataType, int whiteSpace) {
        if (whiteSpace == 0) {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove((Object)"whiteSpace");
            }
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, true);
            eAnnotation.getDetails().put((Object)"whiteSpace", (Object)ExtendedMetaData.WHITE_SPACE_KINDS[whiteSpace]);
        }
    }

    public List getEnumerationFacet(EDataType eDataType) {
        String enumerationLiteral;
        EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
        if (eAnnotation != null && (enumerationLiteral = (String)eAnnotation.getDetails().get((Object)"enumeration")) != null) {
            ArrayList<String> result = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(enumerationLiteral, " ");
            while (stringTokenizer.hasMoreTokens()) {
                String enumeration = stringTokenizer.nextToken().replaceAll("%20", " ").replaceAll("%25", "%");
                result.add(enumeration);
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    public void setEnumerationFacet(EDataType eDataType, List literals) {
        if (literals.isEmpty()) {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove((Object)"enumeration");
            }
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, true);
            StringBuffer result = new StringBuffer();
            Iterator i = literals.iterator();
            while (i.hasNext()) {
                result.append(((String)i.next()).replaceAll("%", "%25").replaceAll(" ", "%20"));
                result.append(' ');
            }
            eAnnotation.getDetails().put((Object)"enumeration", (Object)result.substring(0, result.length() - 1));
        }
    }

    public List getPatternFacet(EDataType eDataType) {
        String patternLiteral;
        EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
        if (eAnnotation != null && (patternLiteral = (String)eAnnotation.getDetails().get((Object)"pattern")) != null) {
            ArrayList<String> result = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(patternLiteral, " ");
            while (stringTokenizer.hasMoreTokens()) {
                String pattern = stringTokenizer.nextToken().replaceAll("%20", " ").replaceAll("%25", "%");
                result.add(pattern);
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    public void setPatternFacet(EDataType eDataType, List pattern) {
        if (pattern.isEmpty()) {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove((Object)"pattern");
            }
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, true);
            StringBuffer result = new StringBuffer();
            Iterator i = pattern.iterator();
            while (i.hasNext()) {
                result.append(((String)i.next()).replaceAll("%", "%25").replaceAll(" ", "%20"));
                result.append(' ');
            }
            eAnnotation.getDetails().put((Object)"pattern", (Object)result.substring(0, result.length() - 1));
        }
    }

    public int getTotalDigitsFacet(EDataType eDataType) {
        String totalDigitsLiteral;
        EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
        if (eAnnotation != null && (totalDigitsLiteral = (String)eAnnotation.getDetails().get((Object)"totalDigits")) != null) {
            return Integer.parseInt(totalDigitsLiteral);
        }
        return -1;
    }

    public void setTotalDigitsFacet(EDataType eDataType, int digits) {
        if (digits == -1) {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove((Object)"totalDigits");
            }
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, true);
            eAnnotation.getDetails().put((Object)"totalDigits", (Object)Integer.toString(digits));
        }
    }

    public int getFractionDigitsFacet(EDataType eDataType) {
        String fractionDigitsLiteral;
        EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
        if (eAnnotation != null && (fractionDigitsLiteral = (String)eAnnotation.getDetails().get((Object)"fractionDigits")) != null) {
            return Integer.parseInt(fractionDigitsLiteral);
        }
        return -1;
    }

    public void setFractionDigitsFacet(EDataType eDataType, int digits) {
        if (digits == -1) {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove((Object)"factionDigits");
            }
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, true);
            eAnnotation.getDetails().put((Object)"fractionDigits", (Object)Integer.toString(digits));
        }
    }

    public int getLengthFacet(EDataType eDataType) {
        String lengthLiteral;
        EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
        if (eAnnotation != null && (lengthLiteral = (String)eAnnotation.getDetails().get((Object)"length")) != null) {
            return Integer.parseInt(lengthLiteral);
        }
        return -1;
    }

    public void setLengthFacet(EDataType eDataType, int length) {
        if (length == -1) {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove((Object)"length");
            }
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, true);
            eAnnotation.getDetails().put((Object)"length", (Object)Integer.toString(length));
        }
    }

    public int getMinLengthFacet(EDataType eDataType) {
        String minLengthLiteral;
        EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
        if (eAnnotation != null && (minLengthLiteral = (String)eAnnotation.getDetails().get((Object)"minLength")) != null) {
            return Integer.parseInt(minLengthLiteral);
        }
        return -1;
    }

    public void setMinLengthFacet(EDataType eDataType, int length) {
        if (length == -1) {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove((Object)"minLength");
            }
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, true);
            eAnnotation.getDetails().put((Object)"minLength", (Object)Integer.toString(length));
        }
    }

    public int getMaxLengthFacet(EDataType eDataType) {
        String maxLengthLiteral;
        EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
        if (eAnnotation != null && (maxLengthLiteral = (String)eAnnotation.getDetails().get((Object)"maxLength")) != null) {
            return Integer.parseInt(maxLengthLiteral);
        }
        return -1;
    }

    public void setMaxLengthFacet(EDataType eDataType, int length) {
        if (length == -1) {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove((Object)"maxLength");
            }
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, true);
            eAnnotation.getDetails().put((Object)"maxLength", (Object)Integer.toString(length));
        }
    }

    public String getMinExclusiveFacet(EDataType eDataType) {
        EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
        return eAnnotation == null ? null : (String)eAnnotation.getDetails().get((Object)"minExclusive");
    }

    public void setMinExclusiveFacet(EDataType eDataType, String literal) {
        if (literal == null) {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove((Object)"minExclusive");
            }
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, true);
            eAnnotation.getDetails().put((Object)"minExclusive", (Object)literal);
        }
    }

    public String getMaxExclusiveFacet(EDataType eDataType) {
        EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
        return eAnnotation == null ? null : (String)eAnnotation.getDetails().get((Object)"maxExclusive");
    }

    public void setMaxExclusiveFacet(EDataType eDataType, String literal) {
        if (literal == null) {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove((Object)"maxExclusive");
            }
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, true);
            eAnnotation.getDetails().put((Object)"maxExclusive", (Object)literal);
        }
    }

    public String getMinInclusiveFacet(EDataType eDataType) {
        EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
        return eAnnotation == null ? null : (String)eAnnotation.getDetails().get((Object)"minInclusive");
    }

    public void setMinInclusiveFacet(EDataType eDataType, String literal) {
        if (literal == null) {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove((Object)"minInclusive");
            }
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, true);
            eAnnotation.getDetails().put((Object)"minInclusive", (Object)literal);
        }
    }

    public String getMaxInclusiveFacet(EDataType eDataType) {
        EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
        return eAnnotation == null ? null : (String)eAnnotation.getDetails().get((Object)"maxInclusive");
    }

    public void setMaxInclusiveFacet(EDataType eDataType, String literal) {
        if (literal == null) {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove((Object)"maxInclusive");
            }
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, true);
            eAnnotation.getDetails().put((Object)"maxInclusive", (Object)literal);
        }
    }

    public EPackage demandPackage(String namespace) {
        EPackage ePackage = this.demandRegistry.getEPackage(namespace);
        if (ePackage == null) {
            ePackage = EcoreFactory.eINSTANCE.createEPackage();
            ePackage.setNsURI(namespace);
            this.setQualified(ePackage, namespace != null);
            if (namespace != null) {
                ePackage.setNsPrefix("_");
            }
            this.demandRegistry.put(namespace, ePackage);
            EClass documentRootEClass = EcoreFactory.eINSTANCE.createEClass();
            documentRootEClass.getESuperTypes().add((Object)XMLTypePackage.eINSTANCE.getXMLTypeDocumentRoot());
            documentRootEClass.setName("DocumentRoot");
            ePackage.getEClassifiers().add((Object)documentRootEClass);
            this.setDocumentRoot(documentRootEClass);
        }
        return ePackage;
    }

    public EClassifier demandType(String namespace, String name) {
        EPackage ePackage = this.demandPackage(namespace);
        EClassifier eClassifier = this.getType(ePackage, name);
        if (eClassifier != null) {
            return eClassifier;
        }
        EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        eClass.setName(name);
        eClass.getESuperTypes().add((Object)XMLTypePackage.eINSTANCE.getAnyType());
        this.setContentKind(eClass, 3);
        ePackage.getEClassifiers().add((Object)eClass);
        return eClass;
    }

    public EStructuralFeature demandFeature(String namespace, String name, boolean isElement) {
        return this.demandFeature(namespace, name, isElement, isElement);
    }

    public EStructuralFeature demandFeature(String namespace, String name, boolean isElement, boolean isReference) {
        EStructuralFeature eStructuralFeature;
        EPackage ePackage = this.demandPackage(namespace);
        EClass documentRootEClass = this.getDocumentRoot(ePackage);
        EStructuralFeature eStructuralFeature2 = eStructuralFeature = isElement ? this.getLocalElement(documentRootEClass, namespace, name) : this.getLocalAttribute(documentRootEClass, namespace, name);
        if (eStructuralFeature != null) {
            return eStructuralFeature;
        }
        if (isReference) {
            EReference eReference = EcoreFactory.eINSTANCE.createEReference();
            eReference.setContainment(isElement);
            eReference.setEType(EcorePackage.eINSTANCE.getEObject());
            eReference.setName(name);
            eReference.setDerived(true);
            eReference.setTransient(true);
            eReference.setVolatile(true);
            documentRootEClass.getEStructuralFeatures().add((Object)eReference);
            this.setFeatureKind(eReference, isElement ? 4 : 2);
            this.setNamespace(eReference, namespace);
            if (isElement) {
                eReference.setUpperBound(-2);
            }
            return eReference;
        }
        EAttribute eAttribute = EcoreFactory.eINSTANCE.createEAttribute();
        eAttribute.setName(name);
        eAttribute.setEType(XMLTypePackage.eINSTANCE.getAnySimpleType());
        eAttribute.setDerived(true);
        eAttribute.setTransient(true);
        eAttribute.setVolatile(true);
        documentRootEClass.getEStructuralFeatures().add((Object)eAttribute);
        this.setFeatureKind(eAttribute, isElement ? 4 : 2);
        this.setNamespace(eAttribute, namespace);
        if (isElement) {
            eAttribute.setUpperBound(-2);
        }
        return eAttribute;
    }

    public Collection demandedPackages() {
        return this.demandRegistry.values();
    }
}

