/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import org.eclipse.hyades.logging.core.XmlUtility;
import org.eclipse.hyades.logging.events.AssociationEngineImpl;
import org.eclipse.hyades.logging.events.IAssociatedEvent;
import org.eclipse.hyades.logging.events.IAssociationEngine;
import org.eclipse.hyades.logging.events.IAvailableSituation;
import org.eclipse.hyades.logging.events.ICommonBaseEvent;
import org.eclipse.hyades.logging.events.ICommonBaseEventAnyElement;
import org.eclipse.hyades.logging.events.IComponentIdentification;
import org.eclipse.hyades.logging.events.IConfigureSituation;
import org.eclipse.hyades.logging.events.IConnectSituation;
import org.eclipse.hyades.logging.events.IContextDataElement;
import org.eclipse.hyades.logging.events.ICreateSituation;
import org.eclipse.hyades.logging.events.IDependencySituation;
import org.eclipse.hyades.logging.events.IDestroySituation;
import org.eclipse.hyades.logging.events.IExtendedDataElement;
import org.eclipse.hyades.logging.events.IFeatureSituation;
import org.eclipse.hyades.logging.events.IMsgCatalogToken;
import org.eclipse.hyades.logging.events.IMsgDataElement;
import org.eclipse.hyades.logging.events.IOtherSituation;
import org.eclipse.hyades.logging.events.IReportSituation;
import org.eclipse.hyades.logging.events.IRequestSituation;
import org.eclipse.hyades.logging.events.ISimpleEventFactory;
import org.eclipse.hyades.logging.events.ISituation;
import org.eclipse.hyades.logging.events.ISituationType;
import org.eclipse.hyades.logging.events.IStartSituation;
import org.eclipse.hyades.logging.events.IStopSituation;
import org.eclipse.hyades.logging.events.SimpleEventFactoryImpl;
import org.eclipse.hyades.logging.events.exceptions.InvalidXMLAnyElementException;

public final class CbeFormatter {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static ISimpleEventFactory factory = SimpleEventFactoryImpl.getInstance();
    public static final String xml_version = "1.0.1";

    public static synchronized String toCanonicalXMLString(IAssociationEngine iAssociationEngine) {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("<AssociationEngine");
        String string = iAssociationEngine.getId();
        if (string != null) {
            stringBuffer.append(" id=\"");
            stringBuffer.append(XmlUtility.normalize((String)string));
            stringBuffer.append("\"");
        }
        if ((string = iAssociationEngine.getName()) != null) {
            stringBuffer.append(" name=\"");
            stringBuffer.append(XmlUtility.normalize((String)string));
            stringBuffer.append("\"");
        }
        if ((string = iAssociationEngine.getType()) != null) {
            stringBuffer.append(" type=\"");
            stringBuffer.append(XmlUtility.normalize((String)string));
            stringBuffer.append("\"");
        }
        stringBuffer.append("/>");
        return stringBuffer.toString();
    }

    public static synchronized void fromCanonicalXMLString(IAssociationEngine iAssociationEngine, String string) {
        int n = string.indexOf(" id=\"");
        if (n != -1) {
            iAssociationEngine.setId(XmlUtility.denormalize((String)string.substring(n + 5, string.indexOf("\"", n + 5))));
        }
        if ((n = string.indexOf(" name=\"")) != -1) {
            iAssociationEngine.setName(XmlUtility.denormalize((String)string.substring(n + 7, string.indexOf("\"", n + 7))));
        }
        if ((n = string.indexOf(" type=\"")) != -1) {
            iAssociationEngine.setType(XmlUtility.denormalize((String)string.substring(n + 7, string.indexOf("\"", n + 7))));
        }
    }

    public static synchronized void fromCanonicalXMLDocString(IAssociationEngine iAssociationEngine, String string) {
        CbeFormatter.fromCanonicalXMLString(iAssociationEngine, string);
    }

    public static synchronized String toCanonicalXMLDocString(AssociationEngineImpl associationEngineImpl) {
        return CbeFormatter.toCanonicalXMLDocString(associationEngineImpl, true);
    }

    public static synchronized String toCanonicalXMLDocString(AssociationEngineImpl associationEngineImpl, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("<CommonBaseEvents xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"commonbaseevent1_0.xsd\">");
        if (bl) {
            stringBuffer.append(LINE_SEPARATOR);
            stringBuffer.append("\t");
        }
        stringBuffer.append(CbeFormatter.toCanonicalXMLString(associationEngineImpl));
        if (bl) {
            stringBuffer.append(LINE_SEPARATOR);
        }
        stringBuffer.append("</CommonBaseEvents>");
        return stringBuffer.toString();
    }

    public static synchronized String toCanonicalXMLString(ICommonBaseEvent iCommonBaseEvent) {
        return CbeFormatter.toCanonicalXMLString(iCommonBaseEvent, true);
    }

    public static synchronized String toCanonicalXMLString(ICommonBaseEvent iCommonBaseEvent, boolean bl) {
        String string = iCommonBaseEvent.getVersion();
        if (string != null && string.trim().equals("1.0")) {
            return CbeFormatter.toCanonicalVersion_1_0_XMLString(iCommonBaseEvent, bl);
        }
        return CbeFormatter.toCanonicalVersion_1_0_1_XMLString(iCommonBaseEvent, bl);
    }

    private static synchronized String toCanonicalVersion_1_0_XMLString(ICommonBaseEvent iCommonBaseEvent, boolean bl) {
        int n;
        List list;
        IComponentIdentification iComponentIdentification;
        Object object;
        List list2;
        List list3;
        String string;
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("<CommonBaseEvent");
        if (iCommonBaseEvent.isSetCreationTime()) {
            stringBuffer.append(" creationTime=\"");
            stringBuffer.append(XmlUtility.normalize((String)iCommonBaseEvent.getCreationTime()));
            stringBuffer.append("\"");
        }
        if ((string = iCommonBaseEvent.getExtensionName()) != null) {
            stringBuffer.append(" extensionName=\"");
            stringBuffer.append(XmlUtility.normalize((String)string));
            stringBuffer.append("\"");
        }
        if ((string = iCommonBaseEvent.getGlobalInstanceId()) != null) {
            stringBuffer.append(" globalInstanceId=\"");
            stringBuffer.append(XmlUtility.normalize((String)string));
            stringBuffer.append("\"");
        }
        if ((string = iCommonBaseEvent.getLocalInstanceId()) != null) {
            stringBuffer.append(" localInstanceId=\"");
            stringBuffer.append(XmlUtility.normalize((String)string));
            stringBuffer.append("\"");
        }
        if ((string = iCommonBaseEvent.getMsg()) != null) {
            stringBuffer.append(" msg=\"");
            stringBuffer.append(XmlUtility.normalize((String)string));
            stringBuffer.append("\"");
        }
        if ((string = iCommonBaseEvent.getSituationType()) != null) {
            stringBuffer.append(" situationType=\"");
            stringBuffer.append(XmlUtility.normalize((String)string));
            stringBuffer.append("\"");
        }
        if (iCommonBaseEvent.isSetElapsedTime()) {
            stringBuffer.append(" elapsedTime=\"");
            stringBuffer.append(iCommonBaseEvent.getElapsedTime());
            stringBuffer.append("\"");
        }
        if (iCommonBaseEvent.isSetPriority()) {
            stringBuffer.append(" priority=\"");
            stringBuffer.append(iCommonBaseEvent.getPriority());
            stringBuffer.append("\"");
        }
        if (iCommonBaseEvent.isSetRepeatCount()) {
            stringBuffer.append(" repeatCount=\"");
            stringBuffer.append(iCommonBaseEvent.getRepeatCount());
            stringBuffer.append("\"");
        }
        if (iCommonBaseEvent.isSetSequenceNumber()) {
            stringBuffer.append(" sequenceNumber=\"");
            stringBuffer.append(iCommonBaseEvent.getSequenceNumber());
            stringBuffer.append("\"");
        }
        if (iCommonBaseEvent.isSetSeverity()) {
            stringBuffer.append(" severity=\"");
            stringBuffer.append(iCommonBaseEvent.getSeverity());
            stringBuffer.append("\"");
        }
        if ((string = iCommonBaseEvent.getVersion()) != null) {
            stringBuffer.append(" version=\"");
            stringBuffer.append(XmlUtility.normalize((String)string));
            stringBuffer.append("\"");
        }
        stringBuffer.append(">");
        List list4 = iCommonBaseEvent.getContextDataElements();
        if (list4 != null) {
            for (int i = 0; i < list4.size(); ++i) {
                if (list4.get(i) == null) continue;
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t");
                }
                stringBuffer.append("<contextDataElements");
                string = ((IContextDataElement)list4.get(i)).getName();
                if (string != null) {
                    stringBuffer.append(" name=\"");
                    stringBuffer.append(XmlUtility.normalize((String)string));
                    stringBuffer.append("\"");
                }
                if ((string = ((IContextDataElement)list4.get(i)).getType()) != null) {
                    stringBuffer.append(" type=\"");
                    stringBuffer.append(XmlUtility.normalize((String)string));
                    stringBuffer.append("\"");
                }
                stringBuffer.append(">");
                string = ((IContextDataElement)list4.get(i)).getContextId();
                if (string != null) {
                    if (bl) {
                        stringBuffer.append(LINE_SEPARATOR);
                        stringBuffer.append("\t\t");
                    }
                    stringBuffer.append("<contextId>");
                    stringBuffer.append(XmlUtility.normalize((String)string));
                    stringBuffer.append("</contextId>");
                } else {
                    string = ((IContextDataElement)list4.get(i)).getContextValue();
                    if (string != null) {
                        if (bl) {
                            stringBuffer.append(LINE_SEPARATOR);
                            stringBuffer.append("\t\t");
                        }
                        stringBuffer.append("<contextValue>");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("</contextValue>");
                    }
                }
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t");
                }
                stringBuffer.append("</contextDataElements>");
            }
        }
        if ((list3 = iCommonBaseEvent.getExtendedDataElements()) != null) {
            for (int i = 0; i < list3.size(); ++i) {
                stringBuffer.append(CbeFormatter.getIExtendedDataElementXML((IExtendedDataElement)list3.get(i), "extendedDataElements", bl, bl ? 1 : 0));
            }
        }
        if ((list2 = iCommonBaseEvent.getAssociatedEvents()) != null) {
            for (int i = 0; i < list2.size(); ++i) {
                if (list2.get(i) == null) continue;
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t");
                }
                stringBuffer.append("<associatedEvents");
                if (((IAssociatedEvent)list2.get(i)).getAssociationEngine() != null && (string = ((IAssociatedEvent)list2.get(i)).getAssociationEngine()) != null) {
                    stringBuffer.append(" associationEngine=\"");
                    stringBuffer.append(XmlUtility.normalize((String)string));
                    stringBuffer.append("\"");
                }
                if ((object = ((IAssociatedEvent)list2.get(i)).getResolvedEvents()) != null) {
                    stringBuffer.append(" resolvedEvents=\"");
                    stringBuffer.append((String)object);
                    stringBuffer.append("\"");
                }
                stringBuffer.append("/>");
            }
        }
        if ((iComponentIdentification = iCommonBaseEvent.getReporterComponentId()) != null) {
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                stringBuffer.append("\t");
            }
            stringBuffer.append("<reporterComponentId");
            string = iComponentIdentification.getApplication();
            if (string != null) {
                stringBuffer.append(" application=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getComponent()) != null) {
                stringBuffer.append(" component=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getComponentIdType()) != null) {
                stringBuffer.append(" componentIdType=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getExecutionEnvironment()) != null) {
                stringBuffer.append(" executionEnvironment=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getInstanceId()) != null) {
                stringBuffer.append(" instanceId=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getLocation()) != null) {
                stringBuffer.append(" location=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getLocationType()) != null) {
                stringBuffer.append(" locationType=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getProcessId()) != null) {
                stringBuffer.append(" processId=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getSubComponent()) != null) {
                stringBuffer.append(" subComponent=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getThreadId()) != null) {
                stringBuffer.append(" threadId=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            stringBuffer.append("/>");
        }
        if ((iComponentIdentification = iCommonBaseEvent.getSourceComponentId()) != null) {
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                stringBuffer.append("\t");
            }
            stringBuffer.append("<sourceComponentId");
            string = iComponentIdentification.getApplication();
            if (string != null) {
                stringBuffer.append(" application=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getComponent()) != null) {
                stringBuffer.append(" component=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getComponentIdType()) != null) {
                stringBuffer.append(" componentIdType=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getExecutionEnvironment()) != null) {
                stringBuffer.append(" executionEnvironment=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getInstanceId()) != null) {
                stringBuffer.append(" instanceId=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getLocation()) != null) {
                stringBuffer.append(" location=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getLocationType()) != null) {
                stringBuffer.append(" locationType=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getProcessId()) != null) {
                stringBuffer.append(" processId=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getSubComponent()) != null) {
                stringBuffer.append(" subComponent=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getThreadId()) != null) {
                stringBuffer.append(" threadId=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            stringBuffer.append("/>");
        }
        if ((object = iCommonBaseEvent.getMsgDataElement()) != null) {
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                stringBuffer.append("\t");
            }
            stringBuffer.append("<msgDataElement");
            string = object.getMsgLocale();
            if (string != null) {
                stringBuffer.append(" msgLocale=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            stringBuffer.append(">");
            list = object.getMsgCatalogTokens();
            if (list != null) {
                for (n = 0; n < list.size(); ++n) {
                    if (list.get(n) == null || ((IMsgCatalogToken)list.get(n)).getValue() == null) continue;
                    if (bl) {
                        stringBuffer.append(LINE_SEPARATOR);
                        stringBuffer.append("\t\t");
                    }
                    stringBuffer.append("<msgCatalogTokens value=\"");
                    stringBuffer.append(XmlUtility.normalize((String)((IMsgCatalogToken)list.get(n)).getValue()));
                    stringBuffer.append("\"/>");
                }
            }
            if ((string = object.getMsgId()) != null) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                stringBuffer.append("<msgId>");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("</msgId>");
            }
            if ((string = object.getMsgIdType()) != null) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                stringBuffer.append("<msgIdType>");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("</msgIdType>");
            }
            if ((string = object.getMsgCatalogId()) != null) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                stringBuffer.append("<msgCatalogId>");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("</msgCatalogId>");
            }
            if ((string = object.getMsgCatalogType()) != null) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                stringBuffer.append("<msgCatalogType>");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("</msgCatalogType>");
            }
            if ((string = object.getMsgCatalog()) != null) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                stringBuffer.append("<msgCatalog>");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("</msgCatalog>");
            }
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                stringBuffer.append("\t");
            }
            stringBuffer.append("</msgDataElement>");
        }
        if ((list = iCommonBaseEvent.getAnyElements()) != null) {
            for (n = 0; n < list.size(); ++n) {
                if (list.get(n) == null) continue;
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t");
                }
                stringBuffer.append(((ICommonBaseEventAnyElement)list.get(n)).getXmlAnyElement());
            }
        }
        if (bl) {
            stringBuffer.append(LINE_SEPARATOR);
        }
        stringBuffer.append("</CommonBaseEvent>");
        return stringBuffer.toString();
    }

    private static synchronized String toCanonicalVersion_1_0_1_XMLString(ICommonBaseEvent iCommonBaseEvent, boolean bl) {
        String[] stringArray;
        int n;
        String[] stringArray2;
        IComponentIdentification iComponentIdentification;
        Object object;
        Object object2;
        List list;
        List list2;
        String string;
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("<CommonBaseEvent");
        if (iCommonBaseEvent.isSetCreationTime()) {
            stringBuffer.append(" creationTime=\"");
            stringBuffer.append(XmlUtility.normalize((String)iCommonBaseEvent.getCreationTime()));
            stringBuffer.append("\"");
        }
        if ((string = iCommonBaseEvent.getExtensionName()) != null) {
            stringBuffer.append(" extensionName=\"");
            stringBuffer.append(XmlUtility.normalize((String)string));
            stringBuffer.append("\"");
        }
        if ((string = iCommonBaseEvent.getGlobalInstanceId()) != null) {
            stringBuffer.append(" globalInstanceId=\"");
            stringBuffer.append(XmlUtility.normalize((String)string));
            stringBuffer.append("\"");
        }
        if ((string = iCommonBaseEvent.getLocalInstanceId()) != null) {
            stringBuffer.append(" localInstanceId=\"");
            stringBuffer.append(XmlUtility.normalize((String)string));
            stringBuffer.append("\"");
        }
        if ((string = iCommonBaseEvent.getMsg()) != null) {
            stringBuffer.append(" msg=\"");
            stringBuffer.append(XmlUtility.normalize((String)string));
            stringBuffer.append("\"");
        }
        if (iCommonBaseEvent.isSetElapsedTime()) {
            stringBuffer.append(" elapsedTime=\"");
            stringBuffer.append(iCommonBaseEvent.getElapsedTime());
            stringBuffer.append("\"");
        }
        if (iCommonBaseEvent.isSetPriority()) {
            stringBuffer.append(" priority=\"");
            stringBuffer.append(iCommonBaseEvent.getPriority());
            stringBuffer.append("\"");
        }
        if (iCommonBaseEvent.isSetRepeatCount()) {
            stringBuffer.append(" repeatCount=\"");
            stringBuffer.append(iCommonBaseEvent.getRepeatCount());
            stringBuffer.append("\"");
        }
        if (iCommonBaseEvent.isSetSequenceNumber()) {
            stringBuffer.append(" sequenceNumber=\"");
            stringBuffer.append(iCommonBaseEvent.getSequenceNumber());
            stringBuffer.append("\"");
        }
        if (iCommonBaseEvent.isSetSeverity()) {
            stringBuffer.append(" severity=\"");
            stringBuffer.append(iCommonBaseEvent.getSeverity());
            stringBuffer.append("\"");
        }
        if ((string = iCommonBaseEvent.getVersion()) != null) {
            stringBuffer.append(" version=\"");
            stringBuffer.append(XmlUtility.normalize((String)string));
            stringBuffer.append("\"");
        }
        stringBuffer.append(">");
        List list3 = iCommonBaseEvent.getContextDataElements();
        if (list3 != null) {
            for (int i = 0; i < list3.size(); ++i) {
                if (list3.get(i) == null) continue;
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t");
                }
                stringBuffer.append("<contextDataElements");
                string = ((IContextDataElement)list3.get(i)).getName();
                if (string != null) {
                    stringBuffer.append(" name=\"");
                    stringBuffer.append(XmlUtility.normalize((String)string));
                    stringBuffer.append("\"");
                }
                if ((string = ((IContextDataElement)list3.get(i)).getType()) != null) {
                    stringBuffer.append(" type=\"");
                    stringBuffer.append(XmlUtility.normalize((String)string));
                    stringBuffer.append("\"");
                }
                stringBuffer.append(">");
                string = ((IContextDataElement)list3.get(i)).getContextId();
                if (string != null) {
                    if (bl) {
                        stringBuffer.append(LINE_SEPARATOR);
                        stringBuffer.append("\t\t");
                    }
                    stringBuffer.append("<contextId>");
                    stringBuffer.append(XmlUtility.normalize((String)string));
                    stringBuffer.append("</contextId>");
                } else {
                    string = ((IContextDataElement)list3.get(i)).getContextValue();
                    if (string != null) {
                        if (bl) {
                            stringBuffer.append(LINE_SEPARATOR);
                            stringBuffer.append("\t\t");
                        }
                        stringBuffer.append("<contextValue>");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("</contextValue>");
                    }
                }
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t");
                }
                stringBuffer.append("</contextDataElements>");
            }
        }
        if ((list2 = iCommonBaseEvent.getExtendedDataElements()) != null) {
            for (int i = 0; i < list2.size(); ++i) {
                stringBuffer.append(CbeFormatter.getIExtendedDataElementXML((IExtendedDataElement)list2.get(i), "extendedDataElements", bl, bl ? 1 : 0));
            }
        }
        if ((list = iCommonBaseEvent.getAssociatedEvents()) != null) {
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) == null) continue;
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t");
                }
                stringBuffer.append("<associatedEvents");
                object2 = ((IAssociatedEvent)list.get(i)).getResolvedEvents();
                if (object2 != null) {
                    stringBuffer.append(" resolvedEvents=\"");
                    stringBuffer.append((String)object2);
                    stringBuffer.append("\"");
                }
                stringBuffer.append(">");
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                if ((object = ((IAssociatedEvent)list.get(i)).getAssociationEngineInfo()) != null) {
                    String string2 = CbeFormatter.toCanonicalXMLString((IAssociationEngine)object).trim();
                    stringBuffer.append("<associationEngineInfo");
                    stringBuffer.append(string2.substring(18));
                } else {
                    string = ((IAssociatedEvent)list.get(i)).getAssociationEngine();
                    if (string != null) {
                        stringBuffer.append("<associationEngine>");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("</associationEngine>");
                    }
                }
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t");
                }
                stringBuffer.append("</associatedEvents>");
            }
        }
        if ((iComponentIdentification = iCommonBaseEvent.getReporterComponentId()) != null) {
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                stringBuffer.append("\t");
            }
            stringBuffer.append("<reporterComponentId");
            string = iComponentIdentification.getApplication();
            if (string != null) {
                stringBuffer.append(" application=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getComponent()) != null) {
                stringBuffer.append(" component=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getComponentIdType()) != null) {
                stringBuffer.append(" componentIdType=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getExecutionEnvironment()) != null) {
                stringBuffer.append(" executionEnvironment=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getInstanceId()) != null) {
                stringBuffer.append(" instanceId=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getLocation()) != null) {
                stringBuffer.append(" location=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getLocationType()) != null) {
                stringBuffer.append(" locationType=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getProcessId()) != null) {
                stringBuffer.append(" processId=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getSubComponent()) != null) {
                stringBuffer.append(" subComponent=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getThreadId()) != null) {
                stringBuffer.append(" threadId=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getComponentType()) != null) {
                stringBuffer.append(" componentType=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            stringBuffer.append("/>");
        }
        if ((iComponentIdentification = iCommonBaseEvent.getSourceComponentId()) != null) {
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                stringBuffer.append("\t");
            }
            stringBuffer.append("<sourceComponentId");
            string = iComponentIdentification.getApplication();
            if (string != null) {
                stringBuffer.append(" application=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getComponent()) != null) {
                stringBuffer.append(" component=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getComponentIdType()) != null) {
                stringBuffer.append(" componentIdType=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getExecutionEnvironment()) != null) {
                stringBuffer.append(" executionEnvironment=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getInstanceId()) != null) {
                stringBuffer.append(" instanceId=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getLocation()) != null) {
                stringBuffer.append(" location=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getLocationType()) != null) {
                stringBuffer.append(" locationType=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getProcessId()) != null) {
                stringBuffer.append(" processId=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getSubComponent()) != null) {
                stringBuffer.append(" subComponent=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getThreadId()) != null) {
                stringBuffer.append(" threadId=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getComponentType()) != null) {
                stringBuffer.append(" componentType=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            stringBuffer.append("/>");
        }
        if ((object2 = iCommonBaseEvent.getMsgDataElement()) != null) {
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                stringBuffer.append("\t");
            }
            stringBuffer.append("<msgDataElement");
            string = object2.getMsgLocale();
            if (string != null) {
                stringBuffer.append(" msgLocale=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            stringBuffer.append(">");
            object = object2.getMsgCatalogTokens();
            if (object != null) {
                for (int i = 0; i < object.size(); ++i) {
                    if (object.get(i) == null || ((IMsgCatalogToken)object.get(i)).getValue() == null) continue;
                    if (bl) {
                        stringBuffer.append(LINE_SEPARATOR);
                        stringBuffer.append("\t\t");
                    }
                    stringBuffer.append("<msgCatalogTokens value=\"");
                    stringBuffer.append(XmlUtility.normalize((String)((IMsgCatalogToken)object.get(i)).getValue()));
                    stringBuffer.append("\"/>");
                }
            }
            if ((string = object2.getMsgId()) != null) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                stringBuffer.append("<msgId>");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("</msgId>");
            }
            if ((string = object2.getMsgIdType()) != null) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                stringBuffer.append("<msgIdType>");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("</msgIdType>");
            }
            if ((string = object2.getMsgCatalogId()) != null) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                stringBuffer.append("<msgCatalogId>");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("</msgCatalogId>");
            }
            if ((string = object2.getMsgCatalogType()) != null) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                stringBuffer.append("<msgCatalogType>");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("</msgCatalogType>");
            }
            if ((string = object2.getMsgCatalog()) != null) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                stringBuffer.append("<msgCatalog>");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("</msgCatalog>");
            }
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                stringBuffer.append("\t");
            }
            stringBuffer.append("</msgDataElement>");
        }
        if ((object = iCommonBaseEvent.getSituation()) == null) {
            string = iCommonBaseEvent.getSituationType();
            if (string != null) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t");
                }
                stringBuffer.append("<situation categoryName=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\">");
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                stringBuffer.append("<reportSituation reasoningScope=\"INTERNAL\" reportCategory=\"LOG\"/>");
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t");
                }
                stringBuffer.append("</situation>");
            }
        } else {
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                stringBuffer.append("\t");
            }
            stringBuffer.append("<situation");
            string = object.getCategoryName();
            if (string != null) {
                stringBuffer.append(" categoryName=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            stringBuffer.append(">");
            ISituationType iSituationType = object.getSituationType();
            if (iSituationType != null) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                stringBuffer.append("<situationType");
                string = iSituationType.getReasoningScope();
                if (iSituationType instanceof IStartSituation) {
                    stringBuffer.append(" xsi:type=\"StartSituation\"");
                    if (string != null) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((IStartSituation)iSituationType).getSuccessDisposition()) != null) {
                        stringBuffer.append(" successDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((IStartSituation)iSituationType).getSituationQualifier()) != null) {
                        stringBuffer.append(" situationQualifier=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (iSituationType instanceof IStopSituation) {
                    stringBuffer.append(" xsi:type=\"StopSituation\"");
                    if (string != null) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((IStopSituation)iSituationType).getSuccessDisposition()) != null) {
                        stringBuffer.append(" successDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((IStopSituation)iSituationType).getSituationQualifier()) != null) {
                        stringBuffer.append(" situationQualifier=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (iSituationType instanceof IConnectSituation) {
                    stringBuffer.append(" xsi:type=\"ConnectSituation\"");
                    if (string != null) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((IConnectSituation)iSituationType).getSuccessDisposition()) != null) {
                        stringBuffer.append(" successDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((IConnectSituation)iSituationType).getSituationDisposition()) != null) {
                        stringBuffer.append(" situationDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (iSituationType instanceof IReportSituation) {
                    stringBuffer.append(" xsi:type=\"ReportSituation\"");
                    if (string != null) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((IReportSituation)iSituationType).getReportCategory()) != null) {
                        stringBuffer.append(" reportCategory=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (iSituationType instanceof IFeatureSituation) {
                    stringBuffer.append(" xsi:type=\"FeatureSituation\"");
                    if (string != null) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((IFeatureSituation)iSituationType).getFeatureDisposition()) != null) {
                        stringBuffer.append(" featureDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (iSituationType instanceof IConfigureSituation) {
                    stringBuffer.append(" xsi:type=\"ConfigureSituation\"");
                    if (string != null) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((IConfigureSituation)iSituationType).getSuccessDisposition()) != null) {
                        stringBuffer.append(" successDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (iSituationType instanceof IDependencySituation) {
                    stringBuffer.append(" xsi:type=\"DependencySituation\"");
                    if (string != null) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((IDependencySituation)iSituationType).getDependencyDisposition()) != null) {
                        stringBuffer.append(" dependencyDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (iSituationType instanceof ICreateSituation) {
                    stringBuffer.append(" xsi:type=\"CreateSituation\"");
                    if (string != null) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((ICreateSituation)iSituationType).getSuccessDisposition()) != null) {
                        stringBuffer.append(" successDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (iSituationType instanceof IDestroySituation) {
                    stringBuffer.append(" xsi:type=\"DestroySituation\"");
                    if (string != null) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((IDestroySituation)iSituationType).getSuccessDisposition()) != null) {
                        stringBuffer.append(" successDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (iSituationType instanceof IAvailableSituation) {
                    stringBuffer.append(" xsi:type=\"AvailableSituation\"");
                    if (string != null) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((IAvailableSituation)iSituationType).getOperationDisposition()) != null) {
                        stringBuffer.append(" operationDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((IAvailableSituation)iSituationType).getProcessingDisposition()) != null) {
                        stringBuffer.append(" processingDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((IAvailableSituation)iSituationType).getAvailabilityDisposition()) != null) {
                        stringBuffer.append(" availabilityDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (iSituationType instanceof IRequestSituation) {
                    stringBuffer.append(" xsi:type=\"RequestSituation\"");
                    if (string != null) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((IRequestSituation)iSituationType).getSuccessDisposition()) != null) {
                        stringBuffer.append(" successDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((IRequestSituation)iSituationType).getSituationQualifier()) != null) {
                        stringBuffer.append(" situationQualifier=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (iSituationType instanceof IOtherSituation) {
                    stringBuffer.append(" xsi:type=\"OtherSituation\"");
                    if (string != null) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append(">");
                    stringArray2 = ((IOtherSituation)iSituationType).getAnyData();
                    if (stringArray2 != null) {
                        for (n = 0; n < stringArray2.length; ++n) {
                            if (stringArray2[n] == null || stringArray2[n].length() <= 0) continue;
                            if (bl) {
                                stringBuffer.append(LINE_SEPARATOR);
                                stringBuffer.append("\t\t\t");
                            }
                            stringBuffer.append(stringArray2[n]);
                        }
                    }
                    if (bl) {
                        stringBuffer.append(LINE_SEPARATOR);
                        stringBuffer.append("\t\t");
                    }
                    stringBuffer.append("</situationType>");
                } else {
                    stringBuffer.append("/>");
                }
            }
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                stringBuffer.append("\t");
            }
            stringBuffer.append("</situation>");
        }
        if ((stringArray = iCommonBaseEvent.getOtherData()) == null) {
            stringArray2 = iCommonBaseEvent.getAnyElements();
            if (stringArray2 != null) {
                for (n = 0; n < stringArray2.size(); ++n) {
                    if (stringArray2.get(n) == null) continue;
                    if (bl) {
                        stringBuffer.append(LINE_SEPARATOR);
                        stringBuffer.append("\t");
                    }
                    stringBuffer.append(((ICommonBaseEventAnyElement)stringArray2.get(n)).getXmlAnyElement());
                }
            }
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].length() <= 0) continue;
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t");
                }
                stringBuffer.append(stringArray[i]);
            }
        }
        if (bl) {
            stringBuffer.append(LINE_SEPARATOR);
        }
        stringBuffer.append("</CommonBaseEvent>");
        return stringBuffer.toString();
    }

    private static String getIExtendedDataElementXML(IExtendedDataElement iExtendedDataElement, String string, boolean bl, int n) {
        if (iExtendedDataElement != null) {
            int n2;
            Object object;
            StringBuffer stringBuffer = new StringBuffer(512);
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append("\t");
                }
            }
            stringBuffer.append("<");
            stringBuffer.append(string);
            String string2 = iExtendedDataElement.getName();
            if (string2 != null) {
                stringBuffer.append(" name=\"");
                stringBuffer.append(XmlUtility.normalize((String)string2));
                stringBuffer.append("\"");
            }
            if ((string2 = iExtendedDataElement.getType()) != null) {
                stringBuffer.append(" type=\"");
                stringBuffer.append(XmlUtility.normalize((String)string2));
                stringBuffer.append("\"");
            }
            stringBuffer.append(">");
            if (iExtendedDataElement.getTypeValue() == 18) {
                object = iExtendedDataElement.getHexValues();
                if (object != null && ((char[])object).length > 0) {
                    if (bl) {
                        stringBuffer.append(LINE_SEPARATOR);
                        for (int i = 0; i < n + 1; ++i) {
                            stringBuffer.append("\t");
                        }
                    }
                    stringBuffer.append("<hexValue>");
                    String string3 = null;
                    for (n2 = 0; n2 < ((Object)object).length; ++n2) {
                        string3 = Integer.toHexString((int)object[n2]).toUpperCase();
                        if (string3.length() == 1 || string3.length() == 3) {
                            stringBuffer.append('0');
                        }
                        stringBuffer.append(string3);
                    }
                    stringBuffer.append("</hexValue>");
                }
            } else {
                object = iExtendedDataElement.getValues();
                if (object != null && object.size() > 0) {
                    for (int i = 0; i < object.size(); ++i) {
                        if (object.get(i) == null || ((String)object.get(i)).length() <= 0) continue;
                        if (bl) {
                            stringBuffer.append(LINE_SEPARATOR);
                            for (n2 = 0; n2 < n + 1; ++n2) {
                                stringBuffer.append("\t");
                            }
                        }
                        stringBuffer.append("<values>");
                        stringBuffer.append(XmlUtility.normalize((String)((String)object.get(i))));
                        stringBuffer.append("</values>");
                    }
                }
            }
            if ((object = iExtendedDataElement.getChildDataElements()) != null) {
                for (int i = 0; i < object.size(); ++i) {
                    stringBuffer.append(CbeFormatter.getIExtendedDataElementXML((IExtendedDataElement)object.get(i), "children", bl, bl ? n + 1 : 0));
                }
            }
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append("\t");
                }
            }
            stringBuffer.append("</");
            stringBuffer.append(string);
            stringBuffer.append(">");
            return stringBuffer.toString();
        }
        return "";
    }

    public static synchronized String toCanonicalXMLDocString(ICommonBaseEvent iCommonBaseEvent) {
        return CbeFormatter.toCanonicalXMLDocString(iCommonBaseEvent, true);
    }

    public static synchronized String toCanonicalXMLDocString(ICommonBaseEvent iCommonBaseEvent, boolean bl) {
        String string = iCommonBaseEvent.getVersion();
        if (string != null && string.trim().equals("1.0")) {
            return CbeFormatter.toCanonicalVersion_1_0_XMLDocString(iCommonBaseEvent, bl);
        }
        return CbeFormatter.toCanonicalVersion_1_0_1_XMLDocString(iCommonBaseEvent, bl);
    }

    private static synchronized String toCanonicalVersion_1_0_XMLDocString(ICommonBaseEvent iCommonBaseEvent, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("<CommonBaseEvents xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"commonbaseevent1_0.xsd\">");
        stringBuffer.append(CbeFormatter.toCanonicalVersion_1_0_XMLString(iCommonBaseEvent, bl));
        if (bl) {
            stringBuffer.append(LINE_SEPARATOR);
        }
        stringBuffer.append("</CommonBaseEvents>");
        return stringBuffer.toString();
    }

    private static synchronized String toCanonicalVersion_1_0_1_XMLDocString(ICommonBaseEvent iCommonBaseEvent, boolean bl) {
        Object object;
        List list;
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("<CommonBaseEvents xmlns=\"http://www.ibm.com/AC/commonbaseevent1_0_1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/AC/commonbaseevent1_0_1 commonbaseevent1_0_1.xsd\">");
        if (bl) {
            stringBuffer.append(LINE_SEPARATOR);
        }
        if ((list = iCommonBaseEvent.getAssociatedEvents()) != null && list.size() > 0) {
            object = null;
            for (int i = 0; i < list.size(); ++i) {
                object = ((IAssociatedEvent)list.get(i)).getAssociationEngineInfo();
                if (object == null) continue;
                if (bl) {
                    stringBuffer.append("\t");
                }
                stringBuffer.append(CbeFormatter.toCanonicalXMLString((IAssociationEngine)object));
                if (!bl) continue;
                stringBuffer.append(LINE_SEPARATOR);
            }
        }
        if (bl) {
            object = new StringTokenizer(CbeFormatter.toCanonicalVersion_1_0_1_XMLString(iCommonBaseEvent, bl).trim(), LINE_SEPARATOR);
            while (((StringTokenizer)object).hasMoreTokens()) {
                stringBuffer.append("\t");
                stringBuffer.append(((StringTokenizer)object).nextToken());
                stringBuffer.append(LINE_SEPARATOR);
            }
        } else {
            stringBuffer.append(CbeFormatter.toCanonicalVersion_1_0_1_XMLString(iCommonBaseEvent, bl));
        }
        stringBuffer.append("</CommonBaseEvents>");
        return stringBuffer.toString();
    }

    public static synchronized void fromCanonicalXMLString(ICommonBaseEvent iCommonBaseEvent, String string) {
        String string2 = iCommonBaseEvent.getVersion();
        if (string2 != null && string2.trim().equals("1.0")) {
            CbeFormatter.fromCanonical_1_0_XMLString(iCommonBaseEvent, string);
        } else {
            CbeFormatter.fromCanonical_1_0_1_XMLString(iCommonBaseEvent, string);
        }
    }

    private static synchronized void fromCanonical_1_0_XMLString(ICommonBaseEvent iCommonBaseEvent, String string) {
        Object object;
        Object object2;
        Object object3;
        int n = string.indexOf("<CommonBaseEvent ");
        int n2 = 0;
        String string2 = string.substring(n, string.indexOf(">", n + 1));
        n = string.indexOf(">", n + 1) + 1;
        n2 = string2.indexOf(" creationTime=\"");
        if (n2 != -1) {
            iCommonBaseEvent.setCreationTime(XmlUtility.denormalize((String)string2.substring(n2 + 15, string2.indexOf("\"", n2 + 15))));
        }
        if ((n2 = string2.indexOf(" extensionName=\"")) != -1) {
            iCommonBaseEvent.setExtensionName(XmlUtility.denormalize((String)string2.substring(n2 + 16, string2.indexOf("\"", n2 + 16))));
        }
        if ((n2 = string2.indexOf(" globalInstanceId=\"")) != -1) {
            iCommonBaseEvent.setGlobalInstanceId(XmlUtility.denormalize((String)string2.substring(n2 + 19, string2.indexOf("\"", n2 + 19))));
        }
        if ((n2 = string2.indexOf(" localInstanceId=\"")) != -1) {
            iCommonBaseEvent.setLocalInstanceId(XmlUtility.denormalize((String)string2.substring(n2 + 18, string2.indexOf("\"", n2 + 18))));
        }
        if ((n2 = string2.indexOf(" msg=\"")) != -1) {
            iCommonBaseEvent.setMsg(XmlUtility.denormalize((String)string2.substring(n2 + 6, string2.indexOf("\"", n2 + 6))));
        }
        if ((n2 = string2.indexOf(" situationType=\"")) != -1) {
            iCommonBaseEvent.setSituationType(XmlUtility.denormalize((String)string2.substring(n2 + 16, string2.indexOf("\"", n2 + 16))));
        }
        if ((n2 = string2.indexOf(" elapsedTime=\"")) != -1) {
            iCommonBaseEvent.setElapsedTime(Long.valueOf(string2.substring(n2 + 14, string2.indexOf("\"", n2 + 14))));
        }
        if ((n2 = string2.indexOf(" priority=\"")) != -1) {
            iCommonBaseEvent.setPriority(Short.valueOf(string2.substring(n2 + 11, string2.indexOf("\"", n2 + 11))));
        }
        if ((n2 = string2.indexOf(" repeatCount=\"")) != -1) {
            iCommonBaseEvent.setRepeatCount(Short.valueOf(string2.substring(n2 + 14, string2.indexOf("\"", n2 + 14))));
        }
        if ((n2 = string2.indexOf(" sequenceNumber=\"")) != -1) {
            iCommonBaseEvent.setSequenceNumber(Long.valueOf(string2.substring(n2 + 17, string2.indexOf("\"", n2 + 17))));
        }
        if ((n2 = string2.indexOf(" severity=\"")) != -1) {
            iCommonBaseEvent.setSeverity(Short.valueOf(string2.substring(n2 + 11, string2.indexOf("\"", n2 + 11))));
        }
        while (string.indexOf("<contextDataElements ", n) != -1) {
            n = string.indexOf("<contextDataElements ", n);
            string2 = string.substring(n, string.indexOf("</contextDataElements>", n + 1));
            IContextDataElement iContextDataElement = factory.createContextDataElement();
            n2 = string2.indexOf(" name=\"");
            if (n2 != -1) {
                iContextDataElement.setName(XmlUtility.denormalize((String)string2.substring(n2 + 7, string2.indexOf("\"", n2 + 7))));
            }
            if ((n2 = string2.indexOf(" type=\"")) != -1) {
                iContextDataElement.setType(XmlUtility.denormalize((String)string2.substring(n2 + 7, string2.indexOf("\"", n2 + 7))));
            }
            if ((n2 = string2.indexOf("<contextValue>")) != -1) {
                iContextDataElement.setContextValue(XmlUtility.denormalize((String)string2.substring(n2 + 14, string2.indexOf("</contextValue>", n2 + 14))));
            } else if (string2.indexOf("<contextId>") != -1) {
                n2 = string2.indexOf("<contextId>");
                iContextDataElement.setContextId(XmlUtility.denormalize((String)string2.substring(n2 + 11, string2.indexOf("</contextId>", n2 + 11))));
            }
            iCommonBaseEvent.addContextDataElement(iContextDataElement);
            n = string.indexOf("</contextDataElements>", n + 1) + 22;
        }
        int n3 = -1;
        int n4 = n;
        int n5 = -1;
        while ((n3 = string.indexOf("<extendedDataElements ", n4)) != -1) {
            n5 = string.indexOf("</extendedDataElements>", n3);
            if (n5 != -1) {
                n4 = n5 + 23;
                n5 = string.indexOf("/>", n3);
                if (n5 != -1 && n5 < n4) {
                    n4 = n5 + 2;
                }
            } else {
                n4 = string.indexOf("/>", n3) + 2;
            }
            iCommonBaseEvent.addExtendedDataElement(CbeFormatter.loadExtendedDataElement(string.substring(n3, n4)));
        }
        n = n4;
        StringBuffer stringBuffer = new StringBuffer();
        while (string.indexOf("<associatedEvents ", n) != -1) {
            n = string.indexOf("<associatedEvents ", n);
            string2 = string.substring(n, string.indexOf("/>", n + 1));
            object3 = factory.createAssociatedEvent();
            n2 = string2.indexOf(" associationEngine=\"");
            if (n2 != -1) {
                object3.setAssociationEngine(XmlUtility.denormalize((String)string2.substring(n2 + 20, string2.indexOf("\"", n2 + 20))));
            }
            if ((n2 = string2.indexOf(" resolvedEvents=\"")) != -1) {
                object2 = new String(string2.substring(n2 + 17, string2.indexOf("\"", n2 + 17)));
                StringTokenizer stringTokenizer = new StringTokenizer((String)object2, " ");
                while (stringTokenizer.hasMoreTokens()) {
                    object = factory.createCommonBaseEvent();
                    object.setGlobalInstanceId(XmlUtility.denormalize((String)stringTokenizer.nextToken()));
                    object3.addResolvedEvent(object.getGlobalInstanceId());
                }
                n2 += ((String)object2).length() + 17;
            }
            iCommonBaseEvent.addAssociatedEvent((IAssociatedEvent)object3);
            n = string.indexOf("/>", n + 1) + 2;
        }
        if (string.indexOf("<reporterComponentId") != -1) {
            n = string.indexOf("<reporterComponentId");
            string2 = string.substring(n, string.indexOf("/>", n + 1));
            n = string.indexOf("/>", n + 1) + 2;
            object3 = factory.createComponentIdentification();
            n2 = string2.indexOf(" application=\"");
            if (n2 != -1) {
                object3.setApplication(XmlUtility.denormalize((String)string2.substring(n2 + 14, string2.indexOf("\"", n2 + 14))));
            }
            if ((n2 = string2.indexOf(" component=\"")) != -1) {
                object3.setComponent(XmlUtility.denormalize((String)string2.substring(n2 + 12, string2.indexOf("\"", n2 + 12))));
            }
            if ((n2 = string2.indexOf(" componentIdType=\"")) != -1) {
                object3.setComponentIdType(XmlUtility.denormalize((String)string2.substring(n2 + 18, string2.indexOf("\"", n2 + 18))));
            }
            if ((n2 = string2.indexOf(" executionEnvironment=\"")) != -1) {
                object3.setExecutionEnvironment(XmlUtility.denormalize((String)string2.substring(n2 + 23, string2.indexOf("\"", n2 + 23))));
            }
            if ((n2 = string2.indexOf(" instanceId=\"")) != -1) {
                object3.setInstanceId(XmlUtility.denormalize((String)string2.substring(n2 + 13, string2.indexOf("\"", n2 + 13))));
            }
            if ((n2 = string2.indexOf(" location=\"")) != -1) {
                object3.setLocation(XmlUtility.denormalize((String)string2.substring(n2 + 11, string2.indexOf("\"", n2 + 11))));
            }
            if ((n2 = string2.indexOf(" locationType=\"")) != -1) {
                object3.setLocationType(XmlUtility.denormalize((String)string2.substring(n2 + 15, string2.indexOf("\"", n2 + 15))));
            }
            if ((n2 = string2.indexOf(" processId=\"")) != -1) {
                object3.setProcessId(XmlUtility.denormalize((String)string2.substring(n2 + 12, string2.indexOf("\"", n2 + 12))));
            }
            if ((n2 = string2.indexOf(" subComponent=\"")) != -1) {
                object3.setSubComponent(XmlUtility.denormalize((String)string2.substring(n2 + 15, string2.indexOf("\"", n2 + 15))));
            }
            if ((n2 = string2.indexOf(" threadId=\"")) != -1) {
                object3.setThreadId(XmlUtility.denormalize((String)string2.substring(n2 + 11, string2.indexOf("\"", n2 + 11))));
            }
            iCommonBaseEvent.setReporterComponentId((IComponentIdentification)object3);
        }
        if (string.indexOf("<sourceComponentId") != -1) {
            n = string.indexOf("<sourceComponentId");
            string2 = string.substring(n, string.indexOf("/>", n + 1));
            n = string.indexOf("/>", n + 1) + 2;
            object3 = factory.createComponentIdentification();
            n2 = string2.indexOf(" application=\"");
            if (n2 != -1) {
                object3.setApplication(XmlUtility.denormalize((String)string2.substring(n2 + 14, string2.indexOf("\"", n2 + 14))));
            }
            if ((n2 = string2.indexOf(" component=\"")) != -1) {
                object3.setComponent(XmlUtility.denormalize((String)string2.substring(n2 + 12, string2.indexOf("\"", n2 + 12))));
            }
            if ((n2 = string2.indexOf(" componentIdType=\"")) != -1) {
                object3.setComponentIdType(XmlUtility.denormalize((String)string2.substring(n2 + 18, string2.indexOf("\"", n2 + 18))));
            }
            if ((n2 = string2.indexOf(" executionEnvironment=\"")) != -1) {
                object3.setExecutionEnvironment(XmlUtility.denormalize((String)string2.substring(n2 + 23, string2.indexOf("\"", n2 + 23))));
            }
            if ((n2 = string2.indexOf(" instanceId=\"")) != -1) {
                object3.setInstanceId(XmlUtility.denormalize((String)string2.substring(n2 + 13, string2.indexOf("\"", n2 + 13))));
            }
            if ((n2 = string2.indexOf(" location=\"")) != -1) {
                object3.setLocation(XmlUtility.denormalize((String)string2.substring(n2 + 11, string2.indexOf("\"", n2 + 11))));
            }
            if ((n2 = string2.indexOf(" locationType=\"")) != -1) {
                object3.setLocationType(XmlUtility.denormalize((String)string2.substring(n2 + 15, string2.indexOf("\"", n2 + 15))));
            }
            if ((n2 = string2.indexOf(" processId=\"")) != -1) {
                object3.setProcessId(XmlUtility.denormalize((String)string2.substring(n2 + 12, string2.indexOf("\"", n2 + 12))));
            }
            if ((n2 = string2.indexOf(" subComponent=\"")) != -1) {
                object3.setSubComponent(XmlUtility.denormalize((String)string2.substring(n2 + 15, string2.indexOf("\"", n2 + 15))));
            }
            if ((n2 = string2.indexOf(" threadId=\"")) != -1) {
                object3.setThreadId(XmlUtility.denormalize((String)string2.substring(n2 + 11, string2.indexOf("\"", n2 + 11))));
            }
            iCommonBaseEvent.setSourceComponentId((IComponentIdentification)object3);
        }
        if (string.indexOf("<msgDataElement") != -1) {
            n = string.indexOf("<msgDataElement");
            string2 = string.substring(n, string.indexOf("</msgDataElement>", n + 1));
            n = string.indexOf("</msgDataElement>", n + 1) + 17;
            object3 = factory.createMsgDataElement();
            n2 = string2.indexOf(" msgLocale=\"");
            if (n2 != -1) {
                object3.setMsgLocale(XmlUtility.denormalize((String)string2.substring(n2 + 12, string2.indexOf("\"", n2 + 12))));
            }
            if (string2.indexOf("<msgCatalogTokens ", n2) != -1) {
                object2 = null;
                while (string2.indexOf("<msgCatalogTokens ", n2) != -1) {
                    if ((n2 = string2.indexOf(" value=\"", n2)) != -1) {
                        object2 = factory.createMsgCatalogToken();
                        object2.setValue(XmlUtility.denormalize((String)new String(string2.substring(n2 + 8, string2.indexOf("\"", n2 + 8)))));
                        object3.addMsgCatalogToken((IMsgCatalogToken)object2);
                    }
                    n2 = string2.indexOf("/>", n2 + 1) + 2;
                }
            }
            if ((n2 = string2.indexOf("<msgCatalogType>")) != -1) {
                object3.setMsgCatalogType(XmlUtility.denormalize((String)string2.substring(n2 + 16, string2.indexOf("</msgCatalogType>", n2 + 16))));
            }
            if ((n2 = string2.indexOf("<msgId>")) != -1) {
                object3.setMsgId(XmlUtility.denormalize((String)string2.substring(n2 + 7, string2.indexOf("</msgId>", n2 + 7))));
            }
            if ((n2 = string2.indexOf("<msgIdType>")) != -1) {
                object3.setMsgIdType(XmlUtility.denormalize((String)string2.substring(n2 + 11, string2.indexOf("</msgIdType>", n2 + 11))));
            }
            if ((n2 = string2.indexOf("<msgCatalogId>")) != -1) {
                object3.setMsgCatalogId(XmlUtility.denormalize((String)string2.substring(n2 + 14, string2.indexOf("</msgCatalogId>", n2 + 14))));
            }
            if ((n2 = string2.indexOf("<msgCatalog>")) != -1) {
                object3.setMsgCatalog(XmlUtility.denormalize((String)string2.substring(n2 + 12, string2.indexOf("</msgCatalog>", n2 + 12))));
            }
            iCommonBaseEvent.setMsgDataElement((IMsgDataElement)object3);
        }
        n2 = string.indexOf("xmlns:");
        string2 = string.substring(0);
        while (n2 > 0) {
            int n6 = string2.indexOf("=", n2);
            if (n6 > 0) {
                object2 = string2.substring(n2 + 6, n6);
                int n7 = string2.indexOf("<" + (String)object2 + ":");
                if (n7 > -1) {
                    object = string2.substring(n7 + 1, string2.indexOf(" ", n7));
                    int n8 = string2.indexOf(">", n7);
                    int n9 = -1;
                    if (string2.charAt(n8 - 1) == '/') {
                        n9 = n8 + 1;
                    } else {
                        n9 = string2.indexOf("</" + (String)object + ">");
                        n9 = n9 + ((String)object).length() + 3;
                    }
                    if (n9 > 0) {
                        String string3 = string2.substring(n7, n9);
                        string2 = string2.substring(n9);
                        n2 = string2.indexOf("xmlns:");
                        ICommonBaseEventAnyElement iCommonBaseEventAnyElement = factory.createAnyElement();
                        try {
                            iCommonBaseEventAnyElement.setXmlAnyElement(string3);
                            iCommonBaseEvent.addAnyElement(iCommonBaseEventAnyElement);
                        }
                        catch (InvalidXMLAnyElementException invalidXMLAnyElementException) {
                            string2 = string2.substring(n2 + 1);
                            n2 = string2.indexOf("xmlns:");
                        }
                        continue;
                    }
                    string2 = string2.substring(n2 + 1);
                    n2 = string2.indexOf("xmlns:");
                    continue;
                }
                string2 = string2.substring(n2 + 1);
                n2 = string2.indexOf("xmlns:");
                continue;
            }
            n2 = -1;
        }
    }

    private static synchronized void fromCanonical_1_0_1_XMLString(ICommonBaseEvent iCommonBaseEvent, String string) {
        Object object;
        Object object2;
        int n = string.indexOf("<CommonBaseEvent ");
        int n2 = 0;
        String string2 = string.substring(n, string.indexOf(">", n + 1));
        n = string.indexOf(">", n + 1) + 1;
        n2 = string2.indexOf(" creationTime=\"");
        if (n2 != -1) {
            iCommonBaseEvent.setCreationTime(XmlUtility.denormalize((String)string2.substring(n2 + 15, string2.indexOf("\"", n2 + 15))));
        }
        if ((n2 = string2.indexOf(" extensionName=\"")) != -1) {
            iCommonBaseEvent.setExtensionName(XmlUtility.denormalize((String)string2.substring(n2 + 16, string2.indexOf("\"", n2 + 16))));
        }
        if ((n2 = string2.indexOf(" globalInstanceId=\"")) != -1) {
            iCommonBaseEvent.setGlobalInstanceId(XmlUtility.denormalize((String)string2.substring(n2 + 19, string2.indexOf("\"", n2 + 19))));
        }
        if ((n2 = string2.indexOf(" localInstanceId=\"")) != -1) {
            iCommonBaseEvent.setLocalInstanceId(XmlUtility.denormalize((String)string2.substring(n2 + 18, string2.indexOf("\"", n2 + 18))));
        }
        if ((n2 = string2.indexOf(" msg=\"")) != -1) {
            iCommonBaseEvent.setMsg(XmlUtility.denormalize((String)string2.substring(n2 + 6, string2.indexOf("\"", n2 + 6))));
        }
        n2 = string2.indexOf(" situationType=\"");
        String string3 = null;
        if (n2 != -1) {
            string3 = XmlUtility.denormalize((String)string2.substring(n2 + 16, string2.indexOf("\"", n2 + 16)));
        }
        if ((n2 = string2.indexOf(" elapsedTime=\"")) != -1) {
            iCommonBaseEvent.setElapsedTime(Long.valueOf(string2.substring(n2 + 14, string2.indexOf("\"", n2 + 14))));
        }
        if ((n2 = string2.indexOf(" priority=\"")) != -1) {
            iCommonBaseEvent.setPriority(Short.valueOf(string2.substring(n2 + 11, string2.indexOf("\"", n2 + 11))));
        }
        if ((n2 = string2.indexOf(" repeatCount=\"")) != -1) {
            iCommonBaseEvent.setRepeatCount(Short.valueOf(string2.substring(n2 + 14, string2.indexOf("\"", n2 + 14))));
        }
        if ((n2 = string2.indexOf(" sequenceNumber=\"")) != -1) {
            iCommonBaseEvent.setSequenceNumber(Long.valueOf(string2.substring(n2 + 17, string2.indexOf("\"", n2 + 17))));
        }
        if ((n2 = string2.indexOf(" severity=\"")) != -1) {
            iCommonBaseEvent.setSeverity(Short.valueOf(string2.substring(n2 + 11, string2.indexOf("\"", n2 + 11))));
        }
        while (string.indexOf("<contextDataElements ", n) != -1) {
            n = string.indexOf("<contextDataElements ", n);
            string2 = string.substring(n, string.indexOf("</contextDataElements>", n + 1));
            IContextDataElement iContextDataElement = factory.createContextDataElement();
            n2 = string2.indexOf(" name=\"");
            if (n2 != -1) {
                iContextDataElement.setName(XmlUtility.denormalize((String)string2.substring(n2 + 7, string2.indexOf("\"", n2 + 7))));
            }
            if ((n2 = string2.indexOf(" type=\"")) != -1) {
                iContextDataElement.setType(XmlUtility.denormalize((String)string2.substring(n2 + 7, string2.indexOf("\"", n2 + 7))));
            }
            if ((n2 = string2.indexOf("<contextValue>")) != -1) {
                iContextDataElement.setContextValue(XmlUtility.denormalize((String)string2.substring(n2 + 14, string2.indexOf("</contextValue>", n2 + 14))));
            } else if (string2.indexOf("<contextId>") != -1) {
                n2 = string2.indexOf("<contextId>");
                iContextDataElement.setContextId(XmlUtility.denormalize((String)string2.substring(n2 + 11, string2.indexOf("</contextId>", n2 + 11))));
            }
            iCommonBaseEvent.addContextDataElement(iContextDataElement);
            n = string.indexOf("</contextDataElements>", n + 1) + 22;
        }
        int n3 = -1;
        int n4 = n;
        int n5 = -1;
        while ((n3 = string.indexOf("<extendedDataElements ", n4)) != -1) {
            n5 = string.indexOf("</extendedDataElements>", n3);
            if (n5 != -1) {
                n4 = n5 + 23;
                n5 = string.indexOf("/>", n3);
                if (n5 != -1 && n5 < n4) {
                    n4 = n5 + 2;
                }
            } else {
                n4 = string.indexOf("/>", n3) + 2;
            }
            iCommonBaseEvent.addExtendedDataElement(CbeFormatter.loadExtendedDataElement(string.substring(n3, n4)));
        }
        n = n4;
        StringBuffer stringBuffer = new StringBuffer();
        while (string.indexOf("<associatedEvents ", n) != -1) {
            n = string.indexOf("<associatedEvents ", n);
            string2 = string.substring(n, string.indexOf("/>", n + 1));
            object2 = factory.createAssociatedEvent();
            n2 = string2.indexOf(" resolvedEvents=\"");
            if (n2 != -1) {
                object = new StringTokenizer(string2.substring(n2 + 17, string2.indexOf("\"", n2 + 17)), " ");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    object2.addResolvedEvent(XmlUtility.denormalize((String)((StringTokenizer)object).nextToken()));
                }
            }
            if ((n2 = string2.indexOf("<associationEngineInfo ", n2)) == -1) {
                n2 = string2.indexOf("<associationEngine>");
                if (n2 != -1) {
                    object2.setAssociationEngine(XmlUtility.denormalize((String)string2.substring(n2 + 19, string2.indexOf("</associationEngine>", n2 + 19))));
                }
            } else {
                object = factory.createAssociationEngine();
                CbeFormatter.fromCanonicalXMLString((IAssociationEngine)object, string2);
                object2.setAssociationEngineInfo((IAssociationEngine)object);
            }
            iCommonBaseEvent.addAssociatedEvent((IAssociatedEvent)object2);
            n = string.indexOf("/>", n) + 2;
        }
        if (string.indexOf("<reporterComponentId") != -1) {
            n = string.indexOf("<reporterComponentId");
            string2 = string.substring(n, string.indexOf("/>", n + 1));
            n = string.indexOf("/>", n + 1) + 2;
            object2 = factory.createComponentIdentification();
            n2 = string2.indexOf(" application=\"");
            if (n2 != -1) {
                object2.setApplication(XmlUtility.denormalize((String)string2.substring(n2 + 14, string2.indexOf("\"", n2 + 14))));
            }
            if ((n2 = string2.indexOf(" component=\"")) != -1) {
                object2.setComponent(XmlUtility.denormalize((String)string2.substring(n2 + 12, string2.indexOf("\"", n2 + 12))));
            }
            if ((n2 = string2.indexOf(" componentIdType=\"")) != -1) {
                object2.setComponentIdType(XmlUtility.denormalize((String)string2.substring(n2 + 18, string2.indexOf("\"", n2 + 18))));
            }
            if ((n2 = string2.indexOf(" executionEnvironment=\"")) != -1) {
                object2.setExecutionEnvironment(XmlUtility.denormalize((String)string2.substring(n2 + 23, string2.indexOf("\"", n2 + 23))));
            }
            if ((n2 = string2.indexOf(" instanceId=\"")) != -1) {
                object2.setInstanceId(XmlUtility.denormalize((String)string2.substring(n2 + 13, string2.indexOf("\"", n2 + 13))));
            }
            if ((n2 = string2.indexOf(" location=\"")) != -1) {
                object2.setLocation(XmlUtility.denormalize((String)string2.substring(n2 + 11, string2.indexOf("\"", n2 + 11))));
            }
            if ((n2 = string2.indexOf(" locationType=\"")) != -1) {
                object2.setLocationType(XmlUtility.denormalize((String)string2.substring(n2 + 15, string2.indexOf("\"", n2 + 15))));
            }
            if ((n2 = string2.indexOf(" processId=\"")) != -1) {
                object2.setProcessId(XmlUtility.denormalize((String)string2.substring(n2 + 12, string2.indexOf("\"", n2 + 12))));
            }
            if ((n2 = string2.indexOf(" subComponent=\"")) != -1) {
                object2.setSubComponent(XmlUtility.denormalize((String)string2.substring(n2 + 15, string2.indexOf("\"", n2 + 15))));
            }
            if ((n2 = string2.indexOf(" threadId=\"")) != -1) {
                object2.setThreadId(XmlUtility.denormalize((String)string2.substring(n2 + 11, string2.indexOf("\"", n2 + 11))));
            }
            if ((n2 = string2.indexOf(" componentType=\"")) != -1) {
                object2.setComponentType(XmlUtility.denormalize((String)string2.substring(n2 + 16, string2.indexOf("\"", n2 + 16))));
            }
            iCommonBaseEvent.setReporterComponentId((IComponentIdentification)object2);
        }
        if (string.indexOf("<sourceComponentId") != -1) {
            n = string.indexOf("<sourceComponentId");
            string2 = string.substring(n, string.indexOf("/>", n + 1));
            n = string.indexOf("/>", n + 1) + 2;
            object2 = factory.createComponentIdentification();
            n2 = string2.indexOf(" application=\"");
            if (n2 != -1) {
                object2.setApplication(XmlUtility.denormalize((String)string2.substring(n2 + 14, string2.indexOf("\"", n2 + 14))));
            }
            if ((n2 = string2.indexOf(" component=\"")) != -1) {
                object2.setComponent(XmlUtility.denormalize((String)string2.substring(n2 + 12, string2.indexOf("\"", n2 + 12))));
            }
            if ((n2 = string2.indexOf(" componentIdType=\"")) != -1) {
                object2.setComponentIdType(XmlUtility.denormalize((String)string2.substring(n2 + 18, string2.indexOf("\"", n2 + 18))));
            }
            if ((n2 = string2.indexOf(" executionEnvironment=\"")) != -1) {
                object2.setExecutionEnvironment(XmlUtility.denormalize((String)string2.substring(n2 + 23, string2.indexOf("\"", n2 + 23))));
            }
            if ((n2 = string2.indexOf(" instanceId=\"")) != -1) {
                object2.setInstanceId(XmlUtility.denormalize((String)string2.substring(n2 + 13, string2.indexOf("\"", n2 + 13))));
            }
            if ((n2 = string2.indexOf(" location=\"")) != -1) {
                object2.setLocation(XmlUtility.denormalize((String)string2.substring(n2 + 11, string2.indexOf("\"", n2 + 11))));
            }
            if ((n2 = string2.indexOf(" locationType=\"")) != -1) {
                object2.setLocationType(XmlUtility.denormalize((String)string2.substring(n2 + 15, string2.indexOf("\"", n2 + 15))));
            }
            if ((n2 = string2.indexOf(" processId=\"")) != -1) {
                object2.setProcessId(XmlUtility.denormalize((String)string2.substring(n2 + 12, string2.indexOf("\"", n2 + 12))));
            }
            if ((n2 = string2.indexOf(" subComponent=\"")) != -1) {
                object2.setSubComponent(XmlUtility.denormalize((String)string2.substring(n2 + 15, string2.indexOf("\"", n2 + 15))));
            }
            if ((n2 = string2.indexOf(" threadId=\"")) != -1) {
                object2.setThreadId(XmlUtility.denormalize((String)string2.substring(n2 + 11, string2.indexOf("\"", n2 + 11))));
            }
            if ((n2 = string2.indexOf(" componentType=\"")) != -1) {
                object2.setComponentType(XmlUtility.denormalize((String)string2.substring(n2 + 16, string2.indexOf("\"", n2 + 16))));
            }
            iCommonBaseEvent.setSourceComponentId((IComponentIdentification)object2);
        }
        if (string.indexOf("<msgDataElement") != -1) {
            n = string.indexOf("<msgDataElement");
            string2 = string.substring(n, string.indexOf("</msgDataElement>", n + 1));
            n = string.indexOf("</msgDataElement>", n + 1) + 17;
            object2 = factory.createMsgDataElement();
            n2 = string2.indexOf(" msgLocale=\"");
            if (n2 != -1) {
                object2.setMsgLocale(XmlUtility.denormalize((String)string2.substring(n2 + 12, string2.indexOf("\"", n2 + 12))));
            }
            if (string2.indexOf("<msgCatalogTokens ", n2) != -1) {
                object = null;
                while (string2.indexOf("<msgCatalogTokens ", n2) != -1) {
                    if ((n2 = string2.indexOf(" value=\"", n2)) != -1) {
                        object = factory.createMsgCatalogToken();
                        object.setValue(XmlUtility.denormalize((String)new String(string2.substring(n2 + 8, string2.indexOf("\"", n2 + 8)))));
                        object2.addMsgCatalogToken((IMsgCatalogToken)object);
                    }
                    n2 = string2.indexOf("/>", n2 + 1) + 2;
                }
            }
            if ((n2 = string2.indexOf("<msgCatalogType>")) != -1) {
                object2.setMsgCatalogType(XmlUtility.denormalize((String)string2.substring(n2 + 16, string2.indexOf("</msgCatalogType>", n2 + 16))));
            }
            if ((n2 = string2.indexOf("<msgId>")) != -1) {
                object2.setMsgId(XmlUtility.denormalize((String)string2.substring(n2 + 7, string2.indexOf("</msgId>", n2 + 7))));
            }
            if ((n2 = string2.indexOf("<msgIdType>")) != -1) {
                object2.setMsgIdType(XmlUtility.denormalize((String)string2.substring(n2 + 11, string2.indexOf("</msgIdType>", n2 + 11))));
            }
            if ((n2 = string2.indexOf("<msgCatalogId>")) != -1) {
                object2.setMsgCatalogId(XmlUtility.denormalize((String)string2.substring(n2 + 14, string2.indexOf("</msgCatalogId>", n2 + 14))));
            }
            if ((n2 = string2.indexOf("<msgCatalog>")) != -1) {
                object2.setMsgCatalog(XmlUtility.denormalize((String)string2.substring(n2 + 12, string2.indexOf("</msgCatalog>", n2 + 12))));
            }
            iCommonBaseEvent.setMsgDataElement((IMsgDataElement)object2);
        }
        if (string.indexOf("<situation") == -1) {
            if (string3 != null) {
                object2 = factory.createReportSituation();
                object2.setReasoningScope("INTERNAL");
                object2.setReportCategory("LOG");
                object = factory.createSituation();
                object.setCategoryName(string3);
                object.setSituationType((ISituationType)object2);
                iCommonBaseEvent.setSituation((ISituation)object);
            }
        } else {
            n = string.indexOf("<situation");
            string2 = string.substring(n, string.indexOf("</situation>", n));
            n = string.indexOf("</situation>", n) + 12;
            object2 = factory.createSituation();
            n2 = string2.indexOf(" categoryName=\"");
            if (n2 != -1) {
                object2.setCategoryName(XmlUtility.denormalize((String)string2.substring(n2 + 15, string2.indexOf("\"", n2 + 15))));
            }
            if ((n2 = string2.indexOf("<situationType ")) != -1) {
                int n6 = string2.indexOf("</situationType>", n2);
                if (n6 == -1) {
                    n6 = string2.indexOf("/>", n2);
                }
                if ((n2 = (string2 = string2.substring(n2, n6)).indexOf(" xsi:type=\"")) != -1) {
                    String string4 = XmlUtility.denormalize((String)string2.substring(n2 + 11, string2.indexOf("\"", n2 + 11)));
                    String string5 = null;
                    n2 = string2.indexOf(" reasoningScope=\"");
                    if (n2 != -1) {
                        string5 = XmlUtility.denormalize((String)string2.substring(n2 + 17, string2.indexOf("\"", n2 + 17)));
                    }
                    if (string4.equals("StartSituation")) {
                        IStartSituation iStartSituation = factory.createStartSituation();
                        n2 = string2.indexOf(" successDisposition=\"");
                        if (n2 != -1) {
                            iStartSituation.setSuccessDisposition(XmlUtility.denormalize((String)string2.substring(n2 + 21, string2.indexOf("\"", n2 + 21))));
                        }
                        if ((n2 = string2.indexOf(" situationQualifier=\"")) != -1) {
                            iStartSituation.setSituationQualifier(XmlUtility.denormalize((String)string2.substring(n2 + 21, string2.indexOf("\"", n2 + 21))));
                        }
                        iStartSituation.setReasoningScope(string5);
                        object2.setSituationType(iStartSituation);
                    } else if (string4.equals("StopSituation")) {
                        IStopSituation iStopSituation = factory.createStopSituation();
                        n2 = string2.indexOf(" successDisposition=\"");
                        if (n2 != -1) {
                            iStopSituation.setSuccessDisposition(XmlUtility.denormalize((String)string2.substring(n2 + 21, string2.indexOf("\"", n2 + 21))));
                        }
                        if ((n2 = string2.indexOf(" situationQualifier=\"")) != -1) {
                            iStopSituation.setSituationQualifier(XmlUtility.denormalize((String)string2.substring(n2 + 21, string2.indexOf("\"", n2 + 21))));
                        }
                        iStopSituation.setReasoningScope(string5);
                        object2.setSituationType(iStopSituation);
                    } else if (string4.equals("ConnectSituation")) {
                        IConnectSituation iConnectSituation = factory.createConnectSituation();
                        n2 = string2.indexOf(" successDisposition=\"");
                        if (n2 != -1) {
                            iConnectSituation.setSuccessDisposition(XmlUtility.denormalize((String)string2.substring(n2 + 21, string2.indexOf("\"", n2 + 21))));
                        }
                        if ((n2 = string2.indexOf(" situationDisposition=\"")) != -1) {
                            iConnectSituation.setSituationDisposition(XmlUtility.denormalize((String)string2.substring(n2 + 23, string2.indexOf("\"", n2 + 23))));
                        }
                        iConnectSituation.setReasoningScope(string5);
                        object2.setSituationType(iConnectSituation);
                    } else if (string4.equals("ReportSituation")) {
                        IReportSituation iReportSituation = factory.createReportSituation();
                        n2 = string2.indexOf(" reportCategory=\"");
                        if (n2 != -1) {
                            iReportSituation.setReportCategory(XmlUtility.denormalize((String)string2.substring(n2 + 17, string2.indexOf("\"", n2 + 17))));
                        }
                        iReportSituation.setReasoningScope(string5);
                        object2.setSituationType(iReportSituation);
                    } else if (string4.equals("FeatureSituation")) {
                        IFeatureSituation iFeatureSituation = factory.createFeatureSituation();
                        n2 = string2.indexOf(" featureDisposition=\"");
                        if (n2 != -1) {
                            iFeatureSituation.setFeatureDisposition(XmlUtility.denormalize((String)string2.substring(n2 + 21, string2.indexOf("\"", n2 + 21))));
                        }
                        iFeatureSituation.setReasoningScope(string5);
                        object2.setSituationType(iFeatureSituation);
                    } else if (string4.equals("ConfigureSituation")) {
                        IConfigureSituation iConfigureSituation = factory.createConfigureSituation();
                        n2 = string2.indexOf(" successDisposition=\"");
                        if (n2 != -1) {
                            iConfigureSituation.setSuccessDisposition(XmlUtility.denormalize((String)string2.substring(n2 + 21, string2.indexOf("\"", n2 + 21))));
                        }
                        iConfigureSituation.setReasoningScope(string5);
                        object2.setSituationType(iConfigureSituation);
                    } else if (string4.equals("DependencySituation")) {
                        IDependencySituation iDependencySituation = factory.createDependencySituation();
                        n2 = string2.indexOf(" dependencyDisposition=\"");
                        if (n2 != -1) {
                            iDependencySituation.setDependencyDisposition(XmlUtility.denormalize((String)string2.substring(n2 + 24, string2.indexOf("\"", n2 + 24))));
                        }
                        iDependencySituation.setReasoningScope(string5);
                        object2.setSituationType(iDependencySituation);
                    } else if (string4.equals("CreateSituation")) {
                        ICreateSituation iCreateSituation = factory.createCreateSituation();
                        n2 = string2.indexOf(" successDisposition=\"");
                        if (n2 != -1) {
                            iCreateSituation.setSuccessDisposition(XmlUtility.denormalize((String)string2.substring(n2 + 21, string2.indexOf("\"", n2 + 21))));
                        }
                        iCreateSituation.setReasoningScope(string5);
                        object2.setSituationType(iCreateSituation);
                    } else if (string4.equals("DestroySituation")) {
                        IDestroySituation iDestroySituation = factory.createDestroySituation();
                        n2 = string2.indexOf(" successDisposition=\"");
                        if (n2 != -1) {
                            iDestroySituation.setSuccessDisposition(XmlUtility.denormalize((String)string2.substring(n2 + 21, string2.indexOf("\"", n2 + 21))));
                        }
                        iDestroySituation.setReasoningScope(string5);
                        object2.setSituationType(iDestroySituation);
                    } else if (string4.equals("AvailableSituation")) {
                        IAvailableSituation iAvailableSituation = factory.createAvailableSituation();
                        n2 = string2.indexOf(" operationDisposition=\"");
                        if (n2 != -1) {
                            iAvailableSituation.setOperationDisposition(XmlUtility.denormalize((String)string2.substring(n2 + 23, string2.indexOf("\"", n2 + 23))));
                        }
                        if ((n2 = string2.indexOf(" processingDisposition=\"")) != -1) {
                            iAvailableSituation.setProcessingDisposition(XmlUtility.denormalize((String)string2.substring(n2 + 24, string2.indexOf("\"", n2 + 24))));
                        }
                        if ((n2 = string2.indexOf(" availabilityDisposition=\"")) != -1) {
                            iAvailableSituation.setAvailabilityDisposition(XmlUtility.denormalize((String)string2.substring(n2 + 26, string2.indexOf("\"", n2 + 26))));
                        }
                        iAvailableSituation.setReasoningScope(string5);
                        object2.setSituationType(iAvailableSituation);
                    } else if (string4.equals("RequestSituation")) {
                        IRequestSituation iRequestSituation = factory.createRequestSituation();
                        n2 = string2.indexOf(" successDisposition=\"");
                        if (n2 != -1) {
                            iRequestSituation.setSuccessDisposition(XmlUtility.denormalize((String)string2.substring(n2 + 21, string2.indexOf("\"", n2 + 21))));
                        }
                        if ((n2 = string2.indexOf(" situationQualifier=\"")) != -1) {
                            iRequestSituation.setSituationQualifier(XmlUtility.denormalize((String)string2.substring(n2 + 21, string2.indexOf("\"", n2 + 21))));
                        }
                        iRequestSituation.setReasoningScope(string5);
                        object2.setSituationType(iRequestSituation);
                    } else if (string4.equals("OtherSituation")) {
                        IOtherSituation iOtherSituation = factory.createOtherSituation();
                        String[] stringArray = CbeFormatter.getXMLFragments(string2.substring(string2.indexOf(">") + 1));
                        if (stringArray != null && stringArray.length > 0) {
                            iOtherSituation.setAnyData(stringArray);
                        }
                        iOtherSituation.setReasoningScope(string5);
                        object2.setSituationType(iOtherSituation);
                    }
                }
            }
            iCommonBaseEvent.setSituation((ISituation)object2);
        }
        if ((object2 = CbeFormatter.getXMLFragments(string.substring(n, string.indexOf("</CommonBaseEvent>", n)))) != null && ((String[])object2).length > 0) {
            iCommonBaseEvent.setOtherData((String[])object2);
        }
    }

    public static synchronized void fromCanonicalXMLDocString(ICommonBaseEvent iCommonBaseEvent, String string) {
        CbeFormatter.fromCanonicalXMLString(iCommonBaseEvent, string);
    }

    public static long convertXmlSchemaDateTimeToDate(String string) {
        long l;
        block21: {
            String string2 = null;
            String string3 = null;
            String string4 = null;
            int n = 0;
            Date date = null;
            l = 0L;
            int n2 = -1;
            String string5 = "yyyy-MM-dd'T'HH:mm:ss";
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string5);
            int n3 = string5.length() - 2;
            try {
                String string6;
                if (string.length() < n3) {
                    l = 0L;
                    break block21;
                }
                if (string.indexOf(90) > n3) {
                    n2 = string.indexOf(90);
                    string2 = string.substring(0, n2);
                    n = 90;
                } else if (string.indexOf(43) > n3) {
                    n2 = string.indexOf(43);
                    string2 = string.substring(0, n2);
                    n = string.charAt(n2);
                    string4 = string.substring(n2 + 1);
                } else if (string.indexOf(45, n3) > n3) {
                    n2 = string.indexOf(45, n3);
                    string2 = string.substring(0, n2);
                    n = string.charAt(n2);
                    string4 = string.substring(n2 + 1);
                } else {
                    string2 = string;
                }
                int n4 = string2.indexOf(46);
                if (n4 > 0) {
                    if (n2 != -1) {
                        string2 = string.substring(0, n2);
                    }
                    string3 = string2.substring(n4 + 1);
                }
                if (string2 != null && Integer.parseInt(string6 = string2.substring(0, 4)) > 1969) {
                    SimpleTimeZone simpleTimeZone = new SimpleTimeZone(0, "UTC");
                    GregorianCalendar gregorianCalendar = new GregorianCalendar(simpleTimeZone);
                    ParsePosition parsePosition = new ParsePosition(0);
                    simpleDateFormat.setCalendar(gregorianCalendar);
                    date = simpleDateFormat.parse(string2, parsePosition);
                }
                if (date == null) break block21;
                l = date.getTime();
                if (string3 != null && string3.length() > 0) {
                    long l2 = Long.parseLong(string3);
                    int n5 = string3.length();
                    if (n5 < 4) {
                        for (int i = 1; i < 4 - n5; ++i) {
                            l2 *= 10L;
                        }
                    } else {
                        for (int i = 1; i < 4 - n5; ++i) {
                            l2 /= 10L;
                        }
                    }
                    l += l2;
                }
                if (n != 0 && string4 != null && string4.length() == 5) {
                    long l3 = Long.parseLong(string4.substring(0, 2));
                    long l4 = Long.parseLong(string4.substring(3));
                    if (n == 43) {
                        l = l + l3 * 60L * 1000L + l4 * 1000L;
                    } else if (n == 45) {
                        l = l - l3 * 60L * 1000L - l4 * 1000L;
                    }
                }
            }
            catch (Exception exception) {
                l = 0L;
            }
        }
        return l;
    }

    public static String convertDateToXmlSchemaDateTime(long l) {
        String string = null;
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(0, "UTC");
        GregorianCalendar gregorianCalendar = new GregorianCalendar(simpleTimeZone);
        gregorianCalendar.setTime(new Date(l));
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2);
        ++n2;
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        int n6 = gregorianCalendar.get(13);
        int n7 = gregorianCalendar.get(14);
        StringBuffer stringBuffer = new StringBuffer(35);
        stringBuffer.append(n);
        stringBuffer.append('-');
        if (n2 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n2);
        stringBuffer.append('-');
        if (n3 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n3);
        stringBuffer.append('T');
        if (n4 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n4);
        stringBuffer.append(':');
        if (n5 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n5);
        stringBuffer.append(':');
        if (n6 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n6);
        stringBuffer.append(".");
        stringBuffer.append(n7);
        stringBuffer.append("Z");
        string = stringBuffer.toString();
        return string;
    }

    public static final String getEventFormatterVersion() {
        return xml_version;
    }

    private static IExtendedDataElement loadExtendedDataElement(String string) {
        String[] stringArray;
        IExtendedDataElement iExtendedDataElement = factory.createExtendedDataElement();
        int n = string.indexOf(" name=\"");
        if (n != -1) {
            iExtendedDataElement.setName(XmlUtility.denormalize((String)string.substring(n + 7, string.indexOf("\"", n + 7))));
        }
        if ((n = string.indexOf(" type=\"")) != -1) {
            iExtendedDataElement.setType(XmlUtility.denormalize((String)string.substring(n + 7, string.indexOf("\"", n + 7))));
        }
        if ((stringArray = CbeFormatter.getChildXMLFragments(string)) != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].startsWith("<values>")) {
                    arrayList.add(XmlUtility.denormalize((String)stringArray[i].substring(8, stringArray[i].indexOf("</values>"))));
                    continue;
                }
                if (stringArray[i].startsWith("<hexValue>")) {
                    String string2 = XmlUtility.denormalize((String)stringArray[i].substring(10, stringArray[i].indexOf("</hexValue>")));
                    int n2 = string2.length() / 2;
                    char[] cArray = new char[n2];
                    for (int j = 0; j < n2; ++j) {
                        cArray[j] = (char)Short.parseShort(string2.substring(j * 2, j * 2 + 2), 16);
                    }
                    iExtendedDataElement.setHexValues(cArray);
                    continue;
                }
                if (!stringArray[i].startsWith("<children ")) continue;
                iExtendedDataElement.addChildDataElement(CbeFormatter.loadExtendedDataElement(stringArray[i]));
            }
            iExtendedDataElement.setValues(arrayList.toArray(new String[arrayList.size()]));
        }
        return iExtendedDataElement;
    }

    private static String[] getChildXMLFragments(String string) {
        int n = string.indexOf(62);
        int n2 = string.lastIndexOf(60);
        if (n != -1 && n2 != -1 && n < n2) {
            return CbeFormatter.getXMLFragments(string.substring(n + 1, n2));
        }
        return null;
    }

    private static String[] getXMLFragments(String string) {
        if (string != null && string.trim().length() > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            char c = '\u0000';
            boolean bl = false;
            int n2 = 0;
            int n3 = -1;
            for (int i = 0; i < string.length(); ++i) {
                c = string.charAt(i);
                if (c == '<') {
                    if (n3 == -1) {
                        n3 = i;
                    }
                    ++n2;
                } else if (c == '/') {
                    if (n == 60) {
                        n2 -= 2;
                    }
                } else if (c == '>') {
                    if (n == 47) {
                        --n2;
                    }
                    if (n3 != -1 && n2 == 0) {
                        arrayList.add(string.substring(n3, i + 1).trim());
                        n3 = -1;
                    }
                } else if (n3 == -1) {
                    stringBuffer.append(c);
                }
                if (Character.isWhitespace(c)) continue;
                n = c;
            }
            if (stringBuffer.length() > 0) {
                arrayList.add(stringBuffer.toString().trim());
            }
            if (arrayList.size() > 0) {
                return arrayList.toArray(new String[arrayList.size()]);
            }
        }
        return null;
    }
}

