/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util;

import java.io.PrintStream;

public class PerfUtil {
    long startTime;
    long stopTime;
    long startTotMem;
    long startFreeMem;
    long stopTotMem;
    long stopFreeMem;
    private String msg;
    private boolean debug = false;

    public PerfUtil(String msg, boolean start) {
        this.setDebugFlag();
        if (!this.debug) {
            return;
        }
        this.msg = msg;
        if (start) {
            this.start();
        }
    }

    private void setDebugFlag() {
        try {
            String s = System.getProperties().getProperty("PerfUtil.debug");
            if (Boolean.valueOf(s).booleanValue()) {
                this.debug = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void start() {
        if (!this.debug) {
            return;
        }
        this.stopTime = this.startTime = System.currentTimeMillis();
        this.startTotMem = Runtime.getRuntime().totalMemory();
        this.startFreeMem = Runtime.getRuntime().freeMemory();
    }

    public void stop() {
        if (!this.debug) {
            return;
        }
        this.stopTime = System.currentTimeMillis();
        this.stopTotMem = Runtime.getRuntime().totalMemory();
        this.stopFreeMem = Runtime.getRuntime().freeMemory();
    }

    public long getTime() {
        return this.stopTime - this.startTime;
    }

    public void printStatus() {
        this.printStatus(System.out);
    }

    public void printStatus(String m) {
        if (!this.debug) {
            return;
        }
        this.msg = this.msg + ", " + m;
        this.printStatus(System.out);
    }

    public void printStatus(PrintStream out) {
        if (this.debug) {
            out.println(this.msg + ": deltaTime=" + this.getTime() + " - stopTime=" + this.stopTime + " - usedMemoryDelta=" + this.getUsedMemoryDelta() + " - freeMemoryDelta=" + this.getFreeMemoryDelta() + " - totalMemoryDelta=" + this.getTotalMemoryDelta() + " - usedMemoryAfter=" + (this.stopTotMem - this.stopFreeMem) + " - freeMemoryAfter=" + this.stopFreeMem + " - totalMemoryAfter=" + this.stopTotMem);
        }
    }

    public long getUsedMemoryDelta() {
        return this.stopTotMem - this.stopFreeMem - (this.startTotMem - this.startFreeMem);
    }

    public long getTotalMemoryDelta() {
        return this.stopTotMem - this.startTotMem;
    }

    public long getFreeMemoryDelta() {
        return this.stopFreeMem - this.startFreeMem;
    }

    public void setMessage(String msg) {
        if (!this.debug) {
            return;
        }
        this.msg = msg;
    }

    public String getMessage() {
        return this.msg;
    }

    public void setMessageAndStart(String string) {
        if (!this.debug) {
            return;
        }
        this.setMessage(string);
        this.start();
    }

    public void stopAndPrintStatus() {
        if (!this.debug) {
            return;
        }
        this.stop();
        this.printStatus();
    }

    public void stopAndPrintStatus(String msg) {
        if (!this.debug) {
            return;
        }
        this.msg = this.msg + ", " + msg;
        this.stop();
        this.printStatus();
    }
}

