/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.hierarchy.util.ContainmentTraverser;
import org.eclipse.hyades.models.hierarchy.util.EObjectVisitor;
import org.eclipse.hyades.models.hierarchy.util.FastList;

public class EMFUtil {
    public static Set delete(EObject object) {
        if (object == null || object.eResource() == null) {
            return Collections.EMPTY_SET;
        }
        return EMFUtil.delete(object, (Collection)object.eResource().getContents());
    }

    public static Set delete(EObject object, Collection rootObjects) {
        if (object == null || object.eResource() == null) {
            return Collections.EMPTY_SET;
        }
        boolean resolve = false;
        ContainmentTraverser containmentTraverser = new ContainmentTraverser(rootObjects, false);
        Set changedResources = EMFUtil.delete(object, false, containmentTraverser);
        return changedResources;
    }

    public static Set delete(final EObject object, final boolean resolve, ContainmentTraverser containmentTraverser) {
        final HashSet<Resource> changedResources = new HashSet<Resource>();
        FastList removeList = new FastList();
        EObjectVisitor objectVisitor = new EObjectVisitor((List)((Object)removeList), containmentTraverser){
            private final /* synthetic */ List val$removeList;
            private final /* synthetic */ ContainmentTraverser val$containmentTraverser;
            {
                this.val$removeList = val$removeList;
                this.val$containmentTraverser = val$containmentTraverser;
            }

            public boolean beforeChildren(EObject element) {
                return !EMFUtil.isContainedIn(element, object);
            }

            public boolean afterChildren(EObject element) {
                EMFUtil.processObjectReferences((Notifier)object, changedResources, resolve, true, this.val$removeList, this.val$containmentTraverser, element);
                return true;
            }
        };
        containmentTraverser.registerVisitors(objectVisitor);
        containmentTraverser.traverse();
        if (object.eResource() != null) {
            changedResources.add(object.eResource());
        }
        EMFUtil.unsetAllFeatures(object);
        object.eAdapters().clear();
        return changedResources;
    }

    public static Set delete(EObject object, ResourceSet resourceSet) {
        if (object == null || object.eResource() == null) {
            return Collections.EMPTY_SET;
        }
        if (resourceSet == null) {
            return EMFUtil.delete(object, (Collection)object.eResource().getContents());
        }
        return EMFUtil.delete(object, EMFUtil.getResourceSetRoots(resourceSet, null));
    }

    public static Set delete(Resource resource) {
        if (resource == null) {
            return Collections.EMPTY_SET;
        }
        return EMFUtil.delete(resource, resource.getResourceSet());
    }

    public static Set delete(final Resource resource, ResourceSet resourceSet) {
        if (resource == null || resourceSet == null) {
            return Collections.EMPTY_SET;
        }
        final HashSet changedResources = new HashSet();
        List resourceSetRoots = EMFUtil.getResourceSetRoots(resourceSet, resource);
        boolean resolve = false;
        FastList removeList = new FastList();
        ContainmentTraverser containmentTraverser = new ContainmentTraverser(resourceSetRoots, false);
        EObjectVisitor objectVisitor = new EObjectVisitor((List)((Object)removeList), containmentTraverser){
            private final /* synthetic */ List val$removeList;
            private final /* synthetic */ ContainmentTraverser val$containmentTraverser;
            {
                this.val$removeList = val$removeList;
                this.val$containmentTraverser = val$containmentTraverser;
            }

            public boolean beforeChildren(EObject element) {
                return true;
            }

            public boolean afterChildren(EObject element) {
                EMFUtil.processObjectReferences((Notifier)resource, changedResources, false, true, this.val$removeList, this.val$containmentTraverser, element);
                return true;
            }
        };
        containmentTraverser.registerVisitors(objectVisitor);
        containmentTraverser.traverse();
        resource.getContents().clear();
        resourceSet.getResources().remove((Object)resource);
        return changedResources;
    }

    public static boolean processObjectReferences(Notifier container, Set changedResources, boolean resolve, boolean delete, Collection collectedEntries, ContainmentTraverser containmentTraverser, EObject element) {
        boolean modified = false;
        EList references = element.eClass().getEAllReferences();
        for (int i = references.size() - 1; i >= 0; --i) {
            Iterator iter;
            Map.Entry entry;
            Iterator iter2;
            EMap l;
            EReference ref = (EReference)references.get(i);
            if (!element.eIsSet((EStructuralFeature)ref)) continue;
            Object o = element.eGet((EStructuralFeature)ref, resolve);
            if (o instanceof EObject) {
                if (!EMFUtil.isContainedIn((EObject)o, container)) continue;
                element.eUnset((EStructuralFeature)ref);
                modified = true;
                continue;
            }
            if (o instanceof EMap) {
                l = (EMap)o;
                if (delete) {
                    collectedEntries.clear();
                }
                iter2 = containmentTraverser.getIterator((EList)l);
                while (iter2.hasNext()) {
                    EObject entry1;
                    entry = (Map.Entry)iter2.next();
                    EObject key = (EObject)entry.getKey();
                    if (key == null) continue;
                    if (EMFUtil.isContainedIn(key, container)) {
                        collectedEntries.add(entry);
                        modified = true;
                        continue;
                    }
                    EList value = (EList)entry.getValue();
                    if (value == null) continue;
                    FastList removeEntries1 = new FastList();
                    Iterator iter3 = containmentTraverser.getIterator(value);
                    while (iter3.hasNext()) {
                        entry1 = (EObject)iter3.next();
                        if (!EMFUtil.isContainedIn(entry1, container)) continue;
                        removeEntries1.add(entry1);
                        modified = true;
                    }
                    if (delete) {
                        Iterator iter4 = removeEntries1.iterator();
                        while (iter4.hasNext()) {
                            entry1 = (EObject)iter4.next();
                            if (entry1.eIsProxy() && !resolve) {
                                ((InternalEList)value).basicRemove((Object)entry, null);
                                continue;
                            }
                            l.remove((Object)entry);
                        }
                        removeEntries1.clear();
                        continue;
                    }
                    collectedEntries.addAll(removeEntries1);
                }
                if (!delete) continue;
                iter = collectedEntries.iterator();
                while (iter.hasNext()) {
                    entry = (Map.Entry)iter.next();
                    if (entry.getKey() == null) continue;
                    if (((EObject)entry.getKey()).eIsProxy() && !resolve) {
                        ((EcoreEMap)l).basicRemove(entry.getKey(), null);
                        continue;
                    }
                    l.removeKey(entry.getKey());
                }
                collectedEntries.clear();
                continue;
            }
            if (!(o instanceof EList)) continue;
            l = (EList)o;
            if (delete) {
                collectedEntries.clear();
            }
            iter2 = containmentTraverser.getIterator((EList)l);
            while (iter2.hasNext()) {
                entry = (EObject)iter2.next();
                if (!EMFUtil.isContainedIn((EObject)entry, container)) continue;
                collectedEntries.add(entry);
                modified = true;
            }
            if (!delete) continue;
            iter = collectedEntries.iterator();
            while (iter.hasNext()) {
                entry = (EObject)iter.next();
                if (entry.eIsProxy() && !resolve) {
                    ((InternalEList)l).basicRemove((Object)entry, null);
                    continue;
                }
                l.remove((Object)entry);
            }
            collectedEntries.clear();
        }
        if (modified) {
            changedResources.add(element.eResource());
        }
        return modified;
    }

    public static Set unload(final Resource resource, ResourceSet resourceSet) {
        if (resource == null || resourceSet == null) {
            return Collections.EMPTY_SET;
        }
        final HashSet changedResources = new HashSet();
        final HashSet proxyObjects = new HashSet();
        List resourceSetRoots = EMFUtil.getResourceSetRoots(resourceSet, resource);
        boolean resolve = false;
        final ContainmentTraverser containmentTraverser = new ContainmentTraverser(resourceSetRoots, false);
        EObjectVisitor objectVisitor = new EObjectVisitor(){

            public boolean beforeChildren(EObject element) {
                return true;
            }

            public boolean afterChildren(EObject element) {
                EMFUtil.processObjectReferences((Notifier)resource, changedResources, false, false, proxyObjects, containmentTraverser, element);
                return true;
            }
        };
        containmentTraverser.registerVisitors(objectVisitor);
        containmentTraverser.traverse();
        Iterator iter = proxyObjects.iterator();
        while (iter.hasNext()) {
            EObject element = (EObject)iter.next();
            EMFUtil.convertToProxy((InternalEObject)element);
        }
        resource.getContents().clear();
        resourceSet.getResources().remove((Object)resource);
        return changedResources;
    }

    public static void unsetFeaturesInSameResource(EObject object, boolean resolve) {
        EStructuralFeature feature;
        int i;
        Resource resource = object.eResource();
        if (resource == null) {
            return;
        }
        EList features = object.eClass().getEAllAttributes();
        for (i = features.size() - 1; i >= 0; --i) {
            feature = (EStructuralFeature)features.get(i);
            object.eUnset(feature);
        }
        features = object.eClass().getEAllReferences();
        for (i = features.size() - 1; i >= 0; --i) {
            EcoreEList l;
            feature = (EReference)features.get(i);
            if (feature == object.eContainmentFeature()) continue;
            Object o = object.eGet(feature, resolve);
            if (feature.getEOpposite() != null) {
                if (o instanceof EObject) {
                    if (!EMFUtil.isContainedIn((EObject)o, resource)) continue;
                    object.eUnset(feature);
                    continue;
                }
                if (!(o instanceof EcoreEList) || !EMFUtil.isContainedIn((EObject)(l = (EcoreEList)o).getNotifier(), resource)) continue;
                object.eUnset(feature);
                continue;
            }
            if (o instanceof EObject) {
                if (!EMFUtil.isContainedIn((EObject)o, resource)) continue;
                object.eUnset(feature);
                continue;
            }
            if (!(o instanceof EcoreEList) || !EMFUtil.isContainedIn((EObject)(l = (EcoreEList)o).getNotifier(), resource)) continue;
            object.eUnset(feature);
        }
        if (object.eContainer() != null) {
            EcoreUtil.remove((EObject)object.eContainer(), (EStructuralFeature)object.eContainmentFeature(), (Object)object);
        }
    }

    public static void convertToProxy(InternalEObject object) {
        object.eSetProxyURI(EcoreUtil.getURI((EObject)object));
        EMFUtil.unsetFeaturesInSameResource((EObject)object, false);
        object.eAdapters().clear();
    }

    public static void unsetAllFeatures(EObject object) {
        EList features = object.eClass().getEAllStructuralFeatures();
        for (int i = features.size() - 1; i >= 0; --i) {
            EStructuralFeature feature = (EStructuralFeature)features.get(i);
            object.eUnset(feature);
        }
        if (object.eContainer() != null) {
            EcoreUtil.remove((EObject)object.eContainer(), (EStructuralFeature)object.eContainmentFeature(), (Object)object);
        }
    }

    public static final boolean isContainedIn(EObject object, Notifier container) {
        if (container instanceof Resource) {
            return EMFUtil.isContainedIn(object, (Resource)container);
        }
        return EMFUtil.isContainedIn(object, (EObject)container);
    }

    public static final boolean isContainedIn(EObject object, Resource resource) {
        if (!object.eIsProxy()) {
            return resource == object.eResource();
        }
        return ((InternalEObject)object).eProxyURI().trimFragment().equals((Object)resource.getURI());
    }

    public static final boolean isContainedIn(EObject object, EObject container) {
        if (!object.eIsProxy()) {
            return object == container || EcoreUtil.isAncestor((EObject)container, (EObject)object);
        }
        return object == container || EcoreUtil.getURI((EObject)object).toString().indexOf(EcoreUtil.getURI((EObject)container).toString()) > 0;
    }

    public static List getResourceSetRoots(ResourceSet resourceSet, Resource ignoredResource) {
        BasicEList list = new BasicEList();
        Iterator iter1 = resourceSet.getResources().iterator();
        while (iter1.hasNext()) {
            Resource resource = (Resource)iter1.next();
            if (resource == ignoredResource || resource.getClass().getName().endsWith("DBResourceImpl")) continue;
            list.addAll(resource.getContents());
        }
        return list;
    }

    public static Set unload(Resource resource) {
        if (resource == null) {
            return Collections.EMPTY_SET;
        }
        return EMFUtil.unload(resource, resource.getResourceSet());
    }
}

