/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.threadanalyzer;

import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.hyades.collection.threadanalyzer.Monitor;
import org.eclipse.hyades.collection.threadanalyzer.Thd;

public class DirectedGraph {
    private Object[] objList = null;
    private Object[][] adjMat = null;
    private int nVerts = -1;
    private Hashtable threadNumbers = null;
    private Hashtable _threads = null;
    private Hashtable _reversedTid = null;
    private boolean deadlockExists = false;

    public DirectedGraph(Hashtable _t) {
        this._threads = _t;
        int maxThreads = this._threads.size();
        this.objList = new Object[maxThreads];
        this.adjMat = new Object[maxThreads][maxThreads];
        this.nVerts = 0;
        int j = 0;
        while (j < maxThreads) {
            int k = 0;
            while (k < maxThreads) {
                this.adjMat[j][k] = null;
                ++k;
            }
            ++j;
        }
        this.threadNumbers = new Hashtable();
    }

    public void addVertex(Object thd) {
        this.threadNumbers.put(thd, new Integer(this.nVerts));
        this.objList[this.nVerts++] = thd;
    }

    public void addEdge(Object edge, Object start, Object end) {
        int startInt = (Integer)this.threadNumbers.get(start);
        int endInt = (Integer)this.threadNumbers.get(end);
        this.adjMat[startInt][endInt] = edge;
    }

    public void displayVertex(int v) {
        System.out.print(((Thd)this.objList[v])._threadId);
    }

    public void findCircularPattern() {
        int orig_nVerts = this.nVerts;
        while (this.nVerts > 0) {
            int currentVertex = this.noSuccessors();
            if (currentVertex == -1) {
                return;
            }
            this.deleteVertex(currentVertex);
        }
    }

    public int noSuccessors() {
        int row = 0;
        while (row < this.nVerts) {
            boolean isEdge = false;
            int col = 0;
            while (col < this.nVerts) {
                if (this.adjMat[row][col] != null) {
                    isEdge = true;
                    break;
                }
                ++col;
            }
            if (!isEdge) {
                return row;
            }
            ++row;
        }
        return -1;
    }

    public void deleteVertex(int delVert) {
        if (delVert != this.nVerts - 1) {
            int j = delVert;
            while (j < this.nVerts - 1) {
                this.objList[j] = this.objList[j + 1];
                ++j;
            }
            int row = delVert;
            while (row < this.nVerts - 1) {
                this.moveRowUp(row, this.nVerts);
                ++row;
            }
            int col = delVert;
            while (col < this.nVerts - 1) {
                this.moveColLeft(col, this.nVerts - 1);
                ++col;
            }
        } else {
            int i = 0;
            while (i < this.nVerts) {
                this.adjMat[delVert][i] = null;
                this.adjMat[i][delVert] = null;
                ++i;
            }
        }
        --this.nVerts;
    }

    private void moveRowUp(int row, int length) {
        int col = 0;
        while (col < length) {
            this.adjMat[row][col] = this.adjMat[row + 1][col];
            this.adjMat[row + 1][col] = null;
            ++col;
        }
    }

    private void moveColLeft(int col, int length) {
        int row = 0;
        while (row < length) {
            this.adjMat[row][col] = this.adjMat[row][col + 1];
            this.adjMat[row][col + 1] = null;
            ++row;
        }
    }

    public void debugPrint() {
        System.out.println("<p>Printing Graph:---------------------</p><br><br>");
        System.err.println("<table>");
        int i = 0;
        while (i < this.adjMat.length) {
            System.err.println("\t<tr><td>" + i + "</td><td>" + ((Thd)this.objList[i])._name + "</td></tr>");
            ++i;
        }
        System.err.println("</table>");
        System.err.println("<table>");
        System.err.println("\t<tr>");
        System.err.print("<td>&nbsp;</td>");
        int i2 = 0;
        while (i2 < this.adjMat.length) {
            System.err.print("<td>[" + i2 + "]</td>");
            ++i2;
        }
        System.err.println("\t</tr>");
        int i3 = 0;
        while (i3 < this.adjMat.length) {
            System.err.println("\t<tr>");
            System.err.print("<td>[" + i3 + "]</td>");
            int j = 0;
            while (j < this.adjMat[i3].length) {
                if (this.adjMat[i3][j] == null) {
                    System.err.print("<td>-</td>");
                } else {
                    System.err.print("<td>" + ((Monitor)this.adjMat[i3][j])._name + "</td>");
                }
                ++j;
            }
            System.err.println("\t</tr>");
            ++i3;
        }
        System.err.println("</table>");
    }

    public void debugPrint(String filename) {
        PrintStream p = null;
        try {
            p = new PrintStream(new FileOutputStream(filename));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("IO Error:: Printing to err stream anyway.");
            p = System.err;
        }
        p.println("<p>Printing Graph:---------------------</p><br><br>");
        p.println("<table>");
        int i = 0;
        while (i < this.adjMat.length) {
            p.println("\t<tr><td>" + i + "</td><td>" + ((Thd)this.objList[i])._name + "</td></tr>");
            ++i;
        }
        p.println("</table>");
        p.println("<table>");
        p.println("\t<tr>");
        p.print("<td>&nbsp;</td>");
        int i2 = 0;
        while (i2 < this.adjMat.length) {
            p.print("<td>[" + i2 + "]</td>");
            ++i2;
        }
        p.println("\t</tr>");
        int i3 = 0;
        while (i3 < this.adjMat.length) {
            p.println("\t<tr>");
            p.print("<td>[" + i3 + "]</td>");
            int j = 0;
            while (j < this.adjMat[i3].length) {
                if (this.adjMat[i3][j] == null) {
                    p.print("<td>-</td>");
                } else {
                    p.print("<td>" + ((Monitor)this.adjMat[i3][j])._name + "</td>");
                }
                ++j;
            }
            p.println("\t</tr>");
            ++i3;
        }
        p.println("</table>");
    }

    public Object[] getObjectList() {
        return this.objList;
    }

    public Object[][] getResultMatrix() {
        return this.adjMat;
    }

    public Object getObjectAt(int i, int j) {
        if (this.adjMat != null && i < this.adjMat.length && j < this.adjMat[0].length) {
            return this.adjMat[i][j];
        }
        return null;
    }

    public Object getObjectAt(Integer i, Integer j) {
        return this.getObjectAt((int)i, (int)j);
    }

    public Object getObjListObjectAt(int i) {
        if (this.objList != null && i < this.objList.length) {
            return this.objList[i];
        }
        return null;
    }

    public Object getObjListObjectAt(Integer i) {
        return this.getObjListObjectAt((int)i);
    }

    public Vector getNotNullPairs() {
        HashMap<Integer, Integer> cyclicHelper = new HashMap<Integer, Integer>();
        Vector tempResult = new Vector();
        tempResult.add(new Vector());
        Vector<String> result = null;
        ((Vector)tempResult.get(0)).add("The following threads appear to be waiting on themselves.\nCheck to see if the application is simply in a timed wait or if it is going \nto wait indefinitely.  Further information can be found by looking in the \nOverall Thread Analysis section of this tool.\n");
        if (this.adjMat != null) {
            int selfWaiterCount = 0;
            int i = 0;
            while (i < this.adjMat.length) {
                int j = 0;
                while (j < this.adjMat[0].length) {
                    if (this.adjMat[i][j] != null) {
                        if (i == j) {
                            ((Thd)this.objList[i]).setSelfWaiter(true);
                            if (!((Thd)this.objList[i]).waitingForWork()) {
                                ((Vector)tempResult.get(0)).add("Single-threaded waiter " + ++selfWaiterCount + ":\n" + "\"" + ((Thd)this.objList[i])._name + "\" (TID:" + this._reversedTid.get(((Thd)this.objList[i])._threadId) + ") is waiting on " + ((Monitor)this.adjMat[i][j])._name + "\n");
                            }
                        } else {
                            cyclicHelper.put(new Integer(i), new Integer(j));
                        }
                    }
                    ++j;
                }
                ++i;
            }
            Set keyset = cyclicHelper.keySet();
            Iterator itr = keyset.iterator();
            Integer i2 = null;
            Vector tempResultSet = new Vector();
            tempResultSet.add(new Hashtable());
            if (itr.hasNext()) {
                i2 = (Integer)itr.next();
            }
            int currentTable = 0;
            Integer value = null;
            while (!cyclicHelper.isEmpty()) {
                value = (Integer)cyclicHelper.get(i2);
                ((Hashtable)tempResultSet.get(currentTable)).put(i2, value);
                cyclicHelper.remove(i2);
                i2 = value;
                if ((Integer)cyclicHelper.get(i2) != null || cyclicHelper.isEmpty()) continue;
                itr = keyset.iterator();
                i2 = (Integer)itr.next();
                tempResultSet.add(++currentTable, new Hashtable());
            }
            Vector<String> deadlockResults = new Vector<String>();
            Hashtable h = null;
            int k = 0;
            while (k < tempResultSet.size()) {
                itr = null;
                h = (Hashtable)tempResultSet.get(k);
                itr = h.keySet().iterator();
                Integer first = null;
                if (itr.hasNext()) {
                    deadlockResults.add("Multi-threaded deadlock " + (k + 1) + ":\n");
                    first = (Integer)itr.next();
                    if (!((Thd)this.objList[first]).isSelfWaiter()) {
                        while (itr.hasNext()) {
                            i2 = (Integer)itr.next();
                            if (!((Thd)this.objList[i2]).isSelfWaiter()) continue;
                            first = i2;
                            break;
                        }
                    }
                }
                i2 = null;
                while (h.size() > 0) {
                    i2 = i2 == null ? first : value;
                    value = (Integer)h.get(i2);
                    h.remove(i2);
                    if (((Thd)this.objList[i2]).isSelfWaiter()) {
                        deadlockResults.add("Thread \"" + ((Thd)this.objList[i2.intValue()])._name + "\" is a self-waiter.  As a result, this deadlock is NON-circular.\n");
                    }
                    deadlockResults.add("\"" + ((Thd)this.objList[i2.intValue()])._name + "\" of (sys:" + ((Thd)this.objList[i2.intValue()])._threadId + ") (TID:" + this._reversedTid.get(((Thd)this.objList[i2.intValue()])._threadId) + ")\n" + "\tHolding Resource: " + ((Monitor)this.adjMat[i2.intValue()][value.intValue()])._name + "\n\tThread Waiting: \"" + ((Thd)this.objList[value.intValue()])._name + "\" (sys:" + ((Thd)this.objList[value.intValue()])._threadId + ") (TID:" + this._reversedTid.get(((Thd)this.objList[value.intValue()])._threadId) + ")\n");
                }
                ++k;
            }
            result = new Vector<String>(deadlockResults.size() + ((Vector)tempResult.get(0)).size());
            result.add("\n\nDeadlock Detection Report\n------------------------\n");
            if (deadlockResults.size() > 0 || ((Vector)tempResult.get(0)).size() > 1) {
                this.deadlockExists = true;
            } else {
                result.add("No deadlock(s) found.\n");
            }
            if (deadlockResults.size() > 1) {
                result.add("The following threads appear to be in a circular deadlock.\nFurther information can be found by looking in the Overall Thread Analysis\nsection of this tool.\n");
            }
            result.addAll(deadlockResults);
            if (((Vector)tempResult.get(0)).size() > 1) {
                result.addAll((Vector)tempResult.get(0));
            }
            result.add("------------------------");
            return result;
        }
        return null;
    }

    public boolean getDeadlockExists() {
        return this.deadlockExists;
    }

    public void putReversedTid(Hashtable _rTid) {
        this._reversedTid = _rTid;
    }
}

