/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.config.generator;

import org.eclipse.hyades.internal.config.generator.Agent;
import org.eclipse.hyades.internal.config.generator.AgentControllerEnvironment;
import org.eclipse.hyades.internal.config.generator.Application;
import org.eclipse.hyades.internal.config.generator.ConfigFile;
import org.eclipse.hyades.internal.config.generator.ConfigUtility;
import org.eclipse.hyades.internal.config.generator.Option;
import org.eclipse.hyades.internal.config.generator.Parameter;
import org.eclipse.hyades.internal.config.generator.PlatformObject;
import org.eclipse.hyades.internal.config.generator.PluginConfig;
import org.eclipse.hyades.internal.config.generator.Variable;
import org.w3c.dom.Element;

public class PluginConfigFile
extends ConfigFile {
    protected static String TAG = ConfigUtility.getString("Config.PluginConfig.Tag");
    protected Element pConfig = null;
    private static String sr = PlatformObject.sr;

    public PluginConfigFile() {
    }

    public PluginConfigFile(String name) {
        super(name);
    }

    public void generateConfiguration_datacollection(String name) {
        this.pConfig = this.doc.createElement(PluginConfig.TAG);
        this.holder = this.doc.createElement("ElementHolder");
        this.holder.appendChild(this.pConfig);
        Element aEnv = this.doc.createElement(AgentControllerEnvironment.TAG);
        AgentControllerEnvironment.setConfiguration(aEnv, "default");
        this.pConfig.appendChild(aEnv);
        Element var = this.doc.createElement(Variable.TAG);
        Variable.setName(var, "JBOSS_HOME");
        Variable.setPosition(var, "replace");
        Variable.setValue(var, this.getValue("JBOSS_HOME"));
        aEnv.appendChild(var);
        var = this.doc.createElement(Variable.TAG);
        Variable.setName(var, "JONAS_HOME");
        Variable.setPosition(var, "replace");
        Variable.setValue(var, this.getValue("JONAS_HOME"));
        aEnv.appendChild(var);
        if (PlatformObject.name.startsWith("Windows")) {
            Element app = this.doc.createElement(Application.TAG);
            Application.setConfiguration(app, "default");
            Application.setExecutable(app, "PerfmonAgent");
            Application.setLocation(app, "%RASERVER_HOME%" + sr + "bin");
            Application.setPath(app, "%RASERVER_HOME%" + sr + "bin" + sr + "PerfmonAgent" + PlatformObject.exeExt);
            this.pConfig.appendChild(app);
        }
        Element agent = this.doc.createElement(Agent.TAG);
        Agent.setConfiguration(agent, "default");
        Agent.setName(agent, "Java Profiling Agent");
        Agent.setClient(agent, "DYNAMIC");
        if (PlatformObject.name.startsWith("Windows")) {
            Agent.setDataChannelSize(agent, "64M");
        } else {
            Agent.setDataChannelSize(agent, "30M");
        }
        Agent.setType(agent, "Profiler");
        this.pConfig.appendChild(agent);
        Element option = this.doc.createElement(Option.TAG);
        Option.setName(option, "Thread Analysis Agent");
        Option.setType(option, "Profiler");
        Option.setValue(option, "hcthread");
        this.pConfig.appendChild(option);
        option = this.doc.createElement(Option.TAG);
        Option.setName(option, name);
        Option.setType(option, "version");
        Option.setValue(option, ConfigUtility.getString("Config.AgentController.Version"));
        this.pConfig.appendChild(option);
        this.saveToFile(this.getValue("RASERVER_HOME") + sr + "plugins" + sr + name + sr + "config" + sr + "pluginconfig.xml");
    }

    public void generateConfiguration_parsers(String name) {
        this.pConfig = this.doc.createElement(PluginConfig.TAG);
        this.holder = this.doc.createElement("ElementHolder");
        this.holder.appendChild(this.pConfig);
        Element app = this.doc.createElement(Application.TAG);
        Application.setConfiguration(app, "default");
        Application.setExecutable(app, "RemoteLogParserLoader");
        Application.setLocation(app, "%SYS_TEMP_DIR%");
        Application.setPath(app, "%JAVA_PATH%");
        this.pConfig.appendChild(app);
        Element var = this.doc.createElement(Variable.TAG);
        Variable.setName(var, "GLA_HOME");
        Variable.setPosition(var, "replace");
        Variable.setValue(var, "%RASERVER_HOME%" + sr + "plugins" + sr + name);
        app.appendChild(var);
        var = this.doc.createElement(Variable.TAG);
        Variable.setName(var, "GLA_CONFIG_PATH");
        Variable.setPosition(var, "replace");
        Variable.setValue(var, "%RASERVER_HOME%" + sr + "plugins" + sr + name + sr + "config");
        app.appendChild(var);
        var = this.doc.createElement(Variable.TAG);
        Variable.setName(var, "CLASSPATH");
        Variable.setPosition(var, "prepend");
        Variable.setValue(var, "%RASERVER_HOME%" + sr + "plugins" + sr + "org.eclipse.hyades.logging.parsers" + sr + "lib" + sr + "hgla.jar");
        app.appendChild(var);
        var = this.doc.createElement(Variable.TAG);
        Variable.setName(var, "CLASSPATH");
        Variable.setPosition(var, "prepend");
        Variable.setValue(var, "%RASERVER_HOME%" + sr + "plugins" + sr + "org.eclipse.hyades.logging.parsers" + sr + "lib" + sr + "hglaconfig.jar");
        app.appendChild(var);
        var = this.doc.createElement(Variable.TAG);
        Variable.setName(var, "CLASSPATH");
        Variable.setPosition(var, "prepend");
        Variable.setValue(var, "%RASERVER_HOME%" + sr + "plugins" + sr + "org.eclipse.hyades.logging.parsers" + sr + "lib" + sr + "hparse.jar");
        app.appendChild(var);
        Element param = this.doc.createElement(Parameter.TAG);
        Parameter.setPosition(param, "prepend");
        Parameter.setValue(param, "org.eclipse.hyades.logging.parsers.RemoteLogParserLoader");
        app.appendChild(param);
        param = this.doc.createElement(Parameter.TAG);
        Parameter.setPosition(param, "prepend");
        Parameter.setValue(param, "-DGLA_HOME=&quot;%GLA_HOME%&quot;");
        app.appendChild(param);
        param = this.doc.createElement(Parameter.TAG);
        Parameter.setPosition(param, "prepend");
        Parameter.setValue(param, "-Djava.version=1.4");
        app.appendChild(param);
        param = this.doc.createElement(Parameter.TAG);
        Parameter.setPosition(param, "append");
        Parameter.setValue(param, "&quot;config_path=%GLA_CONFIG_PATH%&quot;");
        app.appendChild(param);
        Element option = this.doc.createElement(Option.TAG);
        Option.setName(option, name);
        Option.setType(option, "version");
        Option.setValue(option, ConfigUtility.getString("Config.AgentController.Version"));
        this.pConfig.appendChild(option);
        this.saveToFile(this.getValue("RASERVER_HOME") + sr + "plugins" + sr + name + sr + "config" + sr + "pluginconfig.xml");
    }

    public void generateConfiguration_test(String name) {
        this.pConfig = this.doc.createElement(PluginConfig.TAG);
        this.holder = this.doc.createElement("ElementHolder");
        this.holder.appendChild(this.pConfig);
        Element aEnv = this.doc.createElement(AgentControllerEnvironment.TAG);
        AgentControllerEnvironment.setConfiguration(aEnv, "default");
        this.pConfig.appendChild(aEnv);
        Element var = this.doc.createElement(Variable.TAG);
        Variable.setName(var, "CLASSPATH");
        Variable.setPosition(var, "append");
        Variable.setValue(var, "%RASERVER_HOME%" + sr + "plugins" + sr + "org.eclipse.hyades.test" + sr + "lib" + sr + "junit.jar");
        aEnv.appendChild(var);
        Element app = this.doc.createElement(Application.TAG);
        Application.setConfiguration(app, "default");
        Application.setExecutable(app, "HyadesTestingSession");
        Application.setLocation(app, "%SYS_TEMP_DIR%");
        Application.setPath(app, "%JAVA_PATH%");
        this.pConfig.appendChild(app);
        Element param = this.doc.createElement(Parameter.TAG);
        Parameter.setPosition(param, "prepend");
        Parameter.setValue(param, "&quot;-Dhyades.test.JVM=%JAVA_PATH%&quot;");
        app.appendChild(param);
        String testLibDir = "%RASERVER_HOME%" + sr + "plugins" + sr + "org.eclipse.hyades.test" + sr + "lib" + sr;
        var = this.doc.createElement(Variable.TAG);
        Variable.setName(var, "CLASSPATH");
        Variable.setPosition(var, "append");
        Variable.setValue(var, testLibDir + "common.runner.jar");
        app.appendChild(var);
        var = this.doc.createElement(Variable.TAG);
        Variable.setName(var, "CLASSPATH");
        Variable.setPosition(var, "append");
        Variable.setValue(var, testLibDir + "hexrecr.jar");
        app.appendChild(var);
        var = this.doc.createElement(Variable.TAG);
        Variable.setName(var, "CLASSPATH");
        Variable.setPosition(var, "append");
        Variable.setValue(var, testLibDir + "http.hexrecr.jar");
        app.appendChild(var);
        var = this.doc.createElement(Variable.TAG);
        Variable.setName(var, "CLASSPATH");
        Variable.setPosition(var, "append");
        Variable.setValue(var, testLibDir + "http.runner.jar");
        app.appendChild(var);
        var = this.doc.createElement(Variable.TAG);
        Variable.setName(var, "CLASSPATH");
        Variable.setPosition(var, "append");
        Variable.setValue(var, testLibDir + "java.runner.jar");
        app.appendChild(var);
        var = this.doc.createElement(Variable.TAG);
        Variable.setName(var, "CLASSPATH");
        Variable.setPosition(var, "append");
        Variable.setValue(var, testLibDir + "manual.runner.jar");
        app.appendChild(var);
        var = this.doc.createElement(Variable.TAG);
        Variable.setName(var, "CLASSPATH");
        Variable.setPosition(var, "append");
        Variable.setValue(var, testLibDir + "common_model.jar");
        app.appendChild(var);
        var = this.doc.createElement(Variable.TAG);
        Variable.setName(var, "CLASSPATH");
        Variable.setPosition(var, "append");
        Variable.setValue(var, testLibDir + "ecore.xmi.jar");
        app.appendChild(var);
        var = this.doc.createElement(Variable.TAG);
        Variable.setName(var, "CLASSPATH");
        Variable.setPosition(var, "append");
        Variable.setValue(var, testLibDir + "hmodel.jar");
        app.appendChild(var);
        var = this.doc.createElement(Variable.TAG);
        Variable.setName(var, "CLASSPATH");
        Variable.setPosition(var, "append");
        Variable.setValue(var, testLibDir + "runtime.jar");
        app.appendChild(var);
        var = this.doc.createElement(Variable.TAG);
        Variable.setName(var, "CLASSPATH");
        Variable.setPosition(var, "append");
        Variable.setValue(var, testLibDir + "datapool_api.jar");
        app.appendChild(var);
        Element option = this.doc.createElement(Option.TAG);
        Option.setName(option, name);
        Option.setType(option, "version");
        Option.setValue(option, ConfigUtility.getString("Config.AgentController.Version"));
        this.pConfig.appendChild(option);
        this.saveToFile(this.getValue("RASERVER_HOME") + sr + "plugins" + sr + name + sr + "config" + sr + "pluginconfig.xml");
    }

    public void generateHyadesConfiguration() {
    }

    public void saveToFile() {
    }
}

