/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.java;

import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.eclipse.hyades.logging.core.LoggingAgent;
import org.eclipse.hyades.logging.java.XmlFormatter;

public class SingleLoggingAgentHandler
extends Handler {
    private boolean isClosed = false;
    private static LoggingAgent loggingAgent = null;
    private static int instanceCount = 0;
    private static final Object CURRENT_THREAD_LOCK = new Object();
    public static final String DEFAULT_LOGGING_AGENT_NAME = "Logging Agent Handler";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SingleLoggingAgentHandler() {
        LogManager logManager = LogManager.getLogManager();
        String className = this.getClass().getName();
        String defaultProperty = logManager.getProperty(className.concat(".level"));
        if (defaultProperty == null) {
            this.setLevel(Level.OFF);
        } else {
            try {
                this.setLevel(Level.parse(defaultProperty.trim()));
            }
            catch (Throwable t) {
                this.setLevel(Level.OFF);
            }
        }
        defaultProperty = logManager.getProperty(className.concat(".filter"));
        if (defaultProperty == null) {
            this.setFilter(null);
        } else {
            try {
                final String finalDefaultProperty = defaultProperty.trim();
                Class filterClass = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return ClassLoader.getSystemClassLoader().loadClass(finalDefaultProperty);
                    }
                });
                this.setFilter((Filter)filterClass.newInstance());
            }
            catch (Throwable t) {
                this.setFilter(null);
            }
        }
        defaultProperty = logManager.getProperty(className.concat(".encoding"));
        if (defaultProperty == null) {
            try {
                this.setEncoding(null);
            }
            catch (UnsupportedEncodingException u) {}
        } else {
            try {
                this.setEncoding(defaultProperty.trim());
            }
            catch (Throwable t) {
                try {
                    this.setEncoding(null);
                }
                catch (UnsupportedEncodingException u) {
                    // empty catch block
                }
            }
        }
        super.setFormatter(new XmlFormatter());
        Object object = CURRENT_THREAD_LOCK;
        synchronized (object) {
            ++instanceCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(LogRecord logRecord) {
        if (!this.isClosed && this.isLoggable(logRecord)) {
            String formattedLogRecord = null;
            try {
                formattedLogRecord = this.getFormatter().format(logRecord).trim();
            }
            catch (Exception e) {
                this.writeError(null, e, 5);
                return;
            }
            Object object = CURRENT_THREAD_LOCK;
            synchronized (object) {
                if (loggingAgent == null) {
                    loggingAgent = new LoggingAgent(DEFAULT_LOGGING_AGENT_NAME);
                }
                loggingAgent.write(formattedLogRecord);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (!this.isClosed) {
            Object object = CURRENT_THREAD_LOCK;
            synchronized (object) {
                if (loggingAgent != null) {
                    loggingAgent.flush();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.isClosed) {
            this.flush();
            Object object = CURRENT_THREAD_LOCK;
            synchronized (object) {
                if (--instanceCount == 0 && loggingAgent != null) {
                    loggingAgent.deregister();
                }
            }
            this.isClosed = true;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public void setFormatter(Formatter newFormatter) throws SecurityException {
    }

    private void writeError(String message, Exception exception, int code) {
        try {
            this.getErrorManager().error(message, exception, code);
        }
        catch (Throwable t) {
            System.err.println("Error: " + t.getMessage());
            t.printStackTrace();
        }
    }
}

