/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter;

import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.impl.Controller;
import org.eclipse.hyades.logging.adapter.util.Messages;

public class Adapter {
    private Controller rootController = null;
    private String contextFile = null;
    private String componentFile = null;

    public void setContextConfigPath(String configFilePath) {
        this.contextFile = configFilePath;
    }

    public void setComponentConfigPath(String configFilePath) {
        this.componentFile = configFilePath;
    }

    public void validate() throws AdapterException {
        this.rootController = new Controller();
        if (this.componentFile == null) {
            this.componentFile = Messages.getString("HyadesGADefaultComponentConfigurationsFile");
        }
        if (this.contextFile == null) {
            this.contextFile = Messages.getString("HyadesGADefaultContextConfigurationFile");
        }
        this.rootController.setContextConfigPath(this.contextFile);
        this.rootController.setComponentConfigPath(this.componentFile);
        this.rootController.prepareAdapter();
    }

    public void start(boolean separateThread, boolean daemon) throws AdapterException {
        this.rootController = new Controller();
        if (this.componentFile == null) {
            this.componentFile = Messages.getString("HyadesGADefaultComponentConfigurationsFile");
        }
        if (this.contextFile == null) {
            this.contextFile = Messages.getString("HyadesGADefaultContextConfigurationFile");
        }
        this.rootController.setContextConfigPath(this.contextFile);
        this.rootController.setComponentConfigPath(this.componentFile);
        this.rootController.prepareAdapter();
        if (!separateThread) {
            this.rootController.run();
        } else {
            Thread serverThread = new Thread(this.rootController);
            serverThread.setDaemon(daemon);
            serverThread.start();
        }
    }

    public void stop() {
        if (this.rootController != null) {
            this.rootController.stop();
        }
    }

    public void hardStop() {
        if (this.rootController != null) {
            this.rootController.hardStop();
        }
    }

    public static void main(String[] args) {
        Adapter adapter = new Adapter();
        if (adapter.parseCommandLine(args)) {
            try {
                adapter.start(false, false);
            }
            catch (AdapterException e) {
                System.err.println(Messages.getString("HyadesGAAdapterFatal_ERROR_"));
                System.err.println(e.getMessage());
                adapter.stop();
            }
        } else {
            System.out.println(Messages.getString("HyadesGACommand_line_usage"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseCommandLine(String[] args) {
        if (args == null || args.length <= 0) return true;
        String ccArgName = Messages.getString("HyadesGA-cc");
        String acArgName = Messages.getString("HyadesGA-ac");
        int i = 0;
        while (i < args.length) {
            if (ccArgName.equalsIgnoreCase(args[i])) {
                if (++i >= args.length || args[i] == null) return false;
                this.setContextConfigPath(args[i]);
            } else {
                if (!acArgName.equalsIgnoreCase(args[i])) return false;
                if (++i >= args.length || args[i] == null) return false;
                this.setComponentConfigPath(args[i]);
            }
            ++i;
        }
        return true;
    }
}

