/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.parsers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.IComponent;
import org.eclipse.hyades.logging.adapter.IContext;
import org.eclipse.hyades.logging.adapter.IDirectedGraph;
import org.eclipse.hyades.logging.adapter.IParser;
import org.eclipse.hyades.logging.adapter.internal.util.SubstitutionExtensionLoaderUtil;
import org.eclipse.hyades.logging.adapter.parsers.DirectedGraphImpl;
import org.eclipse.hyades.logging.adapter.parsers.IStatefulSubstitutionExtension;
import org.eclipse.hyades.logging.adapter.parsers.IStatement;
import org.eclipse.hyades.logging.adapter.parsers.ISubstitutionExtension;
import org.eclipse.hyades.logging.adapter.parsers.PositionParser;
import org.eclipse.hyades.logging.adapter.parsers.PreparationException;
import org.eclipse.hyades.logging.adapter.parsers.StatementException;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.adapter.util.TimeParser;
import org.w3c.dom.Element;

public class SubstituteStatement
implements IStatement {
    protected String name;
    protected String positions;
    protected String match;
    protected String substitute;
    protected Pattern pattern;
    protected List positionsList;
    protected boolean processTime;
    protected TimeParser timeParser;
    protected String substitutionExtensionClass;
    protected IStatefulSubstitutionExtension statefulExtension = null;
    protected boolean callout = false;
    protected boolean calloutNewInstance = true;
    protected Class substitutionExtensionClassClass = null;
    protected boolean useBuiltin;
    protected List path;
    protected IDirectedGraph resultGraph;
    private IParser parser;

    public SubstituteStatement(IParser parser) {
        this.parser = parser;
    }

    public void prepare(Element node, String path) throws PreparationException {
        this.positions = node.getAttribute(Messages.getString("HyadesGAPositionsAttributeName"));
        this.match = node.getAttribute(Messages.getString("HyadesGAMatchAttributeName"));
        this.substitute = node.getAttribute(Messages.getString("HyadesGASubstituteAttributeName"));
        this.substitutionExtensionClass = node.getAttribute(Messages.getString("HyadesGAsubstitutionExtensionClassAttributeName"));
        String timeFormat = node.getAttribute(Messages.getString("HyadesGAtimeFormatAttributeName"));
        String builtin = node.getAttribute(Messages.getString("HyadesGAuseBuiltInFunctionAttributeName"));
        this.useBuiltin = builtin != null && !builtin.equals("") ? builtin.equals("true") : false;
        this.name = path;
        if (timeFormat != null && !timeFormat.equals("") && !this.useBuiltin) {
            this.processTime = true;
            Locale locale = null;
            IComponent current = this.parser;
            while (current != null) {
                if (current instanceof IContext) {
                    locale = ((IContext)current).getLocale();
                    break;
                }
                current = current.getParent();
            }
            try {
                this.timeParser = locale != null ? new TimeParser(timeFormat, locale) : new TimeParser(timeFormat, Locale.getDefault());
            }
            catch (AdapterException e) {
                PreparationException details = new PreparationException(Messages.getString("HyadesGA_CBE_Parser_Preparation_Invalid_Time_Format_ERROR_", timeFormat), e);
                details.setDigraph(this.name);
                throw details;
            }
        }
        if (!(this.substitutionExtensionClass == null || this.substitutionExtensionClass.equals("") || this.useBuiltin || this.processTime)) {
            this.callout = true;
            ISubstitutionExtension extension = null;
            try {
                this.substitutionExtensionClassClass = Class.forName(this.substitutionExtensionClass);
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                extension = SubstitutionExtensionLoaderUtil.instantiate(this.substitutionExtensionClassClass, this.substitutionExtensionClass);
            }
            catch (ClassCastException e) {
                PreparationException details = new PreparationException(Messages.getString("HyadesGA_CBE_Parser_Run_SubstitutionExtensionClass_Invalid_ERROR_", this.substitutionExtensionClass), e);
                details.setDigraph(this.name);
                throw details;
            }
            catch (ClassNotFoundException e) {
                PreparationException details = new PreparationException(Messages.getString("HyadesGA_CBE_Parser_Preparation_SubstitutionExtensionClass_NotFound_ERROR_", this.substitutionExtensionClass), e);
                details.setDigraph(this.name);
                throw details;
            }
            catch (Exception e) {
                PreparationException details = new PreparationException(Messages.getString("HyadesGA_CBE_Parser_Preparation_SubstitutionExtensionClass_Exception_ERROR_", this.substitutionExtensionClass), e);
                details.setDigraph(this.name);
                throw details;
            }
            try {
                this.statefulExtension = (IStatefulSubstitutionExtension)extension;
                this.calloutNewInstance = false;
            }
            catch (ClassCastException e) {
                this.calloutNewInstance = true;
            }
        }
        this.resultGraph = null;
        this.path = new ArrayList();
        StringTokenizer s = new StringTokenizer(path, ".");
        while (s.hasMoreTokens()) {
            String subPath = s.nextToken();
            int indexStart = subPath.indexOf(91);
            if (indexStart > 0) {
                String index = subPath.substring(indexStart + 1, subPath.length() - 1);
                subPath = subPath.substring(0, indexStart);
                this.path.add(subPath);
                this.path.add(index);
                continue;
            }
            this.path.add(subPath);
        }
        if (this.positions != null && !this.positions.equals("")) {
            this.positionsList = PositionParser.getPositionedString(this.positions, true);
        }
        if (this.match != null && !this.match.equals("")) {
            this.compileMatchString(this.match);
        }
    }

    protected void compileMatchString(String match) throws PreparationException {
        try {
            this.pattern = Pattern.compile(match);
        }
        catch (PatternSyntaxException e) {
            PreparationException details = new PreparationException(Messages.getString("HyadesGAMalformedParserExpression_ERROR_"));
            String detailsString = Messages.getString("HyadesGAPatternSyntaxException_Details", e.getDescription(), e.getPattern());
            if (e.getIndex() >= 0) {
                detailsString = detailsString + "  " + Messages.getString("HyadesGAPatternSyntaxException_Index", String.valueOf(e.getIndex()));
            }
            details.setDetails(detailsString);
            details.setDigraph(this.name);
            throw details;
        }
    }

    public List run(String line, HashMap inputs) throws AdapterException, StatementException {
        String tmpLine = line;
        boolean result = false;
        ArrayList<IDirectedGraph> list = new ArrayList<IDirectedGraph>();
        if (this.useBuiltin) {
            this.resultGraph = new DirectedGraphImpl();
            this.resultGraph.setPath(this.path);
            this.resultGraph.setValue("##BUILTIN");
            list.add(this.resultGraph);
            return list;
        }
        if (this.positions != null && !this.positions.equals("")) {
            tmpLine = this.positionsToString(line, inputs);
        }
        if (tmpLine != null) {
            String newLine;
            if (this.match != null && !this.match.equals("")) {
                newLine = this.substitute != null && !this.substitute.equals("") ? this.matchAndSubstitute(tmpLine) : null;
                result = newLine != null && newLine.length() > 0;
            } else {
                newLine = this.substitute != null && !this.substitute.equals("") ? this.substitute : tmpLine;
                result = true;
            }
            if (result) {
                if (this.processTime) {
                    long convertedTime = this.timeParser.parse(newLine);
                    if (convertedTime == 0L) {
                        this.resultGraph = null;
                        throw StatementException.instance();
                    }
                    list.add(this.createResultGraph(new Long(convertedTime)));
                    return list;
                }
                if (this.callout) {
                    if (this.calloutNewInstance) {
                        ISubstitutionExtension statelessExtension;
                        try {
                            statelessExtension = this.substitutionExtensionClassClass == null ? SubstitutionExtensionLoaderUtil.instantiate(this.substitutionExtensionClass) : (ISubstitutionExtension)this.substitutionExtensionClassClass.newInstance();
                        }
                        catch (Throwable e) {
                            throw new AdapterException(Messages.getString("HyadesGA_CBE_Parser_Preparation_SubstitutionExtensionClass_Exception_ERROR_", this.substitutionExtensionClass), e);
                        }
                        try {
                            if (newLine == line) {
                                newLine = statelessExtension.processRecord(newLine);
                            }
                            newLine = statelessExtension.processMatchResult(newLine);
                        }
                        catch (Exception e) {
                            throw new AdapterException(Messages.getString("HyadesGA_CBE_Parser_Run_StatelessSubstitutionExtensionClass_Exception_ERROR_", this.substitutionExtensionClass), e);
                        }
                    } else {
                        try {
                            newLine = newLine == line ? this.statefulExtension.processRecord(newLine) : this.statefulExtension.processMatchResult(newLine);
                        }
                        catch (Exception e) {
                            throw new AdapterException(Messages.getString("HyadesGA_CBE_Parser_Run_StatefulSubstitutionExtensionClass_Exception_ERROR_", this.substitutionExtensionClass), e);
                        }
                    }
                    if (newLine == null) {
                        this.resultGraph = null;
                        throw StatementException.instance();
                    }
                }
                list.add(this.createResultGraph(newLine));
                return list;
            }
        }
        this.resultGraph = null;
        throw StatementException.instance();
    }

    protected String matchAndSubstitute(String line) {
        if (this.substitute != null && !this.substitute.equals("")) {
            Matcher matcher = this.pattern.matcher(line);
            if (!matcher.find()) {
                return null;
            }
            String result = matcher.replaceAll(this.substitute);
            return result.trim();
        }
        return null;
    }

    protected String positionsToString(String line, HashMap inputs) {
        if (this.positionsList != null) {
            StringBuffer result = new StringBuffer();
            ListIterator iterator = this.positionsList.listIterator();
            boolean first = true;
            boolean emptyString = false;
            while (iterator.hasNext()) {
                Object current = iterator.next();
                if (first) {
                    first = !first;
                } else {
                    result.append("@@");
                }
                if (current instanceof String) {
                    String val = (String)inputs.get(current);
                    if (val != null && val.length() > 0) {
                        result.append(val);
                        continue;
                    }
                    return null;
                }
                if (!(current instanceof Long)) continue;
                Long item = (Long)current;
                String val = null;
                int index = item.intValue() - 1;
                val = (String)inputs.get(new Long(index));
                if (val != null && val.length() > 0) {
                    result.append(val);
                    continue;
                }
                return null;
            }
            return result.toString();
        }
        return line;
    }

    public IDirectedGraph getResultGraph() {
        return this.resultGraph;
    }

    public IDirectedGraph createResultGraph(Object value) {
        this.resultGraph = new DirectedGraphImpl();
        this.resultGraph.setPath(this.path);
        this.resultGraph.setValue(value);
        return this.resultGraph;
    }

    public boolean isRequiredByParent() {
        return false;
    }

    public boolean isChildChoice() {
        return false;
    }
}

