/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.commons;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.eclipse.hyades.logging.commons.FileLogger;

public class FileLoggerFactory
extends LogFactory {
    private Hashtable attributes = new Hashtable();
    private Hashtable loggers = new Hashtable();

    public void setAttribute(String name, Object value) {
        if (name != null) {
            if (value == null) {
                this.attributes.remove(name);
            } else {
                this.attributes.put(name, value);
            }
        }
    }

    public void removeAttribute(String name) {
        if (name != null) {
            this.attributes.remove(name);
        }
    }

    public Object getAttribute(String name) {
        if (name != null) {
            return this.attributes.get(name);
        }
        return null;
    }

    public String[] getAttributeNames() {
        Set attributeNames = this.attributes.keySet();
        return attributeNames.toArray(new String[attributeNames.size()]);
    }

    public Log getInstance(Class classInstance) throws LogConfigurationException {
        return this.getInstance(classInstance.getName());
    }

    public Log getInstance(String loggerName) throws LogConfigurationException {
        if (loggerName != null) {
            if (this.loggers.containsKey(loggerName)) {
                return (Log)this.loggers.get(loggerName);
            }
            FileLogger logger = new FileLogger(loggerName);
            this.loggers.put(loggerName, logger);
            return logger;
        }
        return null;
    }

    public void release() {
        Iterator loggerNames = this.loggers.keySet().iterator();
        while (loggerNames.hasNext()) {
            ((FileLogger)this.loggers.remove(loggerNames.next())).finalize();
        }
    }
}

