/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.util;

import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.logging.events.cbe.MissingPropertyException;
import org.eclipse.hyades.logging.events.cbe.ValidationException;
import org.eclipse.hyades.logging.events.cbe.util.EventHelpers;

public class EventValidation {
    public static String getComponentName(EObject eObject, String string) {
        String string2 = new String(string);
        EObject eObject2 = eObject;
        while (eObject2 != null) {
            string2 = eObject2.eClass().getName() + "." + string2;
            eObject2 = eObject2.eContainer();
        }
        return string2;
    }

    public static void validateRequiredProperties(String string, EObject eObject) throws ValidationException {
        EClass eClass = eObject.eClass();
        EList eList = eClass.getEAllAttributes();
        EList eList2 = eClass.getEAllContainments();
        int n = 0;
        while (n < eList.size()) {
            EAttribute eAttribute = (EAttribute)eList.get(n);
            if (eAttribute.isRequired() && !eObject.eIsSet((EStructuralFeature)eAttribute)) {
                throw new MissingPropertyException(EventHelpers.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", EventValidation.getComponentName(eObject, eAttribute.getName())));
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < eList2.size()) {
            EReference eReference = (EReference)eList2.get(n2);
            if (eReference.isRequired() && !eObject.eIsSet((EStructuralFeature)eReference)) {
                throw new MissingPropertyException(EventHelpers.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", EventValidation.getComponentName(eObject, eReference.getName())));
            }
            ++n2;
        }
    }

    public static void validateId(String string, EObject eObject, EStructuralFeature eStructuralFeature, String string2) throws ValidationException {
        if (string2 != null) {
            if (string2.length() < 32 || string2.length() > 64) {
                throw new ValidationException(EventHelpers.getString("LOG_INVALID_GLOBAL_INSTANCE_ID_LENGTH_EXC_", EventValidation.getComponentName(eObject, eStructuralFeature.getName()), string2));
            }
            char[] cArray = string2.toCharArray();
            if (!(cArray[0] >= 'a' && cArray[0] <= 'z' || cArray[0] >= 'A' && cArray[0] <= 'Z')) {
                throw new ValidationException(EventHelpers.getString("LOG_INVALID_GLOBAL_INSTANCE_ID_EXC_", EventValidation.getComponentName(eObject, eStructuralFeature.getName()), string2));
            }
        }
    }

    public static void validateId(String string, EObject eObject, EStructuralFeature eStructuralFeature) throws ValidationException {
        EventValidation.validateId(string, eObject, eStructuralFeature, (String)eObject.eGet(eStructuralFeature));
    }

    public static void validateStringIdList(String string, EObject eObject, EStructuralFeature eStructuralFeature) throws ValidationException {
        StringTokenizer stringTokenizer = new StringTokenizer((String)eObject.eGet(eStructuralFeature), " ");
        while (stringTokenizer.hasMoreTokens()) {
            EventValidation.validateId(string, eObject, eStructuralFeature, stringTokenizer.nextToken());
        }
    }

    public static void validateLength(String string, EObject eObject, EStructuralFeature eStructuralFeature, int n, int n2) throws ValidationException {
        String string2 = (String)eObject.eGet(eStructuralFeature);
        if (string2 != null && (string2.length() < n || string2.length() > n2)) {
            if (n == 0) {
                throw new ValidationException(EventHelpers.getString("LOG_INVALID_LENGTH_EXC_", EventValidation.getComponentName(eObject, eStructuralFeature.getName()), string2, new Integer(string2.length()), new Integer(n2)));
            }
            throw new ValidationException(EventHelpers.getString("LOG_INVALID_LENGTH_RANGE_EXC_", EventValidation.getComponentName(eObject, eStructuralFeature.getName()), string2, new Integer(string2.length()), n + " - " + n2));
        }
    }

    public static void validateLength(String string, EObject eObject, EStructuralFeature eStructuralFeature, int n) throws ValidationException {
        EventValidation.validateLength(string, eObject, eStructuralFeature, 0, n);
    }

    public static void validateMutuallyExclusiveAttributes(String string, EObject eObject, EStructuralFeature eStructuralFeature, EStructuralFeature eStructuralFeature2) throws ValidationException {
        if (eObject.eGet(eStructuralFeature) == null && eObject.eGet(eStructuralFeature2) == null || eObject.eGet(eStructuralFeature) != null && eObject.eGet(eStructuralFeature2) != null) {
            throw new ValidationException(EventHelpers.getString("LOG_MUTUALLY_EXCLUSIVE_ATTRIBUTES_EXC_", EventValidation.getComponentName(eObject, eStructuralFeature.getName()), EventValidation.getComponentName(eObject, eStructuralFeature2.getName())));
        }
    }

    public static void validateVersion(String string, EObject eObject, EStructuralFeature eStructuralFeature) throws ValidationException {
        String string2 = (String)eObject.eGet(eStructuralFeature);
        if (string2 != null && !string2.equals("1.0.1")) {
            throw new ValidationException(EventHelpers.getString("LOG_INVALID_VERSION_EXC_", EventValidation.getComponentName(eObject, eStructuralFeature.getName()), string2));
        }
    }

    public static void throwValidationException(String string, String string2, Object[] objectArray) throws ValidationException {
        throw new ValidationException(EventHelpers.getString(string2, objectArray));
    }

    public static void throwMissingPropertyException(String string, String string2, Object[] objectArray) throws ValidationException {
        throw new MissingPropertyException(EventHelpers.getString(string2, objectArray));
    }
}

