/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.collection.framework;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.hyades.collection.framework.channel.DataChannelHelper;
import org.eclipse.hyades.collection.framework.channel.DataChannelImpl;
import org.eclipse.hyades.execution.core.DataChannelConnectionException;
import org.eclipse.hyades.execution.core.DataChannelNotInitializedException;
import org.eclipse.hyades.execution.core.InvalidDataChannelAccessException;

public class DCFillerProcess {
    private static String fileName;
    private static String DCName;

    public static void main(String[] stringArray) {
        DCFillerProcess dCFillerProcess = new DCFillerProcess(stringArray);
        DataChannelHelper dataChannelHelper = new DataChannelHelper();
        try {
            DataChannelImpl dataChannelImpl = dataChannelHelper.connectToDataChannel(DCName);
            dataChannelImpl.setFillable();
            FileInputStream fileInputStream = new FileInputStream(fileName);
            OutputStream outputStream = dataChannelImpl.getOutputStream();
            byte[] byArray = new byte[8096];
            int n = 0;
            try {
                while (true) {
                    if ((n = fileInputStream.read(byArray)) > 0) {
                        outputStream.write(byArray, 0, n);
                        continue;
                    }
                    if (n < 0) break;
                }
                outputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("IOException occurred tyring to read from file or write to data channe");
            }
            fileInputStream.close();
            dataChannelImpl.disconnect();
        }
        catch (DataChannelConnectionException dataChannelConnectionException) {
            System.out.println("DCFillerProcess:  could not connect to data channel with name " + DCName + "\n   Reason: " + dataChannelConnectionException.getMessage());
        }
        catch (InvalidDataChannelAccessException invalidDataChannelAccessException) {
            System.out.println("DCFillerProcess:  Cannot write to this data channel");
        }
        catch (DataChannelNotInitializedException dataChannelNotInitializedException) {
            System.out.println("DCFillerProcess:  data channel is not initialized");
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("DCFillerProcess:  could not open file " + fileName);
        }
        catch (IOException iOException) {
            System.out.println("DCFillerProcess:  could not close file " + fileName);
        }
    }

    public DCFillerProcess(String[] stringArray) {
        System.out.println("DCFillerProcess: Command line arguments, length=" + stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            System.out.println("\targs[" + n + "] = " + stringArray[n]);
            ++n;
        }
        if (stringArray.length == 2) {
            DCName = stringArray[0];
            fileName = stringArray[1];
        } else if (stringArray.length == 1) {
            DCName = stringArray[0];
            fileName = "c:\\temp\\dctest.in";
        } else {
            DCName = "shmchannel";
            fileName = "c:\\temp\\dctest.in";
        }
    }
}

