/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events;

import java.util.HashMap;
import org.eclipse.hyades.logging.events.IEventFactory;
import org.eclipse.hyades.logging.events.exceptions.CannotCreateEventFactoryException;
import org.eclipse.hyades.logging.events.exceptions.MissingValueException;

public final class EventFactoryHome {
    protected static final String INTERFACE_PREFIX = "I";
    private static final Object LOCK = new String();
    private static HashMap knownClasses = null;

    public static IEventFactory getFactory(String string, String string2) throws CannotCreateEventFactoryException {
        if (string == null) {
            throw new CannotCreateEventFactoryException(new MissingValueException("instanceName"));
        }
        if (string2 == null) {
            throw new CannotCreateEventFactoryException(new MissingValueException("eventInterface"));
        }
        IEventFactory iEventFactory = null;
        Object object = LOCK;
        synchronized (object) {
            HashMap<String, IEventFactory> hashMap;
            if (knownClasses == null) {
                knownClasses = new HashMap();
            }
            if ((hashMap = (HashMap<String, IEventFactory>)knownClasses.get(string2)) == null) {
                hashMap = new HashMap<String, IEventFactory>();
                knownClasses.put(string2, hashMap);
            }
            if ((iEventFactory = (IEventFactory)hashMap.get(string)) == null) {
                String string3 = string2.startsWith(INTERFACE_PREFIX) ? string2.substring(1) : string2;
                try {
                    Class<?> clazz = Class.forName(string3);
                    iEventFactory = (IEventFactory)clazz.newInstance();
                }
                catch (Exception exception) {
                    throw new CannotCreateEventFactoryException(exception);
                }
                iEventFactory.init(string);
                hashMap.put(string, iEventFactory);
            }
        }
        return iEventFactory;
    }

    public void releaseFactory(IEventFactory iEventFactory) {
        if (iEventFactory == null) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            if (knownClasses != null) {
                HashMap hashMap;
                String string = iEventFactory.getEventInterfaceClassName();
                String string2 = iEventFactory.getName();
                if (string != null && (hashMap = (HashMap)knownClasses.get(string)) != null) {
                    if (string2 != null) {
                        hashMap.remove(string2);
                    }
                    if (hashMap.isEmpty()) {
                        knownClasses.remove(string);
                        hashMap = null;
                    }
                }
                if (knownClasses.isEmpty()) {
                    knownClasses = null;
                }
            }
        }
    }
}

