/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.invocation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class UpdateablePathClassLoader
extends ClassLoader {
    public UpdateablePathClassLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    public UpdateablePathClassLoader() {
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        Object object;
        StringTokenizer stringTokenizer = this.getSearchPathTokens();
        String string2 = string.replace('.', File.separatorChar);
        File file = null;
        while (stringTokenizer.hasMoreTokens()) {
            object = new StringBuffer(stringTokenizer.nextToken());
            ((StringBuffer)object).append(File.separatorChar);
            ((StringBuffer)object).append(string2);
            ((StringBuffer)object).append(".class");
            file = new File(((StringBuffer)object).toString());
            if (file.exists()) break;
        }
        if (!file.exists()) {
            throw new ClassNotFoundException(string);
        }
        object = null;
        byte[] byArray = null;
        try {
            object = new FileInputStream(file);
            byArray = new byte[((FileInputStream)object).available()];
            ((FileInputStream)object).read(byArray);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ClassNotFoundException("Could not open input file: \"" + file.getPath() + "\"");
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException("Could not read '.class' file: \"" + file.getPath() + "\"");
        }
        return this.defineClass(string, byArray, 0, byArray.length);
    }

    protected URL findResource(String string) {
        URL uRL = null;
        StringTokenizer stringTokenizer = this.getSearchPathTokens();
        File file = null;
        while (stringTokenizer.hasMoreTokens()) {
            StringBuffer stringBuffer = new StringBuffer(stringTokenizer.nextToken());
            stringBuffer.append(File.separatorChar);
            stringBuffer.append(string);
            file = new File(stringBuffer.toString());
            if (file.exists()) break;
        }
        try {
            if (file.exists()) {
                uRL = file.toURL();
            }
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Could not find resource \"" + string + "\"\n" + malformedURLException);
        }
        return uRL;
    }

    protected Enumeration findResources(String string) throws IOException {
        Vector<URL> vector = new Vector<URL>();
        StringTokenizer stringTokenizer = this.getSearchPathTokens();
        File file = null;
        while (stringTokenizer.hasMoreTokens()) {
            StringBuffer stringBuffer = new StringBuffer(stringTokenizer.nextToken());
            stringBuffer.append(File.separatorChar);
            stringBuffer.append(string);
            file = new File(stringBuffer.toString());
            if (!file.exists()) continue;
            try {
                vector.add(file.toURL());
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("Could not find resource \"" + string + "\"\n" + malformedURLException);
            }
        }
        return vector.elements();
    }

    private StringTokenizer getSearchPathTokens() {
        String string = System.getProperty("java.class.path", ".");
        return new StringTokenizer(string, File.pathSeparator);
    }
}

