/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.java.runner;

import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import junit.framework.Test;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.remote.CustomCommandHandler;
import org.eclipse.hyades.internal.execution.remote.RemoteComponentSkeleton;
import org.eclipse.hyades.test.common.agent.ComptestAgent;
import org.eclipse.hyades.test.common.event.ExecutionEvent;
import org.eclipse.hyades.test.common.event.MessageEvent;
import org.eclipse.hyades.test.common.junit.HyadesTestRunner;
import org.eclipse.hyades.test.common.junit.HyadesTestSuite;
import org.eclipse.hyades.test.common.junit.HyadesTestUtil;
import org.eclipse.hyades.test.common.util.BaseString;
import org.eclipse.hyades.test.java.runner.JUnitResourceBundle;

public class HyadesJUnitRunner
extends HyadesTestRunner {
    private boolean isOKToStart = false;
    private ComptestAgent comptestAgent;
    static /* synthetic */ Class class$org$eclipse$hyades$test$java$runner$HyadesJUnitRunner;

    public static void main(String[] stringArray) {
        Object object;
        RemoteComponentSkeleton remoteComponentSkeleton = new RemoteComponentSkeleton("Executor$" + stringArray[0], "tester");
        final HyadesJUnitRunner hyadesJUnitRunner = new HyadesJUnitRunner(remoteComponentSkeleton);
        remoteComponentSkeleton.addCommandListener(new CustomCommandHandler(){

            public void handleCommand(CustomCommand customCommand) {
                if (customCommand.getData().equals("START")) {
                    hyadesJUnitRunner.setOKToStart(true);
                }
            }
        });
        try {
            remoteComponentSkeleton.initialize();
        }
        catch (Throwable throwable) {}
        while (!hyadesJUnitRunner.isOKToStart()) {
            object = hyadesJUnitRunner;
            synchronized (object) {
                try {
                    ((Object)((Object)hyadesJUnitRunner)).wait(180000L);
                    if (!hyadesJUnitRunner.isOKToStart()) {
                        remoteComponentSkeleton.sendMessageToAttachedClient("Test was not started after 3 minutes.  Exiting testcase.", 0L);
                        System.exit(-1);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        try {
            object = Class.forName(stringArray[0], true, (class$org$eclipse$hyades$test$java$runner$HyadesJUnitRunner == null ? (class$org$eclipse$hyades$test$java$runner$HyadesJUnitRunner = HyadesJUnitRunner.class$("org.eclipse.hyades.test.java.runner.HyadesJUnitRunner")) : class$org$eclipse$hyades$test$java$runner$HyadesJUnitRunner).getClassLoader());
            Method method = ((Class)object).getMethod("suite", null);
            Test test = (Test)method.invoke(null, null);
            HyadesTestSuite hyadesTestSuite = (HyadesTestSuite)test;
            String string = HyadesTestUtil.appendToHierarchyId((String)HyadesTestUtil.getHierarchyIds((Test)hyadesTestSuite), null, (int)1);
            System.setOut(new PrintStream(new AgentConsoleStream(remoteComponentSkeleton, 0, string)));
            System.setErr(new PrintStream(new AgentConsoleStream(remoteComponentSkeleton, 1, string)));
            hyadesJUnitRunner.run(test);
            remoteComponentSkeleton.sendMessageToAttachedClient("Testcase completed successfuly", 0L);
        }
        catch (Throwable throwable) {
            MessageEvent messageEvent = new MessageEvent();
            messageEvent.setText(BaseString.getStackTrace((Throwable)throwable));
            messageEvent.setSeverity(1);
            messageEvent.setOwnerId(stringArray[1]);
            messageEvent.setId("ROOT");
            remoteComponentSkeleton.logMessageUTF8(messageEvent.toString());
        }
    }

    public HyadesJUnitRunner(RemoteComponentSkeleton remoteComponentSkeleton) {
        this.comptestAgent = new ComptestAgent(remoteComponentSkeleton);
    }

    public synchronized boolean isOKToStart() {
        return this.isOKToStart;
    }

    protected synchronized void setOKToStart(boolean bl) {
        this.isOKToStart = bl;
        ((Object)((Object)this)).notifyAll();
    }

    protected void runnerStarted() {
        this.comptestAgent.write("<EXECUTION>");
        super.runnerStarted();
    }

    protected void runnerExit(boolean bl, long l) {
        super.runnerExit(bl, l);
        this.comptestAgent.write("</EXECUTION>");
    }

    protected void writeEvent(ExecutionEvent executionEvent) {
        if (this.comptestAgent != null && executionEvent != null) {
            this.comptestAgent.write(executionEvent.toString());
        }
    }

    protected String getLastEventText(boolean bl, long l) {
        String[] stringArray = new String[]{new Integer(this.getSucceedTests().size() + this.getFailureTests().size() + this.getErrorTests().size()).toString(), new Integer(this.getFailureTests().size()).toString(), new Integer(this.getErrorTests().size()).toString(), new Long(l).toString()};
        if (bl) {
            return JUnitResourceBundle.getInstance().getString("execution.TestStoped", stringArray);
        }
        return JUnitResourceBundle.getInstance().getString("execution.TestsFinished", stringArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class AgentConsoleStream
    extends OutputStream {
        public static final int OUT = 0;
        public static final int ERR = 1;
        private int mode;
        private RemoteComponentSkeleton agent;
        private String hierarchyId;
        private StringBuffer buffer = new StringBuffer();

        public AgentConsoleStream(RemoteComponentSkeleton remoteComponentSkeleton, int n, String string) {
            this.mode = n;
            this.agent = remoteComponentSkeleton;
            this.hierarchyId = string;
        }

        public void write(int n) {
            this.buffer.append((char)n);
            if (n == 10) {
                MessageEvent messageEvent = new MessageEvent();
                messageEvent.setText(this.buffer.toString());
                messageEvent.setSeverity(0);
                messageEvent.setOwnerId(this.hierarchyId);
                if (this.mode == 0) {
                    messageEvent.setText("System.out:\n" + this.buffer.toString());
                } else if (this.mode == 1) {
                    messageEvent.setText("System.err:\n" + this.buffer.toString());
                }
                this.agent.logMessageUTF8(messageEvent.toString());
                this.buffer = new StringBuffer();
            }
        }
    }
}

