/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.config.generator;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.eclipse.hyades.internal.config.generator.FileError;
import org.eclipse.hyades.internal.config.generator.SetConfigCommon;

public class SetConfig {
    protected static ResourceBundle myResource;
    protected static String _racHome;
    protected static String _javaPath;
    protected static String _allow;
    protected static String _hosts;
    protected static String _configFileName;
    protected static String _startFileName;
    protected static String _platform;
    protected static boolean help;
    protected static boolean silent;
    protected static boolean verifyValues;
    protected static boolean overwrite;
    public static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 2002 - All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static void setRACHome(String string) {
        _racHome = string;
    }

    public static String getRACHome() {
        return _racHome;
    }

    public static void setJavaHome(String string) {
        _javaPath = string;
    }

    public static String getJavaHome() {
        return _javaPath;
    }

    public static void setPlatform(String string) {
        _platform = string;
    }

    public static String getPlatform() {
        return _platform;
    }

    public static void setAllow(String string) {
        _allow = string;
    }

    public static String getAllow() {
        return _allow;
    }

    public static void setHosts(String string) {
        _hosts = string;
    }

    public static String getHosts() {
        return _hosts;
    }

    public static void setConfigFileName(String string) {
        _configFileName = string;
    }

    public static String getConfigFileName() {
        return _configFileName;
    }

    public static void setStartFileName(String string) {
        _startFileName = string;
    }

    public static String getStartFileName() {
        return _startFileName;
    }

    public static void main(String[] stringArray) {
        SetConfigCommon setConfigCommon = SetConfig.generationMain(stringArray);
        if (setConfigCommon != null) {
            SetConfig.writeConfigFile(setConfigCommon);
        }
    }

    public static ResourceBundle getResource() {
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle("org.eclipse.hyades.internal.config.generator.SetConfig");
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("Can't find resource file");
        }
        return resourceBundle;
    }

    public static SetConfigCommon generationMain(String[] stringArray) {
        Iterator iterator;
        Object object;
        SetConfigCommon setConfigCommon;
        block37: {
            myResource = SetConfig.getResource();
            if (myResource == null) {
                return null;
            }
            SetConfig.processParameters(stringArray);
            if (help) {
                SetConfig.printHelpMenu();
                return null;
            }
            if (verifyValues || !silent) {
                SetConfig.verifyParameters();
            }
            if (SetConfig.getPlatform() == null) {
                SetConfig.setPlatform(System.getProperty("os.name", "null"));
            }
            if (SetConfig.getRACHome() == null) {
                SetConfig.setRACHome(SetConfig.getUserRacHome());
                if (SetConfig.getRACHome() == null) {
                    return null;
                }
            }
            if (SetConfig.getPlatform().startsWith("Windows")) {
                SetConfig.setConfigFileName(SetConfig.getRACHome() + "\\config\\serviceconfig.xml");
            } else {
                SetConfig.setConfigFileName(SetConfig.getRACHome() + "/config/serviceconfig.xml");
            }
            setConfigCommon = new SetConfigCommon(SetConfig.getPlatform());
            if (!overwrite && SetConfig.fileExists(SetConfig.getConfigFileName())) {
                try {
                    if (!setConfigCommon.loadExistingConfiguration(SetConfig.getConfigFileName())) {
                        System.out.println(myResource.getString("ErrFileLoad") + "  " + SetConfig.getConfigFileName());
                        System.out.println(myResource.getString("ErrFileLoadSuggestion"));
                        return null;
                    }
                    break block37;
                }
                catch (FileError fileError) {
                    object = fileError.get_exception();
                    iterator = ResourceBundle.getBundle("org.apache.xerces.impl.msg.XMLMessages");
                    if (((Throwable)object).getMessage() != null && ((Throwable)object).getMessage().equals(((ResourceBundle)((Object)iterator)).getString("PrematureEOF"))) {
                        if (!setConfigCommon.createDefaultConfiguration()) {
                            System.out.println(myResource.getString("ErrCreateDefCfg"));
                            return null;
                        }
                        break block37;
                    }
                    System.out.println(myResource.getString("ErrFileLoad") + "  " + fileError.get_fileName());
                    System.out.println(myResource.getString("ErrFileLoadSuggestion"));
                    return null;
                }
            }
            if (!setConfigCommon.createDefaultConfiguration()) {
                System.out.println(myResource.getString("ErrCreateDefCfg"));
                return null;
            }
        }
        if (SetConfig.getRACHome() != null && !SetConfig.getRACHome().equals("")) {
            setConfigCommon.setRACHome(SetConfig.getRACHome());
        }
        if (silent) {
            if (SetConfig.getJavaHome() != null && !SetConfig.getJavaHome().equals("")) {
                setConfigCommon.setJAVAHome(SetConfig.getJavaHome());
            }
            if (SetConfig.getAllow() != null && !SetConfig.getAllow().equals("")) {
                if (SetConfig.getAllow().equals("CUSTOM")) {
                    if (SetConfig.getHosts() != null && !SetConfig.getHosts().equals("")) {
                        List list = SetConfig.processStringList(SetConfig.getHosts());
                        setConfigCommon.removeAllowHosts();
                        object = list.iterator();
                        while (object.hasNext()) {
                            setConfigCommon.addAllowHost((String)object.next());
                        }
                    }
                } else {
                    setConfigCommon.removeAllowHosts();
                    setConfigCommon.addAllowHost(SetConfig.getAllow());
                }
            }
        } else {
            String string;
            if (SetConfig.getJavaHome() == null || SetConfig.getJavaHome().equals("")) {
                string = setConfigCommon.getJAVAHome();
                if (string.equals("%JAVA_PATH%")) {
                    string = new String(System.getProperty("java.home") + setConfigCommon.ps + "bin");
                }
                if (string == null) {
                    string = setConfigCommon.getJAVAHome();
                }
                setConfigCommon.setJAVAHome(SetConfig.getUserJavaPath(string));
            } else {
                setConfigCommon.setJAVAHome(SetConfig.getJavaHome());
            }
            string = setConfigCommon.getAllowHosts();
            if (SetConfig.getAllow() == null || SetConfig.getAllow().equals("")) {
                object = SetConfig.processStringList(string);
                iterator = object.iterator();
                String string2 = new String("LOCAL");
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    if (string3.equals("ALL")) {
                        string2 = "ALL";
                        break;
                    }
                    if (string3.equals("LOCAL")) continue;
                    string2 = "CUSTOM";
                    break;
                }
                SetConfig.setAllow(SetConfig.getUserAllow(string2));
            }
            setConfigCommon.removeAllowHosts();
            if (SetConfig.getAllow().equals("CUSTOM")) {
                if (SetConfig.getHosts() == null || SetConfig.getHosts().equals("")) {
                    object = SetConfig.processStringList(SetConfig.getUserHosts(string));
                    iterator = object.iterator();
                    while (iterator.hasNext()) {
                        setConfigCommon.addAllowHost((String)iterator.next());
                    }
                } else {
                    object = SetConfig.processStringList(SetConfig.getHosts());
                    iterator = object.iterator();
                    while (iterator.hasNext()) {
                        setConfigCommon.addAllowHost((String)iterator.next());
                    }
                }
            } else {
                setConfigCommon.addAllowHost(SetConfig.getAllow());
            }
        }
        return setConfigCommon;
    }

    public static void writeConfigFile(SetConfigCommon setConfigCommon) {
        try {
            setConfigCommon.writeConfigFile(SetConfig.getConfigFileName());
            if (!SetConfig.getPlatform().startsWith("Windows")) {
                _startFileName = new String(setConfigCommon.getRACHome() + "/bin/RAStart.sh");
                setConfigCommon.writeToFile(_startFileName, setConfigCommon.getStartSh());
            }
        }
        catch (FileError fileError) {
            System.out.println(myResource.getString("ErrFileWrite") + "  " + fileError.get_fileName());
        }
    }

    public static void printHelpMenu() {
        System.out.println(myResource.getString("CmdUsage"));
        System.out.println("    " + myResource.getString("CmdUsage2"));
        System.out.println();
        System.out.println(myResource.getString("CmdFlags"));
        System.out.println(myResource.getString("CmdFlagHelp"));
        System.out.println(myResource.getString("CmdFlagSilent"));
        System.out.println(myResource.getString("CmdFlagNoVerify"));
        System.out.println();
        System.out.println(myResource.getString("CmdParms"));
        System.out.println(myResource.getString("CmdRAServerHome"));
        System.out.println(myResource.getString("CmdJavaHome"));
        System.out.println(myResource.getString("CmdAllow"));
        System.out.println(myResource.getString("CmdCustom"));
        System.out.println();
        System.out.println(myResource.getString("CmdExampleTitle"));
        System.out.println();
        System.out.println(myResource.getString("CmdExample1Head"));
        System.out.println(myResource.getString("CmdExample1"));
        System.out.println();
        System.out.println(myResource.getString("CmdExample2Head"));
        System.out.println(myResource.getString("CmdExample2"));
        System.out.println();
        System.out.println(myResource.getString("CmdExample3Head"));
        System.out.println(myResource.getString("CmdExample3"));
        System.out.println();
        System.out.println(myResource.getString("CmdExample4Head"));
        System.out.println(myResource.getString("CmdExample4"));
    }

    public static boolean fileExists(String string) {
        File file = new File(string);
        return file.exists() && file.length() > 206L;
    }

    public static List processStringList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null) {
            return arrayList;
        }
        String string2 = string.trim();
        if (string2.startsWith("\"") && string2.endsWith("\"")) {
            string2 = string2.substring(1, string2.length() - 1).trim();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " ,");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    public static void processParameters(String[] stringArray) {
        String string = null;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-help") || stringArray[n].equals("-?") || stringArray[n].equals("-h")) {
                help = true;
            } else if (stringArray[n].equals("-silent") || stringArray[n].equals("-s")) {
                silent = true;
            } else if (stringArray[n].equals("-noverify") || stringArray[n].equals("-nov")) {
                verifyValues = false;
            } else if (stringArray[n].equals("-overwrite")) {
                overwrite = true;
            } else if (stringArray[n].startsWith("RASERVER_HOME=")) {
                string = stringArray[n].substring(14).trim();
                SetConfig.setRACHome(string);
            } else if (stringArray[n].startsWith("PLATFORM=")) {
                SetConfig.setPlatform(stringArray[n].substring(9));
            } else if (stringArray[n].startsWith("JAVA_HOME=")) {
                string = stringArray[n].substring(10).trim();
                SetConfig.setJavaHome(string);
            } else if (stringArray[n].startsWith("ALLOW=")) {
                string = stringArray[n].substring(6);
                SetConfig.setAllow(string);
            } else if (stringArray[n].startsWith("HOSTS=")) {
                string = stringArray[n].substring(6);
                SetConfig.setHosts(string);
            } else if (stringArray[n] != null && !stringArray[n].equals("")) {
                System.out.println(myResource.getString("WarnUnknownOpt") + " >" + stringArray[n] + "<");
            }
            ++n;
        }
    }

    public static void verifyParameters() {
        if (SetConfig.getRACHome() != null) {
            SetConfig.setRACHome(SetConfig.verifyRacHome(SetConfig.getRACHome()));
        }
        if (SetConfig.getJavaHome() != null) {
            SetConfig.setJavaHome(SetConfig.verifyJavaHome(SetConfig.getJavaHome()));
        }
        if (SetConfig.getAllow() != null) {
            SetConfig.setAllow(SetConfig.verifyAllow(SetConfig.getAllow(), false));
        }
    }

    /*
     * Unable to fully structure code
     */
    public static String getUserRacHome() {
        var0 = null;
        var1_1 = null;
        var0 = System.getProperty("user.dir", "null");
        if (var0 != null) {
            if (SetConfig.getPlatform().startsWith("Windows")) {
                var2_2 = var0.lastIndexOf(92);
                if (var2_2 == var0.length() - 1) {
                    var2_2 = var0.lastIndexOf(92, var2_2 - 1);
                }
            } else {
                var2_2 = var0.lastIndexOf(47);
                if (var2_2 == var0.length() - 1) {
                    var2_2 = var0.lastIndexOf(47, var2_2 - 1);
                }
            }
            if (var2_2 != -1) {
                var0 = var0.substring(0, var2_2);
                var1_1 = SetConfig.verifyRacHome(var0);
            }
        }
        if (var1_1 != null || !SetConfig.silent) ** GOTO lbl26
        return null;
lbl-1000:
        // 1 sources

        {
            System.out.print(SetConfig.myResource.getString("AskRAServerHome"));
            try {
                var2_3 = new BufferedReader(new InputStreamReader(System.in));
                var0 = var2_3.readLine().trim();
            }
            catch (IOException var2_4) {
                System.out.println("Exception caught during RASERVER_HOME resolution: " + var2_4);
            }
            var1_1 = SetConfig.verifyRacHome(var0);
lbl26:
            // 2 sources

            ** while (var1_1 == null)
        }
lbl27:
        // 1 sources

        return var1_1;
    }

    public static String getUserJavaPath(String string) {
        String string2 = null;
        String string3 = null;
        while (string3 == null) {
            if (string == null) {
                System.out.print(myResource.getString("AskJavaHome"));
            } else {
                System.out.print(myResource.getString("AskJavaHome") + " (" + string + ") ");
            }
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                string2 = bufferedReader.readLine().trim();
            }
            catch (IOException iOException) {
                System.out.println("Exception caught during JAVA_HOME resolution: " + iOException);
            }
            if (string2 == null || string2.equals("")) {
                string2 = string;
            }
            string3 = SetConfig.verifyJavaHome(string2);
        }
        return string3;
    }

    public static String getPlatformOverride(String[] stringArray) {
        String string = null;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith("PLATFORM=")) {
                string = stringArray[n].substring(9);
            }
            ++n;
        }
        return string;
    }

    public static String getUserAllow(String string) {
        String string2 = null;
        String string3 = null;
        while (string3 == null) {
            if (string == null) {
                System.out.print(myResource.getString("AskAllow"));
            } else {
                System.out.print(myResource.getString("AskAllow") + " (" + string + ") ");
            }
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                string2 = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                System.out.println("Exception caught during allow resolution: " + iOException);
            }
            if (string2 == null || string2.equals("")) {
                string2 = string;
            }
            string3 = SetConfig.verifyAllow(string2, true);
        }
        return string3;
    }

    public static String getUserHosts(String string) {
        String string2 = null;
        while (string2 == null) {
            if (string == null) {
                System.out.print(myResource.getString("AskHosts"));
            } else {
                System.out.print(myResource.getString("AskHosts") + " (" + string + ") ");
            }
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                string2 = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                System.out.println("Exception caught during hosts resolution: " + iOException);
            }
            if (string2 != null && !string2.equals("")) continue;
            string2 = string;
        }
        return string2;
    }

    public static String getUserSecured(String string) {
        String string2 = null;
        String string3 = null;
        while (string3 == null) {
            System.out.print(myResource.getString("AskSecured") + " (" + string + ") ");
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                string2 = bufferedReader.readLine().toLowerCase();
            }
            catch (IOException iOException) {
                System.out.println("Exception caught during security resolution: " + iOException);
            }
            if (string2 == null || string2.equals("")) {
                string2 = string;
            }
            string3 = SetConfig.verifySecured(string2, true);
        }
        return string3;
    }

    public static String getUserSecuredUsers(String string) {
        String string2 = null;
        System.out.print(myResource.getString("AskSecuredUsers") + " (" + string + ") ");
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            string2 = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            System.out.println("Exception caught during security resolution: " + iOException);
        }
        if (string2 == null || string2.equals("")) {
            string2 = string;
        }
        return string2;
    }

    public static String verifyRacHome(String string) {
        String string2;
        File file;
        if (SetConfig.getPlatform() == null) {
            SetConfig.setPlatform(System.getProperty("os.name", "null"));
        }
        if ((file = new File(string, string2 = SetConfig.getPlatform().startsWith("Windows") ? new String("\\bin\\RAServer.exe") : (SetConfig.getPlatform().startsWith("OS/400") ? new String("/dtd/serviceconfig.dtd") : new String("/bin/RAServer")))).exists()) {
            return string;
        }
        if (silent) {
            System.out.println(myResource.getString("AskRAServerHomeErr") + "  " + myResource.getString("DefaultUsed"));
        } else {
            System.out.println(myResource.getString("AskRAServerHomeErr"));
        }
        return null;
    }

    public static String verifyJavaHome(String string) {
        File file;
        if (SetConfig.getPlatform() == null) {
            SetConfig.setPlatform(System.getProperty("os.name", "null"));
        }
        if (SetConfig.getPlatform().startsWith("Windows")) {
            String string2 = new String("\\java.exe");
            file = new File(string, string2);
        } else if (SetConfig.getPlatform().startsWith("OS/400")) {
            file = new File(string);
        } else {
            String string3 = new String("/java");
            file = new File(string, string3);
        }
        if (file.exists()) {
            return string;
        }
        if (silent) {
            System.out.println(myResource.getString("AskJavaHomeErr") + "  " + myResource.getString("DefaultUsed"));
        } else {
            System.out.println(myResource.getString("AskJavaHomeErr"));
        }
        return null;
    }

    public static String verifyAllow(String string, boolean bl) {
        if (string.toUpperCase().equals("ALL") || string.toUpperCase().equals("LOCAL") || string.toUpperCase().equals("CUSTOM")) {
            return string.toUpperCase();
        }
        if (silent) {
            System.out.println(myResource.getString("TellAllowErr") + "  " + myResource.getString("DefaultUsed"));
        } else if (bl) {
            System.out.println(myResource.getString("AskAllowErr"));
        } else {
            System.out.println(myResource.getString("TellAllowErr"));
        }
        return null;
    }

    public static String verifySecured(String string, boolean bl) {
        if (string.toLowerCase().equals("yes") || string.toLowerCase().equals("no")) {
            return string.toLowerCase();
        }
        if (silent) {
            System.out.println(myResource.getString("TellSecuredErr") + "  " + myResource.getString("DefaultUsed"));
        } else if (bl) {
            System.out.println(myResource.getString("AskSecuredErr"));
        } else {
            System.out.println(myResource.getString("TellSecuredErr"));
        }
        return null;
    }

    static {
        help = false;
        silent = false;
        verifyValues = true;
        overwrite = false;
    }
}

