/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.common.junit;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.extensions.TestDecorator;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.eclipse.hyades.test.common.junit.HyadesTestUtil;
import org.eclipse.hyades.test.common.junit.IHyadesTest;
import org.eclipse.hyades.test.common.junit.IHyadesTestArbiter;

public class HyadesTestSuite
extends TestSuite
implements IHyadesTest {
    private String id;
    private String testInvocationId;
    private Test parent;
    private IHyadesTestArbiter arbiter;
    private int iteration = 0;
    private int previousParentIteration = 0;
    private boolean synchronous = true;
    private int activeAsynchronousTest;

    public HyadesTestSuite() {
    }

    public HyadesTestSuite(Class clazz) {
        super(clazz);
    }

    public HyadesTestSuite(String string) {
        super(string);
    }

    public String getId() {
        return this.id;
    }

    public IHyadesTest setId(String string) {
        this.id = string;
        return this;
    }

    public String getTestInvocationId() {
        return this.testInvocationId;
    }

    public IHyadesTest setTestInvocationId(String string) {
        this.testInvocationId = string;
        return this;
    }

    public void setParent(Test test) {
        this.parent = test;
    }

    public Test getParent() {
        return this.parent;
    }

    public int getIteration() {
        int n;
        if (!this.isSynchronous() && Thread.currentThread() instanceof AsynchronousThread && (n = ((AsynchronousThread)Thread.currentThread()).getIteration(this)) >= 0) {
            return n;
        }
        return this.iteration;
    }

    public IHyadesTest setSynchronous(boolean bl) {
        this.synchronous = bl;
        return this;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public HyadesTestSuite setArbiter(IHyadesTestArbiter iHyadesTestArbiter) {
        this.arbiter = iHyadesTestArbiter;
        return this;
    }

    public IHyadesTestArbiter getArbiter() {
        return this.arbiter;
    }

    public void addTestSuite(Class clazz) {
        this.addTest(new HyadesTestSuite(clazz));
    }

    public void addTest(Test test) {
        super.addTest(test);
        if (test instanceof TestDecorator) {
            test = HyadesTestUtil.getDecoratorTest((TestDecorator)test);
        }
        if (test instanceof IHyadesTest) {
            IHyadesTest iHyadesTest = (IHyadesTest)test;
            iHyadesTest.setParent(this);
        }
    }

    public void run(TestResult testResult) {
        if (this.isSynchronous()) {
            this.doRun(testResult);
        } else {
            final TestResult testResult2 = testResult;
            AsynchronousThread asynchronousThread = new AsynchronousThread("Asynchronous HyadesTestSuite"){

                public void run() {
                    try {
                        HyadesTestSuite.this.doRun(testResult2);
                        Object var2_1 = null;
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        if (HyadesTestSuite.this.getParent() instanceof HyadesTestSuite) {
                            ((HyadesTestSuite)HyadesTestSuite.this.getParent()).runFinished(HyadesTestSuite.this);
                        }
                        this.dispose();
                        throw throwable;
                    }
                    if (HyadesTestSuite.this.getParent() instanceof HyadesTestSuite) {
                        ((HyadesTestSuite)HyadesTestSuite.this.getParent()).runFinished(HyadesTestSuite.this);
                    }
                    this.dispose();
                }
            };
            if (this.getParent() instanceof HyadesTestSuite) {
                ++((HyadesTestSuite)this.getParent()).activeAsynchronousTest;
            }
            asynchronousThread.start();
        }
    }

    protected void doRun(TestResult testResult) {
        Iterator iterator;
        HyadesTestSuite hyadesTestSuite = this;
        synchronized (hyadesTestSuite) {
            this.adjustIteration();
            if (!this.isSynchronous() && Thread.currentThread() instanceof AsynchronousThread) {
                ((AsynchronousThread)Thread.currentThread()).setIteration(this, this.iteration);
            }
            iterator = HyadesTestUtil.getTestListeners(testResult);
            while (iterator.hasNext()) {
                ((TestListener)iterator.next()).startTest((Test)this);
            }
        }
        this.activeAsynchronousTest = 0;
        super.run(testResult);
        this.waitUntilFinished();
        iterator = HyadesTestUtil.getTestListeners(testResult);
        while (iterator.hasNext()) {
            ((TestListener)iterator.next()).endTest((Test)this);
        }
    }

    public void runTest(final Test test, final TestResult testResult) {
        if (test instanceof IHyadesTest && !((IHyadesTest)test).isSynchronous()) {
            Thread thread = new Thread("Asynchronous Test"){

                public void run() {
                    try {
                        test.run(testResult);
                        Object var2_1 = null;
                        HyadesTestSuite.this.runFinished(test);
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        HyadesTestSuite.this.runFinished(test);
                        throw throwable;
                    }
                }
            };
            ++this.activeAsynchronousTest;
            thread.start();
        } else {
            super.runTest(test, testResult);
        }
    }

    protected void adjustIteration() {
        if (this.parent != null) {
            int n = this.previousParentIteration;
            if (this.parent instanceof IHyadesTest) {
                n = ((IHyadesTest)this.parent).getIteration();
            }
            if (n != this.previousParentIteration) {
                this.iteration = 0;
                this.previousParentIteration = n;
            }
        }
        ++this.iteration;
    }

    protected synchronized void waitUntilFinished() {
        while (this.activeAsynchronousTest > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    protected synchronized void runFinished(Test test) {
        --this.activeAsynchronousTest;
        this.notifyAll();
    }

    public String toJUnitString() {
        return super.toString();
    }

    public String toString() {
        return HyadesTestUtil.getHierarchy(this, false);
    }

    private static class AsynchronousThread
    extends Thread {
        private static int counter = 0;
        private Map iterationByTest = new HashMap();

        public AsynchronousThread(String string) {
            super(string + ++counter);
        }

        public void dispose() {
            this.iterationByTest.clear();
        }

        public void setIteration(Test test, int n) {
            this.iterationByTest.put(this.getName() + test.hashCode(), new Integer(n));
        }

        public int getIteration(Test test) {
            Integer n = (Integer)this.iterationByTest.get(this.getName() + test.hashCode());
            if (n == null) {
                return -1;
            }
            return n;
        }
    }
}

