/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.HashMap;
import org.eclipse.hyades.logging.events.CbeFormatter;
import org.eclipse.hyades.logging.events.IExtendedDataElement;
import org.eclipse.hyades.logging.events.exceptions.InvalidExtendedDataElementTypeException;

public class ExtendedDataElementImpl
implements IExtendedDataElement,
Serializable {
    static final long serialVersionUID = 6633427043459375461L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("name", class$java$lang$String == null ? (class$java$lang$String = ExtendedDataElementImpl.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("type", Byte.TYPE), new ObjectStreamField("stringValue", class$java$lang$String == null ? (class$java$lang$String = ExtendedDataElementImpl.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("longValue", Long.TYPE), new ObjectStreamField("doubleValue", Double.TYPE), new ObjectStreamField("booleanValue", Boolean.TYPE), new ObjectStreamField("stringArrayValue", array$Ljava$lang$String == null ? (array$Ljava$lang$String = ExtendedDataElementImpl.class$("[Ljava.lang.String;")) : array$Ljava$lang$String), new ObjectStreamField("byteArrayValue", array$B == null ? (array$B = ExtendedDataElementImpl.class$("[B")) : array$B), new ObjectStreamField("shortArrayValue", array$S == null ? (array$S = ExtendedDataElementImpl.class$("[S")) : array$S), new ObjectStreamField("intArrayValue", array$I == null ? (array$I = ExtendedDataElementImpl.class$("[I")) : array$I), new ObjectStreamField("longArrayValue", array$J == null ? (array$J = ExtendedDataElementImpl.class$("[J")) : array$J), new ObjectStreamField("floatArrayValue", array$F == null ? (array$F = ExtendedDataElementImpl.class$("[F")) : array$F), new ObjectStreamField("doubleArrayValue", array$D == null ? (array$D = ExtendedDataElementImpl.class$("[D")) : array$D), new ObjectStreamField("booleanArrayValue", array$Z == null ? (array$Z = ExtendedDataElementImpl.class$("[Z")) : array$Z), new ObjectStreamField("children", array$Lorg$eclipse$hyades$logging$events$IExtendedDataElement == null ? (array$Lorg$eclipse$hyades$logging$events$IExtendedDataElement = ExtendedDataElementImpl.class$("[Lorg.eclipse.hyades.logging.events.IExtendedDataElement;")) : array$Lorg$eclipse$hyades$logging$events$IExtendedDataElement)};
    private HashMap children = new HashMap();
    private String name = null;
    private String id = null;
    private byte type = (byte)-1;
    private String stringValue = null;
    private long longValue = 0L;
    private double doubleValue = 0.0;
    private boolean booleanValue = false;
    private String[] stringArrayValue = null;
    private byte[] byteArrayValue = null;
    private short[] shortArrayValue = null;
    private int[] intArrayValue = null;
    private long[] longArrayValue = null;
    private float[] floatArrayValue = null;
    private double[] doubleArrayValue = null;
    private boolean[] booleanArrayValue = null;
    private char[] hexValues = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class array$S;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class array$J;
    static /* synthetic */ Class array$F;
    static /* synthetic */ Class array$D;
    static /* synthetic */ Class array$Z;
    static /* synthetic */ Class array$Lorg$eclipse$hyades$logging$events$IExtendedDataElement;

    protected ExtendedDataElementImpl() {
    }

    public void addChildDataElement(IExtendedDataElement iExtendedDataElement) {
        this.children.put(iExtendedDataElement.getName(), iExtendedDataElement);
    }

    public Object[] getChildDataElements() {
        return this.children.values().toArray();
    }

    public void removeChildDataElement(String string) {
        this.children.remove(string);
    }

    public void clearChildDataElements() {
        this.children.clear();
    }

    public String[] getValues() {
        if (this.type == 28) {
            throw new InvalidExtendedDataElementTypeException("getValues was called with an invalid datatype value of  hexBinary");
        }
        String[] stringArray = null;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                stringArray = new String[]{Long.toString(this.longValue)};
                break;
            }
            case 7: {
                stringArray = new String[]{new Boolean(this.booleanValue).toString()};
                break;
            }
            case 4: 
            case 5: {
                stringArray = new String[]{Double.toString(this.doubleValue)};
                break;
            }
            case 6: {
                stringArray = new String[]{this.stringValue};
                break;
            }
            case 8: {
                stringArray = new String[]{this.getDateTime()};
                break;
            }
            case 9: 
            case 16: {
                int n = this.booleanArrayValue.length;
                stringArray = new String[n];
                int n2 = 0;
                while (n2 < n) {
                    stringArray[n2] = new Boolean(this.booleanArrayValue[n2]).toString();
                    ++n2;
                }
                break;
            }
            case 10: {
                int n = this.shortArrayValue.length;
                stringArray = new String[n];
                int n3 = 0;
                while (n3 < n) {
                    stringArray[n3] = Short.toString(this.shortArrayValue[n3]);
                    ++n3;
                }
                break;
            }
            case 11: {
                int n = this.intArrayValue.length;
                stringArray = new String[n];
                int n4 = 0;
                while (n4 < n) {
                    stringArray[n4] = Integer.toString(this.intArrayValue[n4]);
                    ++n4;
                }
                break;
            }
            case 12: {
                int n = this.longArrayValue.length;
                stringArray = new String[n];
                int n5 = 0;
                while (n5 < n) {
                    stringArray[n5] = Long.toString(this.longArrayValue[n5]);
                    ++n5;
                }
                break;
            }
            case 13: {
                int n = this.floatArrayValue.length;
                stringArray = new String[n];
                int n6 = 0;
                while (n6 < n) {
                    stringArray[n6] = Float.toString(this.floatArrayValue[n6]);
                    ++n6;
                }
                break;
            }
            case 14: {
                int n = this.doubleArrayValue.length;
                stringArray = new String[n];
                int n7 = 0;
                while (n7 < n) {
                    stringArray[n7] = Double.toString(this.doubleArrayValue[n7]);
                    ++n7;
                }
                break;
            }
            case 15: {
                stringArray = this.stringArrayValue;
                break;
            }
            case 17: {
                stringArray = this.getDateTimeArray();
            }
        }
        return stringArray;
    }

    public char[] getHexValues() {
        return this.getHexBinarys();
    }

    public byte[] getHexValue() {
        return this.getHexBinary();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public byte getTypeValue() {
        return this.type;
    }

    public String getType() {
        switch (this.type) {
            case 0: {
                return "byte";
            }
            case 1: {
                return "short";
            }
            case 2: {
                return "int";
            }
            case 3: {
                return "long";
            }
            case 7: {
                return "boolean";
            }
            case 4: {
                return "float";
            }
            case 5: {
                return "double";
            }
            case 6: {
                return "string";
            }
            case 8: {
                return "dateTime";
            }
            case 9: {
                return "byteArray";
            }
            case 10: {
                return "shortArray";
            }
            case 11: {
                return "intArray";
            }
            case 12: {
                return "longArray";
            }
            case 16: {
                return "booleanArray";
            }
            case 13: {
                return "floatArray";
            }
            case 14: {
                return "doubleArray";
            }
            case 15: {
                return "stringArray";
            }
            case 17: {
                return "dateTime";
            }
            case 28: {
                return "hexBinary";
            }
        }
        return null;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setType(byte by) {
        if (by < 0 || by > 28) {
            throw new InvalidExtendedDataElementTypeException("setType was called with an invalid datatype value of  " + this.getType());
        }
        this.type = by;
    }

    public void setType(String string) {
        if (string.equals("byte")) {
            this.type = 0;
        } else if (string.equals("boolean")) {
            this.type = (byte)7;
        } else if (string.equals("short")) {
            this.type = 1;
        } else if (string.equals("int")) {
            this.type = (byte)2;
        } else if (string.equals("long")) {
            this.type = (byte)3;
        } else if (string.equals("float")) {
            this.type = (byte)4;
        } else if (string.equals("double")) {
            this.type = (byte)5;
        } else if (string.equals("dateTime")) {
            this.type = (byte)8;
        } else if (string.equals("string")) {
            this.type = (byte)6;
        } else if (string.equals("byteArray")) {
            this.type = (byte)9;
        } else if (string.equals("booleanArray")) {
            this.type = (byte)16;
        } else if (string.equals("shortArray")) {
            this.type = (byte)10;
        } else if (string.equals("intArray")) {
            this.type = (byte)11;
        } else if (string.equals("longArray")) {
            this.type = (byte)12;
        } else if (string.equals("floatArray")) {
            this.type = (byte)13;
        } else if (string.equals("doubleArray")) {
            this.type = (byte)14;
        } else if (string.equals("dateTimeArray")) {
            this.type = (byte)17;
        } else if (string.equals("stringArray")) {
            this.type = (byte)15;
        } else if (string.equals("hexBinary")) {
            this.type = (byte)28;
        } else {
            throw new InvalidExtendedDataElementTypeException("setType was called with an invalid datatype value of  " + this.getType());
        }
    }

    public void setValues(String[] stringArray) {
        if (this.type == 28) {
            throw new InvalidExtendedDataElementTypeException("setValues was called for an event property of type hexBinary");
        }
        int n = stringArray.length;
        this.clearValues();
        switch (this.type) {
            case 0: {
                if (n > 1) {
                    throw new RuntimeException("Values contains more than one element for type" + this.getType());
                }
                this.longValue = Byte.parseByte(stringArray[0]);
                break;
            }
            case 1: {
                if (n > 1) {
                    throw new RuntimeException("Values contains more than one element for type" + this.getType());
                }
                this.longValue = Short.parseShort(stringArray[0]);
                break;
            }
            case 2: {
                if (n > 1) {
                    throw new RuntimeException("Values contains more than one element for type" + this.getType());
                }
                this.longValue = Integer.parseInt(stringArray[0]);
                break;
            }
            case 3: {
                if (n > 1) {
                    throw new RuntimeException("Values contains more than one element for type" + this.getType());
                }
                this.longValue = Long.parseLong(stringArray[0]);
                break;
            }
            case 7: {
                if (n > 1) {
                    throw new RuntimeException("Values contains more than one element for type" + this.getType());
                }
                this.booleanValue = new Boolean(stringArray[0]);
                break;
            }
            case 4: {
                if (n > 1) {
                    throw new RuntimeException("Values contains more than one element for type" + this.getType());
                }
                this.doubleValue = Double.parseDouble(stringArray[0]);
                break;
            }
            case 5: {
                if (n > 1) {
                    throw new RuntimeException("Values contains more than one element for type" + this.getType());
                }
                this.doubleValue = Double.parseDouble(stringArray[0]);
                break;
            }
            case 6: {
                if (n > 1) {
                    throw new RuntimeException("Values contains more than one element for type" + this.getType());
                }
                this.stringValue = stringArray[0];
                break;
            }
            case 8: {
                if (n > 1) {
                    throw new RuntimeException("Values contains more than one element for type" + this.getType());
                }
                this.stringValue = stringArray[0];
                break;
            }
            case 9: {
                this.byteArrayValue = new byte[n];
                int n2 = 0;
                while (n2 < n) {
                    this.byteArrayValue[n2] = Byte.parseByte(stringArray[n2]);
                    ++n2;
                }
                break;
            }
            case 10: {
                this.shortArrayValue = new short[n];
                int n3 = 0;
                while (n3 < n) {
                    this.shortArrayValue[n3] = Short.parseShort(stringArray[n3]);
                    ++n3;
                }
                break;
            }
            case 11: {
                this.intArrayValue = new int[n];
                int n4 = 0;
                while (n4 < n) {
                    this.intArrayValue[n4] = Integer.parseInt(stringArray[n4]);
                    ++n4;
                }
                break;
            }
            case 12: {
                this.longArrayValue = new long[n];
                int n5 = 0;
                while (n5 < n) {
                    this.longArrayValue[n5] = Long.parseLong(stringArray[n5]);
                    ++n5;
                }
                break;
            }
            case 16: {
                this.booleanArrayValue = new boolean[n];
                int n6 = 0;
                while (n6 < n) {
                    this.booleanArrayValue[n6] = Boolean.getBoolean(stringArray[n6]);
                    ++n6;
                }
                break;
            }
            case 13: {
                this.floatArrayValue = new float[n];
                int n7 = 0;
                while (n7 < n) {
                    this.floatArrayValue[n7] = Float.parseFloat(stringArray[n7]);
                    ++n7;
                }
                break;
            }
            case 14: {
                this.doubleArrayValue = new double[n];
                int n8 = 0;
                while (n8 < n) {
                    this.doubleArrayValue[n8] = Double.parseDouble(stringArray[n8]);
                    ++n8;
                }
                break;
            }
            case 15: {
                this.stringArrayValue = stringArray;
                break;
            }
            case 17: {
                this.stringArrayValue = new String[n];
                int n9 = 0;
                while (n9 < n) {
                    this.stringArrayValue[n9] = stringArray[n9];
                    ++n9;
                }
                break;
            }
            default: {
                throw new RuntimeException("Values not set for type :" + this.getType());
            }
        }
    }

    public void setHexValues(char[] cArray) {
        if (this.type != 28) {
            throw new InvalidExtendedDataElementTypeException("setHexValues was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.hexValues = cArray;
    }

    public void setHexValue(byte[] byArray) {
        if (this.type != 28) {
            throw new InvalidExtendedDataElementTypeException("setHexValue was called for an event property of type " + this.getType());
        }
        this.clearValues();
        if (byArray != null) {
            this.hexValues = new char[byArray.length];
            int n = 0;
            while (n < byArray.length) {
                this.hexValues[n] = (char)(byArray[n] + 128);
                ++n;
            }
        }
    }

    public String getString() {
        if (this.type != 6) {
            throw new InvalidExtendedDataElementTypeException("getString was called for an event property of type " + this.getType());
        }
        return this.stringValue;
    }

    public long getDateTimeAsLong() {
        if (this.type != 8) {
            throw new InvalidExtendedDataElementTypeException("getDateTimeAsLong was called for an event property of type " + this.getType());
        }
        if (this.longValue == 0L) {
            this.longValue = CbeFormatter.convertXmlSchemaDateTimeToDate(this.stringValue);
        }
        return this.longValue;
    }

    public String getDateTime() {
        if (this.type != 8) {
            throw new InvalidExtendedDataElementTypeException("getDateTime was called for an event property of type " + this.getType());
        }
        if (this.stringValue == null) {
            this.stringValue = CbeFormatter.convertDateToXmlSchemaDateTime(this.longValue);
        }
        return this.stringValue;
    }

    public boolean getBoolean() {
        if (this.type != 7) {
            throw new InvalidExtendedDataElementTypeException("getBoolean was called for an event property of type " + this.getType());
        }
        return this.booleanValue;
    }

    public byte getByte() {
        if (this.type != 0) {
            throw new InvalidExtendedDataElementTypeException("getByte was called for an event property of type " + this.getType());
        }
        return (byte)this.longValue;
    }

    public short getShort() {
        if (this.type != 1) {
            throw new InvalidExtendedDataElementTypeException("getShort was called for an event property of type " + this.getType());
        }
        return (short)this.longValue;
    }

    public int getInt() {
        if (this.type != 2) {
            throw new InvalidExtendedDataElementTypeException("getInt was called for an event property of type " + this.getType());
        }
        return (int)this.longValue;
    }

    public long getLong() {
        if (this.type != 3) {
            throw new InvalidExtendedDataElementTypeException("getLong was called for an event property of type " + this.getType());
        }
        return this.longValue;
    }

    public float getFloat() {
        if (this.type != 4) {
            throw new InvalidExtendedDataElementTypeException("getFloat was called for an event property of type " + this.getType());
        }
        return (float)this.doubleValue;
    }

    public double getDouble() {
        if (this.type != 5) {
            throw new InvalidExtendedDataElementTypeException("getDouble was called for an event property of type " + this.getType());
        }
        return this.doubleValue;
    }

    public String[] getStringArray() {
        if (this.type != 15) {
            throw new InvalidExtendedDataElementTypeException("getStringArray was called for an event property of type " + this.getType());
        }
        return this.stringArrayValue;
    }

    public long[] getDateTimeArrayAsLong() {
        if (this.type != 17) {
            throw new InvalidExtendedDataElementTypeException("getDateTimeArrayAsLong was called for an event property of type " + this.getType());
        }
        if (this.longArrayValue == null) {
            int n = 0;
            if (this.stringArrayValue != null) {
                n = this.stringArrayValue.length;
            }
            this.longArrayValue = new long[n];
            int n2 = 0;
            while (n2 < n) {
                this.longArrayValue[n2] = CbeFormatter.convertXmlSchemaDateTimeToDate(this.stringArrayValue[n2]);
                ++n2;
            }
        }
        return this.longArrayValue;
    }

    public String[] getDateTimeArray() {
        if (this.type != 17) {
            throw new InvalidExtendedDataElementTypeException("getDateTimeArray was called for an event property of type " + this.getType());
        }
        if (this.stringArrayValue == null) {
            int n = 0;
            if (this.longArrayValue != null) {
                n = this.longArrayValue.length;
            }
            this.stringArrayValue = new String[n];
            int n2 = 0;
            while (n2 < n) {
                this.stringArrayValue[n2] = CbeFormatter.convertDateToXmlSchemaDateTime(this.longArrayValue[n2]);
                ++n2;
            }
        }
        return this.stringArrayValue;
    }

    public boolean[] getBooleanArray() {
        if (this.type != 16) {
            throw new InvalidExtendedDataElementTypeException("getBooleanArray was called for an event property of type " + this.getType());
        }
        return this.booleanArrayValue;
    }

    public byte[] getByteArray() {
        if (this.type != 9) {
            throw new InvalidExtendedDataElementTypeException("getByteArray was called for an event property of type " + this.getType());
        }
        return this.byteArrayValue;
    }

    public short[] getShortArray() {
        if (this.type != 10) {
            throw new InvalidExtendedDataElementTypeException("getShortArray was called for an event property of type " + this.getType());
        }
        return this.shortArrayValue;
    }

    public int[] getIntArray() {
        if (this.type != 11) {
            throw new InvalidExtendedDataElementTypeException("getIntArray was called for an event property of type " + this.getType());
        }
        return this.intArrayValue;
    }

    public long[] getLongArray() {
        if (this.type != 12) {
            throw new InvalidExtendedDataElementTypeException("getLongArray was called for an event property of type " + this.getType());
        }
        return this.longArrayValue;
    }

    public float[] getFloatArray() {
        if (this.type != 13) {
            throw new InvalidExtendedDataElementTypeException("getFloatArray was called for an event property of type " + this.getType());
        }
        return this.floatArrayValue;
    }

    public double[] getDoubleArray() {
        if (this.type != 14) {
            throw new InvalidExtendedDataElementTypeException("getDoubleArray was called for an event property of type " + this.getType());
        }
        return this.doubleArrayValue;
    }

    public char[] getHexBinarys() {
        if (this.type != 28) {
            throw new InvalidExtendedDataElementTypeException("getHexBinarys was called for an event property of type " + this.getType());
        }
        return this.hexValues;
    }

    public byte[] getHexBinary() {
        if (this.type != 28) {
            throw new InvalidExtendedDataElementTypeException("getHexBinary was called for an event property of type " + this.getType());
        }
        byte[] byArray = null;
        if (this.hexValues != null) {
            byArray = new byte[this.hexValues.length];
            int n = 0;
            while (n < this.hexValues.length) {
                byArray[n] = this.hexValues[n] > '\u00ff' ? 127 : (byte)(this.hexValues[n] - 128);
                ++n;
            }
        }
        return byArray;
    }

    public void setString(String string) {
        if (this.type != 6) {
            throw new InvalidExtendedDataElementTypeException("setString was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.stringValue = string;
    }

    public void setDateTime(long l) {
        if (this.type != 8) {
            throw new InvalidExtendedDataElementTypeException("setDateTime was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.longValue = l;
    }

    public void setDateTime(String string) {
        if (this.type != 8) {
            throw new InvalidExtendedDataElementTypeException("setDateTime was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.stringValue = string;
    }

    public void setBoolean(boolean bl) {
        if (this.type != 7) {
            throw new InvalidExtendedDataElementTypeException("setBoolean was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.booleanValue = bl;
    }

    public void setByte(byte by) {
        if (this.type != 0) {
            throw new InvalidExtendedDataElementTypeException("setByte was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.longValue = by;
    }

    public void setShort(short s) {
        if (this.type != 1) {
            throw new InvalidExtendedDataElementTypeException("setShort was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.longValue = s;
    }

    public void setInt(int n) {
        if (this.type != 2) {
            throw new InvalidExtendedDataElementTypeException("setInt was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.longValue = n;
    }

    public void setLong(long l) {
        if (this.type != 3) {
            throw new InvalidExtendedDataElementTypeException("setLong was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.longValue = l;
    }

    public void setFloat(float f) {
        if (this.type != 4) {
            throw new InvalidExtendedDataElementTypeException("setFloat was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.doubleValue = f;
    }

    public void setDouble(double d) {
        if (this.type != 5) {
            throw new InvalidExtendedDataElementTypeException("setDouble was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.doubleValue = d;
    }

    public void setStringArray(String[] stringArray) {
        if (this.type != 15) {
            throw new InvalidExtendedDataElementTypeException("setStringArray was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.stringArrayValue = stringArray;
    }

    public void setDateTimeArray(long[] lArray) {
        if (this.type != 17) {
            throw new InvalidExtendedDataElementTypeException("setDateTimeArray was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.longArrayValue = lArray;
    }

    public void setDateTimeArray(String[] stringArray) {
        if (this.type != 17) {
            throw new InvalidExtendedDataElementTypeException("setDateTimeArray was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.stringArrayValue = stringArray;
    }

    public void setBooleanArray(boolean[] blArray) {
        if (this.type != 16) {
            throw new InvalidExtendedDataElementTypeException("setBooleanArray was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.booleanArrayValue = blArray;
    }

    public void setByteArray(byte[] byArray) {
        if (this.type != 9) {
            throw new InvalidExtendedDataElementTypeException("setByteArray was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.byteArrayValue = byArray;
    }

    public void setShortArray(short[] sArray) {
        if (this.type != 10) {
            throw new InvalidExtendedDataElementTypeException("setShortArray was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.shortArrayValue = sArray;
    }

    public void setIntArray(int[] nArray) {
        if (this.type != 11) {
            throw new InvalidExtendedDataElementTypeException("setIntArray was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.intArrayValue = nArray;
    }

    public void setLongArray(long[] lArray) {
        if (this.type != 12) {
            throw new InvalidExtendedDataElementTypeException("setLongArray was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.longArrayValue = lArray;
    }

    public void setFloatArray(float[] fArray) {
        if (this.type != 13) {
            throw new InvalidExtendedDataElementTypeException("setFloatArray was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.floatArrayValue = fArray;
    }

    public void setDoubleArray(double[] dArray) {
        if (this.type != 14) {
            throw new InvalidExtendedDataElementTypeException("setDoubleArray was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.doubleArrayValue = dArray;
    }

    public void setHexBinarys(char[] cArray) {
        if (this.type != 28) {
            throw new InvalidExtendedDataElementTypeException("setHexBinary was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.hexValues = cArray;
    }

    public void setHexBinary(byte[] byArray) {
        if (this.type != 28) {
            throw new InvalidExtendedDataElementTypeException("setHexBinary was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.hexValues = new char[byArray.length];
        int n = 0;
        while (n < byArray.length) {
            this.hexValues[n] = (char)(byArray[n] + 128);
            ++n;
        }
    }

    public void clearValues() {
        this.stringValue = null;
        this.longValue = 0L;
        this.doubleValue = 0.0;
        this.booleanValue = false;
        this.stringArrayValue = null;
        this.byteArrayValue = null;
        this.shortArrayValue = null;
        this.intArrayValue = null;
        this.longArrayValue = null;
        this.floatArrayValue = null;
        this.doubleArrayValue = null;
        this.booleanArrayValue = null;
        this.hexValues = null;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof ExtendedDataElementImpl) {
            ExtendedDataElementImpl extendedDataElementImpl = (ExtendedDataElementImpl)object;
            if ((this.getName() != null && this.getName().equals(extendedDataElementImpl.getName()) || this.getName() == null && extendedDataElementImpl.getName() == null) && this.getTypeValue() == extendedDataElementImpl.getTypeValue() && (this.children != null && this.children.equals(extendedDataElementImpl.children) || this.children == null && extendedDataElementImpl.children == null)) {
                try {
                    block1 : switch (this.getTypeValue()) {
                        case 0: {
                            if (this.getByte() == extendedDataElementImpl.getByte()) {
                                bl = true;
                            }
                            break;
                        }
                        case 1: {
                            if (this.getShort() == extendedDataElementImpl.getShort()) {
                                bl = true;
                            }
                            break;
                        }
                        case 2: {
                            if (this.getInt() == extendedDataElementImpl.getInt()) {
                                bl = true;
                            }
                            break;
                        }
                        case 3: {
                            if (this.getLong() == extendedDataElementImpl.getLong()) {
                                bl = true;
                            }
                            break;
                        }
                        case 7: {
                            if (this.getBoolean() == extendedDataElementImpl.getBoolean()) {
                                bl = true;
                            }
                            break;
                        }
                        case 4: {
                            if (this.getFloat() == extendedDataElementImpl.getFloat()) {
                                bl = true;
                            }
                            break;
                        }
                        case 5: {
                            if (this.getDouble() == extendedDataElementImpl.getDouble()) {
                                bl = true;
                            }
                            break;
                        }
                        case 6: {
                            if (this.getString().equals(extendedDataElementImpl.getString())) {
                                bl = true;
                            }
                            break;
                        }
                        case 8: {
                            if (this.getDateTimeAsLong() == extendedDataElementImpl.getDateTimeAsLong()) {
                                bl = true;
                            }
                            break;
                        }
                        case 9: {
                            if (this.getByteArray() != null && extendedDataElementImpl.getByteArray() != null) {
                                if (this.getByteArray().length == extendedDataElementImpl.getByteArray().length) {
                                    int n = this.getByteArray().length;
                                    bl = true;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        if (this.getByteArray()[n2] != extendedDataElementImpl.getByteArray()[n2]) {
                                            bl = false;
                                            break block1;
                                        }
                                        ++n2;
                                    }
                                }
                            } else if (this.getByteArray() == null && extendedDataElementImpl.getByteArray() == null) {
                                bl = true;
                            }
                            break;
                        }
                        case 28: {
                            if (this.getHexValues() != null && extendedDataElementImpl.getHexValues() != null) {
                                if (this.getHexValues().length == extendedDataElementImpl.getHexValues().length) {
                                    int n = this.getHexValues().length;
                                    bl = true;
                                    int n3 = 0;
                                    while (n3 < n) {
                                        if (this.getHexValues()[n3] != extendedDataElementImpl.getHexValues()[n3]) {
                                            bl = false;
                                            break block1;
                                        }
                                        ++n3;
                                    }
                                }
                            } else if (this.getHexValues() == null && extendedDataElementImpl.getHexValues() == null) {
                                bl = true;
                            }
                            break;
                        }
                        case 16: {
                            if (this.getBooleanArray() != null && extendedDataElementImpl.getBooleanArray() != null) {
                                if (this.getBooleanArray().length == extendedDataElementImpl.getBooleanArray().length) {
                                    int n = this.getBooleanArray().length;
                                    bl = true;
                                    int n4 = 0;
                                    while (n4 < n) {
                                        if (this.getBooleanArray()[n4] != extendedDataElementImpl.getBooleanArray()[n4]) {
                                            bl = false;
                                            break block1;
                                        }
                                        ++n4;
                                    }
                                }
                            } else if (this.getBooleanArray() == null && extendedDataElementImpl.getBooleanArray() == null) {
                                bl = true;
                            }
                            break;
                        }
                        case 10: {
                            if (this.getShortArray() != null && extendedDataElementImpl.getShortArray() != null) {
                                if (this.getShortArray().length == extendedDataElementImpl.getShortArray().length) {
                                    int n = this.getShortArray().length;
                                    bl = true;
                                    int n5 = 0;
                                    while (n5 < n) {
                                        if (this.getShortArray()[n5] != extendedDataElementImpl.getShortArray()[n5]) {
                                            bl = false;
                                            break block1;
                                        }
                                        ++n5;
                                    }
                                }
                            } else if (this.getShortArray() == null && extendedDataElementImpl.getShortArray() == null) {
                                bl = true;
                            }
                            break;
                        }
                        case 11: {
                            if (this.getIntArray() != null && extendedDataElementImpl.getIntArray() != null) {
                                if (this.getIntArray().length == extendedDataElementImpl.getIntArray().length) {
                                    int n = this.getIntArray().length;
                                    bl = true;
                                    int n6 = 0;
                                    while (n6 < n) {
                                        if (this.getIntArray()[n6] != extendedDataElementImpl.getIntArray()[n6]) {
                                            bl = false;
                                            break block1;
                                        }
                                        ++n6;
                                    }
                                }
                            } else if (this.getIntArray() == null && extendedDataElementImpl.getIntArray() == null) {
                                bl = true;
                            }
                            break;
                        }
                        case 12: {
                            if (this.getLongArray() != null && extendedDataElementImpl.getLongArray() != null) {
                                if (this.getLongArray().length == extendedDataElementImpl.getLongArray().length) {
                                    int n = this.getLongArray().length;
                                    bl = true;
                                    int n7 = 0;
                                    while (n7 < n) {
                                        if (this.getLongArray()[n7] != extendedDataElementImpl.getLongArray()[n7]) {
                                            bl = false;
                                            break block1;
                                        }
                                        ++n7;
                                    }
                                }
                            } else if (this.getLongArray() == null && extendedDataElementImpl.getLongArray() == null) {
                                bl = true;
                            }
                            break;
                        }
                        case 13: {
                            if (this.getFloatArray() != null && extendedDataElementImpl.getFloatArray() != null) {
                                if (this.getFloatArray().length == extendedDataElementImpl.getFloatArray().length) {
                                    int n = this.getFloatArray().length;
                                    bl = true;
                                    int n8 = 0;
                                    while (n8 < n) {
                                        if (this.getFloatArray()[n8] != extendedDataElementImpl.getFloatArray()[n8]) {
                                            bl = false;
                                            break block1;
                                        }
                                        ++n8;
                                    }
                                }
                            } else if (this.getFloatArray() == null && extendedDataElementImpl.getFloatArray() == null) {
                                bl = true;
                            }
                            break;
                        }
                        case 14: {
                            if (this.getDoubleArray() != null && extendedDataElementImpl.getDoubleArray() != null) {
                                if (this.getDoubleArray().length == extendedDataElementImpl.getDoubleArray().length) {
                                    int n = this.getDoubleArray().length;
                                    bl = true;
                                    int n9 = 0;
                                    while (n9 < n) {
                                        if (this.getDoubleArray()[n9] != extendedDataElementImpl.getDoubleArray()[n9]) {
                                            bl = false;
                                            break block1;
                                        }
                                        ++n9;
                                    }
                                }
                            } else if (this.getDoubleArray() == null && extendedDataElementImpl.getDoubleArray() == null) {
                                bl = true;
                            }
                            break;
                        }
                        case 15: {
                            if (this.getStringArray() != null && extendedDataElementImpl.getStringArray() != null) {
                                if (this.getStringArray().length == extendedDataElementImpl.getStringArray().length) {
                                    int n = this.getStringArray().length;
                                    bl = true;
                                    int n10 = 0;
                                    while (n10 < n) {
                                        String string = this.getStringArray()[n10];
                                        if (string == null && extendedDataElementImpl.getStringArray()[n10] != null) {
                                            bl = false;
                                            break block1;
                                        }
                                        if (!string.equals(extendedDataElementImpl.getStringArray()[n10])) {
                                            bl = false;
                                            break block1;
                                        }
                                        ++n10;
                                    }
                                }
                            } else if (this.getStringArray() == null && extendedDataElementImpl.getStringArray() == null) {
                                bl = true;
                            }
                            break;
                        }
                        case 17: {
                            if (this.getDateTimeArrayAsLong() != null && extendedDataElementImpl.getDateTimeArrayAsLong() != null) {
                                if (this.getDateTimeArrayAsLong().length == extendedDataElementImpl.getDateTimeArrayAsLong().length) {
                                    int n = this.getDateTimeArrayAsLong().length;
                                    bl = true;
                                    int n11 = 0;
                                    while (n11 < n) {
                                        if (this.getDateTimeArrayAsLong()[n11] != extendedDataElementImpl.getDateTimeArrayAsLong()[n11]) {
                                            bl = false;
                                            break block1;
                                        }
                                        ++n11;
                                    }
                                }
                            } else if (this.getDateTimeArrayAsLong() == null && extendedDataElementImpl.getDateTimeArrayAsLong() == null) {
                                bl = true;
                            }
                            break;
                        }
                        default: {
                            bl = true;
                        }
                    }
                }
                catch (InvalidExtendedDataElementTypeException invalidExtendedDataElementTypeException) {
                    bl = false;
                }
            }
        }
        return bl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("name", this.name);
        putField.put("type", this.type);
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                putField.put("longValue", this.longValue);
                break;
            }
            case 7: {
                putField.put("booleanValue", this.booleanValue);
                break;
            }
            case 4: 
            case 5: {
                putField.put("doubleValue", this.doubleValue);
                break;
            }
            case 6: {
                putField.put("stringValue", this.stringValue);
                break;
            }
            case 8: {
                putField.put("stringValue", this.getDateTime());
                break;
            }
            case 9: 
            case 28: {
                putField.put("byteArrayValue", this.byteArrayValue);
                break;
            }
            case 10: {
                putField.put("shortArrayValue", this.shortArrayValue);
                break;
            }
            case 11: {
                putField.put("intArrayValue", this.intArrayValue);
                break;
            }
            case 12: {
                putField.put("longArrayValue", this.longArrayValue);
                break;
            }
            case 16: {
                putField.put("booleanArrayValue", this.booleanArrayValue);
                break;
            }
            case 13: {
                putField.put("floatArrayValue", this.floatArrayValue);
                break;
            }
            case 14: {
                putField.put("doubleArrayValue", this.doubleArrayValue);
                break;
            }
            case 15: {
                putField.put("stringArrayValue", this.stringArrayValue);
                break;
            }
            case 17: {
                putField.put("stringArrayValue", this.getDateTimeArray());
            }
        }
        if (!this.children.isEmpty()) {
            putField.put("children", (IExtendedDataElement[])this.children.values().toArray());
        }
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.children = new HashMap();
        ObjectInputStream.GetField getField = null;
        getField = objectInputStream.readFields();
        this.name = (String)getField.get("name", this.name);
        this.type = getField.get("type", this.type);
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.longValue = getField.get("longValue", this.longValue);
                break;
            }
            case 7: {
                this.booleanValue = getField.get("booleanValue", this.booleanValue);
                break;
            }
            case 4: 
            case 5: {
                this.doubleValue = getField.get("doubleValue", this.doubleValue);
                break;
            }
            case 6: {
                this.stringValue = (String)getField.get("stringValue", this.stringValue);
                break;
            }
            case 8: {
                this.stringValue = (String)getField.get("stringValue", this.getDateTime());
                break;
            }
            case 9: 
            case 28: {
                this.byteArrayValue = (byte[])getField.get("byteArrayValue", this.byteArrayValue);
                break;
            }
            case 10: {
                this.shortArrayValue = (short[])getField.get("shortArrayValue", this.shortArrayValue);
                break;
            }
            case 11: {
                this.intArrayValue = (int[])getField.get("intArrayValue", this.intArrayValue);
                break;
            }
            case 12: {
                this.longArrayValue = (long[])getField.get("longArrayValue", this.longArrayValue);
                break;
            }
            case 16: {
                this.booleanArrayValue = (boolean[])getField.get("booleanArrayValue", this.booleanArrayValue);
                break;
            }
            case 13: {
                this.floatArrayValue = (float[])getField.get("floatArrayValue", this.floatArrayValue);
                break;
            }
            case 14: {
                this.doubleArrayValue = (double[])getField.get("doubleArrayValue", this.doubleArrayValue);
                break;
            }
            case 15: {
                this.stringArrayValue = (String[])getField.get("stringArrayValue", this.stringArrayValue);
                break;
            }
            case 17: {
                this.stringArrayValue = (String[])getField.get("stringArrayValue", this.getDateTimeArray());
            }
        }
        Object[] objectArray = null;
        objectArray = (Object[])getField.get("children", null);
        if (objectArray != null) {
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                this.addChildDataElement((IExtendedDataElement)objectArray[n2]);
                ++n2;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

