/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.remote;

import org.eclipse.hyades.execution.core.ExecutionComponentStateException;
import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.IExecutor;
import org.eclipse.hyades.execution.invocation.RemoteInvocationException;
import org.eclipse.hyades.execution.remote.ExecutorSkeleton;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.remote.CustomCommandHandler;
import org.eclipse.hyades.internal.execution.remote.RemoteComponentSkeleton;

public class JavaTaskExecutorSkeleton
extends ExecutorSkeleton {
    private RemoteComponentSkeleton agent;
    private boolean isOKToStart;

    public JavaTaskExecutorSkeleton() {
    }

    public JavaTaskExecutorSkeleton(IExecutionComponent iExecutionComponent, Integer n) {
        super(iExecutionComponent, n);
    }

    public void setExecutableObject(IExecutableObject iExecutableObject) throws ExecutionComponentStateException {
        ((IExecutor)this.delegate).setExecutableObject(iExecutableObject);
    }

    public RemoteComponentSkeleton getAgent() {
        return this.agent;
    }

    public void init() {
        super.init();
        this.agent = new RemoteComponentSkeleton("Executor$" + this.getUniqueId(), "tester");
        this.agent.addCommandListener(new CustomCommandHandler(){

            public void handleCommand(CustomCommand customCommand) {
                if (customCommand.getData().equals("START")) {
                    JavaTaskExecutorSkeleton.this.setOKToStart(true);
                }
            }
        });
        try {
            this.agent.initialize();
        }
        catch (Throwable throwable) {
            throw new RemoteInvocationException(throwable);
        }
    }

    public synchronized boolean isOKToStart() {
        return this.isOKToStart;
    }

    private synchronized void setOKToStart(boolean bl) {
        this.isOKToStart = bl;
        this.notifyAll();
    }

    public void waitForOKToStart() {
        while (!this.isOKToStart()) {
            JavaTaskExecutorSkeleton javaTaskExecutorSkeleton = this;
            synchronized (javaTaskExecutorSkeleton) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.isOKToStart()) break;
        }
    }
}

