/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import org.eclipse.hyades.logging.core.XmlUtility;
import org.eclipse.hyades.logging.events.AssociationEngineImpl;
import org.eclipse.hyades.logging.events.IAssociatedEvent;
import org.eclipse.hyades.logging.events.IAssociationEngine;
import org.eclipse.hyades.logging.events.IAvailableSituation;
import org.eclipse.hyades.logging.events.ICommonBaseEvent;
import org.eclipse.hyades.logging.events.ICommonBaseEventAnyElement;
import org.eclipse.hyades.logging.events.IComponentIdentification;
import org.eclipse.hyades.logging.events.IConfigureSituation;
import org.eclipse.hyades.logging.events.IConnectSituation;
import org.eclipse.hyades.logging.events.IContextDataElement;
import org.eclipse.hyades.logging.events.ICreateSituation;
import org.eclipse.hyades.logging.events.IDependencySituation;
import org.eclipse.hyades.logging.events.IDestroySituation;
import org.eclipse.hyades.logging.events.IExtendedDataElement;
import org.eclipse.hyades.logging.events.IFeatureSituation;
import org.eclipse.hyades.logging.events.IMsgCatalogToken;
import org.eclipse.hyades.logging.events.IMsgDataElement;
import org.eclipse.hyades.logging.events.IOtherSituation;
import org.eclipse.hyades.logging.events.IReportSituation;
import org.eclipse.hyades.logging.events.IRequestSituation;
import org.eclipse.hyades.logging.events.ISimpleEventFactory;
import org.eclipse.hyades.logging.events.ISituation;
import org.eclipse.hyades.logging.events.ISituationType;
import org.eclipse.hyades.logging.events.IStartSituation;
import org.eclipse.hyades.logging.events.IStopSituation;
import org.eclipse.hyades.logging.events.SimpleEventFactoryImpl;
import org.eclipse.hyades.logging.events.exceptions.InvalidXMLAnyElementException;

public final class CbeFormatter {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static ISimpleEventFactory factory = SimpleEventFactoryImpl.getInstance();
    public static final String xml_version = "1.0.1";

    public static synchronized String toCanonicalXMLString(IAssociationEngine iAssociationEngine) {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("<AssociationEngine");
        String string = iAssociationEngine.getId();
        if (string != null && string.length() > 0) {
            stringBuffer.append(" id=\"");
            stringBuffer.append(XmlUtility.normalize((String)string));
            stringBuffer.append("\"");
        }
        if ((string = iAssociationEngine.getName()) != null && string.length() > 0) {
            stringBuffer.append(" name=\"");
            stringBuffer.append(XmlUtility.normalize((String)string));
            stringBuffer.append("\"");
        }
        if ((string = iAssociationEngine.getType()) != null && string.length() > 0) {
            stringBuffer.append(" type=\"");
            stringBuffer.append(XmlUtility.normalize((String)string));
            stringBuffer.append("\"");
        }
        stringBuffer.append("/>");
        return stringBuffer.toString();
    }

    public static synchronized void fromCanonicalXMLString(IAssociationEngine iAssociationEngine, String string) {
        int n = string.indexOf(" id=\"");
        if (n != -1) {
            iAssociationEngine.setId(XmlUtility.denormalize((String)string.substring(n + 5, string.indexOf("\"", n + 5))));
        }
        if ((n = string.indexOf(" name=\"")) != -1) {
            iAssociationEngine.setName(XmlUtility.denormalize((String)string.substring(n + 7, string.indexOf("\"", n + 7))));
        }
        if ((n = string.indexOf(" type=\"")) != -1) {
            iAssociationEngine.setType(XmlUtility.denormalize((String)string.substring(n + 7, string.indexOf("\"", n + 7))));
        }
    }

    public static synchronized void fromCanonicalXMLDocString(IAssociationEngine iAssociationEngine, String string) {
        CbeFormatter.fromCanonicalXMLString(iAssociationEngine, string);
    }

    public static synchronized String toCanonicalXMLDocString(AssociationEngineImpl associationEngineImpl) {
        return CbeFormatter.toCanonicalXMLDocString(associationEngineImpl, false);
    }

    public static synchronized String toCanonicalXMLDocString(AssociationEngineImpl associationEngineImpl, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("<CommonBaseEvents xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"commonbaseevent1_0.xsd\">");
        if (bl) {
            stringBuffer.append(LINE_SEPARATOR);
            stringBuffer.append("\t");
        }
        stringBuffer.append(CbeFormatter.toCanonicalXMLString(associationEngineImpl));
        if (bl) {
            stringBuffer.append(LINE_SEPARATOR);
        }
        stringBuffer.append("</CommonBaseEvents>");
        return stringBuffer.toString();
    }

    public static synchronized String toCanonicalXMLString(ICommonBaseEvent iCommonBaseEvent) {
        return CbeFormatter.toCanonicalXMLString(iCommonBaseEvent, false);
    }

    public static synchronized String toCanonicalXMLString(ICommonBaseEvent iCommonBaseEvent, boolean bl) {
        String string = iCommonBaseEvent.getVersion();
        if (string != null && string.trim().equals("1.0")) {
            return CbeFormatter.toCanonicalVersion_1_0_XMLString(iCommonBaseEvent, bl);
        }
        return CbeFormatter.toCanonicalVersion_1_0_1_XMLString(iCommonBaseEvent, bl);
    }

    private static synchronized String toCanonicalVersion_1_0_XMLString(ICommonBaseEvent iCommonBaseEvent, boolean bl) {
        int n;
        List list;
        IComponentIdentification iComponentIdentification;
        Object object;
        List list2;
        List list3;
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("<CommonBaseEvent");
        String string = iCommonBaseEvent.getCreationTime();
        if (string != null && string.length() > 0) {
            stringBuffer.append(" creationTime=\"");
            stringBuffer.append(XmlUtility.normalize((String)string));
            stringBuffer.append("\"");
        }
        if ((string = iCommonBaseEvent.getExtensionName()) != null && string.length() > 0) {
            stringBuffer.append(" extensionName=\"");
            stringBuffer.append(XmlUtility.normalize((String)string));
            stringBuffer.append("\"");
        }
        if ((string = iCommonBaseEvent.getGlobalInstanceId()) != null && string.length() > 0) {
            stringBuffer.append(" globalInstanceId=\"");
            stringBuffer.append(XmlUtility.normalize((String)string));
            stringBuffer.append("\"");
        }
        if ((string = iCommonBaseEvent.getLocalInstanceId()) != null && string.length() > 0) {
            stringBuffer.append(" localInstanceId=\"");
            stringBuffer.append(XmlUtility.normalize((String)string));
            stringBuffer.append("\"");
        }
        if ((string = iCommonBaseEvent.getMsg()) != null && string.length() > 0) {
            stringBuffer.append(" msg=\"");
            stringBuffer.append(XmlUtility.normalize((String)string));
            stringBuffer.append("\"");
        }
        if ((string = iCommonBaseEvent.getSituationType()) != null && string.length() > 0) {
            stringBuffer.append(" situationType=\"");
            stringBuffer.append(XmlUtility.normalize((String)string));
            stringBuffer.append("\"");
        }
        if (iCommonBaseEvent.getElapsedTime() != 0L) {
            stringBuffer.append(" elapsedTime=\"");
            stringBuffer.append(iCommonBaseEvent.getElapsedTime());
            stringBuffer.append("\"");
        }
        if (iCommonBaseEvent.getPriority() != 0) {
            stringBuffer.append(" priority=\"");
            stringBuffer.append(iCommonBaseEvent.getPriority());
            stringBuffer.append("\"");
        }
        if (iCommonBaseEvent.getRepeatCount() != 0) {
            stringBuffer.append(" repeatCount=\"");
            stringBuffer.append(iCommonBaseEvent.getRepeatCount());
            stringBuffer.append("\"");
        }
        if (iCommonBaseEvent.getSequenceNumber() != 0L) {
            stringBuffer.append(" sequenceNumber=\"");
            stringBuffer.append(iCommonBaseEvent.getSequenceNumber());
            stringBuffer.append("\"");
        }
        if (iCommonBaseEvent.getSeverity() != 0) {
            stringBuffer.append(" severity=\"");
            stringBuffer.append(iCommonBaseEvent.getSeverity());
            stringBuffer.append("\"");
        }
        if ((string = iCommonBaseEvent.getVersion()) != null && string.length() > 0) {
            stringBuffer.append(" version=\"");
            stringBuffer.append(XmlUtility.normalize((String)string));
            stringBuffer.append("\"");
        }
        stringBuffer.append(">");
        List list4 = iCommonBaseEvent.getContextDataElements();
        if (list4 != null) {
            int n2 = 0;
            while (n2 < list4.size()) {
                if (list4.get(n2) != null) {
                    if (bl) {
                        stringBuffer.append(LINE_SEPARATOR);
                        stringBuffer.append("\t");
                    }
                    stringBuffer.append("<contextDataElements");
                    string = ((IContextDataElement)list4.get(n2)).getName();
                    if (string != null && string.length() > 0) {
                        stringBuffer.append(" name=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((IContextDataElement)list4.get(n2)).getType()) != null && string.length() > 0) {
                        stringBuffer.append(" type=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append(">");
                    string = ((IContextDataElement)list4.get(n2)).getContextId();
                    if (string != null && string.length() > 0) {
                        if (bl) {
                            stringBuffer.append(LINE_SEPARATOR);
                            stringBuffer.append("\t\t");
                        }
                        stringBuffer.append("<contextId>");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("</contextId>");
                    } else {
                        string = ((IContextDataElement)list4.get(n2)).getContextValue();
                        if (string != null && string.length() > 0) {
                            if (bl) {
                                stringBuffer.append(LINE_SEPARATOR);
                                stringBuffer.append("\t\t");
                            }
                            stringBuffer.append("<contextValue>");
                            stringBuffer.append(XmlUtility.normalize((String)string));
                            stringBuffer.append("</contextValue>");
                        }
                    }
                    if (bl) {
                        stringBuffer.append(LINE_SEPARATOR);
                        stringBuffer.append("\t");
                    }
                    stringBuffer.append("</contextDataElements>");
                }
                ++n2;
            }
        }
        if ((list3 = iCommonBaseEvent.getExtendedDataElements()) != null) {
            int n3 = 0;
            while (n3 < list3.size()) {
                stringBuffer.append(CbeFormatter.getIExtendedDataElementXML((IExtendedDataElement)list3.get(n3), "extendedDataElements", bl, bl ? 1 : 0));
                ++n3;
            }
        }
        if ((list2 = iCommonBaseEvent.getAssociatedEvents()) != null) {
            int n4 = 0;
            while (n4 < list2.size()) {
                if (list2.get(n4) != null) {
                    if (bl) {
                        stringBuffer.append(LINE_SEPARATOR);
                        stringBuffer.append("\t");
                    }
                    stringBuffer.append("<associatedEvents");
                    if (((IAssociatedEvent)list2.get(n4)).getAssociationEngine() != null && (string = ((IAssociatedEvent)list2.get(n4)).getAssociationEngine()) != null && string.length() > 0) {
                        stringBuffer.append(" associationEngine=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((object = ((IAssociatedEvent)list2.get(n4)).getResolvedEvents()) != null && ((String)object).length() > 0) {
                        stringBuffer.append(" resolvedEvents=\"");
                        stringBuffer.append((String)object);
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                }
                ++n4;
            }
        }
        if ((iComponentIdentification = iCommonBaseEvent.getReporterComponentId()) != null) {
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                stringBuffer.append("\t");
            }
            stringBuffer.append("<reporterComponentId");
            string = iComponentIdentification.getApplication();
            if (string != null && string.length() > 0) {
                stringBuffer.append(" application=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getComponent()) != null && string.length() > 0) {
                stringBuffer.append(" component=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getComponentIdType()) != null && string.length() > 0) {
                stringBuffer.append(" componentIdType=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getExecutionEnvironment()) != null && string.length() > 0) {
                stringBuffer.append(" executionEnvironment=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getInstanceId()) != null && string.length() > 0) {
                stringBuffer.append(" instanceId=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getLocation()) != null && string.length() > 0) {
                stringBuffer.append(" location=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getLocationType()) != null && string.length() > 0) {
                stringBuffer.append(" locationType=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getProcessId()) != null && string.length() > 0) {
                stringBuffer.append(" processId=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getSubComponent()) != null && string.length() > 0) {
                stringBuffer.append(" subComponent=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getThreadId()) != null && string.length() > 0) {
                stringBuffer.append(" threadId=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            stringBuffer.append("/>");
        }
        if ((iComponentIdentification = iCommonBaseEvent.getSourceComponentId()) != null) {
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                stringBuffer.append("\t");
            }
            stringBuffer.append("<sourceComponentId");
            string = iComponentIdentification.getApplication();
            if (string != null && string.length() > 0) {
                stringBuffer.append(" application=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getComponent()) != null && string.length() > 0) {
                stringBuffer.append(" component=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getComponentIdType()) != null && string.length() > 0) {
                stringBuffer.append(" componentIdType=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getExecutionEnvironment()) != null && string.length() > 0) {
                stringBuffer.append(" executionEnvironment=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getInstanceId()) != null && string.length() > 0) {
                stringBuffer.append(" instanceId=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getLocation()) != null && string.length() > 0) {
                stringBuffer.append(" location=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getLocationType()) != null && string.length() > 0) {
                stringBuffer.append(" locationType=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getProcessId()) != null && string.length() > 0) {
                stringBuffer.append(" processId=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getSubComponent()) != null && string.length() > 0) {
                stringBuffer.append(" subComponent=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getThreadId()) != null && string.length() > 0) {
                stringBuffer.append(" threadId=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            stringBuffer.append("/>");
        }
        if ((object = iCommonBaseEvent.getMsgDataElement()) != null) {
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                stringBuffer.append("\t");
            }
            stringBuffer.append("<msgDataElement");
            string = object.getMsgLocale();
            if (string != null && string.length() > 0) {
                stringBuffer.append(" msgLocale=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            stringBuffer.append(">");
            list = object.getMsgCatalogTokens();
            if (list != null) {
                n = 0;
                while (n < list.size()) {
                    if (list.get(n) != null && ((IMsgCatalogToken)list.get(n)).getValue().length() > 0) {
                        if (bl) {
                            stringBuffer.append(LINE_SEPARATOR);
                            stringBuffer.append("\t\t");
                        }
                        stringBuffer.append("<msgCatalogTokens value=\"");
                        stringBuffer.append(XmlUtility.normalize((String)((IMsgCatalogToken)list.get(n)).getValue()));
                        stringBuffer.append("\"/>");
                    }
                    ++n;
                }
            }
            if ((string = object.getMsgId()) != null && string.length() > 0) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                stringBuffer.append("<msgId>");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("</msgId>");
            }
            if ((string = object.getMsgIdType()) != null && string.length() > 0) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                stringBuffer.append("<msgIdType>");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("</msgIdType>");
            }
            if ((string = object.getMsgCatalogId()) != null && string.length() > 0) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                stringBuffer.append("<msgCatalogId>");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("</msgCatalogId>");
            }
            if ((string = object.getMsgCatalogType()) != null && string.length() > 0) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                stringBuffer.append("<msgCatalogType>");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("</msgCatalogType>");
            }
            if ((string = object.getMsgCatalog()) != null && string.length() > 0) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                stringBuffer.append("<msgCatalog>");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("</msgCatalog>");
            }
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                stringBuffer.append("\t");
            }
            stringBuffer.append("</msgDataElement>");
        }
        if ((list = iCommonBaseEvent.getAnyElements()) != null) {
            n = 0;
            while (n < list.size()) {
                if (list.get(n) != null) {
                    if (bl) {
                        stringBuffer.append(LINE_SEPARATOR);
                        stringBuffer.append("\t");
                    }
                    stringBuffer.append(((ICommonBaseEventAnyElement)list.get(n)).getXmlAnyElement());
                }
                ++n;
            }
        }
        if (bl) {
            stringBuffer.append(LINE_SEPARATOR);
        }
        stringBuffer.append("</CommonBaseEvent>");
        return stringBuffer.toString();
    }

    private static synchronized String toCanonicalVersion_1_0_1_XMLString(ICommonBaseEvent iCommonBaseEvent, boolean bl) {
        int n;
        String[] stringArray;
        IComponentIdentification iComponentIdentification;
        Object object;
        Object object2;
        Object object3;
        List list;
        List list2;
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("<CommonBaseEvent");
        String string = iCommonBaseEvent.getCreationTime();
        if (string != null && string.length() > 0) {
            stringBuffer.append(" creationTime=\"");
            stringBuffer.append(XmlUtility.normalize((String)string));
            stringBuffer.append("\"");
        }
        if ((string = iCommonBaseEvent.getExtensionName()) != null && string.length() > 0) {
            stringBuffer.append(" extensionName=\"");
            stringBuffer.append(XmlUtility.normalize((String)string));
            stringBuffer.append("\"");
        }
        if ((string = iCommonBaseEvent.getGlobalInstanceId()) != null && string.length() > 0) {
            stringBuffer.append(" globalInstanceId=\"");
            stringBuffer.append(XmlUtility.normalize((String)string));
            stringBuffer.append("\"");
        }
        if ((string = iCommonBaseEvent.getLocalInstanceId()) != null && string.length() > 0) {
            stringBuffer.append(" localInstanceId=\"");
            stringBuffer.append(XmlUtility.normalize((String)string));
            stringBuffer.append("\"");
        }
        if ((string = iCommonBaseEvent.getMsg()) != null && string.length() > 0) {
            stringBuffer.append(" msg=\"");
            stringBuffer.append(XmlUtility.normalize((String)string));
            stringBuffer.append("\"");
        }
        if (iCommonBaseEvent.getElapsedTime() != 0L) {
            stringBuffer.append(" elapsedTime=\"");
            stringBuffer.append(iCommonBaseEvent.getElapsedTime());
            stringBuffer.append("\"");
        }
        if (iCommonBaseEvent.getPriority() != 0) {
            stringBuffer.append(" priority=\"");
            stringBuffer.append(iCommonBaseEvent.getPriority());
            stringBuffer.append("\"");
        }
        if (iCommonBaseEvent.getRepeatCount() != 0) {
            stringBuffer.append(" repeatCount=\"");
            stringBuffer.append(iCommonBaseEvent.getRepeatCount());
            stringBuffer.append("\"");
        }
        if (iCommonBaseEvent.getSequenceNumber() != 0L) {
            stringBuffer.append(" sequenceNumber=\"");
            stringBuffer.append(iCommonBaseEvent.getSequenceNumber());
            stringBuffer.append("\"");
        }
        if (iCommonBaseEvent.getSeverity() != 0) {
            stringBuffer.append(" severity=\"");
            stringBuffer.append(iCommonBaseEvent.getSeverity());
            stringBuffer.append("\"");
        }
        if ((string = iCommonBaseEvent.getVersion()) != null && string.length() > 0) {
            stringBuffer.append(" version=\"");
            stringBuffer.append(XmlUtility.normalize((String)string));
            stringBuffer.append("\"");
        }
        stringBuffer.append(">");
        List list3 = iCommonBaseEvent.getContextDataElements();
        if (list3 != null) {
            int n2 = 0;
            while (n2 < list3.size()) {
                if (list3.get(n2) != null) {
                    if (bl) {
                        stringBuffer.append(LINE_SEPARATOR);
                        stringBuffer.append("\t");
                    }
                    stringBuffer.append("<contextDataElements");
                    string = ((IContextDataElement)list3.get(n2)).getName();
                    if (string != null && string.length() > 0) {
                        stringBuffer.append(" name=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((IContextDataElement)list3.get(n2)).getType()) != null && string.length() > 0) {
                        stringBuffer.append(" type=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append(">");
                    string = ((IContextDataElement)list3.get(n2)).getContextId();
                    if (string != null && string.length() > 0) {
                        if (bl) {
                            stringBuffer.append(LINE_SEPARATOR);
                            stringBuffer.append("\t\t");
                        }
                        stringBuffer.append("<contextId>");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("</contextId>");
                    } else {
                        string = ((IContextDataElement)list3.get(n2)).getContextValue();
                        if (string != null && string.length() > 0) {
                            if (bl) {
                                stringBuffer.append(LINE_SEPARATOR);
                                stringBuffer.append("\t\t");
                            }
                            stringBuffer.append("<contextValue>");
                            stringBuffer.append(XmlUtility.normalize((String)string));
                            stringBuffer.append("</contextValue>");
                        }
                    }
                    if (bl) {
                        stringBuffer.append(LINE_SEPARATOR);
                        stringBuffer.append("\t");
                    }
                    stringBuffer.append("</contextDataElements>");
                }
                ++n2;
            }
        }
        if ((list2 = iCommonBaseEvent.getExtendedDataElements()) != null) {
            int n3 = 0;
            while (n3 < list2.size()) {
                stringBuffer.append(CbeFormatter.getIExtendedDataElementXML((IExtendedDataElement)list2.get(n3), "extendedDataElements", bl, bl ? 1 : 0));
                ++n3;
            }
        }
        if ((list = iCommonBaseEvent.getAssociatedEvents()) != null) {
            int n4 = 0;
            while (n4 < list.size()) {
                if (list.get(n4) != null) {
                    if (bl) {
                        stringBuffer.append(LINE_SEPARATOR);
                        stringBuffer.append("\t");
                    }
                    stringBuffer.append("<associatedEvents");
                    object3 = ((IAssociatedEvent)list.get(n4)).getResolvedEvents();
                    if (object3 != null && ((String)object3).length() > 0) {
                        stringBuffer.append(" resolvedEvents=\"");
                        stringBuffer.append((String)object3);
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append(">");
                    if (bl) {
                        stringBuffer.append(LINE_SEPARATOR);
                        stringBuffer.append("\t\t");
                    }
                    if ((object2 = ((IAssociatedEvent)list.get(n4)).getAssociationEngineInfo()) != null) {
                        object = CbeFormatter.toCanonicalXMLString((IAssociationEngine)object2).trim();
                        stringBuffer.append("<associationEngineInfo");
                        stringBuffer.append(((String)object).substring(18));
                    } else {
                        string = ((IAssociatedEvent)list.get(n4)).getAssociationEngine();
                        if (string != null && string.length() > 0) {
                            stringBuffer.append("<associationEngine>");
                            stringBuffer.append(XmlUtility.normalize((String)string));
                            stringBuffer.append("</associationEngine>");
                        }
                    }
                    if (bl) {
                        stringBuffer.append(LINE_SEPARATOR);
                        stringBuffer.append("\t");
                    }
                    stringBuffer.append("</associatedEvents>");
                }
                ++n4;
            }
        }
        if ((iComponentIdentification = iCommonBaseEvent.getReporterComponentId()) != null) {
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                stringBuffer.append("\t");
            }
            stringBuffer.append("<reporterComponentId");
            string = iComponentIdentification.getApplication();
            if (string != null && string.length() > 0) {
                stringBuffer.append(" application=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getComponent()) != null && string.length() > 0) {
                stringBuffer.append(" component=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getComponentIdType()) != null && string.length() > 0) {
                stringBuffer.append(" componentIdType=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getExecutionEnvironment()) != null && string.length() > 0) {
                stringBuffer.append(" executionEnvironment=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getInstanceId()) != null && string.length() > 0) {
                stringBuffer.append(" instanceId=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getLocation()) != null && string.length() > 0) {
                stringBuffer.append(" location=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getLocationType()) != null && string.length() > 0) {
                stringBuffer.append(" locationType=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getProcessId()) != null && string.length() > 0) {
                stringBuffer.append(" processId=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getSubComponent()) != null && string.length() > 0) {
                stringBuffer.append(" subComponent=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getThreadId()) != null && string.length() > 0) {
                stringBuffer.append(" threadId=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getComponentType()) != null && string.length() > 0) {
                stringBuffer.append(" componentType=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            stringBuffer.append("/>");
        }
        if ((iComponentIdentification = iCommonBaseEvent.getSourceComponentId()) != null) {
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                stringBuffer.append("\t");
            }
            stringBuffer.append("<sourceComponentId");
            string = iComponentIdentification.getApplication();
            if (string != null && string.length() > 0) {
                stringBuffer.append(" application=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getComponent()) != null && string.length() > 0) {
                stringBuffer.append(" component=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getComponentIdType()) != null && string.length() > 0) {
                stringBuffer.append(" componentIdType=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getExecutionEnvironment()) != null && string.length() > 0) {
                stringBuffer.append(" executionEnvironment=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getInstanceId()) != null && string.length() > 0) {
                stringBuffer.append(" instanceId=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getLocation()) != null && string.length() > 0) {
                stringBuffer.append(" location=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getLocationType()) != null && string.length() > 0) {
                stringBuffer.append(" locationType=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getProcessId()) != null && string.length() > 0) {
                stringBuffer.append(" processId=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getSubComponent()) != null && string.length() > 0) {
                stringBuffer.append(" subComponent=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getThreadId()) != null && string.length() > 0) {
                stringBuffer.append(" threadId=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = iComponentIdentification.getComponentType()) != null && string.length() > 0) {
                stringBuffer.append(" componentType=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            stringBuffer.append("/>");
        }
        if ((object3 = iCommonBaseEvent.getMsgDataElement()) != null) {
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                stringBuffer.append("\t");
            }
            stringBuffer.append("<msgDataElement");
            string = object3.getMsgLocale();
            if (string != null && string.length() > 0) {
                stringBuffer.append(" msgLocale=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            stringBuffer.append(">");
            object2 = object3.getMsgCatalogTokens();
            if (object2 != null) {
                int n5 = 0;
                while (n5 < object2.size()) {
                    if (object2.get(n5) != null && ((IMsgCatalogToken)object2.get(n5)).getValue().length() > 0) {
                        if (bl) {
                            stringBuffer.append(LINE_SEPARATOR);
                            stringBuffer.append("\t\t");
                        }
                        stringBuffer.append("<msgCatalogTokens value=\"");
                        stringBuffer.append(XmlUtility.normalize((String)((IMsgCatalogToken)object2.get(n5)).getValue()));
                        stringBuffer.append("\"/>");
                    }
                    ++n5;
                }
            }
            if ((string = object3.getMsgId()) != null && string.length() > 0) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                stringBuffer.append("<msgId>");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("</msgId>");
            }
            if ((string = object3.getMsgIdType()) != null && string.length() > 0) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                stringBuffer.append("<msgIdType>");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("</msgIdType>");
            }
            if ((string = object3.getMsgCatalogId()) != null && string.length() > 0) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                stringBuffer.append("<msgCatalogId>");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("</msgCatalogId>");
            }
            if ((string = object3.getMsgCatalogType()) != null && string.length() > 0) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                stringBuffer.append("<msgCatalogType>");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("</msgCatalogType>");
            }
            if ((string = object3.getMsgCatalog()) != null && string.length() > 0) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                stringBuffer.append("<msgCatalog>");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("</msgCatalog>");
            }
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                stringBuffer.append("\t");
            }
            stringBuffer.append("</msgDataElement>");
        }
        if ((object2 = iCommonBaseEvent.getSituation()) == null) {
            string = iCommonBaseEvent.getSituationType();
            if (string != null && string.length() > 0) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t");
                }
                stringBuffer.append("<situation categoryName=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\">");
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                stringBuffer.append("<reportSituation reasoningScope=\"INTERNAL\" reportCategory=\"LOG\">");
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t");
                }
                stringBuffer.append("</situation>");
            }
        } else {
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                stringBuffer.append("\t");
            }
            stringBuffer.append("<situation");
            string = object2.getCategoryName();
            if (string != null && string.length() > 0) {
                stringBuffer.append(" categoryName=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            stringBuffer.append(">");
            object = object2.getSituationType();
            if (object != null) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                stringBuffer.append("<situationType");
                string = object.getReasoningScope();
                if (object instanceof IStartSituation) {
                    stringBuffer.append(" xsi:type=\"StartSituation\"");
                    if (string != null && string.length() > 0) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((IStartSituation)object).getSuccessDisposition()) != null && string.length() > 0) {
                        stringBuffer.append(" successDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((IStartSituation)object).getSituationQualifier()) != null && string.length() > 0) {
                        stringBuffer.append(" situationQualifier=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (object instanceof IStopSituation) {
                    stringBuffer.append(" xsi:type=\"StopSituation\"");
                    if (string != null && string.length() > 0) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((IStopSituation)object).getSuccessDisposition()) != null && string.length() > 0) {
                        stringBuffer.append(" successDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((IStopSituation)object).getSituationQualifier()) != null && string.length() > 0) {
                        stringBuffer.append(" situationQualifier=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (object instanceof IConnectSituation) {
                    stringBuffer.append(" xsi:type=\"ConnectSituation\"");
                    if (string != null && string.length() > 0) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((IConnectSituation)object).getSuccessDisposition()) != null && string.length() > 0) {
                        stringBuffer.append(" successDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((IConnectSituation)object).getSituationDisposition()) != null && string.length() > 0) {
                        stringBuffer.append(" situationDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (object instanceof IReportSituation) {
                    stringBuffer.append(" xsi:type=\"ReportSituation\"");
                    if (string != null && string.length() > 0) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((IReportSituation)object).getReportCategory()) != null && string.length() > 0) {
                        stringBuffer.append(" reportCategory=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (object instanceof IFeatureSituation) {
                    stringBuffer.append(" xsi:type=\"FeatureSituation\"");
                    if (string != null && string.length() > 0) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((IFeatureSituation)object).getFeatureDisposition()) != null && string.length() > 0) {
                        stringBuffer.append(" featureDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (object instanceof IConfigureSituation) {
                    stringBuffer.append(" xsi:type=\"ConfigureSituation\"");
                    if (string != null && string.length() > 0) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((IConfigureSituation)object).getSuccessDisposition()) != null && string.length() > 0) {
                        stringBuffer.append(" successDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (object instanceof IDependencySituation) {
                    stringBuffer.append(" xsi:type=\"DependencySituation\"");
                    if (string != null && string.length() > 0) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((IDependencySituation)object).getDependencyDisposition()) != null && string.length() > 0) {
                        stringBuffer.append(" dependencyDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (object instanceof ICreateSituation) {
                    stringBuffer.append(" xsi:type=\"CreateSituation\"");
                    if (string != null && string.length() > 0) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((ICreateSituation)object).getSuccessDisposition()) != null && string.length() > 0) {
                        stringBuffer.append(" successDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (object instanceof IDestroySituation) {
                    stringBuffer.append(" xsi:type=\"DestroySituation\"");
                    if (string != null && string.length() > 0) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((IDestroySituation)object).getSuccessDisposition()) != null && string.length() > 0) {
                        stringBuffer.append(" successDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (object instanceof IAvailableSituation) {
                    stringBuffer.append(" xsi:type=\"AvailableSituation\"");
                    if (string != null && string.length() > 0) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((IAvailableSituation)object).getOperationDisposition()) != null && string.length() > 0) {
                        stringBuffer.append(" operationDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((IAvailableSituation)object).getProcessingDisposition()) != null && string.length() > 0) {
                        stringBuffer.append(" processingDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((IAvailableSituation)object).getAvailabilityDisposition()) != null && string.length() > 0) {
                        stringBuffer.append(" availabilityDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (object instanceof IRequestSituation) {
                    stringBuffer.append(" xsi:type=\"RequestSituation\"");
                    if (string != null && string.length() > 0) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((IRequestSituation)object).getSuccessDisposition()) != null && string.length() > 0) {
                        stringBuffer.append(" successDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((IRequestSituation)object).getSituationQualifier()) != null && string.length() > 0) {
                        stringBuffer.append(" situationQualifier=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (object instanceof IOtherSituation) {
                    stringBuffer.append(" xsi:type=\"OtherSituation\"");
                    if (string != null && string.length() > 0) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append(">");
                    stringArray = ((IOtherSituation)object).getAnyData();
                    if (stringArray != null) {
                        n = 0;
                        while (n < stringArray.length) {
                            if (stringArray[n] != null && stringArray[n].length() > 0) {
                                if (bl) {
                                    stringBuffer.append(LINE_SEPARATOR);
                                    stringBuffer.append("\t\t\t");
                                }
                                stringBuffer.append(stringArray[n]);
                            }
                            ++n;
                        }
                    }
                    if (bl) {
                        stringBuffer.append(LINE_SEPARATOR);
                        stringBuffer.append("\t\t");
                    }
                    stringBuffer.append("</situationType>");
                } else {
                    stringBuffer.append("/>");
                }
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t");
                }
                stringBuffer.append("</situation>");
            }
        }
        if ((object = iCommonBaseEvent.getOtherData()) == null) {
            stringArray = iCommonBaseEvent.getAnyElements();
            if (stringArray != null) {
                n = 0;
                while (n < stringArray.size()) {
                    if (stringArray.get(n) != null) {
                        if (bl) {
                            stringBuffer.append(LINE_SEPARATOR);
                            stringBuffer.append("\t");
                        }
                        stringBuffer.append(((ICommonBaseEventAnyElement)stringArray.get(n)).getXmlAnyElement());
                    }
                    ++n;
                }
            }
        } else {
            int n6 = 0;
            while (n6 < ((String[])object).length) {
                if (object[n6] != null && object[n6].length() > 0) {
                    if (bl) {
                        stringBuffer.append(LINE_SEPARATOR);
                        stringBuffer.append("\t");
                    }
                    stringBuffer.append((String)object[n6]);
                }
                ++n6;
            }
        }
        if (bl) {
            stringBuffer.append(LINE_SEPARATOR);
        }
        stringBuffer.append("</CommonBaseEvent>");
        return stringBuffer.toString();
    }

    private static String getIExtendedDataElementXML(IExtendedDataElement iExtendedDataElement, String string, boolean bl, int n) {
        if (iExtendedDataElement != null) {
            int n2;
            Object object;
            StringBuffer stringBuffer = new StringBuffer(512);
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                int n3 = 0;
                while (n3 < n) {
                    stringBuffer.append("\t");
                    ++n3;
                }
            }
            stringBuffer.append("<");
            stringBuffer.append(string);
            String string2 = iExtendedDataElement.getName();
            if (string2 != null && string2.length() > 0) {
                stringBuffer.append(" name=\"");
                stringBuffer.append(XmlUtility.normalize((String)string2));
                stringBuffer.append("\"");
            }
            if ((string2 = iExtendedDataElement.getType()) != null && string2.length() > 0) {
                stringBuffer.append(" type=\"");
                stringBuffer.append(XmlUtility.normalize((String)string2));
                stringBuffer.append("\"");
            }
            stringBuffer.append(">");
            if (iExtendedDataElement.getTypeValue() == 28) {
                object = iExtendedDataElement.getHexValues();
                if (object != null && ((char[])object).length > 0) {
                    if (bl) {
                        stringBuffer.append(LINE_SEPARATOR);
                        int n4 = 0;
                        while (n4 < n + 1) {
                            stringBuffer.append("\t");
                            ++n4;
                        }
                    }
                    stringBuffer.append("<hexValue>");
                    String string3 = null;
                    n2 = 0;
                    while (n2 < ((Object)object).length) {
                        string3 = Integer.toHexString((int)object[n2]).toUpperCase();
                        if (string3.length() == 1 || string3.length() == 3) {
                            stringBuffer.append('0');
                        }
                        stringBuffer.append(string3);
                        ++n2;
                    }
                    stringBuffer.append("</hexValue>");
                }
            } else {
                object = iExtendedDataElement.getValues();
                if (object != null && object.size() > 0) {
                    int n5 = 0;
                    while (n5 < object.size()) {
                        if (object.get(n5) != null && ((String)object.get(n5)).length() > 0) {
                            if (bl) {
                                stringBuffer.append(LINE_SEPARATOR);
                                n2 = 0;
                                while (n2 < n + 1) {
                                    stringBuffer.append("\t");
                                    ++n2;
                                }
                            }
                            stringBuffer.append("<values>");
                            stringBuffer.append(XmlUtility.normalize((String)((String)object.get(n5))));
                            stringBuffer.append("</values>");
                        }
                        ++n5;
                    }
                }
            }
            if ((object = iExtendedDataElement.getChildDataElements()) != null) {
                int n6 = 0;
                while (n6 < object.size()) {
                    stringBuffer.append(CbeFormatter.getIExtendedDataElementXML((IExtendedDataElement)object.get(n6), "children", bl, bl ? n + 1 : 0));
                    ++n6;
                }
            }
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                int n7 = 0;
                while (n7 < n) {
                    stringBuffer.append("\t");
                    ++n7;
                }
            }
            stringBuffer.append("</");
            stringBuffer.append(string);
            stringBuffer.append(">");
            return stringBuffer.toString();
        }
        return "";
    }

    public static synchronized String toCanonicalXMLDocString(ICommonBaseEvent iCommonBaseEvent) {
        return CbeFormatter.toCanonicalXMLDocString(iCommonBaseEvent, false);
    }

    public static synchronized String toCanonicalXMLDocString(ICommonBaseEvent iCommonBaseEvent, boolean bl) {
        String string = iCommonBaseEvent.getVersion();
        if (string != null && string.trim().equals("1.0")) {
            return CbeFormatter.toCanonicalVersion_1_0_XMLDocString(iCommonBaseEvent, bl);
        }
        return CbeFormatter.toCanonicalVersion_1_0_1_XMLDocString(iCommonBaseEvent, bl);
    }

    private static synchronized String toCanonicalVersion_1_0_XMLDocString(ICommonBaseEvent iCommonBaseEvent, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("<CommonBaseEvents xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"commonbaseevent1_0.xsd\">");
        stringBuffer.append(CbeFormatter.toCanonicalVersion_1_0_XMLString(iCommonBaseEvent, bl));
        if (bl) {
            stringBuffer.append(LINE_SEPARATOR);
        }
        stringBuffer.append("</CommonBaseEvents>");
        return stringBuffer.toString();
    }

    private static synchronized String toCanonicalVersion_1_0_1_XMLDocString(ICommonBaseEvent iCommonBaseEvent, boolean bl) {
        Object object;
        List list;
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("<CommonBaseEvents xmlns=\"http://www.ibm.com/AC/commonbaseevent1_0_1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/AC/commonbaseevent1_0_1 commonbaseevent1_0_1.xsd\">");
        if (bl) {
            stringBuffer.append(LINE_SEPARATOR);
        }
        if ((list = iCommonBaseEvent.getAssociatedEvents()) != null && list.size() > 0) {
            object = null;
            int n = 0;
            while (n < list.size()) {
                object = ((IAssociatedEvent)list.get(n)).getAssociationEngineInfo();
                if (object != null) {
                    if (bl) {
                        stringBuffer.append("\t");
                    }
                    stringBuffer.append(CbeFormatter.toCanonicalXMLString((IAssociationEngine)object));
                    if (bl) {
                        stringBuffer.append(LINE_SEPARATOR);
                    }
                }
                ++n;
            }
        }
        if (bl) {
            object = new StringTokenizer(CbeFormatter.toCanonicalVersion_1_0_1_XMLString(iCommonBaseEvent, bl).trim(), LINE_SEPARATOR);
            while (((StringTokenizer)object).hasMoreTokens()) {
                stringBuffer.append("\t");
                stringBuffer.append(((StringTokenizer)object).nextToken());
                stringBuffer.append(LINE_SEPARATOR);
            }
        } else {
            stringBuffer.append(CbeFormatter.toCanonicalVersion_1_0_1_XMLString(iCommonBaseEvent, bl));
        }
        stringBuffer.append("</CommonBaseEvents>");
        return stringBuffer.toString();
    }

    public static synchronized void fromCanonicalXMLString(ICommonBaseEvent iCommonBaseEvent, String string) {
        String string2 = iCommonBaseEvent.getVersion();
        if (string2 != null && string2.trim().equals("1.0")) {
            CbeFormatter.fromCanonical_1_0_XMLString(iCommonBaseEvent, string);
        } else {
            CbeFormatter.fromCanonical_1_0_1_XMLString(iCommonBaseEvent, string);
        }
    }

    private static synchronized void fromCanonical_1_0_XMLString(ICommonBaseEvent iCommonBaseEvent, String string) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n = string.indexOf("<CommonBaseEvent ");
        int n2 = 0;
        String string2 = string.substring(n, string.indexOf(">", n + 1));
        n = string.indexOf(">", n + 1) + 1;
        n2 = string2.indexOf(" creationTime=\"");
        if (n2 != -1) {
            iCommonBaseEvent.setCreationTime(XmlUtility.denormalize((String)string2.substring(n2 + 15, string2.indexOf("\"", n2 + 15))));
        }
        if ((n2 = string2.indexOf(" extensionName=\"")) != -1) {
            iCommonBaseEvent.setExtensionName(XmlUtility.denormalize((String)string2.substring(n2 + 16, string2.indexOf("\"", n2 + 16))));
        }
        if ((n2 = string2.indexOf(" globalInstanceId=\"")) != -1) {
            iCommonBaseEvent.setGlobalInstanceId(XmlUtility.denormalize((String)string2.substring(n2 + 19, string2.indexOf("\"", n2 + 19))));
        }
        if ((n2 = string2.indexOf(" localInstanceId=\"")) != -1) {
            iCommonBaseEvent.setLocalInstanceId(XmlUtility.denormalize((String)string2.substring(n2 + 18, string2.indexOf("\"", n2 + 18))));
        }
        if ((n2 = string2.indexOf(" msg=\"")) != -1) {
            iCommonBaseEvent.setMsg(XmlUtility.denormalize((String)string2.substring(n2 + 6, string2.indexOf("\"", n2 + 6))));
        }
        if ((n2 = string2.indexOf(" situationType=\"")) != -1) {
            iCommonBaseEvent.setSituationType(XmlUtility.denormalize((String)string2.substring(n2 + 16, string2.indexOf("\"", n2 + 16))));
        }
        if ((n2 = string2.indexOf(" elapsedTime=\"")) != -1) {
            iCommonBaseEvent.setElapsedTime(Long.valueOf(string2.substring(n2 + 14, string2.indexOf("\"", n2 + 14))));
        }
        if ((n2 = string2.indexOf(" priority=\"")) != -1) {
            iCommonBaseEvent.setPriority(Short.valueOf(string2.substring(n2 + 11, string2.indexOf("\"", n2 + 11))));
        }
        if ((n2 = string2.indexOf(" repeatCount=\"")) != -1) {
            iCommonBaseEvent.setRepeatCount(Short.valueOf(string2.substring(n2 + 14, string2.indexOf("\"", n2 + 14))));
        }
        if ((n2 = string2.indexOf(" sequenceNumber=\"")) != -1) {
            iCommonBaseEvent.setSequenceNumber(Long.valueOf(string2.substring(n2 + 17, string2.indexOf("\"", n2 + 17))));
        }
        if ((n2 = string2.indexOf(" severity=\"")) != -1) {
            iCommonBaseEvent.setSeverity(Short.valueOf(string2.substring(n2 + 11, string2.indexOf("\"", n2 + 11))));
        }
        while (string.indexOf("<contextDataElements ", n) != -1) {
            n = string.indexOf("<contextDataElements ", n);
            string2 = string.substring(n, string.indexOf("</contextDataElements>", n + 1));
            object4 = factory.createContextDataElement();
            n2 = string2.indexOf(" name=\"");
            if (n2 != -1) {
                object4.setName(XmlUtility.denormalize((String)string2.substring(n2 + 7, string2.indexOf("\"", n2 + 7))));
            }
            if ((n2 = string2.indexOf(" type=\"")) != -1) {
                object4.setType(XmlUtility.denormalize((String)string2.substring(n2 + 7, string2.indexOf("\"", n2 + 7))));
            }
            if ((n2 = string2.indexOf("<contextValue>")) != -1) {
                object4.setContextValue(XmlUtility.denormalize((String)string2.substring(n2 + 14, string2.indexOf("</contextValue>", n2 + 14))));
            } else if (string2.indexOf("<contextId>") != -1) {
                n2 = string2.indexOf("<contextId>");
                object4.setContextId(XmlUtility.denormalize((String)string2.substring(n2 + 11, string2.indexOf("</contextId>", n2 + 11))));
            }
            iCommonBaseEvent.addContextDataElement((IContextDataElement)object4);
            n = string.indexOf("</contextDataElements>", n + 1) + 22;
        }
        while (string.indexOf("<extendedDataElements ", n) != -1) {
            iCommonBaseEvent.addExtendedDataElement(CbeFormatter.loadIExtendedDataElements(string.substring(string.indexOf("<extendedDataElements ", n), string.indexOf("</extendedDataElements>", n + 1))));
            n = string.indexOf("</extendedDataElements>", n + 1) + 23;
        }
        object4 = new StringBuffer();
        while (string.indexOf("<associatedEvents ", n) != -1) {
            n = string.indexOf("<associatedEvents ", n);
            string2 = string.substring(n, string.indexOf("/>", n + 1));
            object3 = factory.createAssociatedEvent();
            n2 = string2.indexOf(" associationEngine=\"");
            if (n2 != -1) {
                object3.setAssociationEngine(XmlUtility.denormalize((String)string2.substring(n2 + 20, string2.indexOf("\"", n2 + 20))));
            }
            if ((n2 = string2.indexOf(" resolvedEvents=\"")) != -1) {
                object2 = new String(string2.substring(n2 + 17, string2.indexOf("\"", n2 + 17)));
                StringTokenizer stringTokenizer = new StringTokenizer((String)object2, " ");
                while (stringTokenizer.hasMoreTokens()) {
                    object = factory.createCommonBaseEvent();
                    object.setGlobalInstanceId(XmlUtility.denormalize((String)stringTokenizer.nextToken()));
                    object3.addResolvedEvent(object.getGlobalInstanceId());
                }
                n2 += ((String)object2).length() + 17;
            }
            iCommonBaseEvent.addAssociatedEvent((IAssociatedEvent)object3);
            n = string.indexOf("/>", n + 1) + 2;
        }
        if (string.indexOf("<reporterComponentId") != -1) {
            n = string.indexOf("<reporterComponentId");
            string2 = string.substring(n, string.indexOf("/>", n + 1));
            n = string.indexOf("/>", n + 1) + 2;
            object3 = factory.createComponentIdentification();
            n2 = string2.indexOf(" application=\"");
            if (n2 != -1) {
                object3.setApplication(XmlUtility.denormalize((String)string2.substring(n2 + 14, string2.indexOf("\"", n2 + 14))));
            }
            if ((n2 = string2.indexOf(" component=\"")) != -1) {
                object3.setComponent(XmlUtility.denormalize((String)string2.substring(n2 + 12, string2.indexOf("\"", n2 + 12))));
            }
            if ((n2 = string2.indexOf(" componentIdType=\"")) != -1) {
                object3.setComponentIdType(XmlUtility.denormalize((String)string2.substring(n2 + 18, string2.indexOf("\"", n2 + 18))));
            }
            if ((n2 = string2.indexOf(" executionEnvironment=\"")) != -1) {
                object3.setExecutionEnvironment(XmlUtility.denormalize((String)string2.substring(n2 + 23, string2.indexOf("\"", n2 + 23))));
            }
            if ((n2 = string2.indexOf(" instanceId=\"")) != -1) {
                object3.setInstanceId(XmlUtility.denormalize((String)string2.substring(n2 + 13, string2.indexOf("\"", n2 + 13))));
            }
            if ((n2 = string2.indexOf(" location=\"")) != -1) {
                object3.setLocation(XmlUtility.denormalize((String)string2.substring(n2 + 11, string2.indexOf("\"", n2 + 11))));
            }
            if ((n2 = string2.indexOf(" locationType=\"")) != -1) {
                object3.setLocationType(XmlUtility.denormalize((String)string2.substring(n2 + 15, string2.indexOf("\"", n2 + 15))));
            }
            if ((n2 = string2.indexOf(" processId=\"")) != -1) {
                object3.setProcessId(XmlUtility.denormalize((String)string2.substring(n2 + 12, string2.indexOf("\"", n2 + 12))));
            }
            if ((n2 = string2.indexOf(" subComponent=\"")) != -1) {
                object3.setSubComponent(XmlUtility.denormalize((String)string2.substring(n2 + 15, string2.indexOf("\"", n2 + 15))));
            }
            if ((n2 = string2.indexOf(" threadId=\"")) != -1) {
                object3.setThreadId(XmlUtility.denormalize((String)string2.substring(n2 + 11, string2.indexOf("\"", n2 + 11))));
            }
            iCommonBaseEvent.setReporterComponentId((IComponentIdentification)object3);
        }
        if (string.indexOf("<sourceComponentId") != -1) {
            n = string.indexOf("<sourceComponentId");
            string2 = string.substring(n, string.indexOf("/>", n + 1));
            n = string.indexOf("/>", n + 1) + 2;
            object3 = factory.createComponentIdentification();
            n2 = string2.indexOf(" application=\"");
            if (n2 != -1) {
                object3.setApplication(XmlUtility.denormalize((String)string2.substring(n2 + 14, string2.indexOf("\"", n2 + 14))));
            }
            if ((n2 = string2.indexOf(" component=\"")) != -1) {
                object3.setComponent(XmlUtility.denormalize((String)string2.substring(n2 + 12, string2.indexOf("\"", n2 + 12))));
            }
            if ((n2 = string2.indexOf(" componentIdType=\"")) != -1) {
                object3.setComponentIdType(XmlUtility.denormalize((String)string2.substring(n2 + 18, string2.indexOf("\"", n2 + 18))));
            }
            if ((n2 = string2.indexOf(" executionEnvironment=\"")) != -1) {
                object3.setExecutionEnvironment(XmlUtility.denormalize((String)string2.substring(n2 + 23, string2.indexOf("\"", n2 + 23))));
            }
            if ((n2 = string2.indexOf(" instanceId=\"")) != -1) {
                object3.setInstanceId(XmlUtility.denormalize((String)string2.substring(n2 + 13, string2.indexOf("\"", n2 + 13))));
            }
            if ((n2 = string2.indexOf(" location=\"")) != -1) {
                object3.setLocation(XmlUtility.denormalize((String)string2.substring(n2 + 11, string2.indexOf("\"", n2 + 11))));
            }
            if ((n2 = string2.indexOf(" locationType=\"")) != -1) {
                object3.setLocationType(XmlUtility.denormalize((String)string2.substring(n2 + 15, string2.indexOf("\"", n2 + 15))));
            }
            if ((n2 = string2.indexOf(" processId=\"")) != -1) {
                object3.setProcessId(XmlUtility.denormalize((String)string2.substring(n2 + 12, string2.indexOf("\"", n2 + 12))));
            }
            if ((n2 = string2.indexOf(" subComponent=\"")) != -1) {
                object3.setSubComponent(XmlUtility.denormalize((String)string2.substring(n2 + 15, string2.indexOf("\"", n2 + 15))));
            }
            if ((n2 = string2.indexOf(" threadId=\"")) != -1) {
                object3.setThreadId(XmlUtility.denormalize((String)string2.substring(n2 + 11, string2.indexOf("\"", n2 + 11))));
            }
            iCommonBaseEvent.setSourceComponentId((IComponentIdentification)object3);
        }
        if (string.indexOf("<msgDataElement") != -1) {
            n = string.indexOf("<msgDataElement");
            string2 = string.substring(n, string.indexOf("</msgDataElement>", n + 1));
            n = string.indexOf("</msgDataElement>", n + 1) + 17;
            object3 = factory.createMsgDataElement();
            n2 = string2.indexOf(" msgLocale=\"");
            if (n2 != -1) {
                object3.setMsgLocale(XmlUtility.denormalize((String)string2.substring(n2 + 12, string2.indexOf("\"", n2 + 12))));
            }
            if (string2.indexOf("<msgCatalogTokens ", n2) != -1) {
                object2 = null;
                while (string2.indexOf("<msgCatalogTokens ", n2) != -1) {
                    if ((n2 = string2.indexOf(" value=\"", n2)) != -1) {
                        object2 = factory.createMsgCatalogToken();
                        object2.setValue(XmlUtility.denormalize((String)new String(string2.substring(n2 + 8, string2.indexOf("\"", n2 + 8)))));
                        object3.addMsgCatalogToken((IMsgCatalogToken)object2);
                    }
                    n2 = string2.indexOf("/>", n2 + 1) + 2;
                }
            }
            if ((n2 = string2.indexOf("<msgCatalogType>")) != -1) {
                object3.setMsgCatalogType(XmlUtility.denormalize((String)string2.substring(n2 + 16, string2.indexOf("</msgCatalogType>", n2 + 16))));
            }
            if ((n2 = string2.indexOf("<msgId>")) != -1) {
                object3.setMsgId(XmlUtility.denormalize((String)string2.substring(n2 + 7, string2.indexOf("</msgId>", n2 + 7))));
            }
            if ((n2 = string2.indexOf("<msgIdType>")) != -1) {
                object3.setMsgIdType(XmlUtility.denormalize((String)string2.substring(n2 + 11, string2.indexOf("</msgIdType>", n2 + 11))));
            }
            if ((n2 = string2.indexOf("<msgCatalogId>")) != -1) {
                object3.setMsgCatalogId(XmlUtility.denormalize((String)string2.substring(n2 + 14, string2.indexOf("</msgCatalogId>", n2 + 14))));
            }
            if ((n2 = string2.indexOf("<msgCatalog>")) != -1) {
                object3.setMsgCatalog(XmlUtility.denormalize((String)string2.substring(n2 + 12, string2.indexOf("</msgCatalog>", n2 + 12))));
            }
            iCommonBaseEvent.setMsgDataElement((IMsgDataElement)object3);
        }
        n2 = string.indexOf("xmlns:");
        string2 = string.substring(0);
        while (n2 > 0) {
            int n3 = string2.indexOf("=", n2);
            if (n3 > 0) {
                object2 = string2.substring(n2 + 6, n3);
                int n4 = string2.indexOf("<" + (String)object2 + ":");
                if (n4 > -1) {
                    object = string2.substring(n4 + 1, string2.indexOf(" ", n4));
                    int n5 = string2.indexOf(">", n4);
                    int n6 = -1;
                    if (string2.charAt(n5 - 1) == '/') {
                        n6 = n5 + 1;
                    } else {
                        n6 = string2.indexOf("</" + (String)object + ">");
                        n6 = n6 + ((String)object).length() + 3;
                    }
                    if (n6 > 0) {
                        String string3 = string2.substring(n4, n6);
                        string2 = string2.substring(n6);
                        n2 = string2.indexOf("xmlns:");
                        ICommonBaseEventAnyElement iCommonBaseEventAnyElement = factory.createAnyElement();
                        try {
                            iCommonBaseEventAnyElement.setXmlAnyElement(string3);
                            iCommonBaseEvent.addAnyElement(iCommonBaseEventAnyElement);
                        }
                        catch (InvalidXMLAnyElementException invalidXMLAnyElementException) {
                            string2 = string2.substring(n2 + 1);
                            n2 = string2.indexOf("xmlns:");
                        }
                        continue;
                    }
                    string2 = string2.substring(n2 + 1);
                    n2 = string2.indexOf("xmlns:");
                    continue;
                }
                string2 = string2.substring(n2 + 1);
                n2 = string2.indexOf("xmlns:");
                continue;
            }
            n2 = -1;
        }
    }

    private static synchronized void fromCanonical_1_0_1_XMLString(ICommonBaseEvent iCommonBaseEvent, String string) {
        Object object;
        Object object2;
        Object object3;
        int n = string.indexOf("<CommonBaseEvent ");
        int n2 = 0;
        String string2 = string.substring(n, string.indexOf(">", n + 1));
        n = string.indexOf(">", n + 1) + 1;
        n2 = string2.indexOf(" creationTime=\"");
        if (n2 != -1) {
            iCommonBaseEvent.setCreationTime(XmlUtility.denormalize((String)string2.substring(n2 + 15, string2.indexOf("\"", n2 + 15))));
        }
        if ((n2 = string2.indexOf(" extensionName=\"")) != -1) {
            iCommonBaseEvent.setExtensionName(XmlUtility.denormalize((String)string2.substring(n2 + 16, string2.indexOf("\"", n2 + 16))));
        }
        if ((n2 = string2.indexOf(" globalInstanceId=\"")) != -1) {
            iCommonBaseEvent.setGlobalInstanceId(XmlUtility.denormalize((String)string2.substring(n2 + 19, string2.indexOf("\"", n2 + 19))));
        }
        if ((n2 = string2.indexOf(" localInstanceId=\"")) != -1) {
            iCommonBaseEvent.setLocalInstanceId(XmlUtility.denormalize((String)string2.substring(n2 + 18, string2.indexOf("\"", n2 + 18))));
        }
        if ((n2 = string2.indexOf(" msg=\"")) != -1) {
            iCommonBaseEvent.setMsg(XmlUtility.denormalize((String)string2.substring(n2 + 6, string2.indexOf("\"", n2 + 6))));
        }
        n2 = string2.indexOf(" situationType=\"");
        String string3 = null;
        if (n2 != -1) {
            string3 = XmlUtility.denormalize((String)string2.substring(n2 + 16, string2.indexOf("\"", n2 + 16)));
        }
        if ((n2 = string2.indexOf(" elapsedTime=\"")) != -1) {
            iCommonBaseEvent.setElapsedTime(Long.valueOf(string2.substring(n2 + 14, string2.indexOf("\"", n2 + 14))));
        }
        if ((n2 = string2.indexOf(" priority=\"")) != -1) {
            iCommonBaseEvent.setPriority(Short.valueOf(string2.substring(n2 + 11, string2.indexOf("\"", n2 + 11))));
        }
        if ((n2 = string2.indexOf(" repeatCount=\"")) != -1) {
            iCommonBaseEvent.setRepeatCount(Short.valueOf(string2.substring(n2 + 14, string2.indexOf("\"", n2 + 14))));
        }
        if ((n2 = string2.indexOf(" sequenceNumber=\"")) != -1) {
            iCommonBaseEvent.setSequenceNumber(Long.valueOf(string2.substring(n2 + 17, string2.indexOf("\"", n2 + 17))));
        }
        if ((n2 = string2.indexOf(" severity=\"")) != -1) {
            iCommonBaseEvent.setSeverity(Short.valueOf(string2.substring(n2 + 11, string2.indexOf("\"", n2 + 11))));
        }
        while (string.indexOf("<contextDataElements ", n) != -1) {
            n = string.indexOf("<contextDataElements ", n);
            string2 = string.substring(n, string.indexOf("</contextDataElements>", n + 1));
            object3 = factory.createContextDataElement();
            n2 = string2.indexOf(" name=\"");
            if (n2 != -1) {
                object3.setName(XmlUtility.denormalize((String)string2.substring(n2 + 7, string2.indexOf("\"", n2 + 7))));
            }
            if ((n2 = string2.indexOf(" type=\"")) != -1) {
                object3.setType(XmlUtility.denormalize((String)string2.substring(n2 + 7, string2.indexOf("\"", n2 + 7))));
            }
            if ((n2 = string2.indexOf("<contextValue>")) != -1) {
                object3.setContextValue(XmlUtility.denormalize((String)string2.substring(n2 + 14, string2.indexOf("</contextValue>", n2 + 14))));
            } else if (string2.indexOf("<contextId>") != -1) {
                n2 = string2.indexOf("<contextId>");
                object3.setContextId(XmlUtility.denormalize((String)string2.substring(n2 + 11, string2.indexOf("</contextId>", n2 + 11))));
            }
            iCommonBaseEvent.addContextDataElement((IContextDataElement)object3);
            n = string.indexOf("</contextDataElements>", n + 1) + 22;
        }
        while (string.indexOf("<extendedDataElements ", n) != -1) {
            iCommonBaseEvent.addExtendedDataElement(CbeFormatter.loadIExtendedDataElements(string.substring(string.indexOf("<extendedDataElements ", n), string.indexOf("</extendedDataElements>", n + 1))));
            n = string.indexOf("</extendedDataElements>", n + 1) + 23;
        }
        object3 = new StringBuffer();
        while (string.indexOf("<associatedEvents ", n) != -1) {
            n = string.indexOf("<associatedEvents ", n);
            string2 = string.substring(n, string.indexOf("/>", n + 1));
            object2 = factory.createAssociatedEvent();
            n2 = string2.indexOf(" resolvedEvents=\"");
            if (n2 != -1) {
                object = new StringTokenizer(string2.substring(n2 + 17, string2.indexOf("\"", n2 + 17)), " ");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    object2.addResolvedEvent(XmlUtility.denormalize((String)((StringTokenizer)object).nextToken()));
                }
            }
            if ((n2 = string2.indexOf("<associationEngineInfo ", n2)) == -1) {
                n2 = string2.indexOf("<associationEngine>");
                if (n2 != -1) {
                    object2.setAssociationEngine(XmlUtility.denormalize((String)string2.substring(n2 + 19, string2.indexOf("</associationEngine>", n2 + 19))));
                }
            } else {
                object = factory.createAssociationEngine();
                CbeFormatter.fromCanonicalXMLString((IAssociationEngine)object, string2.substring(n2, string2.indexOf("/>", n2) + 2));
                object2.setAssociationEngineInfo((IAssociationEngine)object);
            }
            iCommonBaseEvent.addAssociatedEvent((IAssociatedEvent)object2);
            n = string.indexOf("/>", n) + 2;
        }
        if (string.indexOf("<reporterComponentId") != -1) {
            n = string.indexOf("<reporterComponentId");
            string2 = string.substring(n, string.indexOf("/>", n + 1));
            n = string.indexOf("/>", n + 1) + 2;
            object2 = factory.createComponentIdentification();
            n2 = string2.indexOf(" application=\"");
            if (n2 != -1) {
                object2.setApplication(XmlUtility.denormalize((String)string2.substring(n2 + 14, string2.indexOf("\"", n2 + 14))));
            }
            if ((n2 = string2.indexOf(" component=\"")) != -1) {
                object2.setComponent(XmlUtility.denormalize((String)string2.substring(n2 + 12, string2.indexOf("\"", n2 + 12))));
            }
            if ((n2 = string2.indexOf(" componentIdType=\"")) != -1) {
                object2.setComponentIdType(XmlUtility.denormalize((String)string2.substring(n2 + 18, string2.indexOf("\"", n2 + 18))));
            }
            if ((n2 = string2.indexOf(" executionEnvironment=\"")) != -1) {
                object2.setExecutionEnvironment(XmlUtility.denormalize((String)string2.substring(n2 + 23, string2.indexOf("\"", n2 + 23))));
            }
            if ((n2 = string2.indexOf(" instanceId=\"")) != -1) {
                object2.setInstanceId(XmlUtility.denormalize((String)string2.substring(n2 + 13, string2.indexOf("\"", n2 + 13))));
            }
            if ((n2 = string2.indexOf(" location=\"")) != -1) {
                object2.setLocation(XmlUtility.denormalize((String)string2.substring(n2 + 11, string2.indexOf("\"", n2 + 11))));
            }
            if ((n2 = string2.indexOf(" locationType=\"")) != -1) {
                object2.setLocationType(XmlUtility.denormalize((String)string2.substring(n2 + 15, string2.indexOf("\"", n2 + 15))));
            }
            if ((n2 = string2.indexOf(" processId=\"")) != -1) {
                object2.setProcessId(XmlUtility.denormalize((String)string2.substring(n2 + 12, string2.indexOf("\"", n2 + 12))));
            }
            if ((n2 = string2.indexOf(" subComponent=\"")) != -1) {
                object2.setSubComponent(XmlUtility.denormalize((String)string2.substring(n2 + 15, string2.indexOf("\"", n2 + 15))));
            }
            if ((n2 = string2.indexOf(" threadId=\"")) != -1) {
                object2.setThreadId(XmlUtility.denormalize((String)string2.substring(n2 + 11, string2.indexOf("\"", n2 + 11))));
            }
            if ((n2 = string2.indexOf(" componentType=\"")) != -1) {
                object2.setComponentType(XmlUtility.denormalize((String)string2.substring(n2 + 16, string2.indexOf("\"", n2 + 16))));
            }
            iCommonBaseEvent.setReporterComponentId((IComponentIdentification)object2);
        }
        if (string.indexOf("<sourceComponentId") != -1) {
            n = string.indexOf("<sourceComponentId");
            string2 = string.substring(n, string.indexOf("/>", n + 1));
            n = string.indexOf("/>", n + 1) + 2;
            object2 = factory.createComponentIdentification();
            n2 = string2.indexOf(" application=\"");
            if (n2 != -1) {
                object2.setApplication(XmlUtility.denormalize((String)string2.substring(n2 + 14, string2.indexOf("\"", n2 + 14))));
            }
            if ((n2 = string2.indexOf(" component=\"")) != -1) {
                object2.setComponent(XmlUtility.denormalize((String)string2.substring(n2 + 12, string2.indexOf("\"", n2 + 12))));
            }
            if ((n2 = string2.indexOf(" componentIdType=\"")) != -1) {
                object2.setComponentIdType(XmlUtility.denormalize((String)string2.substring(n2 + 18, string2.indexOf("\"", n2 + 18))));
            }
            if ((n2 = string2.indexOf(" executionEnvironment=\"")) != -1) {
                object2.setExecutionEnvironment(XmlUtility.denormalize((String)string2.substring(n2 + 23, string2.indexOf("\"", n2 + 23))));
            }
            if ((n2 = string2.indexOf(" instanceId=\"")) != -1) {
                object2.setInstanceId(XmlUtility.denormalize((String)string2.substring(n2 + 13, string2.indexOf("\"", n2 + 13))));
            }
            if ((n2 = string2.indexOf(" location=\"")) != -1) {
                object2.setLocation(XmlUtility.denormalize((String)string2.substring(n2 + 11, string2.indexOf("\"", n2 + 11))));
            }
            if ((n2 = string2.indexOf(" locationType=\"")) != -1) {
                object2.setLocationType(XmlUtility.denormalize((String)string2.substring(n2 + 15, string2.indexOf("\"", n2 + 15))));
            }
            if ((n2 = string2.indexOf(" processId=\"")) != -1) {
                object2.setProcessId(XmlUtility.denormalize((String)string2.substring(n2 + 12, string2.indexOf("\"", n2 + 12))));
            }
            if ((n2 = string2.indexOf(" subComponent=\"")) != -1) {
                object2.setSubComponent(XmlUtility.denormalize((String)string2.substring(n2 + 15, string2.indexOf("\"", n2 + 15))));
            }
            if ((n2 = string2.indexOf(" threadId=\"")) != -1) {
                object2.setThreadId(XmlUtility.denormalize((String)string2.substring(n2 + 11, string2.indexOf("\"", n2 + 11))));
            }
            if ((n2 = string2.indexOf(" componentType=\"")) != -1) {
                object2.setComponentType(XmlUtility.denormalize((String)string2.substring(n2 + 16, string2.indexOf("\"", n2 + 16))));
            }
            iCommonBaseEvent.setSourceComponentId((IComponentIdentification)object2);
        }
        if (string.indexOf("<msgDataElement") != -1) {
            n = string.indexOf("<msgDataElement");
            string2 = string.substring(n, string.indexOf("</msgDataElement>", n + 1));
            n = string.indexOf("</msgDataElement>", n + 1) + 17;
            object2 = factory.createMsgDataElement();
            n2 = string2.indexOf(" msgLocale=\"");
            if (n2 != -1) {
                object2.setMsgLocale(XmlUtility.denormalize((String)string2.substring(n2 + 12, string2.indexOf("\"", n2 + 12))));
            }
            if (string2.indexOf("<msgCatalogTokens ", n2) != -1) {
                object = null;
                while (string2.indexOf("<msgCatalogTokens ", n2) != -1) {
                    if ((n2 = string2.indexOf(" value=\"", n2)) != -1) {
                        object = factory.createMsgCatalogToken();
                        object.setValue(XmlUtility.denormalize((String)new String(string2.substring(n2 + 8, string2.indexOf("\"", n2 + 8)))));
                        object2.addMsgCatalogToken((IMsgCatalogToken)object);
                    }
                    n2 = string2.indexOf("/>", n2 + 1) + 2;
                }
            }
            if ((n2 = string2.indexOf("<msgCatalogType>")) != -1) {
                object2.setMsgCatalogType(XmlUtility.denormalize((String)string2.substring(n2 + 16, string2.indexOf("</msgCatalogType>", n2 + 16))));
            }
            if ((n2 = string2.indexOf("<msgId>")) != -1) {
                object2.setMsgId(XmlUtility.denormalize((String)string2.substring(n2 + 7, string2.indexOf("</msgId>", n2 + 7))));
            }
            if ((n2 = string2.indexOf("<msgIdType>")) != -1) {
                object2.setMsgIdType(XmlUtility.denormalize((String)string2.substring(n2 + 11, string2.indexOf("</msgIdType>", n2 + 11))));
            }
            if ((n2 = string2.indexOf("<msgCatalogId>")) != -1) {
                object2.setMsgCatalogId(XmlUtility.denormalize((String)string2.substring(n2 + 14, string2.indexOf("</msgCatalogId>", n2 + 14))));
            }
            if ((n2 = string2.indexOf("<msgCatalog>")) != -1) {
                object2.setMsgCatalog(XmlUtility.denormalize((String)string2.substring(n2 + 12, string2.indexOf("</msgCatalog>", n2 + 12))));
            }
            iCommonBaseEvent.setMsgDataElement((IMsgDataElement)object2);
        }
        if (string.indexOf("<situation") == -1) {
            if (string3 != null) {
                object2 = factory.createReportSituation();
                object2.setReasoningScope("INTERNAL");
                object2.setReportCategory("LOG");
                object = factory.createSituation();
                object.setCategoryName(string3);
                object.setSituationType((ISituationType)object2);
                iCommonBaseEvent.setSituation((ISituation)object);
            }
        } else {
            n = string.indexOf("<situation");
            string2 = string.substring(n, string.indexOf("</situation>", n));
            n = string.indexOf("</situation>", n) + 12;
            object2 = factory.createSituation();
            n2 = string2.indexOf(" categoryName=\"");
            if (n2 != -1) {
                object2.setCategoryName(XmlUtility.denormalize((String)string2.substring(n2 + 15, string2.indexOf("\"", n2 + 15))));
            }
            if ((n2 = string2.indexOf("<situationType ", n2)) != -1) {
                int n3 = string2.indexOf("</situationType>", n2);
                if (n3 == -1) {
                    n3 = string2.indexOf("/>", n2);
                }
                if ((n2 = (string2 = string2.substring(n2, n3)).indexOf(" xsi:type=\"")) != -1) {
                    String string4 = XmlUtility.denormalize((String)string2.substring(n2 + 11, string2.indexOf("\"", n2 + 11)));
                    n2 = string2.indexOf(" reasoningScope=\"", n2);
                    String string5 = null;
                    if (n2 != -1) {
                        string5 = XmlUtility.denormalize((String)string2.substring(n2 + 17, string2.indexOf("\"", n2 + 17)));
                    }
                    if (string4.equals("StartSituation")) {
                        IStartSituation iStartSituation = factory.createStartSituation();
                        if ((n2 = string2.indexOf(" successDisposition=\"", n2)) != -1) {
                            iStartSituation.setSuccessDisposition(XmlUtility.denormalize((String)string2.substring(n2 + 21, string2.indexOf("\"", n2 + 21))));
                        }
                        if ((n2 = string2.indexOf(" situationQualifier=\"", n2)) != -1) {
                            iStartSituation.setSituationQualifier(XmlUtility.denormalize((String)string2.substring(n2 + 21, string2.indexOf("\"", n2 + 21))));
                        }
                        iStartSituation.setReasoningScope(string5);
                        object2.setSituationType(iStartSituation);
                    } else if (string4.equals("StopSituation")) {
                        IStopSituation iStopSituation = factory.createStopSituation();
                        if ((n2 = string2.indexOf(" successDisposition=\"", n2)) != -1) {
                            iStopSituation.setSuccessDisposition(XmlUtility.denormalize((String)string2.substring(n2 + 21, string2.indexOf("\"", n2 + 21))));
                        }
                        if ((n2 = string2.indexOf(" situationQualifier=\"", n2)) != -1) {
                            iStopSituation.setSituationQualifier(XmlUtility.denormalize((String)string2.substring(n2 + 21, string2.indexOf("\"", n2 + 21))));
                        }
                        iStopSituation.setReasoningScope(string5);
                        object2.setSituationType(iStopSituation);
                    } else if (string4.equals("ConnectSituation")) {
                        IConnectSituation iConnectSituation = factory.createConnectSituation();
                        if ((n2 = string2.indexOf(" successDisposition=\"", n2)) != -1) {
                            iConnectSituation.setSuccessDisposition(XmlUtility.denormalize((String)string2.substring(n2 + 21, string2.indexOf("\"", n2 + 21))));
                        }
                        if ((n2 = string2.indexOf(" situationDisposition=\"", n2)) != -1) {
                            iConnectSituation.setSituationDisposition(XmlUtility.denormalize((String)string2.substring(n2 + 23, string2.indexOf("\"", n2 + 23))));
                        }
                        iConnectSituation.setReasoningScope(string5);
                        object2.setSituationType(iConnectSituation);
                    } else if (string4.equals("ReportSituation")) {
                        IReportSituation iReportSituation = factory.createReportSituation();
                        if ((n2 = string2.indexOf(" reportCategory=\"", n2)) != -1) {
                            iReportSituation.setReportCategory(XmlUtility.denormalize((String)string2.substring(n2 + 17, string2.indexOf("\"", n2 + 17))));
                        }
                        iReportSituation.setReasoningScope(string5);
                        object2.setSituationType(iReportSituation);
                    } else if (string4.equals("FeatureSituation")) {
                        IFeatureSituation iFeatureSituation = factory.createFeatureSituation();
                        if ((n2 = string2.indexOf(" featureDisposition=\"", n2)) != -1) {
                            iFeatureSituation.setFeatureDisposition(XmlUtility.denormalize((String)string2.substring(n2 + 21, string2.indexOf("\"", n2 + 21))));
                        }
                        iFeatureSituation.setReasoningScope(string5);
                        object2.setSituationType(iFeatureSituation);
                    } else if (string4.equals("ConfigureSituation")) {
                        IConfigureSituation iConfigureSituation = factory.createConfigureSituation();
                        if ((n2 = string2.indexOf(" successDisposition=\"", n2)) != -1) {
                            iConfigureSituation.setSuccessDisposition(XmlUtility.denormalize((String)string2.substring(n2 + 21, string2.indexOf("\"", n2 + 21))));
                        }
                        iConfigureSituation.setReasoningScope(string5);
                        object2.setSituationType(iConfigureSituation);
                    } else if (string4.equals("DependencySituation")) {
                        IDependencySituation iDependencySituation = factory.createDependencySituation();
                        if ((n2 = string2.indexOf(" dependencyDisposition=\"", n2)) != -1) {
                            iDependencySituation.setDependencyDisposition(XmlUtility.denormalize((String)string2.substring(n2 + 24, string2.indexOf("\"", n2 + 24))));
                        }
                        iDependencySituation.setReasoningScope(string5);
                        object2.setSituationType(iDependencySituation);
                    } else if (string4.equals("CreateSituation")) {
                        ICreateSituation iCreateSituation = factory.createCreateSituation();
                        if ((n2 = string2.indexOf(" successDisposition=\"", n2)) != -1) {
                            iCreateSituation.setSuccessDisposition(XmlUtility.denormalize((String)string2.substring(n2 + 21, string2.indexOf("\"", n2 + 21))));
                        }
                        iCreateSituation.setReasoningScope(string5);
                        object2.setSituationType(iCreateSituation);
                    } else if (string4.equals("DestroySituation")) {
                        IDestroySituation iDestroySituation = factory.createDestroySituation();
                        if ((n2 = string2.indexOf(" successDisposition=\"", n2)) != -1) {
                            iDestroySituation.setSuccessDisposition(XmlUtility.denormalize((String)string2.substring(n2 + 21, string2.indexOf("\"", n2 + 21))));
                        }
                        iDestroySituation.setReasoningScope(string5);
                        object2.setSituationType(iDestroySituation);
                    } else if (string4.equals("AvailableSituation")) {
                        IAvailableSituation iAvailableSituation = factory.createAvailableSituation();
                        if ((n2 = string2.indexOf(" operationDisposition\"", n2)) != -1) {
                            iAvailableSituation.setOperationDisposition(XmlUtility.denormalize((String)string2.substring(n2 + 23, string2.indexOf("\"", n2 + 23))));
                        }
                        if ((n2 = string2.indexOf(" processingDisposition=\"", n2)) != -1) {
                            iAvailableSituation.setProcessingDisposition(XmlUtility.denormalize((String)string2.substring(n2 + 24, string2.indexOf("\"", n2 + 24))));
                        }
                        if ((n2 = string2.indexOf(" availabilityDisposition=\"", n2)) != -1) {
                            iAvailableSituation.setAvailabilityDisposition(XmlUtility.denormalize((String)string2.substring(n2 + 25, string2.indexOf("\"", n2 + 25))));
                        }
                        iAvailableSituation.setReasoningScope(string5);
                        object2.setSituationType(iAvailableSituation);
                    } else if (string4.equals("RequestSituation")) {
                        IRequestSituation iRequestSituation = factory.createRequestSituation();
                        if ((n2 = string2.indexOf(" successDisposition=\"", n2)) != -1) {
                            iRequestSituation.setSuccessDisposition(XmlUtility.denormalize((String)string2.substring(n2 + 21, string2.indexOf("\"", n2 + 21))));
                        }
                        if ((n2 = string2.indexOf(" situationQualifier=\"", n2)) != -1) {
                            iRequestSituation.setSituationQualifier(XmlUtility.denormalize((String)string2.substring(n2 + 21, string2.indexOf("\"", n2 + 21))));
                        }
                        iRequestSituation.setReasoningScope(string5);
                        object2.setSituationType(iRequestSituation);
                    } else if (string4.equals("OtherSituation")) {
                        IOtherSituation iOtherSituation = factory.createOtherSituation();
                        String[] stringArray = CbeFormatter.getXMLFragments(string2.substring(string2.indexOf(">", n2) + 1, string2.indexOf("</situationType>", n2)));
                        if (stringArray.length > 0) {
                            iOtherSituation.setAnyData(stringArray);
                        }
                        iOtherSituation.setReasoningScope(string5);
                        object2.setSituationType(iOtherSituation);
                    }
                }
            }
            iCommonBaseEvent.setSituation((ISituation)object2);
        }
        if (((String[])(object2 = CbeFormatter.getXMLFragments(string.substring(n, string.indexOf("</CommonBaseEvent>", n))))).length > 0) {
            iCommonBaseEvent.setOtherData((String[])object2);
        }
    }

    public static synchronized void fromCanonicalXMLDocString(ICommonBaseEvent iCommonBaseEvent, String string) {
        CbeFormatter.fromCanonicalXMLString(iCommonBaseEvent, string);
    }

    public static long convertXmlSchemaDateTimeToDate(String string) {
        long l;
        block21: {
            String string2 = null;
            String string3 = null;
            String string4 = null;
            int n = 0;
            Date date = null;
            l = 0L;
            int n2 = -1;
            String string5 = "yyyy-MM-dd'T'HH:mm:ss";
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string5);
            int n3 = string5.length() - 2;
            try {
                String string6;
                if (string.length() < n3) {
                    l = 0L;
                    break block21;
                }
                if (string.indexOf(90) > n3) {
                    n2 = string.indexOf(90);
                    string2 = string.substring(0, n2);
                    n = 90;
                } else if (string.indexOf(43) > n3) {
                    n2 = string.indexOf(43);
                    string2 = string.substring(0, n2);
                    n = string.charAt(n2);
                    string4 = string.substring(n2 + 1);
                } else if (string.indexOf(45, n3) > n3) {
                    n2 = string.indexOf(45, n3);
                    string2 = string.substring(0, n2);
                    n = string.charAt(n2);
                    string4 = string.substring(n2 + 1);
                } else {
                    string2 = string;
                }
                int n4 = string2.indexOf(46);
                if (n4 > 0) {
                    if (n2 != -1) {
                        string2 = string.substring(0, n2);
                    }
                    string3 = string2.substring(n4 + 1);
                }
                if (string2 != null && Integer.parseInt(string6 = string2.substring(0, 4)) > 1969) {
                    SimpleTimeZone simpleTimeZone = new SimpleTimeZone(0, "UTC");
                    GregorianCalendar gregorianCalendar = new GregorianCalendar(simpleTimeZone);
                    ParsePosition parsePosition = new ParsePosition(0);
                    simpleDateFormat.setCalendar(gregorianCalendar);
                    date = simpleDateFormat.parse(string2, parsePosition);
                }
                if (date == null) break block21;
                l = date.getTime();
                if (string3 != null && string3.length() > 0) {
                    long l2 = Long.parseLong(string3);
                    int n5 = string3.length();
                    if (n5 < 4) {
                        int n6 = 1;
                        while (n6 < 4 - n5) {
                            l2 *= 10L;
                            ++n6;
                        }
                    } else {
                        int n7 = 1;
                        while (n7 < 4 - n5) {
                            l2 /= 10L;
                            ++n7;
                        }
                    }
                    l += l2;
                }
                if (n != 0 && string4 != null && string4.length() == 5) {
                    long l3 = Long.parseLong(string4.substring(0, 2));
                    long l4 = Long.parseLong(string4.substring(3));
                    if (n == 43) {
                        l = l + l3 * 60L * 1000L + l4 * 1000L;
                    } else if (n == 45) {
                        l = l - l3 * 60L * 1000L - l4 * 1000L;
                    }
                }
            }
            catch (Exception exception) {
                l = 0L;
            }
        }
        return l;
    }

    public static String convertDateToXmlSchemaDateTime(long l) {
        String string = null;
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(0, "UTC");
        GregorianCalendar gregorianCalendar = new GregorianCalendar(simpleTimeZone);
        gregorianCalendar.setTime(new Date(l));
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2);
        ++n2;
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        int n6 = gregorianCalendar.get(13);
        int n7 = gregorianCalendar.get(14);
        StringBuffer stringBuffer = new StringBuffer(35);
        stringBuffer.append(n);
        stringBuffer.append('-');
        if (n2 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n2);
        stringBuffer.append('-');
        if (n3 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n3);
        stringBuffer.append('T');
        if (n4 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n4);
        stringBuffer.append(':');
        if (n5 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n5);
        stringBuffer.append(':');
        if (n6 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n6);
        stringBuffer.append(".");
        stringBuffer.append(n7);
        stringBuffer.append("Z");
        string = stringBuffer.toString();
        return string;
    }

    public static final String getEventFormatterVersion() {
        return xml_version;
    }

    private static IExtendedDataElement loadIExtendedDataElements(String string) {
        int n;
        Object object;
        IExtendedDataElement iExtendedDataElement = factory.createExtendedDataElement();
        int n2 = string.indexOf(" name=\"");
        int n3 = -1;
        if (n2 != -1 && (n3 = string.indexOf(34, n2 + 7)) != -1) {
            iExtendedDataElement.setName(XmlUtility.denormalize((String)string.substring(n2 + 7, n3)));
        }
        if ((n2 = string.indexOf(" type=\"", n3)) != -1 && (n3 = string.indexOf(34, n2 + 7)) != -1) {
            iExtendedDataElement.setType(XmlUtility.denormalize((String)string.substring(n2 + 7, n3)));
        }
        if (string.indexOf("<values>", n3) != -1) {
            object = new ArrayList<String>();
            while ((n2 = string.indexOf("<values>", n3)) != -1) {
                if (n2 == -1 || (n3 = string.indexOf("</values>", n2)) == -1) continue;
                ((ArrayList)object).add(XmlUtility.denormalize((String)string.substring(n2 + 8, n3)));
            }
            if (((ArrayList)object).size() > 0) {
                iExtendedDataElement.setValues(((ArrayList)object).toArray(new String[((ArrayList)object).size()]));
            }
        } else {
            n2 = string.indexOf("<hexValue>", n3);
            if (n2 != -1 && (n3 = string.indexOf("</hexValue>", n2)) != -1) {
                object = new String(XmlUtility.denormalize((String)string.substring(n2 + 10, n3)));
                n = ((String)object).length() / 2;
                char[] cArray = new char[n];
                int n4 = 0;
                while (n4 < n) {
                    cArray[n4] = (char)Short.parseShort(((String)object).substring(n4 * 2, n4 * 2 + 2), 16);
                    ++n4;
                }
                iExtendedDataElement.setHexValues(cArray);
            }
        }
        int n5 = 0;
        while ((n2 = string.indexOf("<children ", n3)) != -1) {
            if (string.indexOf("</children>", n2) == -1) break;
            n3 = n2;
            n5 = 0;
            while (n5 >= 0 && (n3 = string.indexOf("children", n3 + 8)) != -1) {
                n = string.charAt(n3 - 1);
                if (n == 47) {
                    --n5;
                    continue;
                }
                if (n != 60) continue;
                ++n5;
            }
            if (n5 >= 0) continue;
            iExtendedDataElement.addChildDataElement(CbeFormatter.loadIExtendedDataElements(string.substring(n2, n3 -= 2)));
        }
        return iExtendedDataElement;
    }

    private static String[] getXMLFragments(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        char c = '\u0000';
        boolean bl = false;
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        while (n4 < string.length()) {
            c = string.charAt(n4);
            if (c == '<') {
                if (n3 == -1) {
                    n3 = n4;
                }
                ++n2;
            } else if (c == '/') {
                if (n == 60) {
                    n2 -= 2;
                }
            } else if (c == '>') {
                if (n == 47) {
                    --n2;
                }
                if (n3 != -1 && n2 == 0) {
                    arrayList.add(string.substring(n3, n4 + 1).trim());
                    n3 = -1;
                }
            } else if (n3 == -1) {
                stringBuffer.append(c);
            }
            if (!Character.isWhitespace(c)) {
                n = c;
            }
            ++n4;
        }
        if (stringBuffer.length() > 0) {
            arrayList.add(stringBuffer.toString().trim());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

