/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.impl;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.AdapterPlugin;
import org.eclipse.hyades.logging.adapter.IComponent;
import org.eclipse.hyades.logging.adapter.IContextListener;
import org.eclipse.hyades.logging.adapter.impl.Component;
import org.eclipse.hyades.logging.adapter.impl.ComponentFactory;
import org.eclipse.hyades.logging.adapter.impl.Context;
import org.eclipse.hyades.logging.adapter.impl.ContextFactory;
import org.eclipse.hyades.logging.adapter.internal.util.AdapterSensor;
import org.eclipse.hyades.logging.adapter.util.AdapterUtilities;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.ICommonBaseEvent;
import org.eclipse.hyades.logging.events.IComponentIdentification;
import org.eclipse.hyades.logging.events.ISimpleEventFactory;
import org.eclipse.hyades.logging.events.SimpleEventFactoryImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Controller
implements Runnable {
    private boolean singleFileInputMode = false;
    private AdapterSensor logger = null;
    private short loggingLevel = (short)76;
    private ISimpleEventFactory eventFactory = null;
    private IComponentIdentification sourceComponentId = null;
    Context[] contexts = null;
    String contextConfigurationFile = Messages.getString("HyadesGADefaultContextConfigurationFile");
    String componentConfigurationFile = Messages.getString("HyadesGADefaultComponentConfigurationsFile");
    private DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
    private InputStream inContextParams = null;
    private InputStream inAppParams = null;
    boolean running = false;
    long sleepTime = 500L;
    Thread[] contextThreads = null;

    public Controller() {
        if (this.eventFactory == null) {
            this.eventFactory = SimpleEventFactoryImpl.getInstance();
        }
        this.sourceComponentId = this.eventFactory.createComponentIdentification();
        this.sourceComponentId.setComponent("Controller");
        this.sourceComponentId.setSubComponent("1");
        this.sourceComponentId.setComponentIdType("controller");
        this.sourceComponentId.setLocation("Test Source Component Location");
        this.sourceComponentId.setLocationType("Test Source Component Location Type");
    }

    public boolean isRunning() {
        return this.running;
    }

    public void start() {
        int n = 0;
        while (n < this.contextThreads.length) {
            if (this.contextThreads[n] != null) {
                this.contextThreads[n].start();
            }
            ++n;
        }
        this.running = true;
    }

    public void stop() {
        if (this.contexts != null) {
            int n = 0;
            while (n < this.contexts.length) {
                if (this.contexts[n] != null) {
                    this.contexts[n].stop();
                }
                ++n;
            }
        }
        this.running = false;
    }

    public void setContextThreads(Thread[] threadArray) {
        this.contextThreads = threadArray;
    }

    public Context[] getContexts() {
        return this.contexts;
    }

    public void setContextConfigPath(String string) {
        this.contextConfigurationFile = string;
    }

    public void setComponentConfigPath(String string) {
        this.componentConfigurationFile = string;
    }

    public void prepareAdapter() throws AdapterException {
        int n;
        Object object;
        try {
            this.inContextParams = new FileInputStream(this.contextConfigurationFile);
            this.contexts = this.createContextsAndComponents(this.inContextParams);
            try {
                if (this.inContextParams != null) {
                    this.inContextParams.close();
                }
            }
            catch (Exception exception) {
                this.log(exception.toString(), (short)30);
            }
            this.inAppParams = this.singleFileInputMode ? new FileInputStream(this.contextConfigurationFile) : new FileInputStream(this.componentConfigurationFile);
            this.setComponentConfigurations(this.inAppParams);
            try {
                if (this.inAppParams != null) {
                    this.inAppParams.close();
                }
            }
            catch (Exception exception) {
                this.log(exception.toString(), (short)30);
            }
            try {
                List list = AdapterPlugin.getContextListeners();
                if (list != null) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        object = (IContextListener)iterator.next();
                        String[] stringArray = object.getTargetContextUniqueIds();
                        int n2 = 0;
                        while (n2 < stringArray.length) {
                            int n3 = 0;
                            while (n3 < this.contexts.length) {
                                if (this.contexts[n3].getUniqueID().equals(stringArray[n2])) {
                                    this.contexts[n3].setContextListener((IContextListener)object);
                                }
                                ++n3;
                            }
                            ++n2;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            n = 0;
            while (n < this.contexts.length) {
                if (this.contexts[n] != null) {
                    this.contexts[n].init();
                    this.contexts[n].update();
                }
                ++n;
            }
            try {
                if (this.inAppParams != null) {
                    this.inAppParams.close();
                }
            }
            catch (Exception exception) {
                this.log(exception.toString(), (short)30);
            }
        }
        catch (Exception exception) {
            this.log(exception.toString(), (short)30);
            throw new AdapterException(exception.getMessage());
        }
        this.contextThreads = new Thread[this.contexts.length];
        n = 0;
        int n4 = 0;
        while (n < this.contexts.length) {
            if (this.contexts[n] != null && this.contexts[n] != null) {
                object = new Thread(this.contexts[n]);
                ((Thread)object).setName(this.contexts[n].getName() + Messages.getString("HyadesGA") + this.contexts[n].getUniqueID());
                ((Thread)object).setDaemon(true);
                this.contextThreads[n4++] = object;
            }
            ++n;
        }
    }

    public void update(Element element) {
    }

    Context[] createContextsAndComponents(InputStream inputStream) {
        Document document = null;
        Context[] contextArray = null;
        try {
            Object object;
            document = this.docFactory.newDocumentBuilder().parse(inputStream);
            Element element = document.createElement(Messages.getString("HyadesGAContextElementTagName"));
            element.setAttribute(Messages.getString("HyadesGADescriptionAttributeName"), "Context instance for the current component");
            element.setAttribute(Messages.getString("HyadesGAExecutableClassAttributeName"), "org.eclipse.hyades.logging.adapter.impl.BasicContext");
            element.setAttribute(Messages.getString("HyadesGAImplemenationCreationDateAttributeName"), "Fri Jan 09 15:27:17 EST 2004");
            element.setAttribute(Messages.getString("HyadesGALoggingLevelAttributeName"), "60");
            element.setAttribute(Messages.getString("HyadesGANameAttributeName"), "BasicContext");
            element.setAttribute(Messages.getString("HyadesGARoleAttributeName"), "context");
            element.setAttribute(Messages.getString("HyadesGARoleCreationDateAttributeName"), "Fri Jan 09 15:27:17 EST 2004");
            element.setAttribute(Messages.getString("HyadesGAUniqueIDAttributeName"), "NB1F4ED002DA11D8A519FBE7C98C2F53");
            Element element2 = document.createElement(Messages.getString("HyadesGAComponentElementTagName"));
            element2.setAttribute(Messages.getString("HyadesGADescriptionAttributeName"), "Adapter logging sensor");
            element2.setAttribute(Messages.getString("HyadesGAExecutableClassAttributeName"), "org.eclipse.hyades.logging.adapter.internal.util.AdapterSensor");
            element2.setAttribute(Messages.getString("HyadesGAImplemenationCreationDateAttributeName"), "Fri Jan 09 15:27:17 EST 2004");
            element2.setAttribute(Messages.getString("HyadesGALoggingLevelAttributeName"), "0");
            element2.setAttribute(Messages.getString("HyadesGANameAttributeName"), "AdapterSensor");
            element2.setAttribute(Messages.getString("HyadesGARoleAttributeName"), "sensor");
            element2.setAttribute(Messages.getString("HyadesGARoleCreationDateAttributeName"), "Fri Jan 09 15:27:17 EST 2004");
            element2.setAttribute(Messages.getString("HyadesGAUniqueIDAttributeName"), "NF991E0004FF11D8930381B6A308BEB5");
            element.appendChild(element2);
            Element element3 = document.createElement(Messages.getString("HyadesGAComponentElementTagName"));
            element3.setAttribute(Messages.getString("HyadesGADescriptionAttributeName"), "Adapter logging outputter");
            element3.setAttribute(Messages.getString("HyadesGAImplemenationCreationDateAttributeName"), "Fri Jan 09 15:27:17 EST 2004");
            element3.setAttribute(Messages.getString("HyadesGAImplementationVersionAttributeName"), "");
            element3.setAttribute(Messages.getString("HyadesGAImplemenationVersionDescriptionAttributeName"), "");
            element3.setAttribute(Messages.getString("HyadesGALoggingLevelAttributeName"), "60");
            element3.setAttribute(Messages.getString("HyadesGARoleAttributeName"), "outputter");
            element3.setAttribute(Messages.getString("HyadesGARoleCreationDateAttributeName"), "Fri Jan 09 15:27:17 EST 2004");
            element3.setAttribute(Messages.getString("HyadesGAUniqueIDAttributeName"), "N5F286A002DA11D8BC799C6AF4352915");
            if (AdapterUtilities.isWorkbench()) {
                element3.setAttribute(Messages.getString("HyadesGAExecutableClassAttributeName"), "org.eclipse.hyades.logging.adapter.outputters.CBEEclipseErrorDialogOutputter");
                element3.setAttribute(Messages.getString("HyadesGANameAttributeName"), "CBEEclipseErrorDialogOutputter");
            } else {
                element3.setAttribute(Messages.getString("HyadesGAExecutableClassAttributeName"), "org.eclipse.hyades.logging.adapter.outputters.CBEFileOutputter");
                element3.setAttribute(Messages.getString("HyadesGANameAttributeName"), "CBEFileOutputter");
            }
            element.appendChild(element3);
            NodeList nodeList = document.getElementsByTagName(Messages.getString("HyadesGAContextsElementTagName"));
            if (nodeList.getLength() == 0) {
                object = document.createElement(Messages.getString("HyadesGAContextsElementTagName"));
                object.appendChild(element);
                document.getDocumentElement().appendChild((Node)object);
            } else {
                object = nodeList.item(0);
                object.appendChild(element);
                document.getDocumentElement().appendChild((Node)object);
            }
            try {
                object = document.getElementsByTagName(Messages.getString("HyadesGAContextElementTagName"));
                NodeList nodeList2 = document.getElementsByTagName(Messages.getString("HyadesGAContextInstanceElementTagName"));
                this.singleFileInputMode = nodeList2.getLength() > 0;
                int n = object.getLength();
                contextArray = new Context[n];
                int n2 = 0;
                Element element4 = null;
                Context context = null;
                Component component = null;
                int n3 = 0;
                while (n3 < n) {
                    element4 = (Element)object.item(n3);
                    context = ContextFactory.buildContext(element4.getAttribute(Messages.getString("HyadesGAExecutableClassAttributeName")), element4.getAttribute(Messages.getString("HyadesGAUniqueIDAttributeName")), element4.getAttribute(Messages.getString("HyadesGANameAttributeName")));
                    context.setContextConfiguration(element4);
                    NodeList nodeList3 = element4.getElementsByTagName(Messages.getString("HyadesGAComponentElementTagName"));
                    IComponent[] iComponentArray = null;
                    int n4 = nodeList3.getLength();
                    iComponentArray = new IComponent[n4];
                    int n5 = 0;
                    int n6 = 0;
                    while (n5 < n4) {
                        element4 = (Element)nodeList3.item(n5);
                        String string = element4.getAttribute(Messages.getString("HyadesGAExecutableClassAttributeName"));
                        String string2 = element4.getAttribute(Messages.getString("HyadesGANameAttributeName"));
                        component = ComponentFactory.buildComponent(element4.getAttribute(Messages.getString("HyadesGAExecutableClassAttributeName")), element4.getAttribute(Messages.getString("HyadesGAUniqueIDAttributeName")), element4.getAttribute(Messages.getString("HyadesGANameAttributeName")));
                        component.setContextConfiguration(element4);
                        iComponentArray[n6++] = component;
                        ++n5;
                    }
                    context.setComponents(iComponentArray);
                    contextArray[n2++] = context;
                    ++n3;
                }
            }
            catch (Exception exception) {
                this.log(exception.toString(), (short)30);
                return null;
            }
        }
        catch (SAXException sAXException) {
            this.log(sAXException.toString(), (short)30);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.log(parserConfigurationException.toString(), (short)30);
        }
        catch (IOException iOException) {
            this.log(iOException.toString(), (short)30);
        }
        return contextArray;
    }

    void setComponentConfigurations(InputStream inputStream) {
        Document document = null;
        try {
            Object object;
            Object object2;
            document = this.docFactory.newDocumentBuilder().parse(inputStream);
            Element element = document.createElement(Messages.getString("HyadesGAAdapterCBESensorTypeTagName"));
            Element element2 = document.createElement(Messages.getString("HyadesGASensorTagName"));
            element2.setAttribute(Messages.getString("HyadesGADescriptionAttributeName"), "An adapter CBE sensor");
            element2.setAttribute(Messages.getString("HyadesGAmaximumBlockingAttributeName"), "5");
            element2.setAttribute(Messages.getString("HyadesGAtypeAttributeName"), "AdapterCBESensor");
            element2.setAttribute(Messages.getString("HyadesGAUniqueIDAttributeName"), "NF991E0004FF11D8930381B6A308BEB5");
            element2.appendChild(element);
            Element element3 = document.createElement(Messages.getString("HyadesGAContextInstanceElementTagName"));
            element3.setAttribute(Messages.getString("HyadesGADescriptionAttributeName"), "Context instance for the current component");
            element3.setAttribute(Messages.getString("HyadesGAcontinuousOperationAttributeName"), "false");
            element3.setAttribute(Messages.getString("HyadesGAmaximumIdleTimeAttributeName"), "20000");
            element3.setAttribute(Messages.getString("HyadesGApauseIntervalAttributeName"), "10");
            element3.setAttribute(Messages.getString("HyadesGAUniqueIDAttributeName"), "NB1F4ED002DA11D8A519FBE7C98C2F53");
            element3.appendChild(element2);
            if (AdapterUtilities.isWorkbench()) {
                object2 = document.createElement(Messages.getString("HyadesGAEclipseErrorDialogOutputterTypeTagName"));
                object = document.createElement(Messages.getString("HyadesGAOutputterTagName"));
                object.setAttribute(Messages.getString("HyadesGADescriptionAttributeName"), "Eclipse error dialog outputter");
                object.setAttribute(Messages.getString("HyadesGAtypeAttributeName"), "EclipseErrorDialogOutputter");
                object.setAttribute(Messages.getString("HyadesGAUniqueIDAttributeName"), "N5F286A002DA11D8BC799C6AF4352915");
                object.appendChild((Node)object2);
                element3.appendChild((Node)object);
            } else {
                object2 = document.createElement(Messages.getString("HyadesGASingleFileOutputterTypeTagName"));
                object2.setAttribute(Messages.getString("HyadesGAdirectoryAttributeName"), ".");
                object2.setAttribute(Messages.getString("HyadesGAfileNameAttributeName"), "hgla.log");
                object = document.createElement(Messages.getString("HyadesGAOutputterTagName"));
                object.setAttribute(Messages.getString("HyadesGADescriptionAttributeName"), "Single file outputter");
                object.setAttribute(Messages.getString("HyadesGAtypeAttributeName"), "SingleFileOutputter");
                object.setAttribute(Messages.getString("HyadesGAUniqueIDAttributeName"), "N5F286A002DA11D8BC799C6AF4352915");
                object.appendChild((Node)object2);
                element3.appendChild((Node)object);
            }
            object2 = document.getElementsByTagName(Messages.getString("HyadesGAConfigurationTagName"));
            if (object2.getLength() == 0) {
                object = document.createElement(Messages.getString("HyadesGAConfigurationTagName"));
                object.setAttribute(Messages.getString("HyadesGADescriptionAttributeName"), "The component level configurations for this adapter");
                object.setAttribute(Messages.getString("HyadesGAUniqueIDAttributeName"), "N06FBD3004FF11D8BCF4CFA9EA8F31E7");
                object.appendChild(element3);
                document.getDocumentElement().appendChild((Node)object);
            } else {
                object = object2.item(0);
                object.appendChild(element3);
                document.getDocumentElement().appendChild((Node)object);
            }
            try {
                object = document.getElementsByTagName(Messages.getString("HyadesGAContextInstanceElementTagName"));
                int n = object.getLength();
                int n2 = 0;
                while (n2 < n) {
                    try {
                        Element element4 = (Element)object.item(n2);
                        String string = element4.getAttribute(Messages.getString("HyadesGAUniqueIDAttributeName"));
                        int n3 = this.contexts.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            if (this.contexts[n4].getUniqueID().equals(string)) {
                                this.contexts[n4].setConfiguration(element4);
                                NodeList nodeList = element4.getChildNodes();
                                int n5 = nodeList.getLength();
                                int n6 = 0;
                                while (n6 < n5) {
                                    if (nodeList.item(n6).getNodeType() == 1) {
                                        Element element5 = (Element)nodeList.item(n6);
                                        String string2 = element5.getAttribute(Messages.getString("HyadesGAUniqueIDAttributeName"));
                                        IComponent[] iComponentArray = this.contexts[n4].getComponents();
                                        int n7 = iComponentArray.length;
                                        int n8 = 0;
                                        while (n8 < n7) {
                                            if (iComponentArray[n8].getUniqueID().equals(string2)) {
                                                iComponentArray[n8].setConfiguration(element5);
                                                break;
                                            }
                                            ++n8;
                                        }
                                    }
                                    ++n6;
                                }
                                break;
                            }
                            ++n4;
                        }
                    }
                    catch (Exception exception) {
                        this.log(exception.toString(), (short)30);
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                this.log(exception.toString(), (short)30);
                return;
            }
        }
        catch (SAXException sAXException) {
            this.log(sAXException.toString(), (short)30);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.log(parserConfigurationException.toString(), (short)30);
        }
        catch (IOException iOException) {
            this.log(iOException.toString(), (short)30);
        }
    }

    public void run() {
        this.start();
        while (this.isRunning()) {
            Controller controller = this;
            synchronized (controller) {
                try {
                    this.wait(this.sleepTime);
                }
                catch (Exception exception) {
                    this.log(exception.toString(), (short)30);
                }
                if (this.areContextsDone()) {
                    this.stop();
                }
            }
        }
    }

    boolean areContextsDone() {
        if (this.contextThreads != null) {
            int n = 0;
            while (n < this.contextThreads.length) {
                if (this.contextThreads[n] != null && this.contextThreads[n].isAlive()) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    private void clean() {
        int n;
        if (this.contexts != null) {
            n = 0;
            while (n < this.contexts.length) {
                this.contexts[n] = null;
                ++n;
            }
        }
        this.contexts = null;
        if (this.contextThreads != null) {
            n = 0;
            while (n < this.contexts.length) {
                this.contextThreads[n] = null;
                ++n;
            }
        }
        this.contextThreads = null;
    }

    public AdapterSensor getLogger() {
        if (this.logger == null) {
            this.logger = AdapterSensor.getInstance();
        }
        return this.logger;
    }

    public ISimpleEventFactory getEventFactory() {
        if (this.eventFactory == null) {
            this.eventFactory = SimpleEventFactoryImpl.getInstance();
        }
        return this.eventFactory;
    }

    public void log(String string, short s) {
        if (s <= this.loggingLevel) {
            ICommonBaseEvent iCommonBaseEvent = this.getEventFactory().createCommonBaseEvent();
            iCommonBaseEvent.setSourceComponentId(this.sourceComponentId);
            iCommonBaseEvent.setCreationTime(System.currentTimeMillis());
            iCommonBaseEvent.setSeverity(s);
            iCommonBaseEvent.setMsg(string);
            this.getLogger().addEvent(iCommonBaseEvent);
        }
    }
}

