/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.sensors;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.impl.Sensor;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SingleOSFileSensor
extends Sensor {
    private String directory = null;
    private String fileName = null;
    private String converterCommand = null;
    private String converterShell = null;
    private String rawLogFileName = null;
    private File inputFile = null;
    private FileReader rawLogIn = null;
    private BufferedPeriodicReader input = null;
    private String[] lastLine = new String[this.maximumBlocking];
    private Object currentThreadLock = new Object();
    private int childThreadsDone = 0;

    public void stop() {
        super.stop();
        this.clean();
    }

    public void update() throws AdapterInvalidConfig {
        super.update();
        this.lastLine = new String[this.maximumBlocking];
        String string = null;
        String string2 = null;
        String string3 = null;
        Element element = null;
        Element element2 = this.getConfiguration();
        NodeList nodeList = element2.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n).getNodeType() == 1) {
                element = (Element)nodeList.item(n);
            }
            ++n;
        }
        if (element.hasAttribute(Messages.getString("HyadesGAdirectoryAttributeName"))) {
            string = element.getAttribute(Messages.getString("HyadesGAdirectoryAttributeName"));
        }
        if (element.hasAttribute(Messages.getString("HyadesGAfileNameAttributeName"))) {
            string2 = element.getAttribute(Messages.getString("HyadesGAfileNameAttributeName"));
        }
        if (element.hasAttribute(Messages.getString("HyadesGAexpirationAttributeName"))) {
            string3 = element.getAttribute(Messages.getString("HyadesGAexpirationAttributeName"));
        }
        this.setDirectory(string);
        this.setFileName(string2);
        String string4 = element.getAttribute(Messages.getString("HyadesGAconverterCmdAttributeName"));
        if (string4.length() > 0) {
            this.setConverterCommand(string4);
        }
        if (element.hasAttribute(Messages.getString("HyadesGAconverterShellAttributeName"))) {
            this.converterShell = element.getAttribute(Messages.getString("HyadesGAconverterShellAttributeName"));
            if (this.converterShell.length() == 0) {
                this.converterShell = null;
            }
        }
    }

    public Object[] testGetNext() {
        return this.testGetNextLine();
    }

    public String[] testGetNextLine() {
        String[] stringArray = new String[2];
        stringArray[0] = "test string";
        return stringArray;
    }

    public Object[] getNext() {
        if (this.rawLogFileName == null) {
            String string = System.getProperty("file.separator");
            this.rawLogFileName = this.getDirectory().endsWith(string) ? this.getDirectory() + this.getFileName() : this.getDirectory() + string + this.getFileName();
            if (this.rawLogFileName != null) {
                try {
                    this.input = new BufferedPeriodicReader(this.rawLogFileName, this.converterCommand, this.converterShell);
                }
                catch (Exception exception) {
                    this.log(exception.toString(), (short)50);
                }
            }
        }
        if (this.input != null) {
            int n = 0;
            while (n < this.maximumBlocking) {
                try {
                    this.lastLine[n] = this.input.readLine();
                }
                catch (Exception exception) {
                    this.log(exception.toString(), (short)30);
                }
                if (this.lastLine[n] == null) {
                    n = this.maximumBlocking;
                }
                ++n;
            }
        }
        if (this.lastLine[0] != null) {
            return this.lastLine;
        }
        return null;
    }

    public void clean() {
        try {
            if (this.input != null) {
                this.input.close();
            }
        }
        catch (Exception exception) {
            this.log(exception.toString(), (short)20);
        }
    }

    public final String getDirectory() {
        return this.directory;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final String getConverterCommand() {
        return this.converterCommand;
    }

    public final void setDirectory(String string) {
        this.directory = string;
    }

    public final void setFileName(String string) {
        this.fileName = string;
    }

    public final void setConverterCommand(String string) {
        this.converterCommand = string;
    }

    class ConverterOutputReader
    extends Thread {
        private BufferedReader reader;

        public ConverterOutputReader(InputStream inputStream) {
            this.reader = new BufferedReader(new InputStreamReader(inputStream));
        }

        public void run() {
            try {
                String string;
                while ((string = this.reader.readLine()) != null) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Object object = SingleOSFileSensor.this.currentThreadLock;
            synchronized (object) {
                if (++SingleOSFileSensor.this.childThreadsDone == 2) {
                    SingleOSFileSensor.this.currentThreadLock.notify();
                }
            }
        }
    }

    private class BufferedPeriodicReader {
        private String filename = null;
        private String converter = null;
        private String shell = null;
        private RandomAccessFile fileReader = null;
        long lastBookmark = 0L;

        public BufferedPeriodicReader(String string) {
            this(string, null, null);
        }

        public BufferedPeriodicReader(String string, String string2) {
            this(string, string2, null);
        }

        public BufferedPeriodicReader(String string, String string2, String string3) {
            this.filename = string;
            this.converter = string2;
            this.shell = string3;
            this.prepareFile();
        }

        public boolean prepareFile() {
            if (this.converter != null) {
                try {
                    Process process;
                    Object object = SingleOSFileSensor.this.currentThreadLock;
                    synchronized (object) {
                        SingleOSFileSensor.this.childThreadsDone = 0;
                        String string = System.getProperty("os.name", null);
                        if (string.startsWith("Windows")) {
                            process = Runtime.getRuntime().exec(this.converter);
                        } else if (string.startsWith("AIX")) {
                            if (this.shell == null) {
                                this.shell = "sh";
                            }
                            String[] stringArray = new String[]{this.shell, this.converter};
                            process = Runtime.getRuntime().exec(stringArray);
                        } else {
                            if (this.shell == null) {
                                this.shell = "sh";
                            }
                            String string2 = this.shell + " " + this.converter;
                            process = Runtime.getRuntime().exec(string2);
                        }
                        new ConverterOutputReader(process.getErrorStream()).start();
                        new ConverterOutputReader(process.getInputStream()).start();
                        try {
                            SingleOSFileSensor.this.currentThreadLock.wait(300000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    int n = -1;
                    try {
                        n = process.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        process.destroy();
                    }
                    if (n != 0) {
                        throw new Exception();
                    }
                }
                catch (Exception exception) {
                    SingleOSFileSensor.this.log(exception.toString(), (short)50);
                    return false;
                }
            }
            boolean bl = false;
            try {
                this.fileReader = new RandomAccessFile(this.filename, "r");
            }
            catch (Exception exception) {
                this.fileReader = null;
            }
            try {
                if (this.fileReader != null && this.fileReader.length() > this.lastBookmark) {
                    bl = true;
                }
            }
            catch (IOException iOException) {
                SingleOSFileSensor.this.log(iOException.toString(), (short)30);
            }
            return bl;
        }

        public void close() {
            if (this.fileReader != null) {
                try {
                    this.fileReader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.fileReader = null;
        }

        public String readLine() throws IOException {
            if (this.fileReader == null) {
                this.prepareFile();
                this.fileReader.seek(this.lastBookmark);
            }
            if (this.fileReader != null) {
                String string = null;
                this.fileReader.seek(this.lastBookmark);
                if (this.fileReader != null) {
                    try {
                        string = this.fileReader.readLine();
                    }
                    catch (EOFException eOFException) {
                        string = null;
                    }
                    catch (NullPointerException nullPointerException) {
                        string = null;
                    }
                    if (string != null) {
                        this.lastBookmark = this.fileReader.getFilePointer();
                        return string;
                    }
                    this.close();
                }
            }
            return null;
        }
    }
}

