/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.eclipse.hyades.logging.adapter.Adapter;
import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.ICommonBaseEvent;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.Parser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class StaticParserWrapper
extends Parser {
    private Adapter adapter;
    private String parserName;
    private String agentName;
    private String key = String.valueOf(System.currentTimeMillis());
    protected String newDirectory = null;
    protected String newFileName = null;
    protected String currentPlugin = "org.eclipse.hyades.logging.adapter.config";
    private static Hashtable activeWrappers = new Hashtable();

    public StaticParserWrapper() {
        this.adapter = new Adapter();
        this.parserName = new String(Messages.getString((String)"HyadesGAUnknownNameTag"));
        this.agentName = new String(Messages.getString((String)"HyadesGAUnknownNameTag"));
    }

    public static Log getLogInstance(String string) {
        return (Log)activeWrappers.remove(string);
    }

    public void parse(Log log) throws LogParserException {
        try {
            activeWrappers.put(this.key, log);
            this.adapter.start(false, false);
        }
        catch (AdapterException adapterException) {
            // empty catch block
        }
    }

    public void setUserInput(Hashtable hashtable) throws LogParserException {
        hashtable.put("loggerKey", this.key);
        String string = this.getNewConfigFile(hashtable);
        this.adapter.setContextConfigPath(string);
        this.adapter.setComponentConfigPath(string);
    }

    public String getName() {
        return this.agentName;
    }

    public ICommonBaseEvent[] parseNext() throws LogParserException {
        return null;
    }

    public String getVersion() {
        return null;
    }

    private InputStream getConfigInputStream(String string) throws LogParserException {
        try {
            String string2 = System.getProperty("file.separator");
            if (string.indexOf(47) != -1 && string2 != "/") {
                string = string.replace('/', string2.charAt(0));
            }
            if (string.startsWith("." + string2)) {
                string = string.substring(2);
            }
            return new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new LogParserException(Messages.getString((String)"Cannot find configuration file"));
        }
        catch (SecurityException securityException) {
            throw new LogParserException(Messages.getString((String)"Cannot open configuration file"));
        }
    }

    private String getNewConfigFile(Hashtable hashtable) throws LogParserException {
        File file;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Comparable<Boolean> comparable;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Document document = null;
        String string = (String)hashtable.get(Messages.getString((String)"HyadesGALogVersionTagName"));
        String string2 = null;
        if (string == null) {
            string = Messages.getString((String)"HyadesGADefaultLogVersionTagName");
        }
        if ((string2 = (String)hashtable.get(string)) == null && (string2 = (String)hashtable.get(Messages.getString((String)"HyadesGADefaultLogVersionTagName"))) == null) {
            throw new LogParserException(Messages.getString((String)"Cannot find configuration file"));
        }
        InputStream inputStream = null;
        try {
            comparable = Boolean.TRUE;
            object5 = Class.forName("org.eclipse.core.runtime.Path");
            Constructor<?> constructor = ((Class)object5).getConstructor(string2.getClass());
            Object obj = constructor.newInstance(string2);
            object4 = Class.forName("org.eclipse.core.runtime.Platform");
            object3 = Class.forName("org.eclipse.core.runtime.Plugin");
            object2 = ((Class)object4).getMethod("getPlugin", this.currentPlugin.getClass()).invoke(null, this.currentPlugin);
            inputStream = (InputStream)((Class)object3).getMethod("openStream", Class.forName("org.eclipse.core.runtime.IPath"), Boolean.TYPE).invoke(object2, obj, comparable);
        }
        catch (ClassNotFoundException classNotFoundException) {
            inputStream = this.getConfigInputStream(string2);
        }
        catch (InvocationTargetException invocationTargetException) {
            inputStream = this.getConfigInputStream(string2);
        }
        catch (Exception exception) {
            throw new LogParserException(Messages.getString((String)("Cannot get configuration file " + string2 + ".  Exception occurred: " + exception.getMessage())));
        }
        comparable = new File(((String)hashtable.get(Messages.getString((String)"HyadesGAInputLogFilenameTag"))).trim());
        try {
            document = documentBuilderFactory.newDocumentBuilder().parse(inputStream);
        }
        catch (SAXException sAXException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return null;
        }
        catch (Exception exception) {
            return null;
        }
        object5 = document.getElementsByTagName(Messages.getString((String)"HyadesGASensorTagName"));
        int n = object5.getLength();
        int n2 = 0;
        while (n2 < n) {
            object4 = (Element)object5.item(n2);
            object3 = null;
            object2 = object4.getChildNodes();
            int n3 = 0;
            while (n3 < object2.getLength()) {
                if (object2.item(n3).getNodeType() == 1) {
                    object3 = (Element)object2.item(n3);
                    n3 = object2.getLength();
                }
                ++n3;
            }
            if (object3 != null) {
                Node node;
                String string3;
                Object object6;
                object = object3.getElementsByTagName(Messages.getString((String)"HyadesGASensorPropertyTagName"));
                int n4 = object.getLength();
                int n5 = 0;
                while (n5 < n4) {
                    object6 = (Element)object.item(n5);
                    String string4 = object6.getAttribute(Messages.getString((String)"HyadesGASensorPropertyNameTag"));
                    string3 = (String)hashtable.get(string4);
                    if (string3 != null) {
                        object6.setAttribute(Messages.getString((String)"HyadesGASensorPropertyValueTag"), string3.trim());
                    }
                    ++n5;
                }
                object6 = object3.getAttributes();
                int n6 = object6.getLength();
                int n7 = 0;
                while (n7 < n6) {
                    node = object6.item(n7);
                    String string5 = node.getNodeName();
                    if (string5.equals(Messages.getString((String)"HyadesGAdirectoryAttributeName"))) {
                        node.setNodeValue(((File)comparable).getParent());
                    } else if (string5.equals(Messages.getString((String)"HyadesGAfileNameAttributeName"))) {
                        node.setNodeValue(((File)comparable).getName());
                    } else if (string5.equals(Messages.getString((String)"HyadesGAstaticParserClassAttributeName"))) {
                        this.parserName = node.getNodeValue();
                    } else if (string5.equals(Messages.getString((String)"HyadesGAconverterCmdAttributeName"))) {
                        string3 = this.modifyConverter(node.getNodeValue(), string2, hashtable, (File)comparable);
                        node.setNodeValue(string3);
                    } else {
                        String string6 = (String)hashtable.get(string5);
                        if (string6 != null) {
                            node.setNodeValue(string6.trim());
                        }
                    }
                    ++n7;
                }
                if (this.newDirectory != null) {
                    node = object3.getAttributeNode(Messages.getString((String)"HyadesGAdirectoryAttributeName"));
                    node.setNodeValue(this.newDirectory);
                }
                if (this.newFileName != null) {
                    node = object3.getAttributeNode(Messages.getString((String)"HyadesGAfileNameAttributeName"));
                    node.setNodeValue(this.newFileName);
                }
            }
            ++n2;
        }
        object4 = document.getElementsByTagName(Messages.getString((String)"HyadesGAOutputterTagName"));
        int n8 = object4.getLength();
        int n9 = 0;
        while (n9 < n8) {
            Element element = (Element)object4.item(n9);
            object = element.getOwnerDocument().createElement(Messages.getString((String)"HyadesGAOutputterPropertyTagName"));
            object.setAttribute(Messages.getString((String)"HyadesGAStaticParserLoggerKeyName"), this.key);
            element.appendChild((Node)object);
            ++n9;
        }
        try {
            file = File.createTempFile("GLA", ".adapter");
        }
        catch (Exception exception) {
            File file2 = new File(string2);
            String string7 = new String("GLA" + System.currentTimeMillis() + ".adapter");
            file = new File(file2.getParent(), string7);
        }
        file.deleteOnExit();
        this.saveConfigFile(document, file);
        return file.getAbsolutePath();
    }

    protected String modifyConverter(String string, String string2, Hashtable hashtable, File file) {
        return string;
    }

    private void saveConfigFile(Document document, File file) {
        String string = System.getProperty("os.name", null);
        OutputFormat outputFormat = new OutputFormat(document);
        if (string.startsWith("Windows")) {
            outputFormat.setLineSeparator("\r\n");
        } else if (string.equals("z/OS") || string.equals("OS/390")) {
            outputFormat.setEncoding("IBM-1047");
        }
        outputFormat.setIndenting(true);
        outputFormat.setLineWidth(0);
        outputFormat.setPreserveSpace(true);
        try {
            XMLSerializer xMLSerializer = new XMLSerializer((Writer)new FileWriter(file), outputFormat);
            xMLSerializer.asDOMSerializer();
            xMLSerializer.serialize(document);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

