/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.eclipse.hyades.internal.logging.core.Constants;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.LoggingParsersPlugin;

public final class ParserUtilities {
    private static ResourceBundle resourceBundle = null;

    public static String getResourceString(String string) {
        if (resourceBundle == null) {
            try {
                resourceBundle = LoggingParsersPlugin.getResourceBundle();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (resourceBundle == null) {
                try {
                    resourceBundle = ResourceBundle.getBundle("org.eclipse.hyades.logging.parsers.properties.plugin", Locale.getDefault());
                }
                catch (MissingResourceException missingResourceException) {
                    return string;
                }
            }
        }
        try {
            return resourceBundle.getString(string.trim()).trim();
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static String getResourceString(String string, String string2) {
        return ParserUtilities.getResourceString(string, new String[]{string2});
    }

    public static String getResourceString(String string, String string2, String string3) {
        return ParserUtilities.getResourceString(string, new String[]{string2, string3});
    }

    public static String getResourceString(String string, String string2, String string3, String string4) {
        return ParserUtilities.getResourceString(string, new String[]{string2, string3, string4});
    }

    public static String getResourceString(String string, String[] stringArray) {
        try {
            return MessageFormat.format(ParserUtilities.getResourceString(string), stringArray);
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static void exceptionHandler(Throwable throwable, long l, String string, String string2) throws LogParserException {
        StringBuffer stringBuffer = new StringBuffer(ParserUtilities.getResourceString("INVALID_LINE_NUMBER_ERROR_", String.valueOf(l)));
        String string3 = Constants.LINE_SEPARATOR;
        stringBuffer.append(':').append(string3).append(string3).append(string).append(string3);
        String string4 = null;
        if (throwable != null) {
            string4 = throwable.getMessage();
        }
        if (string4 != null && string4.length() > 0) {
            stringBuffer.append(string4).append(string3);
        }
        stringBuffer.append(string2);
        LogParserException logParserException = new LogParserException(stringBuffer.toString(), throwable);
        logParserException.fillInStackTrace();
        throw logParserException;
    }

    public static void exceptionHandler(Throwable throwable, String string) throws LogParserException {
        String string2 = Constants.LINE_SEPARATOR;
        StringBuffer stringBuffer = new StringBuffer();
        if (throwable != null && throwable.getMessage() != null && throwable.getMessage().length() > 0) {
            stringBuffer.append(throwable.getMessage()).append(string2);
        }
        stringBuffer.append(string);
        LogParserException logParserException = new LogParserException(stringBuffer.toString(), throwable);
        logParserException.fillInStackTrace();
        throw logParserException;
    }

    public static boolean isValidIPAddress(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
        if (stringTokenizer.countTokens() == 7) {
            try {
                int n = Integer.parseInt(stringTokenizer.nextToken());
                if (n >= 0 && n <= 255 && stringTokenizer.nextToken().equals(".") && (n = Integer.parseInt(stringTokenizer.nextToken())) >= 0 && n <= 255 && stringTokenizer.nextToken().equals(".") && (n = Integer.parseInt(stringTokenizer.nextToken())) >= 0 && n <= 255 && stringTokenizer.nextToken().equals(".") && (n = Integer.parseInt(stringTokenizer.nextToken())) >= 0 && n <= 255) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }
}

