/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.extractors;

import org.eclipse.hyades.logging.adapter.MessageString;
import org.eclipse.hyades.logging.adapter.impl.Extractor;
import org.eclipse.hyades.logging.adapter.util.Messages;

public class SimpleExtractor
extends Extractor {
    private int arraySize = 8;
    private int messageArraySize = 8;
    private int lastAddedString = -1;
    private int lastAddedMessage = -1;
    private int lastRemovedString = -1;
    protected String searchString;
    private String[] inputStrings = new String[this.arraySize];
    private StringPosition start;
    private StringPosition end;
    private StringPosition adjustedStart;
    private StringPosition adjustedEnd;
    private MessageString[] finalResult;
    private String localLineSeparator = System.getProperty("line.separator");

    public MessageString[] processStrings(String[] stringArray) {
        int n;
        this.finalResult = new MessageString[this.messageArraySize];
        if (stringArray != null) {
            n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] != null) {
                    this.addString(stringArray[n]);
                }
                stringArray[n] = null;
                ++n;
            }
        }
        if (this.lastAddedString == this.lastRemovedString) {
            return null;
        }
        if (!this.getContainsLineBreaks()) {
            this.processSeparateLines();
        } else {
            this.processMultipleLines();
        }
        if (this.finalResult != null) {
            n = 0;
            while (n < this.finalResult.length) {
                if (this.finalResult[n] != null) {
                    this.log(Messages.getString("HyadesGA_CBE_Simple_Extractor_Message_Info", this.finalResult[n].getValue()), (short)76);
                }
                ++n;
            }
        }
        return this.finalResult;
    }

    private void processSeparateLines() {
        int n = this.lastRemovedString + 1;
        while (n <= this.lastAddedString) {
            int n2 = 0;
            this.searchString = this.buildString(n, n2, n, this.inputStrings[n].length() - 1);
            int n3 = this.searchString.length() - 1;
            this.processSearchString(n2, n3);
            String string = null;
            if (n == this.lastAddedString && this.start != null && this.end == null) {
                string = this.inputStrings[n].substring(this.start.getStartPosition(), n3);
            }
            this.lastRemovedString = n;
            if (n == this.lastAddedString && this.start != null && this.end == null) {
                this.addString(string);
            }
            ++n;
        }
    }

    private void processMultipleLines() {
        int n = 0;
        this.searchString = this.buildString(this.lastRemovedString + 1, n, this.lastAddedString, this.inputStrings[this.lastAddedString].length() - 1);
        int n2 = this.searchString.length() - 1;
        this.processSearchString(n, n2);
        String string = null;
        if (this.start != null && this.end == null) {
            string = this.searchString.substring(this.start.getStartPosition(), n2 + 1);
        }
        if (this.end != null && (this.getEndPattern() == null || this.getEndPattern().length() < 1)) {
            string = this.searchString.substring(this.end.getStartPosition(), n2 + 1);
        }
        this.lastRemovedString = this.lastAddedString;
        if (this.flushingMode && (this.getEndPattern() == null || this.getEndPattern().length() < 1) && this.start != null && this.end == null) {
            this.adjustAndAddMessage(this.start, new StringPosition(n2 + 1, n2 + 1));
        } else if (string != null) {
            this.addString(string);
        }
    }

    private void processSearchString(int n, int n2) {
        MessageString[] messageStringArray = new MessageString[this.lastAddedString - this.lastRemovedString];
        boolean bl = false;
        while (!bl) {
            this.start = null;
            this.end = null;
            this.adjustedStart = null;
            this.adjustedEnd = null;
            this.start = this.getStartPattern() != null && this.getStartPattern().length() > 0 ? this.search(this.getStartPattern(), n) : new StringPosition(n, n);
            if (this.start != null) {
                this.end = this.getEndPattern() != null && this.getEndPattern().length() > 0 ? this.search(this.getEndPattern(), n) : this.search(this.getStartPattern(), this.start.getEndPosition() + 1);
            }
            if (this.end == null || this.end.getEndPosition() >= n2) {
                bl = true;
            } else {
                n = this.getIncludeEndPattern() ? this.end.getEndPosition() + 1 : this.end.getStartPosition();
            }
            if (this.end != null && this.start != null && this.start.getStartPosition() >= this.end.getEndPosition()) {
                this.start = null;
                n = this.end.getEndPosition() + 1;
            }
            if (this.start == null || this.end == null) continue;
            this.adjustAndAddMessage(this.start, this.end);
        }
    }

    protected void adjustAndAddMessage(StringPosition stringPosition, StringPosition stringPosition2) {
        this.adjustedStart = this.getIncludeStartPattern() || this.getStartPattern().compareTo("^") == 0 || this.getStartPattern().length() < 1 ? stringPosition : new StringPosition(stringPosition.getEndPosition() + 1, stringPosition.getEndPosition() + 1);
        if (this.getIncludeEndPattern()) {
            int n = this.searchString.length() - 1;
            int n2 = this.searchString.length() - 1;
            this.adjustedEnd = this.end.getEndPosition() > n || this.end.getStartPosition() > n2 ? new StringPosition(n2, n) : stringPosition2;
        } else {
            this.adjustedEnd = new StringPosition(stringPosition2.getStartPosition() - 1, stringPosition2.getStartPosition() - 1);
        }
        this.addMessageString(this.createAndPopulateMessageString(this.adjustedStart, this.adjustedEnd));
    }

    private MessageString createAndPopulateMessageString(StringPosition stringPosition, StringPosition stringPosition2) {
        int n = stringPosition.getStartPosition();
        int n2 = stringPosition2.getEndPosition();
        if (n < 0 || n2 < 0) {
            return null;
        }
        MessageString messageString = new MessageString();
        if (n > n2) {
            messageString.setValue("");
        } else {
            messageString.setValue(this.searchString.substring(n, n2 + 1));
        }
        return messageString;
    }

    private void addMessageString(MessageString messageString) {
        if (messageString == null) {
            return;
        }
        if (this.lastAddedMessage + 1 >= this.finalResult.length) {
            this.increaseMessageStringArraySize();
        }
        this.finalResult[++this.lastAddedMessage] = messageString;
    }

    private void increaseMessageStringArraySize() {
        MessageString[] messageStringArray = new MessageString[this.messageArraySize * 2];
        System.arraycopy(this.finalResult, 0, messageStringArray, 0, this.messageArraySize);
        this.messageArraySize *= 2;
        this.finalResult = messageStringArray;
    }

    private String getNextString() {
        if (this.lastAddedString == -1 || this.lastRemovedString == this.lastAddedString) {
            return null;
        }
        return this.inputStrings[this.lastRemovedString + 1];
    }

    private void addString(String string) {
        if (this.lastAddedString + 1 >= this.inputStrings.length) {
            this.increaseStringArraySize();
        }
        this.inputStrings[++this.lastAddedString] = string;
    }

    private void increaseStringArraySize() {
        String[] stringArray = new String[this.arraySize * 2];
        this.arraySize *= 2;
        this.compressStringArrayInto(stringArray);
        this.inputStrings = stringArray;
    }

    private void compressStringArrayInto(String[] stringArray) {
        System.arraycopy(this.inputStrings, this.lastRemovedString + 1, stringArray, 0, this.lastAddedString - this.lastRemovedString);
        this.lastAddedString = this.lastAddedString - this.lastRemovedString - 1;
        this.lastRemovedString = -1;
    }

    protected StringPosition search(String string, int n) {
        int n2 = -1;
        if (string != null) {
            n2 = this.searchString.indexOf(string, n);
        }
        if (n2 > -1) {
            if (string.length() < 1) {
                return new StringPosition(n2, n2);
            }
            return new StringPosition(n2, n2 + string.length() - 1);
        }
        return null;
    }

    private String buildString(int n, int n2, int n3, int n4) {
        String string = "";
        int n5 = n;
        while (n5 <= n3) {
            int n6 = n5 == n ? n2 : 0;
            int n7 = n5 == n3 ? n4 + 1 : this.inputStrings[n5].length();
            if (n5 != n) {
                if (this.getReplaceLineBreaks()) {
                    if (this.getLineBreakSymbol() != null) {
                        string = string + this.getLineBreakSymbol();
                    }
                } else {
                    string = string + this.localLineSeparator;
                }
            }
            string = string + this.inputStrings[n5].substring(n6, n7);
            ++n5;
        }
        return string;
    }

    protected class Position
    extends StringPosition {
        private int arrayIndex;
        private int startPosition;
        private int endPosition;

        Position(int n, int n2, int n3) {
            super(n2, n3);
            this.arrayIndex = n;
        }

        int getArrayIndex() {
            return this.arrayIndex;
        }
    }

    protected class StringPosition {
        private int startPosition;
        private int endPosition;

        StringPosition(int n, int n2) {
            this.startPosition = n;
            this.endPosition = n2;
        }

        int getStartPosition() {
            return this.startPosition;
        }

        int getEndPosition() {
            return this.endPosition;
        }
    }
}

