/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.collection.framework;

import java.security.Provider;
import org.eclipse.hyades.execution.security.IConnectionHandler;
import org.eclipse.hyades.execution.security.IKeystoreManager;
import org.eclipse.hyades.execution.security.ISecureServerParameters;
import org.eclipse.hyades.internal.collection.framework.ConnectionHandlerImpl;

public class SecureServer
implements ISecureServerParameters {
    private int port;
    private boolean clientAuthenticationRequired;
    private String keystoreFile;
    private String keystorePassword;
    private Provider provider;
    private IKeystoreManager manager;
    IConnectionHandler connectionHandler;
    private String[] ciphers;
    private String[] protos;

    public int getPort() {
        return this.port;
    }

    public boolean clientAuthenticationRequired() {
        return this.clientAuthenticationRequired;
    }

    public Provider getSecurityProvider() {
        return this.provider;
    }

    public IConnectionHandler getConnectionHandler() {
        if (this.connectionHandler == null) {
            this.connectionHandler = new ConnectionHandlerImpl();
        }
        return this.connectionHandler;
    }

    public String getKeystoreFileName() {
        return this.keystoreFile;
    }

    public String getKeystoreFilepassword() {
        return this.keystorePassword;
    }

    public IKeystoreManager getKeystoreManager() {
        return this.manager;
    }

    public String[] getEnabledCipherSuites() {
        return this.ciphers;
    }

    public String[] getEnabledProtocols() {
        return this.protos;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setClientAuthenticationRequired(boolean bl) {
        this.clientAuthenticationRequired = bl;
    }

    public void setKeystoreFile(String string) {
        this.keystoreFile = string;
    }

    public void setKeystorePassword(String string) {
        this.keystorePassword = string;
    }

    public void setSecurityProvider(String string) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> clazz = Class.forName(string);
        this.provider = (Provider)clazz.newInstance();
    }

    public void setKeystoreManager(String string) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> clazz = Class.forName(string);
        this.manager = (IKeystoreManager)clazz.newInstance();
    }

    public void setCipherSuites(String[] stringArray) {
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = stringArray[n].trim();
                System.out.println(stringArray[n]);
                ++n;
            }
        }
        this.ciphers = stringArray;
    }

    public void setProtocols(String[] stringArray) {
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = stringArray[n].trim();
                System.out.println(stringArray[n]);
                ++n;
            }
        }
        this.protos = stringArray;
    }
}

