/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.core;

public class XmlUtility {
    public static String normalize(String string) {
        if (string == null) {
            return "null";
        }
        if (string.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '>') {
                stringBuffer.append("&gt;");
            } else if (c == '&') {
                stringBuffer.append("&amp;");
            } else if (c == '\"') {
                stringBuffer.append("&quot;");
            } else if (c == '\'') {
                stringBuffer.append("&apos;");
            } else if (c == '\t') {
                stringBuffer.append("&#x9;");
            } else if (c == '\n') {
                stringBuffer.append("&#xA;");
            } else if (c == '\r') {
                stringBuffer.append("&#xD;");
            } else if (c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff') {
                stringBuffer.append(c);
            } else {
                stringBuffer.append('?');
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String denormalize(String string) {
        if (string == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        char c = '\u0000';
        int n = -1;
        String string2 = null;
        int n2 = 0;
        while (n2 < string.length()) {
            c = string.charAt(n2);
            if (c == '&' && (n = string.indexOf(59, n2 + 1)) != -1) {
                string2 = string.substring(n2 + 1, n).trim();
                if (string2.equals("lt")) {
                    stringBuffer.append('<');
                } else if (string2.equals("gt")) {
                    stringBuffer.append('>');
                } else if (string2.equals("amp")) {
                    stringBuffer.append('&');
                } else if (string2.equals("quot")) {
                    stringBuffer.append('\"');
                } else if (string2.equals("apos")) {
                    stringBuffer.append('\'');
                } else if (string2.equals("#x9")) {
                    stringBuffer.append('\t');
                } else if (string2.equals("#xA")) {
                    stringBuffer.append('\n');
                } else if (string2.equals("#xD")) {
                    stringBuffer.append('\r');
                } else {
                    stringBuffer.append('&');
                    stringBuffer.append(string2);
                    stringBuffer.append(';');
                }
                n2 = n;
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }
}

