/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.manual.runner;

import org.eclipse.hyades.test.common.event.ExecutionEvent;
import org.eclipse.hyades.test.manual.runner.RemoteAppResourceBundle;
import org.eclipse.hyades.test.manual.runner.model.TestInvocation;
import org.eclipse.hyades.test.manual.runner.model.TestSuite;
import org.eclipse.hyades.test.manual.runner.model.util.EventLogger;
import org.eclipse.hyades.test.manual.runner.model.util.ModelUtil;
import org.eclipse.hyades.test.manual.runner.model.util.ScriptParser;
import org.eclipse.hyades.test.manual.runner.ui.RemoteAppFrame;

public class RemoteApp {
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            throw new IllegalArgumentException("args.lenght must be equals 1");
        }
        ModelUtil.setEventLogger(new EventLogger(){

            public void log(ExecutionEvent executionEvent) {
                if (executionEvent != null) {
                    System.out.println(executionEvent.toString());
                }
            }
        });
        new RemoteApp().initialize(stringArray[0]);
        new RemoteAppFrame().show();
    }

    protected void initialize(String string) throws Exception {
        RemoteAppResourceBundle.initialize();
        TestInvocation.addListener(ModelUtil.DEFAULT_EXECUTION_MANAGER);
        ScriptParser scriptParser = new ScriptParser();
        TestSuite testSuite = scriptParser.parse(string.getBytes("UTF-8"));
        if (testSuite == null) {
            System.err.println("\n" + string);
            throw new IllegalArgumentException(RemoteAppResourceBundle.getString("exception.parse.Fail"));
        }
        ModelUtil.DEFAULT_EXECUTION_MANAGER.setRoot(testSuite);
        ModelUtil.DEFAULT_EXECUTION_MANAGER.registerTestInvocations(scriptParser.getTestInvocations());
        ModelUtil.setVerdicts(scriptParser.getVerdics());
        scriptParser.dispose();
    }
}

