/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.commons;

import org.apache.commons.logging.Log;
import org.eclipse.hyades.internal.logging.core.XmlGenerator;
import org.eclipse.hyades.logging.core.IExternalizableToXml;
import org.eclipse.hyades.logging.core.IPreemptedLogger;
import org.eclipse.hyades.logging.core.LoggingAgent;

public class Logger
implements Log,
IPreemptedLogger {
    public static final int TRACE_LEVEL = 0;
    public static final int DEBUG_LEVEL = 1;
    public static final int INFO_LEVEL = 2;
    public static final int WARN_LEVEL = 3;
    public static final int ERROR_LEVEL = 4;
    public static final int FATAL_LEVEL = 5;
    private static final String[] LEVEL_NAMES = new String[]{"TRACE", "DEBUG", "INFO", "WARN", "ERROR", "FATAL"};
    private LoggingAgent loggingAgent = null;
    private int level = 3;
    private String name = null;
    private XmlGenerator xmlGenerator = null;

    public Logger(String string) {
        this.name = string;
        this.xmlGenerator = new XmlGenerator(string);
        this.loggingAgent = new LoggingAgent(string);
        this.configure();
    }

    public boolean isTraceEnabled() {
        return this.level <= 0;
    }

    public boolean isDebugEnabled() {
        return this.level <= 1;
    }

    public boolean isInfoEnabled() {
        return this.level <= 2;
    }

    public boolean isWarnEnabled() {
        return this.level <= 3;
    }

    public boolean isErrorEnabled() {
        return this.level <= 4;
    }

    public boolean isFatalEnabled() {
        return this.level <= 5;
    }

    public void trace(Object object) {
        if (this.isTraceEnabled()) {
            this.loggingAgent.write(this.convertToXML(object));
        }
    }

    public void trace(Object object, Throwable throwable) {
        if (this.isTraceEnabled()) {
            this.loggingAgent.write(this.convertToXML(object));
            this.loggingAgent.write(this.convertToXML(throwable));
        }
    }

    public void debug(Object object) {
        if (this.isDebugEnabled()) {
            this.loggingAgent.write(this.convertToXML(object));
        }
    }

    public void debug(Object object, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.loggingAgent.write(this.convertToXML(object));
            this.loggingAgent.write(this.convertToXML(throwable));
        }
    }

    public void info(Object object) {
        if (this.isInfoEnabled()) {
            this.loggingAgent.write(this.convertToXML(object));
        }
    }

    public void info(Object object, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.loggingAgent.write(this.convertToXML(object));
            this.loggingAgent.write(this.convertToXML(throwable));
        }
    }

    public void warn(Object object) {
        if (this.isWarnEnabled()) {
            this.loggingAgent.write(this.convertToXML(object));
        }
    }

    public void warn(Object object, Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.loggingAgent.write(this.convertToXML(object));
            this.loggingAgent.write(this.convertToXML(throwable));
        }
    }

    public void error(Object object) {
        if (this.isErrorEnabled()) {
            this.loggingAgent.write(this.convertToXML(object));
        }
    }

    public void error(Object object, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.loggingAgent.write(this.convertToXML(object));
            this.loggingAgent.write(this.convertToXML(throwable));
        }
    }

    public void fatal(Object object) {
        if (this.isFatalEnabled()) {
            this.loggingAgent.write(this.convertToXML(object));
        }
    }

    public void fatal(Object object, Throwable throwable) {
        if (this.isFatalEnabled()) {
            this.loggingAgent.write(this.convertToXML(object));
            this.loggingAgent.write(this.convertToXML(throwable));
        }
    }

    public String getName() {
        return this.name;
    }

    public int getLevel() {
        return this.level;
    }

    public String getLevelAsString() {
        return LEVEL_NAMES[this.level];
    }

    public synchronized void setLevel(int n) throws IllegalArgumentException {
        if (!this.isValidLevel(n)) {
            throw new IllegalArgumentException("Invalid logging level");
        }
        this.level = n;
    }

    public synchronized void setLevelAsString(String string) throws IllegalArgumentException {
        this.setLevel(this.getLevelInteger(string));
    }

    private int getLevelInteger(String string) {
        if (string != null && string.trim().length() != 0) {
            String string2 = string.trim();
            int n = 0;
            while (n < LEVEL_NAMES.length) {
                if (string2.equalsIgnoreCase(LEVEL_NAMES[n])) {
                    return n;
                }
                ++n;
            }
            try {
                int n2 = Integer.parseInt(string2);
                if (this.isValidLevel(n2)) {
                    return n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    private boolean isValidLevel(int n) {
        return n >= 0 || n <= 5;
    }

    private boolean isValidLevelString(String string) {
        return this.isValidLevel(this.getLevelInteger(string));
    }

    private String convertToXML(Object object) {
        if (object instanceof IExternalizableToXml) {
            return ((IExternalizableToXml)object).externalizeCanonicalXmlString();
        }
        this.xmlGenerator.reset(LEVEL_NAMES[this.level], false, 4);
        return this.xmlGenerator.objectToXML(object);
    }

    public final void finalize() {
        this.loggingAgent.deregister();
    }

    public boolean waitUntilLogging(long l) {
        return this.loggingAgent.waitUntilLogging(l);
    }

    public boolean isLogging() {
        return this.loggingAgent.isLogging();
    }

    private void configure() {
        String string = System.getProperty("org.eclipse.hyades.logging.commons.Logger.Level");
        if (string != null && string.trim().length() > 0 && this.isValidLevelString(string)) {
            this.setLevelAsString(string);
        }
    }
}

