/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.remote;

import java.util.HashMap;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.IExecutionComponentFactory;
import org.eclipse.hyades.execution.core.ISession;
import org.eclipse.hyades.execution.invocation.IRemoteObject;
import org.eclipse.hyades.execution.invocation.Marshaller;
import org.eclipse.hyades.execution.invocation.RemoteInvocationException;
import org.eclipse.hyades.execution.invocation.ReturnData;
import org.eclipse.hyades.execution.remote.ClassRelationship;
import org.eclipse.hyades.execution.remote.ExecutionComponentSkeleton;
import org.eclipse.hyades.execution.remote.RemoteObjectSkeleton;

public class ExecutionComponentFactoryImpl
implements IExecutionComponentFactory,
IRemoteObject {
    private static ExecutionComponentFactoryImpl instance;
    private static ISession sessionContext;
    private HashMap components = new HashMap();

    private ExecutionComponentFactoryImpl(ISession iSession) {
        sessionContext = iSession;
        Marshaller.addInstanceToMap((Integer)this.getUniqueId(), (Object)this);
    }

    public static ExecutionComponentFactoryImpl getInstance(ISession iSession) {
        if (instance == null) {
            instance = new ExecutionComponentFactoryImpl(iSession);
        }
        return instance;
    }

    public ISession getSessionContext() {
        return sessionContext;
    }

    public void setSessionContext(ISession iSession) {
        throw new UnsupportedOperationException("The session context of the factory should not be set via this method");
    }

    public Integer getUniqueId() {
        return new Integer(-1);
    }

    public IExecutionComponent createExecutionComponentByType(String string) {
        return null;
    }

    public IExecutionComponent createExecutionComponentByType(Integer n, String string) {
        ClassRelationship classRelationship = (ClassRelationship)this.components.get(string);
        if (classRelationship != null) {
            try {
                Class clazz = classRelationship.impl;
                Class clazz2 = classRelationship.skeletonClass;
                IExecutionComponent iExecutionComponent = (IExecutionComponent)clazz.newInstance();
                ExecutionComponentSkeleton executionComponentSkeleton = (ExecutionComponentSkeleton)clazz2.newInstance();
                executionComponentSkeleton.setId(n);
                executionComponentSkeleton.setDelegate(iExecutionComponent);
                executionComponentSkeleton.setSessionContext(sessionContext);
                Marshaller.addInstanceToMap((Integer)executionComponentSkeleton.getUniqueId(), (Object)executionComponentSkeleton);
                executionComponentSkeleton.init();
                return executionComponentSkeleton;
            }
            catch (Throwable throwable) {
                throw new RemoteInvocationException(throwable);
            }
        }
        throw new RemoteInvocationException("Factory not configured for this type");
    }

    public IRemoteObject createRemoteObjectByType(Integer n, String string) {
        ClassRelationship classRelationship = (ClassRelationship)this.components.get(string);
        if (classRelationship != null) {
            try {
                Class clazz = classRelationship.impl;
                Class clazz2 = classRelationship.skeletonClass;
                Object t = clazz.newInstance();
                RemoteObjectSkeleton remoteObjectSkeleton = (RemoteObjectSkeleton)clazz2.newInstance();
                remoteObjectSkeleton.setId(n);
                remoteObjectSkeleton.setDelegate(t);
                remoteObjectSkeleton.setSessionContext(sessionContext);
                Marshaller.addInstanceToMap((Integer)remoteObjectSkeleton.getUniqueId(), (Object)remoteObjectSkeleton);
                remoteObjectSkeleton.init();
                return remoteObjectSkeleton;
            }
            catch (Throwable throwable) {
                throw new RemoteInvocationException(throwable);
            }
        }
        throw new RemoteInvocationException("Factory not configured for this type");
    }

    public void addExecutionComponent(String string, String string2) throws ClassNotFoundException {
        try {
            Class<?> clazz = Class.forName(string2, true, this.getClass().getClassLoader());
            ClassRelationship classRelationship = new ClassRelationship();
            classRelationship.impl = clazz;
            this.components.put(string, classRelationship);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RemoteInvocationException((Throwable)classNotFoundException);
        }
    }

    public void addStub(String string, String string2) throws ClassNotFoundException {
    }

    public void addSkeleton(String string, String string2) throws ClassNotFoundException {
        try {
            Class<?> clazz = Class.forName(string2, true, this.getClass().getClassLoader());
            ClassRelationship classRelationship = (ClassRelationship)this.components.get(string);
            if (classRelationship != null) {
                classRelationship.skeletonClass = clazz;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RemoteInvocationException((Throwable)classNotFoundException);
        }
    }

    public ReturnData delegateRemoteCall(Class[] classArray, Object[] objectArray, String string) throws RemoteInvocationException {
        return null;
    }

    public Object getDelegate() {
        return this;
    }

    public void setDelegate(Object object) {
    }

    public void init() {
    }
}

