/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.parsers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Util;
import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IParser;
import org.eclipse.hyades.logging.adapter.MessageString;
import org.eclipse.hyades.logging.adapter.impl.ProcessUnit;
import org.eclipse.hyades.logging.adapter.parsers.AttributeStatement;
import org.eclipse.hyades.logging.adapter.parsers.GroupStatement;
import org.eclipse.hyades.logging.adapter.parsers.IStatement;
import org.eclipse.hyades.logging.adapter.parsers.PreparationException;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Parser
extends ProcessUnit
implements IParser {
    private static PatternCompiler compiler = new Perl5Compiler();
    private static PatternMatcher matcher = new Perl5Matcher();
    private List ruleSets;
    private String separatorToken;
    private Pattern separatorPattern;
    private String designationToken;
    private Pattern designationPattern;

    public static final PatternCompiler getCompiler() {
        return compiler;
    }

    public static PatternMatcher getPatternMatcher() {
        return matcher;
    }

    public void update() throws AdapterInvalidConfig {
        int n;
        super.update();
        Element element = this.getConfiguration();
        if (!element.getNodeName().equals(Messages.getString("HyadesGAParserTagName"))) {
            throw new AdapterInvalidConfig("cc:Parser expected to contain parsing rules");
        }
        NodeList nodeList = element.getChildNodes();
        this.separatorToken = element.getAttribute(Messages.getString("HyadesGASeparatorTokenAttributeName"));
        this.designationToken = element.getAttribute(Messages.getString("HyadesGADesignationTokenName"));
        if (this.separatorToken != null && !this.separatorToken.equals("")) {
            try {
                this.separatorPattern = compiler.compile(this.separatorToken);
            }
            catch (MalformedPatternException malformedPatternException) {
                throw new PreparationException(malformedPatternException);
            }
        }
        if (this.designationToken != null && !this.designationToken.equals("")) {
            try {
                this.designationPattern = compiler.compile(this.designationToken);
            }
            catch (MalformedPatternException malformedPatternException) {
                throw new PreparationException(malformedPatternException);
            }
        }
        if ((n = nodeList.getLength()) > 0) {
            this.ruleSets = new ArrayList();
            int n2 = 0;
            while (n2 < n) {
                block20: {
                    Element element2 = null;
                    try {
                        element2 = (Element)nodeList.item(n2);
                    }
                    catch (ClassCastException classCastException) {
                        break block20;
                    }
                    if (element2 != null) {
                        IStatement iStatement = null;
                        if (element2.getNodeName().endsWith(Messages.getString("HyadesGARuleElementTagName"))) {
                            iStatement = new GroupStatement();
                        } else if (element2.getNodeName().endsWith(Messages.getString("HyadesRuleAttributeTagName"))) {
                            iStatement = new AttributeStatement();
                        } else {
                            throw new AdapterInvalidConfig();
                        }
                        try {
                            iStatement.prepare(element2, null);
                            this.ruleSets.add(iStatement);
                        }
                        catch (PreparationException preparationException) {
                            if (preparationException.getDetails() == null) {
                                this.log(preparationException.getLocalizedMessage(), (short)50);
                            } else {
                                this.log(preparationException.getLocalizedMessage() + " " + preparationException.getDetails() + ". ", (short)50);
                            }
                            this.log(Messages.getString("HyadesGASubstitutionRuleIgnored") + " " + preparationException.getDigraph(), (short)50);
                        }
                    }
                }
                ++n2;
            }
        }
    }

    public Object[] processEventItems(Object[] objectArray) {
        if (this.ruleSets != null) {
            ArrayList arrayList = new ArrayList();
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] != null) {
                    HashMap hashMap = this.prepareEnvData(((MessageString)objectArray[n]).getValue());
                    ListIterator listIterator = this.ruleSets.listIterator();
                    ArrayList arrayList2 = new ArrayList();
                    while (listIterator.hasNext()) {
                        IStatement iStatement = (IStatement)listIterator.next();
                        try {
                            iStatement.run(((MessageString)objectArray[n]).getValue(), hashMap, arrayList2);
                        }
                        catch (AdapterException adapterException) {
                            this.log(adapterException.getLocalizedMessage(), (short)50);
                        }
                    }
                    arrayList.add(arrayList2);
                }
                ++n;
            }
            return arrayList.toArray();
        }
        return null;
    }

    public Object[] testProcessEventItems(Object[] objectArray) throws AdapterInvalidConfig {
        if (!(objectArray instanceof MessageString[])) {
            throw new AdapterInvalidConfig("This parser will only accept arrays of MessageString");
        }
        return objectArray;
    }

    private HashMap prepareEnvData(String string) {
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        ArrayList arrayList = new ArrayList();
        if (this.separatorToken == null || this.separatorToken.equals("")) {
            return hashMap;
        }
        Util.split(arrayList, (PatternMatcher)matcher, (Pattern)this.separatorPattern, (String)string);
        int n = 0;
        while (n < arrayList.size()) {
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = "";
            String string3 = "";
            String string4 = (String)arrayList.get(n);
            if (string4.length() > 0) {
                if (this.designationToken == null || this.designationToken.equals("")) {
                    hashMap.put(new Long(n), string4);
                } else if (matcher.contains(string4, this.designationPattern)) {
                    MatchResult matchResult = matcher.getMatch();
                    if (matchResult.beginOffset(0) > 0) {
                        string2 = string4.substring(0, matchResult.beginOffset(0));
                        if (matchResult.endOffset(0) < string4.length()) {
                            string3 = string4.substring(matchResult.endOffset(0));
                        }
                        hashMap.put(string2.trim(), string3.trim());
                    }
                } else {
                    hashMap.put(new Long(n), string4);
                }
            }
            ++n;
        }
        return hashMap;
    }

    static {
        ((Perl5Matcher)matcher).setMultiline(true);
    }
}

