/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.impl;

import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IComponent;
import org.eclipse.hyades.logging.adapter.IProcessUnit;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.CompletionException;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.EventFactoryHome;
import org.eclipse.hyades.logging.events.cbe.MsgDataElement;
import org.eclipse.hyades.logging.events.cbe.impl.EventFactoryContext;
import org.w3c.dom.Element;

public class Component
implements IComponent {
    protected IProcessUnit logger = null;
    private short loggingLevel = 0;
    private String name = null;
    private String role = null;
    private String executableClassName = null;
    private String description = null;
    private String uniqueID = null;
    private String roleVersion = null;
    private String implVersion = null;
    private String roleVersionDescription = null;
    private String implVersionDescription = null;
    private String roleCreationDate = null;
    private String implCreationDate = null;
    private IComponent[] components = null;
    private EventFactory eventFactory = null;
    protected boolean stopping = false;
    private Element configuration = null;
    private Element contextConfiguration = null;

    public boolean init() {
        IComponent[] components;
        Element element = this.getContextConfiguration();
        if (element.hasAttribute(Messages.getString("HyadesGADescriptionAttributeName"))) {
            this.setDescription(element.getAttribute(Messages.getString("HyadesGADescriptionAttributeName")));
        }
        if (element.hasAttribute(Messages.getString("HyadesGARoleAttributeName"))) {
            this.setRole(element.getAttribute(Messages.getString("HyadesGARoleAttributeName")));
        }
        if (element.hasAttribute(Messages.getString("HyadesGALoggingLevelAttributeName"))) {
            this.setLoggingLevel(Short.valueOf(element.getAttribute(Messages.getString("HyadesGALoggingLevelAttributeName"))));
        }
        if (element.hasAttribute(Messages.getString("HyadesGARoleVersionAttributeName"))) {
            this.setRoleVersion(element.getAttribute(Messages.getString("HyadesGARoleVersionAttributeName")));
        }
        if (element.hasAttribute(Messages.getString("HyadesGARoleCreationDateAttributeName"))) {
            this.setRoleCreationDate(element.getAttribute(Messages.getString("HyadesGARoleCreationDateAttributeName")));
        }
        if (element.hasAttribute(Messages.getString("HyadesGARoleVersionDescriptionAttributeName"))) {
            this.setRoleVersionDescription(element.getAttribute(Messages.getString("HyadesGARoleVersionDescriptionAttributeName")));
        }
        if (element.hasAttribute(Messages.getString("HyadesGAImplementationVersionAttributeName"))) {
            this.setImplementationVersion(element.getAttribute(Messages.getString("HyadesGAImplementationVersionAttributeName")));
        }
        if (element.hasAttribute(Messages.getString("HyadesGAImplemenationCreationDateAttributeName"))) {
            this.setImplemenationCreationDate(element.getAttribute(Messages.getString("HyadesGAImplemenationCreationDateAttributeName")));
        }
        if (element.hasAttribute(Messages.getString("HyadesGAImplemenationVersionDescriptionAttributeName"))) {
            this.setImplementationVersionDescription(element.getAttribute(Messages.getString("HyadesGAImplemenationVersionDescriptionAttributeName")));
        }
        if ((components = this.getComponents()) != null) {
            int i = 0;
            while (i < components.length) {
                components[i].setLogger(this.getLogger());
                components[i].init();
                ++i;
            }
        }
        return true;
    }

    public void start() {
    }

    public void stop(int toStop) {
    }

    public void stop() {
        if (this.components != null) {
            int i = 0;
            while (i < this.components.length) {
                this.components[i].stop();
                ++i;
            }
        }
        this.stopping = true;
    }

    public void update(Element config) throws AdapterInvalidConfig {
        this.setConfiguration(config);
        this.update();
    }

    public void update() throws AdapterInvalidConfig {
        Element element = this.getConfiguration();
        this.setDescription(element.getAttribute(Messages.getString("HyadesGADescriptionAttributeName")));
        this.setUniqueID(element.getAttribute(Messages.getString("HyadesGAUniqueIDAttributeName")));
        IComponent[] components = this.getComponents();
        if (components != null) {
            int i = 0;
            while (i < components.length) {
                components[i].update();
                ++i;
            }
        }
    }

    public Element getContextConfiguration() {
        return this.contextConfiguration;
    }

    public void setContextConfiguration(Element newConfiguration) {
        this.contextConfiguration = newConfiguration;
    }

    public Element getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Element newConfiguration) {
        this.configuration = newConfiguration;
    }

    public IProcessUnit getLogger() {
        return this.logger;
    }

    public void setLogger(IProcessUnit logger) {
        this.logger = logger;
    }

    public EventFactory getEventFactory() {
        if (this.eventFactory == null) {
            EventFactoryHome eventFactoryHome = EventFactoryContext.getInstance().getEventFactoryHome("org.eclipse.hyades.logging.adapter.internal.util.RuntimeEventXMLFileEventFactoryHomeImpl", this.getClass().getClassLoader());
            if (eventFactoryHome != null) {
                this.eventFactory = eventFactoryHome.getEventFactory("org.eclipse.hyades.logging.adapter.impl.Component");
                this.eventFactory.setCompleteEvent(true);
            } else {
                this.eventFactory = EventFactoryContext.getInstance().getEventFactoryHome("org.eclipse.hyades.logging.events.cbe.impl.SimpleEventFactoryHomeImpl").getEventFactory("org.eclipse.hyades.logging.adapter.impl.Component");
            }
        }
        return this.eventFactory;
    }

    public short getLoggingLevel() {
        return this.loggingLevel;
    }

    public void setLoggingLevel(short newLevel) {
        this.loggingLevel = newLevel;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String newRole) {
        this.role = newRole;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String newDescription) {
        this.description = newDescription;
    }

    public String getUniqueID() {
        return this.uniqueID;
    }

    public void setUniqueID(String newUniqueID) {
        this.uniqueID = newUniqueID;
    }

    public String getExecutableClassName() {
        return this.executableClassName;
    }

    public void setExecutableClassName(String newExecutableClassName) {
        this.executableClassName = newExecutableClassName;
    }

    public String getRoleVersion() {
        return this.roleVersion;
    }

    public void setRoleVersion(String newRoleVersion) {
        this.roleVersion = newRoleVersion;
    }

    public String getRoleCreationDate() {
        return this.roleCreationDate;
    }

    public void setRoleCreationDate(String newCreationDate) {
        this.roleCreationDate = newCreationDate;
    }

    public String getRoleVersionDescription() {
        return this.roleVersionDescription;
    }

    public void setRoleVersionDescription(String newRoleVersionDescription) {
        this.roleVersionDescription = newRoleVersionDescription;
    }

    public String getImplementationVersion() {
        return this.implVersion;
    }

    public void setImplementationVersion(String newImplementationVersion) {
        this.implVersion = newImplementationVersion;
    }

    public String getImplementationCreationDate() {
        return this.implCreationDate;
    }

    public void setImplemenationCreationDate(String newImplementationCreationDate) {
        this.implCreationDate = newImplementationCreationDate;
    }

    public String getImplementationVersionDescription() {
        return this.implVersionDescription;
    }

    public void setImplementationVersionDescription(String newImplementationVersionDescription) {
        this.implVersionDescription = newImplementationVersionDescription;
    }

    public IComponent[] getComponents() {
        return this.components;
    }

    public void setComponents(IComponent[] newComponents) {
        this.components = newComponents;
    }

    public void clean() {
        if (this.components == null) {
            return;
        }
        int i = 0;
        while (i < this.components.length) {
            this.components[i] = null;
            ++i;
        }
        this.components = null;
    }

    public void log(CommonBaseEvent event) {
        if (event != null && event.getSeverity() >= this.loggingLevel) {
            ComponentIdentification sourceComponentId;
            String msgCatalogId;
            MsgDataElement msgDataElement;
            String msg = event.getMsg();
            if ((msg == null || msg.length() == 0) && (msgDataElement = event.getMsgDataElement()) != null && (msgCatalogId = msgDataElement.getMsgCatalogId()) != null) {
                String[] msgCatalogTokens = msgDataElement.getMsgCatalogTokensAsStrings();
                if (msgCatalogTokens == null || msgCatalogTokens.length == 0) {
                    event.setMsg(Messages.getString(msgCatalogId));
                } else {
                    event.setMsg(Messages.getString(msgCatalogId, msgCatalogTokens));
                }
            }
            if (!event.isComplete()) {
                try {
                    event.complete();
                }
                catch (CompletionException c) {
                    // empty catch block
                }
            }
            if ((sourceComponentId = event.getSourceComponentId()) != null) {
                sourceComponentId.setComponent(this.getName());
                sourceComponentId.setSubComponent(this.getUniqueID());
                sourceComponentId.setComponentIdType(this.getRole());
            }
            this.getLogger().processEventItems(new CommonBaseEvent[]{event});
        }
    }

    public void log(CommonBaseEvent event, short level) {
        if (event != null) {
            event.setSeverity(level);
            this.log(event);
        }
    }
}

