/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.common;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.loaders.common.ExecutionContext;
import org.eclipse.hyades.loaders.common.ExecutionResultData;
import org.eclipse.hyades.loaders.common.IXMLEventConstants;
import org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.common.common.CMNExtendedProperty;
import org.eclipse.hyades.models.common.common.CommonFactory;
import org.eclipse.hyades.models.common.interactions.BVRInteractionFragment;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofileFactory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;

public abstract class XMLexecutionEventLoader
extends IgnoredXMLFragmentLoader
implements IXMLEventConstants {
    public static final boolean DEBUG = false;
    public static final String ROOT_PARENT = "ROOT";
    protected static final String EVENT_ID = "id";
    protected static final String EVENT_OWNERID = "ownerId";
    protected static final String EVENT_TIMESTAMP = "timestamp";
    protected static final String EVENT_TEXT = "text";
    protected static final String EVENT_PARENTID = "parentId";
    protected static final String EVENT_NAME = "name";
    protected static final String EVENT_EVENT_TYPE = "eventType";
    protected static final String EVENT_SORT_BY = "sortBy";
    protected static final String EVENT_CONFLICT = "conflict";
    protected static final String EVENT_PROPERTY = "property";
    protected static final String EVENT_PROPERTY_NAME = "pname";
    protected static final String EVENT_PROPERTY_TYPE = "ptype";
    protected static final String EVENT_PROPERTY_VALUE = "pvalue";
    protected String id = null;
    protected String ownerId = null;
    protected long timestamp = -1L;
    protected String text;
    protected TPFExecutionEvent event = null;
    protected String parentId = null;
    protected String name = null;
    protected String eventType = null;
    protected String sortBy = null;
    protected int conflict = 0;
    protected CMNExtendedProperty property = null;
    protected ArrayList properties = new ArrayList();

    public void initialize(HierarchyContext context, String name) {
        super.initialize(context, name);
        this.event = null;
        this.id = null;
        this.ownerId = null;
        this.timestamp = 0L;
        this.text = null;
        this.parentId = null;
        this.name = null;
        this.eventType = null;
        this.sortBy = null;
        this.conflict = 0;
        this.property = null;
        this.properties.clear();
        this.printTag(name);
    }

    public void addAttribute(String name, String value) {
        switch (LoadersUtils.getHashCode((String)name)) {
            case 3355: {
                this.id = value;
                break;
            }
            case -1054729426: {
                this.ownerId = value;
                break;
            }
            case 1175162725: {
                this.parentId = value;
                break;
            }
            case 55126294: {
                this.timestamp = Long.parseLong(value);
                break;
            }
            case 3556653: {
                this.text = value;
                break;
            }
            case 3373707: {
                this.name = value;
                break;
            }
            case 31430900: {
                this.eventType = value;
                break;
            }
            case -896594283: {
                this.sortBy = value;
                break;
            }
            case -580047918: {
                this.conflict = Integer.parseInt(value);
                break;
            }
            case 106808059: {
                if (this.property == null) break;
                this.property.setName(value);
                break;
            }
            case 107009962: {
                if (this.property == null) break;
                this.property.setType(value);
                break;
            }
            case -976529663: {
                if (this.property == null) break;
                this.property.setValue(value);
                break;
            }
        }
    }

    public void startChild(String name) {
        switch (LoadersUtils.getHashCode((String)name)) {
            case -993141291: {
                this.property = CommonFactory.eINSTANCE.createCMNExtendedProperty();
            }
        }
        super.startChild(name);
    }

    public void endChild(String name) {
        switch (LoadersUtils.getHashCode((String)name)) {
            case -993141291: {
                this.properties.add(this.property);
                this.property = null;
            }
        }
        super.endChild(name);
    }

    public void addYourselfInContext() {
        EObject testElement;
        ExecutionContext eContext;
        if (this.event == null) {
            return;
        }
        this.printEndTag();
        this.event.setId(this.id);
        this.event.setOwnerId(this.ownerId);
        this.event.setTimestamp(this.timestamp);
        this.event.setText(this.text);
        this.event.setName(this.name);
        this.event.setEventType(this.eventType);
        if (this.properties != null) {
            Iterator iter = this.properties.iterator();
            while (iter.hasNext()) {
                CMNExtendedProperty p = (CMNExtendedProperty)iter.next();
                if (p == null) continue;
                this.event.getProperties().add((Object)p);
            }
        }
        if (this.parentId == null) {
            eContext = (ExecutionContext)this.context.getCustomData().get(ExecutionContext.root);
            eContext.logEvent(this.event);
        } else if (this.ownerId != null && this.ownerId.length() != 0 && (testElement = ExecutionResultData.getObjectFromTest((eContext = (ExecutionContext)this.context.getCustomData().get(ExecutionContext.root)).getTestSuite(), this.ownerId)) != null && testElement instanceof BVRInteractionFragment) {
            this.event.setInteractionFragment((BVRInteractionFragment)testElement);
        }
    }

    public void addYourselfToContainer() {
        ExecutionContext eContext = (ExecutionContext)this.context.getCustomData().get(ExecutionContext.root);
        if (this.parentId != null && this.parentId.equals(ROOT_PARENT)) {
            TPFExecutionResult exResult = eContext.rootResult.getResult();
            if (exResult != null) {
                TPFExecutionHistory history = exResult.getExecutionHistory();
                if (history == null) {
                    history = Common_TestprofileFactory.eINSTANCE.createTPFExecutionHistory();
                    exResult.setExecutionHistory(history);
                }
                if (!this.insertEvent(history.getExecutionEvents(), this.event)) {
                    this.event.setExecutionHistory(history);
                }
            }
        } else if (this.parentId != null) {
            TPFExecutionEvent parentEvent;
            TPFExecutionResult result = eContext.rootResult.getResult();
            EObject obj = result.eResource().getEObject(this.parentId);
            if (obj != null && obj instanceof TPFInvocationEvent) {
                TPFExecutionHistory history = ((TPFInvocationEvent)obj).getInvokedExecutionResult().getExecutionHistory();
                if (history != null && !this.insertEvent(history.getExecutionEvents(), this.event)) {
                    this.event.setExecutionHistory(history);
                }
            } else if (obj != null && !this.insertEvent((parentEvent = (TPFExecutionEvent)obj).getChildren(), this.event)) {
                this.event.setParent(parentEvent);
            }
        }
    }

    private EAttribute getSortEAttribute() {
        if (this.sortBy == null) {
            return null;
        }
        EStructuralFeature esf = this.event.eClass().getEStructuralFeature(this.sortBy);
        if (esf == null || !(esf instanceof EAttribute)) {
            return null;
        }
        return (EAttribute)esf;
    }

    private boolean isSortNeeded() {
        if (this.sortBy == null || this.sortBy.length() == 0) {
            return false;
        }
        EAttribute ea = this.getSortEAttribute();
        if (ea == null) {
            return false;
        }
        Object obj = this.event.eGet((EStructuralFeature)ea);
        return obj != null;
    }

    private boolean insertEvent(EList events, TPFExecutionEvent event) {
        if (this.resolveConflict(events)) {
            return true;
        }
        if (!this.isSortNeeded()) {
            return false;
        }
        int index = this.getIndex(events, event);
        if (index >= events.size()) {
            return false;
        }
        events.add(index, (Object)event);
        return true;
    }

    protected boolean resolveConflict(EList events) {
        if (this.conflict == 0) {
            return false;
        }
        if (this.event.getId() == null) {
            return false;
        }
        TPFExecutionEvent match = null;
        Iterator iter = events.iterator();
        while (iter.hasNext()) {
            TPFExecutionEvent ev = (TPFExecutionEvent)iter.next();
            if (!this.isIdentical(ev)) continue;
            match = ev;
            break;
        }
        if (match == null) {
            return false;
        }
        if (this.needOverwrite(match)) {
            this.overwrite(match);
        }
        return true;
    }

    protected boolean isIdentical(TPFExecutionEvent match) {
        return this.event.getId().equals(match.getId()) && this.event.getClass().getName().equals(match.getClass().getName());
    }

    protected boolean needOverwrite(TPFExecutionEvent match) {
        boolean overwrite = false;
        switch (this.conflict) {
            case 1: {
                break;
            }
            case 2: {
                overwrite = true;
                break;
            }
            case 3: {
                if (this.event.getTimestamp() >= match.getTimestamp()) break;
                overwrite = true;
                break;
            }
            case 4: {
                if (this.event.getTimestamp() <= match.getTimestamp()) break;
                overwrite = true;
                break;
            }
            default: {
                return false;
            }
        }
        return overwrite;
    }

    protected void overwrite(TPFExecutionEvent match) {
        match.setTimestamp(this.event.getTimestamp());
        match.setText(this.event.getText());
        match.setEventType(this.event.getEventType());
        match.setName(this.event.getName());
        match.setInteractionFragment(this.event.getInteractionFragment());
        match.setOwnerId(this.event.getOwnerId());
    }

    private int getIndex(EList events, TPFExecutionEvent event) {
        EAttribute ea = (EAttribute)event.eClass().getEStructuralFeature(this.sortBy);
        String newValue = event.eGet((EStructuralFeature)ea).toString();
        int index = 0;
        Object obj = null;
        index = 0;
        while (index < events.size()) {
            String val;
            TPFExecutionEvent ev = (TPFExecutionEvent)events.get(index);
            obj = ev.eGet((EStructuralFeature)ea);
            if (obj != null && (val = obj.toString()).compareTo(newValue) > 0) break;
            ++index;
        }
        return index;
    }

    protected void printTag(String str) {
    }

    protected void printAttribute(String name, String value) {
    }

    protected void printEndTag() {
    }
}

