/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.local;

import org.eclipse.hyades.execution.core.ExecutionComponentStateChangeEvent;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.INode;
import org.eclipse.hyades.execution.core.ISession;
import org.eclipse.hyades.execution.core.impl.ExecutionComponentImpl;
import org.eclipse.hyades.execution.invocation.Marshaller;
import org.eclipse.hyades.execution.invocation.ReturnData;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.InactiveAgentException;

public class SessionImpl
extends ExecutionComponentImpl
implements ISession {
    protected INode node;
    protected Agent agent;

    public SessionImpl(INode node, Agent agent) {
        this.node = node;
        this.agent = agent;
        this.createAgentListener();
    }

    public void release() {
    }

    public INode getNode() {
        return this.node;
    }

    private void createAgentListener() {
        this.agent.addAgentListener(new AgentListener(){

            public void agentActive(Agent agent) {
                SessionImpl.this.fireStateChangeEvent(new ExecutionComponentStateChangeEvent((IExecutionComponent)SessionImpl.this, 2));
            }

            public void agentInactive(Agent agent) {
                SessionImpl.this.fireStateChangeEvent(new ExecutionComponentStateChangeEvent((IExecutionComponent)SessionImpl.this, 4));
            }

            public void error(Agent agent, String errorId, String errorMessage) {
            }

            public void handleCommand(Agent agent, CommandElement command) {
                block2: {
                    if (!(command instanceof CustomCommand)) break block2;
                    CustomCommand custom = (CustomCommand)command;
                    try {
                        ReturnData returnVal = Marshaller.unmarshalReturnValue((byte[])custom.getDataBinary());
                        Marshaller.queueReturnValue((ReturnData)returnVal);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public void invokeRemote(CustomCommand command) {
        try {
            this.agent.invokeCustomCommand(command);
        }
        catch (InactiveAgentException e) {}
    }

    public Agent getAgent() {
        return this.agent;
    }
}

