/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.threadanalyzer;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.hyades.collection.threadanalyzer.DumpData;
import org.eclipse.hyades.collection.threadanalyzer.Monitor;
import org.eclipse.hyades.collection.threadanalyzer.StkEntry;
import org.eclipse.hyades.collection.threadanalyzer.StkEntryNative;
import org.eclipse.hyades.collection.threadanalyzer.TAUtils;

public class Thd
implements Externalizable {
    private static int _curVersion = 1;
    private int _version = -1;
    public String _name = null;
    public int _ID;
    public Vector _stack;
    public Vector _stackNative;
    public String _threadId = null;
    public String _priority = null;
    public String _state = null;
    public int _waitMonitorID = 0;
    public Monitor _waitMonitor = null;
    public Properties _props = null;
    private boolean _fHtml = false;
    private boolean _selfWaiter = false;
    private static String sTab = "   ";
    public transient Thd _nextByTOS = null;
    public transient Thd _prevByTOS = null;

    public Thd(String name, String threadId, String state, String priority) {
        this._version = _curVersion;
        this._name = name;
        this._ID = DumpData.getID();
        this._stack = null;
        this._stackNative = null;
        this._threadId = threadId;
        this._priority = priority;
        this._state = state;
        this._stack = new Vector();
        this._stackNative = new Vector();
        this._waitMonitor = null;
        this._props = new Properties();
        this._nextByTOS = null;
        this._prevByTOS = null;
        this._fHtml = false;
    }

    public String getThreadId() {
        return this._threadId;
    }

    public void setProperty(String prop, String val) {
        this._props.setProperty(prop, val);
    }

    public String getProperty(String prop) {
        return this._props.getProperty(prop);
    }

    public void addStackEntry(StkEntry stkEntry) {
        this._stack.add(stkEntry);
    }

    public void addStackEntryNative(StkEntryNative stkEntryNative) {
        this._stackNative.add(stkEntryNative);
    }

    public String getName() {
        return this._name;
    }

    public void setWaitMonitor(Monitor waitMonitor) {
        this._waitMonitorID = waitMonitor._ID;
        this._waitMonitor = waitMonitor;
    }

    public int getWaitMonitorId() {
        return this._waitMonitorID;
    }

    public boolean waitingForWebWork() {
        return this.boolPropVal("WAITING_FOR_WEB_WORK");
    }

    public boolean waitingForOtherWork() {
        return this.boolPropVal("WAITING_FOR_OTHER_WORK");
    }

    public String getServletName() {
        return this.getProperty("SERVLET_NAME");
    }

    public String[] getEjbNames() {
        return new String[0];
    }

    public boolean isServletThread() {
        boolean fRet = false;
        fRet = this.isExecutingWebWork() || this.waitingForWebWork() || this.isEmptyServletThd();
        return fRet;
    }

    public boolean isEmptyServletThd() {
        return this.getName().indexOf("Servlet") != -1 && this.getStkSize() == 0;
    }

    public boolean isOrbThread() {
        boolean fRet = false;
        fRet = this.isExecutingRemoteOrbWork() || this.waitingForOrbWork() || this.isEmptyOrbThd();
        return fRet;
    }

    public boolean isEmptyOrbThd() {
        return this.getName().indexOf("ORB") != -1 && this.getStkSize() == 0;
    }

    public boolean isExecutingWebWork() {
        return this.boolPropVal("EXECUTING_WEB_WORK");
    }

    public boolean isExecutingOrbWork() {
        return this.boolPropVal("EXECUTING_ORB_WORK");
    }

    public boolean isExecutingRemoteOrbWork() {
        return this.boolPropVal("EXECUTING_REMOTE_ORB_WORK");
    }

    public boolean waitingForOrbWork() {
        return this.boolPropVal("WAITING_FOR_REMOTE_ORB_WORK");
    }

    public boolean waitingForInfrastructureWork() {
        return this.boolPropVal("WAITING_FOR_INFRASTRUCTURE_WORK");
    }

    public boolean waitingForQueueWork() {
        return this.boolPropVal("WAITING_FOR_QUEUE_WORK");
    }

    public boolean waitingForWork() {
        return this.waitingForOrbWork() || this.waitingForWebWork() || this.waitingForQueueWork() || this.waitingForOtherWork();
    }

    public boolean firstStackDifference(Vector callers, Thd t) {
        int otherStkSize;
        Object seMine = null;
        Object seOther = null;
        int myStkSize = this._stack.size();
        int maxSize = myStkSize > (otherStkSize = t._stack.size()) ? otherStkSize : myStkSize;
        int i = 0;
        while (i < maxSize) {
            StkEntry mine = (StkEntry)this._stack.elementAt(i);
            StkEntry other = (StkEntry)t._stack.elementAt(i);
            if (!mine.getFQName().equals(other.getFQName()) || i == maxSize - 1) {
                Caller caller;
                boolean found = false;
                int j = 0;
                while (j < callers.size()) {
                    caller = (Caller)callers.elementAt(j);
                    StkEntry se = caller._stkEntry;
                    if (se.getFQName().equals(other.getFQName())) {
                        found = true;
                        ++caller._count;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    caller = new Caller();
                    caller._stkEntry = other;
                    caller._count = 1;
                    callers.add(caller);
                }
                return true;
            }
            ++i;
        }
        if (otherStkSize > myStkSize) {
            System.out.println(TAUtils.getNLSValue("ta.warnmsg.AnalysisIncomplete", "WARNING: stack diff analysis incomplete for thread") + " " + t.getName());
        }
        return false;
    }

    public static int getCallerCount(Object caller) {
        return ((Caller)caller)._count;
    }

    public static String getCallerName(Object caller) {
        return ((Caller)caller)._stkEntry.getFQName();
    }

    public Vector format(int indent, boolean fHtml) {
        Vector<String> lines = new Vector<String>();
        this._fHtml = fHtml;
        String sIndent = "";
        int i = 0;
        while (i < indent) {
            sIndent = sIndent + sTab;
            ++i;
        }
        lines.add(" ");
        lines.add(sIndent + this.html("<a name=" + this.getThreadId() + "></a>") + TAUtils.getNLSValue("ta.format.ThreadInformation", "Thread information") + ":");
        lines.add(sIndent + sTab + TAUtils.getNLSValue("ta.format.ThreadType", "Thread type") + "..................... " + this._props.getProperty("THREAD_TYPE"));
        lines.add(sIndent + sTab + TAUtils.getNLSValue("ta.format.Name", "name") + "............................ " + this._name);
        lines.add(sIndent + sTab + TAUtils.getNLSValue("ta.format.ThreadID", "thread id") + "....................... " + this._threadId);
        lines.add(sIndent + sTab + TAUtils.getNLSValue("ta.format.Priority", "priority") + "........................ " + this._priority);
        lines.add(sIndent + sTab + TAUtils.getNLSValue("ta.format.State", "state") + "........................... " + this._state);
        String sPrevByTOS = "";
        String sNextByTOS = "";
        if (this._nextByTOS != null) {
            sNextByTOS = "<a href=#" + this._nextByTOS.getThreadId() + ">[" + TAUtils.getNLSValue("ta.string.next", "next") + "]</a> ";
        }
        if (this._prevByTOS != null) {
            sPrevByTOS = "<a href=#" + this._prevByTOS.getThreadId() + ">[" + TAUtils.getNLSValue("ta.string.previous", "previous") + "]</a> ";
        }
        if (fHtml && (this._nextByTOS != null || this._prevByTOS != null)) {
            lines.add(sIndent + sTab + " " + sPrevByTOS + sNextByTOS + TAUtils.getNLSValue("ta.msg.WithSameTOS", "with same top of stack") + ".");
        }
        if (!this.waitingForWebWork() && !this.waitingForOrbWork() && this._waitMonitor != null) {
            lines.add(sIndent + "\t" + TAUtils.getNLSValue("ta.msg.WaitingOnMonitor", "Waiting on monitor") + "................ " + this._waitMonitor.getName());
        }
        lines.add(sIndent + sTab + TAUtils.getNLSValue("ta.msg.WaitingForWebWork", "Waiting for web work") + "............. " + Thd.yesOrNo(this.waitingForWebWork()));
        lines.add(sIndent + sTab + TAUtils.getNLSValue("ta.msg.ExecutingWebOrLocalEjbWork", "Executing web or local EJB work") + ".. " + Thd.yesOrNo(this.isExecutingWebWork() || this.isExecutingOrbWork() || this.isExecutingRemoteOrbWork()));
        lines.add(sIndent + sTab + TAUtils.getNLSValue("ta.msg.WaitingForRemoteOrb", "Waiting for remote orb work") + "...... " + Thd.yesOrNo(this.waitingForOrbWork()));
        if (this._stack.size() <= 0 && this._stackNative.size() <= 0) {
            lines.add(sIndent + sTab + sTab + "* " + TAUtils.getNLSValue("ta.msg.NoStackInfo", "no stack information available") + " *");
        } else {
            int i2;
            if (this._stack.size() > 0) {
                lines.add(sIndent + sTab + TAUtils.getNLSValue("ta.string.Stack", "Stack") + ": ");
                i2 = 0;
                while (i2 < this._stack.size()) {
                    StkEntry se = (StkEntry)this._stack.get(i2);
                    lines.add(se.format(indent));
                    ++i2;
                }
            }
            if (this._stackNative.size() > 0) {
                lines.add(sIndent + sTab + "Native Stack" + ": ");
                i2 = 0;
                while (i2 < this._stackNative.size()) {
                    StkEntryNative sen = (StkEntryNative)this._stackNative.get(i2);
                    lines.add(sen.format(indent));
                    ++i2;
                }
            }
        }
        return lines;
    }

    public static String yesOrNo(boolean b) {
        if (b) {
            return TAUtils.getNLSValue("ta.string.yes", "yes");
        }
        return TAUtils.getNLSValue("ta.string.no", "no");
    }

    public void print(int indent, boolean fHtml) {
        Vector lines = this.format(indent, fHtml);
        int i = 0;
        while (i < lines.size()) {
            System.out.println(lines.elementAt(i));
            ++i;
        }
    }

    public boolean stackContainsLike(String stackEntryPattern) {
        int idx = 0;
        boolean fRet = false;
        StkEntry se = this.getStkEntry(idx);
        while (se != null) {
            if (se.getFQName().indexOf(stackEntryPattern) != -1) {
                fRet = true;
                break;
            }
            se = this.getStkEntry(++idx);
        }
        return fRet;
    }

    public StkEntry getTOS() {
        if (this._stack.size() > 0) {
            return (StkEntry)this._stack.elementAt(0);
        }
        return null;
    }

    public StkEntry getBOS() {
        if (this._stack.size() > 0) {
            return (StkEntry)this._stack.elementAt(this._stack.size() - 1);
        }
        return null;
    }

    public int getStkSize() {
        return this._stack.size();
    }

    public int getStkNativeSize() {
        return this._stackNative.size();
    }

    public StkEntry getStkEntry(int ndx) {
        StkEntry retVal = null;
        if (ndx < this._stack.size()) {
            retVal = (StkEntry)this._stack.elementAt(ndx);
        }
        return retVal;
    }

    public StkEntryNative getStkEntryNative(int ndx) {
        StkEntryNative retVal = null;
        if (ndx < this._stackNative.size()) {
            retVal = (StkEntryNative)this._stackNative.elementAt(ndx);
        }
        return retVal;
    }

    protected boolean boolPropVal(String propName) {
        boolean fRet = false;
        String sRet = this.getProperty(propName);
        if (sRet != null && sRet.equals("true")) {
            fRet = true;
        }
        return fRet;
    }

    private String html(String sHtml) {
        if (this._fHtml) {
            return sHtml;
        }
        return "";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this._version);
        out.writeObject(this._name);
        out.writeInt(this._ID);
        out.writeObject(this._stack);
        out.writeObject(this._stackNative);
        out.writeObject(this._threadId);
        out.writeObject(this._priority);
        out.writeObject(this._state);
        out.writeInt(this._waitMonitorID);
        out.writeObject(this._props);
        out.writeBoolean(this._fHtml);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._version = in.readInt();
        this._name = (String)in.readObject();
        this._ID = in.readInt();
        this._stack = (Vector)in.readObject();
        Object unknown = in.readObject();
        try {
            this._stackNative = (Vector)unknown;
            this._threadId = (String)in.readObject();
        }
        catch (ClassCastException cce) {
            this._stackNative = new Vector();
            this._threadId = (String)unknown;
        }
        this._priority = (String)in.readObject();
        this._state = (String)in.readObject();
        this._waitMonitorID = in.readInt();
        this._props = (Properties)in.readObject();
        this._fHtml = in.readBoolean();
    }

    int getId() {
        return this._ID;
    }

    public Thd() {
    }

    public boolean isSelfWaiter() {
        return this._selfWaiter;
    }

    public void setSelfWaiter(boolean b) {
        this._selfWaiter = b;
    }

    class Caller {
        public StkEntry _stkEntry = null;
        public int _count = 1;

        Caller() {
        }
    }
}

