/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.hyades.logging.adapter.util.AdapterMigrationException;
import org.eclipse.hyades.logging.adapter.util.IComponentMigrator;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.adapter.util.OutputterMigrator;
import org.eclipse.hyades.logging.adapter.util.SensorMigrator;
import org.eclipse.hyades.logging.core.SerializationException;
import org.eclipse.hyades.logging.core.XmlUtility;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AdapterMigrator {
    private boolean migrated = false;

    public static void main(String[] args) {
        AdapterMigrator migrator = new AdapterMigrator();
        if (args != null && args.length >= 1) {
            String originalFileName = args[0];
            String newFileName = args.length >= 2 ? args[1] : originalFileName;
            try {
                migrator.migrate(originalFileName, newFileName);
                if (!migrator.isMigrated()) {
                    System.out.println(Messages.getString("HyadesGA_CBE_Adapter_No_Config_File_Migration_Required_INFO_", originalFileName));
                }
            }
            catch (AdapterMigrationException e) {
                System.err.println(e.getLocalizedMessage());
            }
        } else {
            System.out.println(Messages.getString("HyadesGA_CBE_Adapter_No_Config_File_Specified_ERROR_"));
        }
    }

    public boolean migrate(String originalFile) throws AdapterMigrationException {
        return this.migrate(originalFile, originalFile);
    }

    public boolean migrate(String originalFile, String newFile) throws AdapterMigrationException {
        Element newElement;
        Element oldElement;
        int i;
        FileInputStream inStream = null;
        String fileName = originalFile;
        this.migrated = false;
        try {
            String fileSeparator = System.getProperty("file.separator");
            if (fileName.indexOf(47) != -1 && fileSeparator != "/") {
                fileName = fileName.replace('/', fileSeparator.charAt(0));
            }
            if (fileName.startsWith("." + fileSeparator)) {
                fileName = fileName.substring(2);
            }
            inStream = new FileInputStream(fileName);
        }
        catch (FileNotFoundException exc) {
            throw new AdapterMigrationException(Messages.getString("HyadesGA_CBE_Adapter_No_Config_File_ERROR_", originalFile));
        }
        catch (SecurityException exc) {
            throw new AdapterMigrationException(Messages.getString("HyadesGA_CBE_Adapter_Config_File_Open_ERROR_", originalFile));
        }
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inStream);
        }
        catch (SAXException e) {
            throw new AdapterMigrationException(Messages.getString("HyadesGA_CBE_Adapter_Config_File_Parse_ERROR_", originalFile), e);
        }
        catch (IOException e) {
            throw new AdapterMigrationException(Messages.getString("HyadesGA_CBE_Adapter_Config_File_Parse_ERROR_", originalFile), e);
        }
        catch (ParserConfigurationException e) {
            throw new AdapterMigrationException(Messages.getString("HyadesGA_CBE_Adapter_Config_File_Parse_ERROR_", originalFile), e);
        }
        catch (Exception e) {
            throw new AdapterMigrationException(Messages.getString("HyadesGA_CBE_Adapter_Config_File_Parse_ERROR_", originalFile), e);
        }
        NodeList nodeList = doc.getElementsByTagName(Messages.getString("HyadesGASensorTagName"));
        int nodeCount = nodeList.getLength();
        IComponentMigrator migrator = new SensorMigrator();
        for (i = 0; i < nodeCount; ++i) {
            oldElement = (Element)nodeList.item(i);
            newElement = migrator.migrate(oldElement);
            if (newElement == null) continue;
            oldElement.getParentNode().replaceChild(newElement, oldElement);
            this.migrated = true;
        }
        nodeList = doc.getElementsByTagName(Messages.getString("HyadesGAOutputterTagName"));
        nodeCount = nodeList.getLength();
        migrator = new OutputterMigrator();
        for (i = 0; i < nodeCount; ++i) {
            oldElement = (Element)nodeList.item(i);
            newElement = migrator.migrate(oldElement);
            if (newElement == null) continue;
            oldElement.getParentNode().replaceChild(newElement, oldElement);
            this.migrated = true;
        }
        if (this.isMigrated()) {
            nodeList = doc.getElementsByTagName(Messages.getString("HyadesGAAdapterElementTagName"));
            if (nodeList.getLength() == 0) {
                throw new AdapterMigrationException(Messages.getString("HyadesGA_CBE_Adapter_Config_File_Missing_Element_ERROR_", originalFile, Messages.getString("HyadesGAAdapterElementTagName")));
            }
            Element adapterElement = (Element)nodeList.item(0);
            if (!adapterElement.hasAttribute(Messages.getString("HyadesGAAdapterProcessUnitNamespaceAttributeTagName"))) {
                adapterElement.setAttribute(Messages.getString("HyadesGAAdapterProcessUnitNamespaceAttributeTagName"), Messages.getString("HyadesGAAdapterProcessUnitNamespaceAttributeValue"));
            }
            try {
                XmlUtility.serialize((Document)doc, (File)new File(newFile));
            }
            catch (SerializationException s) {
                throw new AdapterMigrationException(Messages.getString("HyadesGA_CBE_Adapter_Config_File_Save_ERROR_", newFile), s);
            }
        }
        return this.isMigrated();
    }

    public boolean isMigrated() {
        return this.migrated;
    }
}

