/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import org.eclipse.hyades.loaders.util.HyadesConfigurationElement;
import org.eclipse.hyades.loaders.util.IHyadesPluginClassDescriptor;
import org.eclipse.hyades.loaders.util.RegistryReader;
import org.eclipse.hyades.loaders.util.XMLFragmentHandler;
import org.eclipse.hyades.loaders.util.XMLFragmentHandlerExtensions;

class XMLFragmentHandlerRegistryReader
extends RegistryReader {
    static final String TAG_HANDLER = "handler";
    static final String ATT_CLASS = "class";

    public XMLFragmentHandlerRegistryReader() {
        super("fragment_handler");
    }

    protected boolean readElement(HyadesConfigurationElement element) {
        if (element.getName().equals(TAG_HANDLER)) {
            if (element.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(element, ATT_CLASS);
            } else if (XMLFragmentHandlerExtensions.getInstance().size() > 0) {
                this.logError(element, "Another handler has been already registered. Only the first registered XML handler would be active.");
            } else {
                try {
                    IHyadesPluginClassDescriptor classDescriptor = this.createPluginClassDescriptor(element, ATT_CLASS);
                    XMLFragmentHandlerExtensions.getInstance().put(TAG_HANDLER, (XMLFragmentHandler)classDescriptor.createInstance());
                }
                catch (Exception e) {
                    this.logError(element, e.getLocalizedMessage());
                }
                return true;
            }
        }
        return false;
    }
}

