/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.impl;

import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IComponent;
import org.eclipse.hyades.logging.adapter.IProcessUnit;
import org.eclipse.hyades.logging.adapter.ISensor;
import org.eclipse.hyades.logging.adapter.impl.Context;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.Situation;

public class BasicContext
extends Context {
    public boolean init() {
        super.init();
        return this.testRun();
    }

    private boolean testRun() {
        ISensor sensor = (ISensor)this.getComponents()[0];
        Object[] msgs = sensor.testGetNext();
        try {
            this.testProcessMessages(msgs, 1);
        }
        catch (AdapterInvalidConfig e) {
            CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
            event.setMsg(e.toString());
            event.setSeverity((short)60);
            this.log(event);
            return false;
        }
        catch (Exception e) {
            CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
            event.setMsg(e.toString());
            event.setSeverity((short)60);
            this.log(event);
            return false;
        }
        return true;
    }

    private void testProcessMessages(Object[] msgs, int level) throws AdapterInvalidConfig {
        IComponent[] contextComponents = this.getComponents();
        if (level < contextComponents.length) {
            Object[] oa = ((IProcessUnit)contextComponents[level]).testProcessEventItems(msgs);
            ++level;
            if (oa != null && oa[0] != null) {
                this.testProcessMessages(oa, level);
            }
        }
    }

    public void run() {
        CommonBaseEvent startEvent = this.getEventFactory().createCommonBaseEvent();
        startEvent.setMsg(Messages.getString("HyadesGAContext_Started_INFO_", this.getName()));
        startEvent.setSeverity((short)10);
        Situation startSituation = this.getEventFactory().createSituation();
        startSituation.setStartSituation("INTERNAL", "START COMPLETED", "SUCCESSFUL");
        startEvent.setSituation(startSituation);
        this.log(startEvent);
        IComponent[] contextComponents = this.getComponents();
        int i = 0;
        while (i < contextComponents.length) {
            startEvent = this.getEventFactory().createCommonBaseEvent();
            startEvent.setMsg(Messages.getString("HyadesGAComponent_Started_INFO_", contextComponents[i].getName()));
            startEvent.setSeverity((short)10);
            startSituation = this.getEventFactory().createSituation();
            startSituation.setStartSituation("INTERNAL", "START COMPLETED", "SUCCESSFUL");
            startEvent.setSituation(startSituation);
            this.log(startEvent);
            ++i;
        }
        try {
            ISensor sensor = (ISensor)this.getComponents()[0];
            try {
                while (!this.isHardStop() && !this.stopping) {
                    if (this.listener != null) {
                        try {
                            this.listener.preProcessEventItems(sensor, null);
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                    }
                    Object[] msgs = sensor.getNext();
                    if (this.listener != null) {
                        try {
                            this.listener.postProcessEventItems(sensor, msgs);
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                    }
                    if (msgs == null) {
                        this.handleControledStop();
                        continue;
                    }
                    this.resetControledStop();
                    this.processMessages(msgs, 1);
                }
            }
            catch (Exception e) {
                CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                event.setMsg(e.toString());
                event.setSeverity((short)60);
                this.log(event);
            }
        }
        catch (Throwable e) {
            CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
            event.setMsg(e.toString());
            event.setSeverity((short)60);
            this.log(event);
        }
    }

    private void processMessages(Object[] msgs, int level) {
        IComponent[] contextComponents = this.getComponents();
        if (level > 0 && level < contextComponents.length) {
            if (this.listener != null) {
                try {
                    this.listener.preProcessEventItems(contextComponents[level], msgs);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            Object[] oa = ((IProcessUnit)contextComponents[level]).processEventItems(msgs);
            if (this.listener != null) {
                try {
                    this.listener.postProcessEventItems(contextComponents[level], oa);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            ++level;
            if (oa != null) {
                this.processMessages(oa, level);
            }
        }
    }

    public void stop() {
        if (this.listener != null && !this.isHardStop()) {
            try {
                this.listener.preProcessEventItems(this.getComponents()[0], null);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        Object[] flushedSensorContent = ((ISensor)this.getComponents()[0]).flush();
        if (this.listener != null && !this.isHardStop()) {
            try {
                this.listener.postProcessEventItems(this.getComponents()[0], flushedSensorContent);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        this.flushMessages(flushedSensorContent, 1);
        super.stop();
    }

    private void flushMessages(Object[] msgs, int level) {
        IComponent[] contextComponents = this.getComponents();
        if (level > 0 && level < contextComponents.length) {
            if (this.listener != null && !this.isHardStop()) {
                try {
                    this.listener.preProcessEventItems(contextComponents[level], msgs);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            Object[] oa = ((IProcessUnit)contextComponents[level]).flushEventItems(msgs);
            if (this.listener != null && !this.isHardStop()) {
                try {
                    this.listener.postProcessEventItems(contextComponents[level], oa);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            ++level;
            if (oa != null) {
                this.flushMessages(oa, level);
            }
        }
    }
}

