/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.loaders.util.LoaderExtensions;
import org.eclipse.hyades.loaders.util.RegistryReader;
import org.eclipse.hyades.loaders.util.XMLFragmentLoader;
import org.eclipse.hyades.models.hierarchy.plugin.HierarchyPlugin;

class LoaderRegistryReader
extends RegistryReader {
    static final String TAG_LOADER = "loader";
    static final String ATT_ELEMENT_NAME = "elementName";
    static final String ATT_CLASS = "class";

    public LoaderRegistryReader() {
        super(Platform.getPluginRegistry(), HierarchyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), "fragment_loader");
    }

    protected boolean readElement(IConfigurationElement iConfigurationElement) {
        if (iConfigurationElement.getName().equals(TAG_LOADER)) {
            String string = iConfigurationElement.getAttribute(ATT_ELEMENT_NAME);
            if (string == null) {
                this.logMissingAttribute(iConfigurationElement, ATT_ELEMENT_NAME);
            } else if (iConfigurationElement.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(iConfigurationElement, ATT_CLASS);
            } else if (LoaderExtensions.getInstance().containsKey(string)) {
                this.logError(iConfigurationElement, "A loader for this element already exists, this loader will be ignored.");
            } else {
                try {
                    RegistryReader.PluginClassDescriptor pluginClassDescriptor = new RegistryReader.PluginClassDescriptor(iConfigurationElement, ATT_CLASS);
                    LoaderExtensions.getInstance().put(string, (XMLFragmentLoader)pluginClassDescriptor.createInstance());
                }
                catch (Exception exception) {
                    this.logError(iConfigurationElement, exception.getLocalizedMessage());
                }
                return true;
            }
        }
        return false;
    }
}

