/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.loaders.util.LoaderExtensions;
import org.eclipse.hyades.loaders.util.RegistryReader;
import org.eclipse.hyades.loaders.util.XMLFragmentLoader;
import org.eclipse.hyades.loaders.util.XMLFragmentLoadersFactory;
import org.eclipse.hyades.models.hierarchy.plugin.HierarchyPlugin;

class LoadersFactoryRegistryReader
extends RegistryReader {
    static final String TAG_LOADERS_FACTORY = "loadersFactory";
    static final String ATT_CLASS = "class";

    public LoadersFactoryRegistryReader() {
        super(Platform.getPluginRegistry(), HierarchyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), "fragment_loaders_factory");
    }

    protected boolean readElement(IConfigurationElement iConfigurationElement) {
        if (iConfigurationElement.getName().equals(TAG_LOADERS_FACTORY)) {
            if (iConfigurationElement.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(iConfigurationElement, ATT_CLASS);
            } else {
                try {
                    RegistryReader.PluginClassDescriptor pluginClassDescriptor = new RegistryReader.PluginClassDescriptor(iConfigurationElement, ATT_CLASS);
                    XMLFragmentLoadersFactory xMLFragmentLoadersFactory = (XMLFragmentLoadersFactory)pluginClassDescriptor.createInstance();
                    Set set = xMLFragmentLoadersFactory.getSupportedElements();
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        if (LoaderExtensions.getInstance().containsKey(string)) {
                            this.logError(iConfigurationElement, "A loader for this element already exists, this loader will be ignored.");
                            continue;
                        }
                        try {
                            XMLFragmentLoader xMLFragmentLoader = (XMLFragmentLoader)xMLFragmentLoadersFactory.getClass().getClassLoader().loadClass(xMLFragmentLoadersFactory.getLoaderClassName(string)).newInstance();
                            if (xMLFragmentLoader == null) continue;
                            LoaderExtensions.getInstance().put(string, xMLFragmentLoader);
                        }
                        catch (Exception exception) {
                            this.logError(iConfigurationElement, exception.getLocalizedMessage());
                        }
                    }
                }
                catch (Exception exception) {
                    this.logError(iConfigurationElement, exception.getLocalizedMessage());
                }
                return true;
            }
        }
        return false;
    }
}

