/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.loaders.util.RegistryReader;
import org.eclipse.hyades.loaders.util.XMLFragmentHandler;
import org.eclipse.hyades.loaders.util.XMLFragmentHandlerExtensions;
import org.eclipse.hyades.models.hierarchy.plugin.HierarchyPlugin;

class XMLFragmentHandlerRegistryReader
extends RegistryReader {
    static final String TAG_HANDLER = "handler";
    static final String ATT_CLASS = "class";

    public XMLFragmentHandlerRegistryReader() {
        super(Platform.getPluginRegistry(), HierarchyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), "fragment_handler");
    }

    protected boolean readElement(IConfigurationElement iConfigurationElement) {
        if (iConfigurationElement.getName().equals(TAG_HANDLER)) {
            if (iConfigurationElement.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(iConfigurationElement, ATT_CLASS);
            } else if (XMLFragmentHandlerExtensions.getInstance().size() > 0) {
                this.logError(iConfigurationElement, "Another handler has been already registered. Only the first registered XML handler would be active.");
            } else {
                try {
                    RegistryReader.PluginClassDescriptor pluginClassDescriptor = new RegistryReader.PluginClassDescriptor(iConfigurationElement, ATT_CLASS);
                    XMLFragmentHandlerExtensions.getInstance().put(TAG_HANDLER, (XMLFragmentHandler)pluginClassDescriptor.createInstance());
                }
                catch (Exception exception) {
                    this.logError(iConfigurationElement, exception.getLocalizedMessage());
                }
                return true;
            }
        }
        return false;
    }
}

