/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.hierarchy.util.ContainmentTraverser;
import org.eclipse.hyades.models.hierarchy.util.EObjectVisitor;

public class EMFUtil {
    public static Set delete(EObject eObject) {
        if (eObject == null || eObject.eResource() == null) {
            return Collections.EMPTY_SET;
        }
        return EMFUtil.delete(eObject, (Collection)eObject.eResource().getContents());
    }

    public static Set delete(final EObject eObject, Collection collection) {
        if (eObject == null || eObject.eResource() == null) {
            return Collections.EMPTY_SET;
        }
        final HashSet hashSet = new HashSet();
        final ContainmentTraverser containmentTraverser = new ContainmentTraverser(collection, false);
        EObjectVisitor eObjectVisitor = new EObjectVisitor(){

            public boolean beforeChildren(EObject eObject2) {
                return !EMFUtil.isContainedIn(eObject2, eObject);
            }

            public boolean afterChildren(EObject eObject2) {
                boolean bl = false;
                Iterator iterator = eObject2.eClass().getEAllReferences().iterator();
                while (iterator.hasNext()) {
                    EReference eReference = (EReference)iterator.next();
                    if (!eObject2.eIsSet((EStructuralFeature)eReference)) continue;
                    Object object = eObject2.eGet((EStructuralFeature)eReference, false);
                    if (object instanceof EObject) {
                        if (!EMFUtil.isContainedIn((EObject)object, eObject)) continue;
                        eObject2.eUnset((EStructuralFeature)eReference);
                        bl = true;
                        continue;
                    }
                    if (!(object instanceof EList)) continue;
                    EList eList = (EList)object;
                    Iterator iterator2 = containmentTraverser.getIterator(eList);
                    while (iterator2.hasNext()) {
                        Object e = iterator2.next();
                        if (!(e instanceof EObject) || !EMFUtil.isContainedIn((EObject)object, eObject)) continue;
                        ((InternalEList)eList).basicRemove(e, null);
                        bl = true;
                    }
                }
                if (bl) {
                    hashSet.add(eObject2.eResource());
                }
                return true;
            }
        };
        containmentTraverser.registerVisitors(eObjectVisitor);
        containmentTraverser.traverse();
        return hashSet;
    }

    public static Set delete(EObject eObject, ResourceSet resourceSet) {
        if (eObject == null || eObject.eResource() == null) {
            return Collections.EMPTY_SET;
        }
        if (resourceSet == null) {
            return EMFUtil.delete(eObject, (Collection)eObject.eResource().getContents());
        }
        return EMFUtil.delete(eObject, EMFUtil.getResourceSetRoots(resourceSet, null));
    }

    public static Set delete(Resource resource) {
        if (resource == null) {
            return Collections.EMPTY_SET;
        }
        return EMFUtil.delete(resource, resource.getResourceSet());
    }

    public static Set delete(final Resource resource, ResourceSet resourceSet) {
        if (resource == null || resourceSet == null) {
            return Collections.EMPTY_SET;
        }
        final HashSet hashSet = new HashSet();
        EList eList = resource.getContents();
        List list = EMFUtil.getResourceSetRoots(resourceSet, resource);
        final ContainmentTraverser containmentTraverser = new ContainmentTraverser(list, false);
        EObjectVisitor eObjectVisitor = new EObjectVisitor(){

            public boolean beforeChildren(EObject eObject) {
                return true;
            }

            public boolean afterChildren(EObject eObject) {
                boolean bl = false;
                Iterator iterator = eObject.eClass().getEAllReferences().iterator();
                while (iterator.hasNext()) {
                    EReference eReference = (EReference)iterator.next();
                    if (!eObject.eIsSet((EStructuralFeature)eReference)) continue;
                    Object object = eObject.eGet((EStructuralFeature)eReference, false);
                    if (object instanceof EObject) {
                        if (!EMFUtil.isContainedIn((EObject)object, resource)) continue;
                        eObject.eUnset((EStructuralFeature)eReference);
                        bl = true;
                        continue;
                    }
                    if (!(object instanceof EList)) continue;
                    EList eList = (EList)object;
                    Iterator iterator2 = containmentTraverser.getIterator(eList);
                    while (iterator2.hasNext()) {
                        Object e = iterator2.next();
                        if (!(e instanceof EObject) || !EMFUtil.isContainedIn((EObject)e, resource)) continue;
                        ((InternalEList)eList).basicRemove(e, null);
                        bl = true;
                    }
                }
                if (bl) {
                    hashSet.add(eObject.eResource());
                }
                return true;
            }
        };
        containmentTraverser.registerVisitors(eObjectVisitor);
        containmentTraverser.traverse();
        resource.getContents().clear();
        resourceSet.getResources().remove(resource);
        return hashSet;
    }

    public static Set unload(final Resource resource, ResourceSet resourceSet) {
        if (resource == null || resourceSet == null) {
            return Collections.EMPTY_SET;
        }
        final HashSet hashSet = new HashSet();
        EList eList = resource.getContents();
        List list = EMFUtil.getResourceSetRoots(resourceSet, resource);
        final ContainmentTraverser containmentTraverser = new ContainmentTraverser(list, false);
        EObjectVisitor eObjectVisitor = new EObjectVisitor(){

            public boolean beforeChildren(EObject eObject) {
                return true;
            }

            public boolean afterChildren(EObject eObject) {
                boolean bl = false;
                Iterator iterator = eObject.eClass().getEAllReferences().iterator();
                while (iterator.hasNext()) {
                    EReference eReference = (EReference)iterator.next();
                    if (!eObject.eIsSet((EStructuralFeature)eReference)) continue;
                    Object object = eObject.eGet((EStructuralFeature)eReference, false);
                    if (object instanceof EObject && !((EObject)object).eIsProxy()) {
                        if (!EMFUtil.isContainedIn((EObject)object, resource)) continue;
                        ((InternalEObject)eObject).eSetProxyURI(EcoreUtil.getURI((EObject)eObject));
                        bl = true;
                        continue;
                    }
                    if (!(object instanceof EList)) continue;
                    EList eList = (EList)object;
                    Iterator iterator2 = containmentTraverser.getIterator(eList);
                    while (iterator2.hasNext()) {
                        Object e = iterator2.next();
                        if (!(e instanceof EObject) || ((EObject)e).eIsProxy() || !EMFUtil.isContainedIn((EObject)e, resource)) continue;
                        ((InternalEObject)e).eSetProxyURI(EcoreUtil.getURI((EObject)((EObject)e)));
                        bl = true;
                    }
                }
                if (bl) {
                    hashSet.add(eObject.eResource());
                }
                return true;
            }
        };
        containmentTraverser.registerVisitors(eObjectVisitor);
        containmentTraverser.traverse();
        resource.getContents().clear();
        resourceSet.getResources().remove(resource);
        return hashSet;
    }

    public static final boolean isContainedIn(EObject eObject, Resource resource) {
        if (!eObject.eIsProxy()) {
            return resource == eObject.eResource();
        }
        return ((InternalEObject)eObject).eProxyURI().trimFragment().equals((Object)resource.getURI());
    }

    public static final boolean isContainedIn(EObject eObject, EObject eObject2) {
        if (!eObject.eIsProxy()) {
            return EcoreUtil.isAncestor((EObject)eObject2, (EObject)eObject);
        }
        return EcoreUtil.getURI((EObject)eObject).toString().indexOf(EcoreUtil.getURI((EObject)eObject2).toString()) > 0;
    }

    public static List getResourceSetRoots(ResourceSet resourceSet, Resource resource) {
        BasicEList basicEList = new BasicEList();
        Iterator iterator = resourceSet.getResources().iterator();
        while (iterator.hasNext()) {
            Resource resource2 = (Resource)iterator.next();
            if (resource2 == resource) continue;
            basicEList.addAll(resource2.getContents());
        }
        return basicEList;
    }

    public static Set unload(Resource resource) {
        if (resource == null) {
            return Collections.EMPTY_SET;
        }
        return EMFUtil.unload(resource, resource.getResourceSet());
    }
}

