/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.internal.sdb.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;

abstract class RegistryReader {
    protected static final String TAG_DESCRIPTION = "description";
    protected IPluginRegistry pluginRegistry;
    String extensionPointID;
    String pluginID;

    public RegistryReader(IPluginRegistry iPluginRegistry, String string, String string2) {
        this.pluginRegistry = iPluginRegistry;
        this.pluginID = string;
        this.extensionPointID = string2;
    }

    public void readRegistry() {
        IExtensionPoint iExtensionPoint = this.pluginRegistry.getExtensionPoint(this.pluginID, this.extensionPointID);
        if (iExtensionPoint != null) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                this.internalReadElement(iConfigurationElementArray[n]);
                ++n;
            }
        }
    }

    protected void logError(IConfigurationElement iConfigurationElement, String string) {
        IExtension iExtension = iConfigurationElement.getDeclaringExtension();
        IPluginDescriptor iPluginDescriptor = iExtension.getDeclaringPluginDescriptor();
        System.err.println("Plugin " + iPluginDescriptor.getUniqueIdentifier() + ", extension " + iExtension.getExtensionPointUniqueIdentifier());
        System.err.println(string);
    }

    protected void logMissingAttribute(IConfigurationElement iConfigurationElement, String string) {
        this.logError(iConfigurationElement, "The required attribute '" + string + "' not defined");
    }

    abstract boolean readElement(IConfigurationElement var1);

    private void internalReadElement(IConfigurationElement iConfigurationElement) {
        boolean bl = this.readElement(iConfigurationElement);
        if (bl) {
            IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren();
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                this.internalReadElement(iConfigurationElementArray[n]);
                ++n;
            }
        } else {
            this.logError(iConfigurationElement, "Error processing extension: " + iConfigurationElement);
        }
    }

    static class PluginClassDescriptor {
        protected IConfigurationElement element;
        protected String attributeName;

        public PluginClassDescriptor(IConfigurationElement iConfigurationElement, String string) {
            this.element = iConfigurationElement;
            this.attributeName = string;
        }

        public Object createInstance() {
            try {
                return this.element.createExecutableExtension(this.attributeName);
            }
            catch (CoreException coreException) {
                throw new RuntimeException(coreException.getLocalizedMessage());
            }
        }
    }
}

