/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.util;

import java.util.ArrayList;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.ColumnData;
import org.eclipse.hyades.log.ui.internal.util.DoubleCList;
import org.eclipse.hyades.log.ui.internal.util.LogAnalyzerUI;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CBESortUI
extends LogAnalyzerUI {
    private DoubleCList _doubleList;
    private ArrayList _sourceList = new ArrayList();
    private ArrayList _targetList = new ArrayList();
    private ArrayList _pdSortData = new ArrayList();
    private Text _sortString;

    public Control createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)GridUtil.createFill());
        Label label = new Label(composite2, 0);
        label.setLayoutData((Object)GridUtil.createHorizontalFill());
        label.setText(LogUIPlugin.getResourceString("SORT_DIALOG_DESCR"));
        this._doubleList = new DoubleCList(composite2, 0, "", LogUIPlugin.getResourceString("SORT_SOURCE_LIST_DESCR"), LogUIPlugin.getResourceString("SORT_TARGET_LIST_DESCR"));
        this._sortString = new Text(composite2, 578);
        GridData gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 3;
        gridData.heightHint = 30;
        this._sortString.setLayoutData((Object)gridData);
        this._sortString.setEditable(false);
        this._doubleList.addSelectionListener(this);
        return composite2;
    }

    public boolean storeValues(IPreferenceStore iPreferenceStore) {
        this.applyValues(iPreferenceStore);
        this._doubleList.removeSelectionListener(this);
        return true;
    }

    public void applyValues(IPreferenceStore iPreferenceStore) {
        this._pdSortData.clear();
        Object[] objectArray = this._doubleList.getSourceItems().toArray();
        Object[] objectArray2 = this._doubleList.getTargetItems().toArray();
        int n = 0;
        while (n < objectArray.length) {
            this._pdSortData.add(new ColumnData(objectArray[n].toString(), false));
            ++n;
        }
        int n2 = 0;
        while (n2 < objectArray2.length) {
            this._pdSortData.add(new ColumnData(objectArray2[n2].toString(), true));
            ++n2;
        }
        ColumnData.setColumns(this._pdSortData, "pd_sort_log_options", iPreferenceStore);
    }

    protected void populateList() {
        this._sourceList.clear();
        this._targetList.clear();
        ColumnData columnData = null;
        Object var2_2 = null;
        int n = 0;
        while (n < this._pdSortData.size()) {
            columnData = (ColumnData)this._pdSortData.get(n);
            if (columnData.visible()) {
                this._targetList.add(columnData.name());
            } else {
                this._sourceList.add(columnData.name());
            }
            ++n;
        }
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        this.setSortString();
        this.notifyListeners(selectionEvent);
    }

    private void setSortString() {
        String string = "";
        Object[] objectArray = this._doubleList.getTargetItems().toArray();
        int n = 0;
        while (n < objectArray.length) {
            string = string + ", " + objectArray[n].toString();
            ++n;
        }
        string = !string.equals("") ? LogUIPlugin.getResourceString("STR_SORT_CRITERIA") + "<" + string.substring(1) + ">" : LogUIPlugin.getResourceString("STR_SORT_CRITERIA") + "<>";
        this._sortString.setText(string);
    }

    public void initializeValues(boolean bl) {
        IPreferenceStore iPreferenceStore = LogUIPlugin.getDefault().getPreferenceStore();
        String string = bl ? iPreferenceStore.getDefaultString("pd_sort_log_options") : iPreferenceStore.getString("pd_sort_log_options");
        this.createColumnDataFromString(string, this._pdSortData);
        this.populateList();
        this._doubleList.removeAll();
        this._doubleList.initializeSourceList(this._sourceList);
        this._doubleList.initializeTargetList(this._targetList);
        if (bl) {
            Event event = new Event();
            event.data = new Integer(4);
            event.type = 13;
            this.notifyListeners(new SelectionEvent(event));
        }
        this.setSortString();
    }
}

