/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.util;

import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.CBEFilterUI;
import org.eclipse.hyades.log.ui.internal.util.ContextIds;
import org.eclipse.hyades.log.ui.internal.util.RecordChangeEvent;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.help.WorkbenchHelp;

public class ColumnsDialog
extends Dialog
implements SelectionListener {
    private CBEFilterUI _options;
    private static final int _restoreDefaultsButtonId = 1025;
    private boolean filterHasChanged = false;
    private boolean sevHasChanged = false;
    private String _title;

    public ColumnsDialog(Shell shell, String string, Image image) {
        super(shell);
        this._title = string;
        Window.setDefaultImage((Image)image);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this._title);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.verticalSpacing = 15;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = GridUtil.createFill();
        gridData.heightHint = 400;
        gridData.widthHint = 370;
        composite2.setLayoutData((Object)gridData);
        IPreferenceStore iPreferenceStore = LogUIPlugin.getDefault().getPreferenceStore();
        this._options = new CBEFilterUI();
        this._options.createControl(composite2);
        this._options.initializeValues(false);
        this._options.addListener(this);
        WorkbenchHelp.setHelp((Control)composite2, (String)ContextIds.ACTLOG_VIEW_DIALOG_FILTER);
        return composite2;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 1025, LogUIPlugin.getResourceString("STR_COL_DLG_RESTORE_DEFAULTS"), false);
        super.createButtonsForButtonBar(composite);
    }

    protected void buttonPressed(int n) {
        if (n == 1025) {
            this._options.initializeValues(true);
        } else {
            this._options.removeListener(this);
            super.buttonPressed(n);
        }
    }

    protected void okPressed() {
        boolean bl = this._options.storeValues(LogUIPlugin.getDefault().getPreferenceStore());
        this._options.removeListener(this);
        if (this.filterHasChanged) {
            LogUIPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(1, (Object)this));
        }
        if (this.sevHasChanged) {
            LogUIPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(2, (Object)this));
        }
        if (bl) {
            super.okPressed();
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        Widget widget = selectionEvent.widget;
        if (widget instanceof Button && (((Button)widget).getStyle() & 0x20) == 32) {
            this.sevHasChanged = true;
        } else if (widget == this._options.getControl()) {
            this.sevHasChanged = true;
            this.filterHasChanged = true;
        } else {
            this.filterHasChanged = true;
        }
    }
}

