/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.views;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.analysis.engine.AnalysisEnginePlugin;
import org.eclipse.hyades.analysis.engine.ILogAnalyzer;
import org.eclipse.hyades.analysis.engine.Incident;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.views.AnalysisEngine;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.cbe.CBEDefaultEvent;
import org.eclipse.hyades.models.internal.sdb.SDBSymptom;
import org.eclipse.jface.viewers.IStructuredSelection;

public class LogAnalyzerImpl
implements ILogAnalyzer {
    protected String errorMessage;
    protected Map _analysisEngine = new Hashtable();
    private final String PLATFORM_PREFIX = "platform:/resource";

    public String errorMsg() {
        return this.errorMessage;
    }

    public void loadDatabase() {
        Object object;
        Object object2;
        Object object3;
        this.errorMessage = null;
        Map map = this.getSymptomDBPathList();
        Set set = this._analysisEngine.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object3 = (AnalysisEngine)iterator.next();
            if (!this.databaseExists(((AnalysisEngine)object3).getSymptomDatabasePath())) {
                ((AnalysisEngine)object3).removeSymptomDatabase();
                iterator.remove();
                continue;
            }
            object2 = ((AnalysisEngine)object3).getSymptomDatabasePath();
            object = (Long)map.get(object2);
            if (object == null) {
                ((AnalysisEngine)object3).removeSymptomDatabase();
                iterator.remove();
                continue;
            }
            if (object != null && ((Long)object).longValue() != ((Long)this._analysisEngine.get(object3)).longValue()) {
                ((AnalysisEngine)object3).removeSymptomDatabase();
                iterator.remove();
                continue;
            }
            map.remove(object2);
        }
        object3 = map.keySet();
        object2 = object3.iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            this._analysisEngine.put(AnalysisEngine.getInstance((String)object), map.get(object));
        }
        if (this._analysisEngine.size() == 0) {
            this.errorMessage = LogUIPlugin.getResourceString("STR_NO_SYMPTOM_DB_ERROR");
        }
    }

    public void unloadDatabase() {
        Set set = this._analysisEngine.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AnalysisEngine analysisEngine = (AnalysisEngine)iterator.next();
            analysisEngine.removeSymptomDatabase();
        }
        this._analysisEngine.clear();
    }

    protected Map getSymptomDBPathList() {
        IResource iResource;
        Path path;
        Object object;
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        String string = AnalysisEnginePlugin.getPlugin().getPreferenceStore().getString("symptom_db_path");
        if (string == null || string.equals("")) {
            return hashMap;
        }
        int n = string.indexOf(";");
        while (n != -1) {
            String string2 = string.substring(0, n);
            int n2 = string2.indexOf(",");
            if (n2 != -1 && string2.substring(n2 + 1).equals("1")) {
                object = string2.substring(0, n2);
                path = ResourcesPlugin.getWorkspace();
                iResource = new Path((String)object);
                IResource iResource2 = path.getRoot().findMember((IPath)iResource);
                if (iResource2 != null && iResource2.exists()) {
                    hashMap.put("platform:/resource" + (String)object, new Long(this.getTimestamp(iResource2)));
                }
            }
            string = string.substring(n + 1);
            n = string.indexOf(";");
        }
        int n3 = string.indexOf(",");
        if (n3 != -1 && string.substring(n3 + 1).equals("1")) {
            String string3 = string.substring(0, n3);
            object = ResourcesPlugin.getWorkspace();
            path = new Path(string3);
            iResource = object.getRoot().findMember((IPath)path);
            if (iResource != null && iResource.exists()) {
                hashMap.put("platform:/resource" + string3, new Long(this.getTimestamp(iResource)));
            }
        }
        return hashMap;
    }

    protected boolean databaseExists(String string) {
        if (string == null) {
            return false;
        }
        string = this.resourcePath(URI.createURI((String)string));
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IResource iResource = iWorkspace.getRoot().findMember(string);
        return iResource != null && iResource.exists();
    }

    protected String resourcePath(URI uRI) {
        String string = uRI.path();
        if (string.startsWith("/resource")) {
            return string.substring(9);
        }
        if (string.startsWith("platform:/resource")) {
            return string.substring(18);
        }
        return string;
    }

    public String analyze(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = ((IStructuredSelection)object).iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof CBEDefaultEvent)) continue;
            stringBuffer.append(this.analyzeEvent((CBEDefaultEvent)e));
        }
        return stringBuffer.toString();
    }

    protected String analyzeEvent(CBEDefaultEvent cBEDefaultEvent) {
        String string = this.getSymptomStringFor(cBEDefaultEvent);
        return this.findMatchesFor(cBEDefaultEvent, string);
    }

    protected String getSymptomStringFor(CBEDefaultEvent cBEDefaultEvent) {
        String string = cBEDefaultEvent.getExtensionName();
        if (cBEDefaultEvent instanceof CBECommonBaseEvent) {
            string = ((CBECommonBaseEvent)cBEDefaultEvent).getMsg();
        }
        return string;
    }

    private String findMatchesFor(CBEDefaultEvent cBEDefaultEvent, String string) {
        EList eList = cBEDefaultEvent.getSymptoms();
        if (!eList.isEmpty()) {
            eList.clear();
        }
        Set set = this._analysisEngine.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AnalysisEngine analysisEngine = (AnalysisEngine)iterator.next();
            Object[] objectArray = analysisEngine.analyze(new Incident(string));
            int n = 0;
            while (n < objectArray.length) {
                cBEDefaultEvent.getSymptoms().add((SDBSymptom)objectArray[n]);
                ++n;
            }
        }
        cBEDefaultEvent.setAnalyzed(true);
        return string;
    }

    private long getTimestamp(IResource iResource) {
        long l = 0L;
        IPath iPath = iResource.getLocation();
        if (iPath != null) {
            l = iPath.toFile().lastModified();
        }
        return l;
    }
}

