/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.ContextIds;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceHostUI;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.help.WorkbenchHelp;

public class ImportLogHostPage
extends WizardPage {
    private TraceHostUI hostUI;

    public ImportLogHostPage() {
        super("ImportLogHostPage");
        this.setTitle(LogUIPlugin.getResourceString("STR_IMPORT_LOG_FILE_HOST_TITLE"));
        this.setDescription(LogUIPlugin.getResourceString("STR_IMPORT_LOG_FILE_HOST_DESC"));
        this.setImageDescriptor(LogUIPlugin.getImageDescriptor("importactivitylog_wiz.gif"));
    }

    public void createControl(Composite composite) {
        this.hostUI = new TraceHostUI();
        this.setControl((Control)this.hostUI.createControl(composite));
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)ContextIds.IMPORT_LOG_FILE_HOST_LIST);
    }

    public boolean finish() {
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        String string = "";
        TableItem[] tableItemArray = this.hostUI.getHosts();
        int n = 0;
        while (n < tableItemArray.length) {
            string = string + "," + tableItemArray[n].getText().trim();
            ++n;
        }
        if (string.startsWith(",") && string.length() > 1) {
            string = string.substring(1);
        }
        iPreferenceStore.setValue("use_host", string);
        return true;
    }

    public String getHost() {
        return this.hostUI.getHost().trim();
    }

    public int getPort() {
        return this.hostUI.getPort();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.hostUI.getHostUI().setFocus();
    }

    public boolean isLocaHost() {
        return this.hostUI.isLocalHost(this.getHost());
    }
}

