/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.LogUIPluginImages;
import org.eclipse.hyades.log.ui.internal.util.TraceMergeUI;
import org.eclipse.hyades.log.ui.internal.wizards.ImportLogWizard;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.internal.core.TraceLocationUI;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;

public class ImportLogLocationPage
extends WizardPage
implements Listener {
    private TraceLocationUI locationUI;
    private TraceMergeUI mergeUI;
    private TRCAgentProxy currentAgentProxy;

    public ImportLogLocationPage() {
        super("ImportLogFilePage1");
        this.setTitle(LogUIPlugin.getResourceString("STR_IMPORT_LOG_FILE_DES_TITLE"));
        this.setDescription(LogUIPlugin.getResourceString("STR_IMPORT_LOG_FILE_DES_DESC"));
        this.setImageDescriptor(LogUIPluginImages.getImageDescriptor("importactivitylog_wiz.gif"));
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)GridUtil.createFill());
        this.locationUI = new TraceLocationUI();
        this.locationUI.createControl(composite2);
        this.locationUI.setLocation("LogAnalyzerProject");
        this.locationUI.getLocationLabel().setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_FILE_DES_PROJECT"));
        this.locationUI.getLocation().addListener(24, (Listener)this);
        this.locationUI.getMonitor().addListener(24, (Listener)this);
        Label label = new Label(composite2, 0);
        GridData gridData = new GridData(768);
        this.mergeUI = new TraceMergeUI();
        this.mergeUI.createControl(composite2);
        this.mergeUI.getTree().addListener(13, (Listener)this);
        this.mergeUI.getMergeButton().addListener(13, (Listener)this);
        this.setControl((Control)composite2);
    }

    public boolean finish() {
        IPreferenceStore iPreferenceStore = LogUIPlugin.getDefault().getPreferenceStore();
        String string = iPreferenceStore.getString("pd_sort_log_options");
        if (string == null || string.equals("")) {
            iPreferenceStore.setValue("pd_sort_log_options", "TimeStamp");
        }
        return true;
    }

    public void handleEvent(Event event) {
        if (event.type == 24) {
            this.setPageComplete(!this.locationUI.getLocation().getText().trim().equals("") && !this.locationUI.getMonitor().getText().trim().equals(""));
        } else if (event.widget == this.mergeUI.getMergeButton()) {
            this.mergeUI.getTree().setEnabled(this.mergeUI.getMergeButton().getSelection());
            if (this.mergeUI.getMergeButton().getSelection()) {
                TreeItem[] treeItemArray = this.mergeUI.getTree().getSelection();
                if (treeItemArray.length > 0) {
                    TreeItem treeItem = treeItemArray[0];
                    if (treeItem != null && treeItem.getData() != null) {
                        if (treeItem.getData() instanceof TRCAgentProxy) {
                            this.setPageComplete(!this.locationUI.getLocation().getText().trim().equals("") && !this.locationUI.getMonitor().getText().trim().equals(""));
                            this.currentAgentProxy = (TRCAgentProxy)treeItem.getData();
                            return;
                        }
                        this.setPageComplete(false);
                    } else {
                        this.setPageComplete(false);
                    }
                } else {
                    this.setPageComplete(false);
                }
            } else {
                this.setPageComplete(!this.locationUI.getLocation().getText().trim().equals("") && !this.locationUI.getMonitor().getText().trim().equals(""));
            }
            this.currentAgentProxy = null;
        } else {
            TreeItem treeItem;
            TreeItem[] treeItemArray = this.mergeUI.getTree().getSelection();
            if (treeItemArray.length > 0 && (treeItem = treeItemArray[0]) != null && treeItem.getData() != null) {
                if (treeItem.getData() instanceof TRCAgentProxy) {
                    TRCMonitor tRCMonitor = ((TRCAgentProxy)treeItem.getData()).getProcessProxy().getNode().getMonitor();
                    this.locationUI.setMonitor(tRCMonitor.getName());
                    String string = this.resourcePath(tRCMonitor.eResource().getURI());
                    IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
                    Path path = new Path(string);
                    IResource iResource = iWorkspace.getRoot().findMember((IPath)path);
                    if (iResource != null && iResource.exists()) {
                        this.locationUI.setLocation(iResource.getProject().getName());
                    }
                    this.setPageComplete(!this.locationUI.getLocation().getText().trim().equals("") && !this.locationUI.getMonitor().getText().trim().equals(""));
                    this.currentAgentProxy = (TRCAgentProxy)treeItem.getData();
                    return;
                }
                this.setPageComplete(false);
            }
            this.currentAgentProxy = null;
        }
    }

    public String getProject() {
        return this.locationUI.getLocation().getText().trim();
    }

    public String getMonitor() {
        return this.locationUI.getMonitor().getText().trim();
    }

    public TRCAgentProxy getAgentProxy() {
        return this.currentAgentProxy;
    }

    public boolean getSelection() {
        return this.mergeUI.getMergeButton().getSelection();
    }

    private String resourcePath(URI uRI) {
        String string = uRI.path();
        if (string.startsWith("/resource")) {
            return string.substring(9);
        }
        if (string.startsWith("platform:/resource")) {
            return string.substring(18);
        }
        return string;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        boolean bl2 = ((ImportLogWizard)this.getWizard()).isLocalHost();
        if (bl) {
            if (!bl2) {
                this.mergeUI.getMergeButton().setEnabled(false);
            } else {
                this.mergeUI.getMergeButton().setEnabled(true);
            }
        }
    }
}

