/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.net.URL;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.LogUIPluginImages;
import org.eclipse.hyades.log.ui.internal.wizards.AdaptableList;
import org.eclipse.hyades.log.ui.internal.wizards.ImportWizardNode;
import org.eclipse.hyades.log.ui.internal.wizards.LogWizardElementBase;
import org.eclipse.hyades.log.ui.internal.wizards.WorkbenchWizardListSelectionPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ImportLogSelectionWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    private IStructuredSelection selection;

    public ImportLogSelectionWizard() {
        AbstractUIPlugin abstractUIPlugin = (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
        IDialogSettings iDialogSettings = abstractUIPlugin.getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection("org.eclipse.hyades.log.ui.internal.internal.wizards.ImportLogSelectionWizard");
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection("org.eclipse.hyades.log.ui.internal.internal.wizards.ImportLogSelectionWizard");
        }
        this.setDialogSettings(iDialogSettings2);
    }

    public boolean performFinish() {
        ((SelectionPage)this.getPages()[0]).saveWidgetValues();
        return true;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.workbench = iWorkbench;
        this.selection = iStructuredSelection;
        this.setWindowTitle(LogUIPlugin.getResourceString("IMPORT_LOG_FILE_WIZARD_TITLE"));
        this.setDefaultPageImageDescriptor(LogUIPluginImages.getImageDescriptor("importactivitylog_wiz.gif"));
        this.setNeedsProgressMonitor(true);
    }

    protected AdaptableList getAvailableImportWizards() {
        IPluginRegistry iPluginRegistry = Platform.getPluginRegistry();
        IConfigurationElement[] iConfigurationElementArray = iPluginRegistry.getConfigurationElementsFor("org.eclipse.hyades.logging.parsers", "logParser");
        AdaptableList adaptableList = new AdaptableList();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            block4: {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
                LogWizardElementBase logWizardElementBase = new LogWizardElementBase(iConfigurationElement.getAttribute("name"));
                logWizardElementBase.setDescription(iConfigurationElement.getAttribute("description"));
                logWizardElementBase.setParserConfigurationElement(iConfigurationElement);
                logWizardElementBase.setParserId(iConfigurationElement.getAttribute("id"));
                String string = iConfigurationElement.getAttribute("icon");
                if (string != null && !string.equals("")) {
                    ImageDescriptor imageDescriptor;
                    URL uRL = iConfigurationElement.getDeclaringExtension().getDeclaringPluginDescriptor().getInstallURL();
                    try {
                        URL uRL2 = new URL(uRL, string);
                        imageDescriptor = ImageDescriptor.createFromURL((URL)uRL2);
                        logWizardElementBase.setImageDescriptor(imageDescriptor);
                    }
                    catch (Exception exception) {
                        imageDescriptor = new Status(4, LogUIPlugin.getPluginId(), 2, "exception.malformedURL", (Throwable)exception);
                        LogUIPlugin.getDefault().getLog().log((IStatus)imageDescriptor);
                        break block4;
                    }
                }
                adaptableList.add(logWizardElementBase);
            }
            ++n;
        }
        return adaptableList;
    }

    public void addPages() {
        this.addPage((IWizardPage)new SelectionPage(this.workbench, this.selection, this.getAvailableImportWizards(), LogUIPlugin.getResourceString("LOG_PARSER_PAGE_DESC")));
    }

    class SelectionPage
    extends WorkbenchWizardListSelectionPage {
        SelectionPage(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection, AdaptableList adaptableList, String string) {
            super(iWorkbench, iStructuredSelection, adaptableList, string);
        }

        public void createControl(Composite composite) {
            super.createControl(composite);
            WorkbenchHelp.setHelp((Control)this.getControl(), (String)(LogUIPlugin.getPluginId() + ".pp0000"));
            this.setTitle(LogUIPlugin.getResourceString("LOG_PARSER_PAGE_TITLE"));
            this.setDescription(LogUIPlugin.getResourceString("LOG_PARSER_PAGE_DESC"));
        }

        public IWizardNode createWizardNode(LogWizardElementBase logWizardElementBase) {
            ImportWizardNode importWizardNode = new ImportWizardNode(logWizardElementBase.getParserId(), this);
            return importWizardNode;
        }
    }
}

