/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.io.File;
import java.util.Map;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.wizards.IImportWizardWidget;
import org.eclipse.hyades.log.ui.internal.wizards.ISetLastWasHome;
import org.eclipse.hyades.log.ui.internal.wizards.ParserField;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ImportWizardTextField
implements IImportWizardWidget,
Listener,
ModifyListener {
    protected Button btn;
    protected Map _filtersTable;
    protected Text text;
    protected ISetLastWasHome lastWasHome;

    public ImportWizardTextField(Map map, ISetLastWasHome iSetLastWasHome) {
        this._filtersTable = map;
        this.lastWasHome = iSetLastWasHome;
    }

    public String getValue() {
        return this.text.getText().trim();
    }

    public void createControl(Composite composite, ParserField parserField, String string) {
        Label label = new Label(composite, 64);
        GridData gridData = new GridData();
        gridData.widthHint = 400;
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label.setText(parserField.getName());
        this.text = new Text(composite, 2048);
        this.text.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.text.addModifyListener((ModifyListener)this);
        this.text.setToolTipText(parserField.getTooltip());
        this.btn = new Button(composite, 8);
        this.btn.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_FILE_BROWSE1"));
        this.btn.addListener(13, (Listener)this);
        if (parserField.useBrowse()) {
            this.btn.setVisible(true);
            String string2 = parserField.getFilters();
            if (string2 != null) {
                this._filtersTable.put(this.btn, string2);
            }
        } else {
            this.btn.setVisible(false);
        }
    }

    public void handleEvent(Event event) {
        if (event.widget == this.btn) {
            Object v = this._filtersTable.get(this.btn);
            if (v != null) {
                FileDialog fileDialog = new FileDialog(this.btn.getParent().getShell());
                fileDialog.setFilterPath(this.text.getText().trim());
                fileDialog.setFilterExtensions(new String[]{v.toString(), "*"});
                fileDialog.open();
                String string = fileDialog.getFileName();
                if (string != null && !string.trim().equals("")) {
                    this.text.setText(fileDialog.getFilterPath().concat(File.separator).concat(string));
                }
            } else {
                DirectoryDialog directoryDialog = new DirectoryDialog(this.btn.getParent().getShell());
                directoryDialog.setMessage(LogUIPlugin.getResourceString("STR_IMPORT_LOG_FILE_LOC_BROWSE"));
                if (this.text.getText().trim().length() > 0) {
                    directoryDialog.setFilterPath(this.text.getText().trim());
                } else if (this.lastWasHome.getLastWasHome().trim().length() > 0) {
                    directoryDialog.setFilterPath(this.lastWasHome.getLastWasHome().trim());
                }
                String string = directoryDialog.open();
                if (string != null && !string.trim().equals("")) {
                    this.text.setText(string);
                    this.lastWasHome.setLastWasHome(string);
                }
            }
        }
    }

    public void modifyText(ModifyEvent modifyEvent) {
    }

    public boolean isValid() {
        return !this.text.getVisible() || !this.text.getText().trim().equals("");
    }

    public Text getText() {
        return this.text;
    }

    public void setText(Text text) {
        this.text = text;
    }

    public Button getBtn() {
        return this.btn;
    }

    public void setBtn(Button button) {
        this.btn = button;
    }
}

